# Copyright (c) 2025 Beijing Volcano Engine Technology Co., Ltd. and/or its affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""AgentKit CLI - Destroy command implementation."""

from pathlib import Path
import typer
from rich.console import Console
from agentkit.toolkit.config import get_config

# Note: 不要在文件开头导很重的包，不然会导致命令很卡(import包很慢)

console = Console()


def destroy_command(
    config_file: Path = typer.Option("agentkit.yaml", help="Configuration file"),
    force: bool = typer.Option(False, help="Force destroy without confirmation"),
):
    """Destroy running Agent runtime."""
    from agentkit.toolkit import sdk
    
    console.print(f"[red]Destroying current workflow runtime...[/red]")
    if not force:
        typer.confirm("Are you sure you want to destroy?", abort=True)
    
    try:
        # Call SDK
        result = sdk.destroy(config_file=str(config_file), force=force)
        
        if result.success:
            console.print(f"[green]✅ {result.message}[/green]")
        else:
            console.print(f"[red]❌ Destruction failed: {result.error}[/red]")
            raise typer.Exit(1)
        
    except Exception as e:
        console.print(f"[red]Destruction failed: {e}[/red]")
        raise typer.Exit(1)
