# Copyright (c) 2025 Beijing Volcano Engine Technology Co., Ltd. and/or its affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
VeAgentkit 常量定义模块

这个模块定义了在整个VeAgentkit项目中使用的通用常量，
确保各个模块之间的一致性。
"""

from pathlib import Path

# 自动创建资源的标识符
AUTO_CREATE_VE = "Auto"
DEFAULT_WORKSPACE_NAME = "agentkit-cli-workspace"
DEFAULT_CR_NAMESPACE = "agentkit"

DEFAULT_IMAGE_TAG = "{{timestamp}}"

# 全局配置相关常量
GLOBAL_CONFIG_DIR = Path.home() / ".agentkit"
GLOBAL_CONFIG_FILE = GLOBAL_CONFIG_DIR / "config.yaml"
GLOBAL_CONFIG_FILE_PERMISSIONS = 0o600  # 仅所有者可读写

# 其他通用常量可以在这里添加
# DEFAULT_REGION = "cn-beijing"
# DEFAULT_TIMEOUT = 300