# Copyright (c) 2025 Beijing Volcano Engine Technology Co., Ltd. and/or its affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated from API JSON definition
# Do not edit manually

from __future__ import annotations

from typing import Optional, List, Dict, Any
from pydantic import BaseModel, Field


# Data Types
class CustomJwtAuthorizerForGetTool(BaseModel):
    allowed_clients: Optional[list[str]] = Field(default=None, alias="AllowedClients")
    discovery_url: Optional[str] = Field(default=None, alias="DiscoveryUrl")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class KeyAuthForGetTool(BaseModel):
    api_key: Optional[str] = Field(default=None, alias="ApiKey")
    api_key_location: Optional[str] = Field(default=None, alias="ApiKeyLocation")
    api_key_name: Optional[str] = Field(default=None, alias="ApiKeyName")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AuthorizerConfigurationForGetTool(BaseModel):
    custom_jwt_authorizer: Optional[CustomJwtAuthorizerForGetTool] = Field(default=None, alias="CustomJwtAuthorizer")
    key_auth: Optional[KeyAuthForGetTool] = Field(default=None, alias="KeyAuth")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class TagsForGetTool(BaseModel):
    key: Optional[str] = Field(default=None, alias="Key")
    value: Optional[str] = Field(default=None, alias="Value")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class SessionMetaForGetSession(BaseModel):
    vnc_url: Optional[str] = Field(default=None, alias="VncUrl")
    webshell_url: Optional[str] = Field(default=None, alias="WebshellUrl")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class SessionMetaForListSessions(BaseModel):
    vnc_url: Optional[str] = Field(default=None, alias="VncUrl")
    webshell_url: Optional[str] = Field(default=None, alias="WebshellUrl")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class SessioninfoForListSessions(BaseModel):
    created_at: Optional[str] = Field(default=None, alias="CreatedAt")
    endpoint: Optional[str] = Field(default=None, alias="Endpoint")
    expire_at: Optional[str] = Field(default=None, alias="ExpireAt")
    internal_endpoint: Optional[str] = Field(default=None, alias="InternalEndpoint")
    name: Optional[str] = Field(default=None, alias="Name")
    session_id: Optional[str] = Field(default=None, alias="SessionId")
    session_meta: Optional[SessionMetaForListSessions] = Field(default=None, alias="SessionMeta")
    status: Optional[str] = Field(default=None, alias="Status")
    tool_type: Optional[str] = Field(default=None, alias="ToolType")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class TagsForListTools(BaseModel):
    key: Optional[str] = Field(default=None, alias="Key")
    value: Optional[str] = Field(default=None, alias="Value")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ToolsForListTools(BaseModel):
    created_at: Optional[str] = Field(default=None, alias="CreatedAt")
    description: Optional[str] = Field(default=None, alias="Description")
    name: Optional[str] = Field(default=None, alias="Name")
    project_name: Optional[str] = Field(default=None, alias="ProjectName")
    status: Optional[str] = Field(default=None, alias="Status")
    tags: Optional[list[TagsForListTools]] = Field(default=None, alias="Tags")
    tool_id: Optional[str] = Field(default=None, alias="ToolId")
    tool_type: Optional[str] = Field(default=None, alias="ToolType")
    updated_at: Optional[str] = Field(default=None, alias="UpdatedAt")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetTool - Request
class GetToolRequest(BaseModel):
    tool_id: Optional[str] = Field(default=None, alias="ToolId", description="工具ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetTool - Response
class GetToolResponse(BaseModel):
    authorizer_configuration: Optional[AuthorizerConfigurationForGetTool] = Field(default=None, alias="AuthorizerConfiguration")
    created_at: Optional[str] = Field(default=None, alias="CreatedAt", description="工具的创建时间。")
    description: Optional[str] = Field(default=None, alias="Description", description="工具的描述信息。")
    name: Optional[str] = Field(default=None, alias="Name", description="工具的名称。")
    project_name: Optional[str] = Field(default=None, alias="ProjectName")
    status: Optional[str] = Field(default=None, alias="Status", description="工具的状态，取值： - Creating：创建中。 - Error：错误。 - Ready：运行中。 - Deleting：删除中。")
    tags: Optional[list[TagsForGetTool]] = Field(default=None, alias="Tags")
    tool_id: Optional[str] = Field(default=None, alias="ToolId", description="工具ID。")
    tool_type: Optional[str] = Field(default=None, alias="ToolType", description="工具类型。取值： - All-in-one：一体化工具集。")
    updated_at: Optional[str] = Field(default=None, alias="UpdatedAt", description="工具的更新时间。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetSession - Request
class GetSessionRequest(BaseModel):
    session_id: str = Field(..., alias="SessionId", description="会话ID。")
    tool_id: str = Field(..., alias="ToolId", description="工具ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetSession - Response
class GetSessionResponse(BaseModel):
    created_at: Optional[str] = Field(default=None, alias="CreatedAt", description="会话创建时间。")
    endpoint: Optional[str] = Field(default=None, alias="Endpoint", description="会话公网访问端点。")
    expire_at: Optional[str] = Field(default=None, alias="ExpireAt", description="会话过期时间。")
    internal_endpoint: Optional[str] = Field(default=None, alias="InternalEndpoint", description="会话私网访问端点。")
    name: Optional[str] = Field(default=None, alias="Name", description="会话名称。")
    session_id: Optional[str] = Field(default=None, alias="SessionId", description="会话ID。")
    session_meta: Optional[SessionMetaForGetSession] = Field(default=None, alias="SessionMeta", description="会话元数据。")
    status: Optional[str] = Field(default=None, alias="Status", description="会话状态，取值： - Creating：创建中。 - Error：错误。 - Ready：运行中。 - Deleting：删除中。")
    tool_type: Optional[str] = Field(default=None, alias="ToolType", description="工具类型。取值： - All-in-one：一体化工具集，当前仅支持All-in-one。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# CreateTool - Request
class CreateToolRequest(BaseModel):
    client_token: Optional[str] = Field(default=None, alias="ClientToken", description="保证请求幂等性。由客户端自动生成一个参数值，确保不同请求间该参数值唯一，避免当调用API超时或服务器内部错误时，客户端多次重试导致重复性操作。 取值：仅支持ASCII字符，且不能超过64个字符。")
    description: Optional[str] = Field(default=None, alias="Description", description="工具的描述信息，取值： - 长度限制为 1000 以内的 Unicode 字符。 - 不填默认为空。")
    name: str = Field(..., alias="Name", description="工具的名称，取值： - 支持大小写英文字母、数字、中划线（-）、下划线(_)。 - 长度限制为4 ~ 64个字符。")
    tool_type: str = Field(..., alias="ToolType", description="工具类型。取值： - All-in-one：一体化工具集，当前仅支持All-in-one。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# CreateTool - Response
class CreateToolResponse(BaseModel):
    tool_id: Optional[str] = Field(default=None, alias="ToolId", description="工具ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# SetSessionTtl - Request
class SetSessionTtlRequest(BaseModel):
    session_id: str = Field(..., alias="SessionId", description="会话ID。")
    tool_id: str = Field(..., alias="ToolId", description="工具ID。")
    ttl: int = Field(..., alias="Ttl", description="会话实例存活时长，即工具在一次 “用户 - 工具交互会话” 中，保持用户状态、操作上下文不丢失的有效时长。会话过期后，只需重新登录或重启操作即可。 - 单位：分钟。 - 取值范围：3～1440。 - 默认值为：30。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# SetSessionTtl - Response
class SetSessionTtlResponse(BaseModel):
    expire_at: Optional[str] = Field(default=None, alias="ExpireAt", description="会话过期时间。")
    session_id: Optional[str] = Field(default=None, alias="SessionId", description="会话ID。")
    tool_id: Optional[str] = Field(default=None, alias="ToolId", description="工具ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# DeleteTool - Request
class DeleteToolRequest(BaseModel):
    client_token: Optional[str] = Field(default=None, alias="ClientToken", description="保证请求幂等性。由客户端自动生成一个参数值，确保不同请求间该参数值唯一，避免当调用API超时或服务器内部错误时，客户端多次重试导致重复性操作。取值： 仅支持ASCII字符，且不能超过64个字符。")
    tool_id: Optional[str] = Field(default=None, alias="ToolId", description="工具ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# DeleteTool - Response
class DeleteToolResponse(BaseModel):
    tool_id: Optional[str] = Field(default=None, alias="ToolId", description="工具ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# CreateSession - Request
class CreateSessionRequest(BaseModel):
    name: Optional[str] = Field(default=None, alias="Name", description="会话名称，取值： - 支持大小写英文字母、数字、中划线（-）、下划线(_)。 - 长度限制为0 ~ 64个字符。 - 不填默认为空。")
    tool_id: str = Field(..., alias="ToolId", description="工具ID。")
    ttl: Optional[int] = Field(default=None, alias="Ttl", description="会话实例存活时长，即工具在一次 “用户 - 工具交互会话” 中，保持用户状态、操作上下文不丢失的有效时长。会话过期后，只需重新登录或重启操作即可。 - 单位：分钟。 - 取值范围：3～1440。 - 默认值为：30。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# CreateSession - Response
class CreateSessionResponse(BaseModel):
    endpoint: Optional[str] = Field(default=None, alias="Endpoint", description="会话公网访问端点。")
    internal_endpoint: Optional[str] = Field(default=None, alias="InternalEndpoint", description="会话私网访问端点。")
    name: Optional[str] = Field(default=None, alias="Name", description="会话名称。")
    session_id: Optional[str] = Field(default=None, alias="SessionId", description="会话ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListTools - Request
class ListToolsFiltersItem(BaseModel):
    name: Optional[str] = Field(default=None, alias="Name", description="精确过滤的字段名，取值： - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔，为“或”的关系。 - 取值： - Id：工具ID。 - Name：工具名称。 - Description：工具描述。 - Status：工具状态。 ::: tip 当`Filters.N.Name`和`Filters.N.NameContains`同时传入时，仅`Filters.N.Name`生效。 :::")
    name_contains: Optional[str] = Field(default=None, alias="NameContains", description="模糊过滤的字段名，取值： - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔，为“或”的关系。 - 取值： - Id：工具ID。 - Name：工具名称。 - Description：工具描述。 - Status：工具状态。 ::: tip 当`Filters.N.Name`和`Filters.N.NameContains`同时传入时，仅`Filters.N.Name`生效。 :::")
    values: Optional[list[str]] = Field(default=None, alias="Values", description="过滤字段的值。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔。 当过滤字段为Status时，取值： - Creating：创建中。 - Error：错误。 - Ready：运行中。 - Deleting：删除中。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ListToolsRequest(BaseModel):
    create_time_after: Optional[str] = Field(default=None, alias="CreateTimeAfter", description="筛选该时间点后创建的工具。（RFC3339格式）")
    create_time_before: Optional[str] = Field(default=None, alias="CreateTimeBefore", description="筛选该时间点前创建的工具。（RFC3339格式）")
    max_results: Optional[int] = Field(default=None, alias="MaxResults", description="分页查询时设置的每页行数。 - 最小值：1。 - 最大值：100。 - 默认值：10。")
    next_token: Optional[str] = Field(default=None, alias="NextToken", description="分页查询凭证，用于标记分页的位置，初次调用该接口时无需设置。下次查询时，取值为上一次API调用返回的`NextToken`参数值。")
    update_time_after: Optional[str] = Field(default=None, alias="UpdateTimeAfter", description="筛选该时间点前更新的工具。（RFC3339格式）")
    update_time_before: Optional[str] = Field(default=None, alias="UpdateTimeBefore", description="筛选该时间点前更新的工具。（RFC3339格式）")
    filters: Optional[list[ListToolsFiltersItem]] = Field(default=None, alias="Filters")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListTools - Response
class ListToolsResponse(BaseModel):
    next_token: Optional[str] = Field(default=None, alias="NextToken", description="本次调用返回的查询凭证值，返回为空表示该页为末页。")
    tools: Optional[list[ToolsForListTools]] = Field(default=None, alias="Tools", description="符合条件的工具信息。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListSessions - Request
class ListSessionsFiltersItem(BaseModel):
    name: Optional[str] = Field(default=None, alias="Name", description="支持精确过滤的字段名。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔，为“或”的关系。 - 取值： - Id：工具ID。 - Name：工具名称。 - Description：工具描述。 - Status：工具状态。 ::: tip 当`Filters.N.Name`和`Filters.N.NameContains`同时传入时，仅`Filters.N.Name`生效。 :::")
    name_contains: Optional[str] = Field(default=None, alias="NameContains", description="模糊过滤的字段名，取值： - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔，为“或”的关系。 - 取值： - Id：工具ID。 - Name：工具名称。 - Description：工具描述。 - Status：工具状态。 ::: tip 当`Filters.N.Name`和`Filters.N.NameContains`同时传入时，仅`Filters.N.Name`生效。")
    values: Optional[list[str]] = Field(default=None, alias="Values", description="过滤字段的值。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔。 当过滤字段为Status时，取值： - Creating：创建中。 - Error：错误。 - Ready：运行中。 - Deleting：删除中。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ListSessionsRequest(BaseModel):
    create_time_after: Optional[str] = Field(default=None, alias="CreateTimeAfter", description="筛选该时间点后创建的会话。（RFC3339格式）")
    create_time_before: Optional[str] = Field(default=None, alias="CreateTimeBefore", description="筛选该时间点前创建的会话。（RFC3339格式）")
    expire_time_after: Optional[str] = Field(default=None, alias="ExpireTimeAfter", description="筛选该时间点后更新的会话。（RFC3339格式）")
    expire_time_before: Optional[str] = Field(default=None, alias="ExpireTimeBefore", description="筛选该时间点前更新的会话。（RFC3339格式）")
    max_results: Optional[int] = Field(default=None, alias="MaxResults", description="分页查询时设置的每页行数。 - 最小值：1。 - 最大值：100。 - 默认值：10。")
    next_token: Optional[str] = Field(default=None, alias="NextToken", description="分页查询凭证，用于标记分页的位置，初次调用该接口时无需设置。下次查询时，取值为上一次API调用返回的`NextToken`参数值。")
    tool_id: str = Field(..., alias="ToolId", description="工具ID。")
    filters: Optional[list[ListSessionsFiltersItem]] = Field(default=None, alias="Filters")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListSessions - Response
class ListSessionsResponse(BaseModel):
    next_token: Optional[str] = Field(default=None, alias="NextToken", description="本次调用返回的查询凭证值，返回为空表示该页为末页。")
    sessioninfo: Optional[list[SessioninfoForListSessions]] = Field(default=None, alias="Sessioninfo", description="符合条件的会话信息。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# UpdateTool - Request
class UpdateToolRequest(BaseModel):
    description: Optional[str] = Field(default=None, alias="Description", description="工具的描述，取值：长度限制为 1000 以内的 Unicode 字符。")
    tool_id: str = Field(..., alias="ToolId", description="工具ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# UpdateTool - Response
class UpdateToolResponse(BaseModel):
    tool_id: Optional[str] = Field(default=None, alias="ToolId", description="工具ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# DeleteSession - Request
class DeleteSessionRequest(BaseModel):
    session_id: str = Field(..., alias="SessionId", description="会话ID。")
    tool_id: Optional[str] = Field(default=None, alias="ToolId", description="工具ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# DeleteSession - Response
class DeleteSessionResponse(BaseModel):
    session_id: Optional[str] = Field(default=None, alias="SessionId", description="会话ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }

