# Copyright (c) 2025 Beijing Volcano Engine Technology Co., Ltd. and/or its affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated from API JSON definition
# Do not edit manually

from __future__ import annotations

from typing import Optional, List, Dict, Any
from pydantic import BaseModel, Field


# Data Types
class KnowledgeBasesForAddKnowledgeBase(BaseModel):
    knowledge_id: Optional[str] = Field(default=None, alias="KnowledgeId")
    message: Optional[str] = Field(default=None, alias="Message")
    provider_knowledge_id: Optional[str] = Field(default=None, alias="ProviderKnowledgeId")
    provider_type: Optional[str] = Field(default=None, alias="ProviderType")
    status: Optional[str] = Field(default=None, alias="Status")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ConnectionInfosForGetKnowledgeConnectionInfo(BaseModel):
    auth_key: Optional[str] = Field(default=None, alias="AuthKey")
    auth_type: Optional[str] = Field(default=None, alias="AuthType")
    base_url: Optional[str] = Field(default=None, alias="BaseUrl")
    expire_at: Optional[str] = Field(default=None, alias="ExpireAt")
    extra_config: Optional[str] = Field(default=None, alias="ExtraConfig")
    region: Optional[str] = Field(default=None, alias="Region")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class KnowledgeBasesForListKnowledgeBases(BaseModel):
    create_time: Optional[str] = Field(default=None, alias="CreateTime")
    description: Optional[str] = Field(default=None, alias="Description")
    knowledge_id: Optional[str] = Field(default=None, alias="KnowledgeId")
    last_update_time: Optional[str] = Field(default=None, alias="LastUpdateTime")
    name: Optional[str] = Field(default=None, alias="Name")
    provider_knowledge_id: Optional[str] = Field(default=None, alias="ProviderKnowledgeId")
    provider_type: Optional[str] = Field(default=None, alias="ProviderType")
    status: Optional[str] = Field(default=None, alias="Status")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# AddKnowledgeBase - Request
class KnowledgeBasesItem(BaseModel):
    name: str = Field(..., alias="Name", description="待导入知识库名称。 - 参数 - N：表示知识库的序号，取值范围：1～10。 - 多个字段名之间用&分隔。 取值： - Viking知识库需填入CollectionName。")
    provider_knowledge_id: str = Field(..., alias="ProviderKnowledgeId", description="待导入知识库ID。 - 参数 - N：表示知识库的序号，取值范围：1～10。 - 多个字段名之间用&分隔。 取值： - Viking知识库需使用ResourceId。")
    provider_type: str = Field(..., alias="ProviderType", description="待导入知识库平台类型。 - 参数 - N：表示知识库的序号，取值范围：1～10。 - 多个字段名之间用&分隔。 取值： - VIKINGDB_KNOWLEDGE：Viking知识库。")
    description: Optional[str] = Field(default=None, alias="Description", description="待导入知识库的描述。 - 参数 - N：表示知识库的序号，取值范围：1～10。 - 不填默认为空。 - 多个字段名之间用&分隔。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class AddKnowledgeBaseRequest(BaseModel):
    client_token: Optional[str] = Field(default=None, alias="ClientToken", description="保证请求幂等性。由客户端自动生成一个参数值，确保不同请求间该参数值唯一，避免当调用API超时或服务器内部错误时，客户端多次重试导致重复性操作。 取值：仅支持ASCII字符，且不能超过64个字符。")
    project_name: Optional[str] = Field(default=None, alias="ProjectName", description="知识库所属项目名称，不填默认为default。")
    knowledge_bases: Optional[list[KnowledgeBasesItem]] = Field(default=None, alias="KnowledgeBases")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# AddKnowledgeBase - Response
class AddKnowledgeBaseResponse(BaseModel):
    knowledge_bases: Optional[list[KnowledgeBasesForAddKnowledgeBase]] = Field(default=None, alias="KnowledgeBases", description="知识库信息。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetKnowledgeConnectionInfo - Request
class GetKnowledgeConnectionInfoRequest(BaseModel):
    knowledge_id: str = Field(..., alias="KnowledgeId", description="知识库ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# GetKnowledgeConnectionInfo - Response
class GetKnowledgeConnectionInfoResponse(BaseModel):
    connection_infos: Optional[list[ConnectionInfosForGetKnowledgeConnectionInfo]] = Field(default=None, alias="ConnectionInfos", description="知识库的连接信息。")
    knowledge_id: Optional[str] = Field(default=None, alias="KnowledgeId", description="知识库ID。")
    message: Optional[str] = Field(default=None, alias="Message", description="状态消息，包含额外的状态信息或错误描述。")
    name: Optional[str] = Field(default=None, alias="Name", description="知识库名称。")
    project_name: Optional[str] = Field(default=None, alias="ProjectName", description="已导入的知识库所属项目名称。")
    provider_knowledge_id: Optional[str] = Field(default=None, alias="ProviderKnowledgeId", description="已导入的知识库所属项目ID。")
    provider_type: Optional[str] = Field(default=None, alias="ProviderType", description="已导入的知识库平台类型。取值： - VIKINGDB_KNOWLEDGE：Viking知识库。")
    status: Optional[str] = Field(default=None, alias="Status", description="知识库状态，取值： - Importing：导入中。 - ImportFailed：导入失败。 - Ready：成功。 - Deleting：删除中。 - DeleteFailed：删除失败。 - Deleted：已删除。 - Error：错误。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# DeleteKnowledgeBase - Request
class DeleteKnowledgeBaseRequest(BaseModel):
    knowledge_id: str = Field(..., alias="KnowledgeId", description="知识库ID。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# DeleteKnowledgeBase - Response
class DeleteKnowledgeBaseResponse(BaseModel):
    knowledge_id: Optional[str] = Field(default=None, alias="KnowledgeId", description="知识库ID。")
    provider_knowledge_id: Optional[str] = Field(default=None, alias="ProviderKnowledgeId", description="导入的知识库ID。")
    provider_type: Optional[str] = Field(default=None, alias="ProviderType", description="导入的知识库平台类型。取值： - VIKINGDB_KNOWLEDGE：Viking知识库。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListKnowledgeBases - Request
class FiltersItem(BaseModel):
    name: Optional[str] = Field(default=None, alias="Name", description="精确过滤的字段名。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔，为“或”的关系。 - 取值： - knowledge_id：知识库ID。 - name：知识库名称。 - status：知识库状态。 - provider_type：导入的知识库平台类型。 ::: tip 当`Filters.N.Name`和`Filters.N.NameContains`同时传入时，仅`Filters.N.Name`生效。 :::")
    name_contains: Optional[str] = Field(default=None, alias="NameContains", description="模糊过滤的字段名。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔，为“或”的关系。 - 取值： - knowledge_id：知识库ID。 - name：知识库名称。 - status：知识库状态。 - provider_type：导入的知识库平台类型。 ::: tip 当`Filters.N.Name`和`Filters.N.NameContains`同时传入时，仅`Filters.N.Name`生效。 :::")
    values: Optional[list[str]] = Field(default=None, alias="Values", description="过滤字段的值。 - 参数 - N：表示过滤条件的序号，取值范围：1～10。 - 多个字段名之间用&分隔。 当过滤字段为provider_type时，取值： - VIKINGDB_KNOWLEDGE：Viking知识库。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


class ListKnowledgeBasesRequest(BaseModel):
    create_time_after: Optional[str] = Field(default=None, alias="CreateTimeAfter", description="筛选该时间点后创建的知识库。（RFC3339格式）")
    create_time_before: Optional[str] = Field(default=None, alias="CreateTimeBefore", description="筛选该时间点前创建的知识库。（RFC3339格式）")
    max_results: Optional[int] = Field(default=None, alias="MaxResults", description="分页查询时设置的每页行数。 - 最小值：1。 - 最大值：100。 - 默认值：10。")
    next_token: Optional[str] = Field(default=None, alias="NextToken", description="分页查询凭证，用于标记分页的位置，初次调用该接口时无需设置。下次查询时，取值为上一次API调用返回的`NextToken`参数值。")
    update_time_after: Optional[str] = Field(default=None, alias="UpdateTimeAfter", description="筛选该时间点后更新的知识库。（RFC3339格式）")
    update_time_before: Optional[str] = Field(default=None, alias="UpdateTimeBefore", description="筛选该时间点前更新的知识库。（RFC3339格式）")
    filters: Optional[list[FiltersItem]] = Field(default=None, alias="Filters")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }


# ListKnowledgeBases - Response
class ListKnowledgeBasesResponse(BaseModel):
    knowledge_bases: Optional[list[KnowledgeBasesForListKnowledgeBases]] = Field(default=None, alias="KnowledgeBases", description="符合要求的知识库信息。")
    page_number: Optional[int] = Field(default=None, alias="PageNumber")
    page_size: Optional[int] = Field(default=None, alias="PageSize")
    total_count: Optional[int] = Field(default=None, alias="TotalCount", description="符合要求的知识库总个数。")
    
    model_config = {
        "populate_by_name": True,
        "arbitrary_types_allowed": True
    }

