# Copyright (c) 2025 Beijing Volcano Engine Technology Co., Ltd. and/or its affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""AgentKit CLI - Deploy command implementation."""

from pathlib import Path
import typer
from rich.console import Console
from agentkit.toolkit.config import get_config

# Note: 不要在文件开头导很重的包，不然会导致命令很卡(import包很慢)

console = Console()


def deploy_command(
    config_file: Path = typer.Option("agentkit.yaml", help="Configuration file"),
):
    """Deploy the Agent to target environment."""
    from agentkit.toolkit import sdk
    
    console.print(f"[green]Deploying with {config_file}[/green]")
    
    # Call SDK
    result = sdk.deploy(config_file=str(config_file))
    
    # Format output
    if result.success:
        console.print(f"[green]✅ Deployment successful[/green]")
        if result.endpoint_url:
            console.print(f"[green]Endpoint: {result.endpoint_url}[/green]")
        if result.container_id:
            console.print(f"[green]Container ID: {result.container_id}[/green]")
        if result.service_id:
            console.print(f"[green]Service ID: {result.service_id}[/green]")
    else:
        console.print(f"[red]❌ Deployment failed: {result.error}[/red]")
        if result.deploy_logs:
            for log in result.deploy_logs:
                if log.strip():
                    console.print(f"[red]{log}[/red]")
        raise typer.Exit(1)
