# Copyright (c) 2025 Beijing Volcano Engine Technology Co., Ltd. and/or its affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Agent file information model."""

from dataclasses import dataclass, field
from typing import List, Optional


@dataclass
class AgentFileInfo:
    """Information extracted from user's Agent file."""
    
    file_path: str
    """Original file path."""
    
    agent_var_name: str
    """Variable name of the Agent object."""
    
    module_name: str
    """Module name for import (without .py extension)."""
    
    file_name: str
    """File name with extension."""
    
    imports: List[str] = field(default_factory=list)
    """Import statements found in the file."""
    
    has_runner: bool = False
    """Whether a Runner is already defined."""
    
    detected_tools: List[str] = field(default_factory=list)
    """Detected tool names (e.g., ['web_search', 'run_code'])."""
    
    has_entrypoint: bool = False
    """Whether the file already has an entrypoint function."""
    
    def __str__(self) -> str:
        """String representation."""
        return (
            f"AgentFileInfo(file={self.file_name}, "
            f"agent_var={self.agent_var_name}, "
            f"has_runner={self.has_runner})"
        )
