"""Config for Sherlock."""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/03_config.ipynb.

# %% auto 0
__all__ = ['FewsatsMarketplaceConfig', 'get_cfg', 'save_cfg']

# %% ../nbs/03_config.ipynb 3
from fastcore.all import *
from fastcore.xdg import *
from typing import get_type_hints
from dataclasses import dataclass
import json

# %% ../nbs/03_config.ipynb 4
@dataclass
class FewsatsMarketplaceConfig:
    priv: str = ''  # private key (hex)

def _cfg_path(): return xdg_config_home() / 'fewsats' / 'marketplace.conf'
_cfg_path()

# %% ../nbs/03_config.ipynb 5
def get_cfg(path = None):
    "Get config from XDG config dir, creating if needed"
    if path is None: path = _cfg_path()
    path.parent.mkdir(parents=True, exist_ok=True)
    _types = get_type_hints(FewsatsMarketplaceConfig)
    return Config(path.parent, path.name, create=asdict(FewsatsMarketplaceConfig()),
                 types=_types, inline_comment_prefixes=('#'))

def save_cfg(cfg: dict, path = None):
    "Save config to file"
    if path is None: path = _cfg_path()
    path.parent.mkdir(parents=True, exist_ok=True)
    save_config_file(path, cfg)
