"""Some cryptograhpy functions for AI agents."""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/02_crypto.ipynb.

# %% auto 0
__all__ = ['generate_keys', 'from_pk_hex', 'priv_key_hex']

# %% ../nbs/02_crypto.ipynb 3
from cryptography.hazmat.primitives.asymmetric import ed25519
import secrets; secrets.token_hex(32)

# %% ../nbs/02_crypto.ipynb 7
def generate_keys():
    pk = ed25519.Ed25519PrivateKey.generate()
    pub = pk.public_key().public_bytes_raw().hex()
    return pk, pub


# %% ../nbs/02_crypto.ipynb 11
def from_pk_hex(priv):
    pk = ed25519.Ed25519PrivateKey.from_private_bytes(bytes.fromhex(priv))
    return pk, pk.public_key().public_bytes_raw().hex()

def priv_key_hex(pk):
    return pk.private_bytes_raw().hex()
