# ahs_orchestator_client
AHS Orchestrator API's

This Python package is automatically generated by the [OpenAPI JSON Schema Generator](https://github.com/openapi-json-schema-tools/openapi-json-schema-generator) project:

- API version: 1.0.0
- Package version: 1.0.1
- Build package: PythonClientGenerator

## Requirements

Python &gt;&#x3D;3.8

## Migration Guides
- [3.0.0 Migration Guide](migration_3_0_0.md)
- [2.0.0 Migration Guide](migration_2_0_0.md)
- [Migration from Other Python Generators](migration_other_python_generators.md)


## Installation
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import ahs_orchestator_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python -m pip install . --user
```
(or `python -m pip install .` to install the package for all users)

Then import the package:
```python
import ahs_orchestator_client
```

## Usage Notes
### Validation, Immutability, and Data Type
This python code validates data to schema classes and return back an immutable instance containing the data
which subclasses all validated schema classes. This ensure that
- valid data cannot be mutated and become invalid to a set of schemas
  - the one exception is that files are not immutable, so schema instances storing/sending/receiving files are not immutable

Here is the mapping from json schema types to python subclassed types:
| Json Schema Type | Python Base Class |
| ---------------- | ----------------- |
| object           | schemas.immutabledict |
| array            | tuple |
| string           | str |
| number           | float, int |
| integer          | int |
| boolean          | bool |
| null             | None |
| AnyType (unset)  | typing.Union[schemas.immutabledict, tuple, str, float, int, bool, None] |

### Storage of Json Schema Definition in Python Classes
In openapi v3.0.3 there are ~ 28 json schema keywords. Almost all of them can apply if
type is unset. I have chosen to separate the storage of json schema definition info and output
validated classes for payload instantiation.

<details>
  <summary>Reason</summary>

This json schema data is stored in each class that is written for a schema, in a component or
other openapi document location. This class is only responsible for storing schema info.
Output classes like those that store dict payloads are written separately and are
returned by the Schema.validate method when that method is passed in dict input.
This prevents payload property access methods from
colliding with json schema definition.
</details>

### Json Schema Type Object
Most component schemas (models) are probably of type object. Which is a map data structure.
Json schema allows string keys in this map, which means schema properties can have key names that are
invalid python variable names. Names like:
- "hi-there"
- "1variable"
- "@now"
- " "
- "from"

To allow these use cases to work, schemas.immutabledict is used as the base class of type object schemas.
This means that one can use normal dict methods on instances of these classes.

<details>
  <summary>Other Details</summary>

- optional properties which were not set will not exist in the instance
- None is only allowed in as a value if type: "null" was included or nullable: true was set
- preserving the original key names is required to properly validate a payload to multiple json schemas
</details>

### Json Schema Type + Format, Validated Data Storage
N schemas can be validated on the same payload.
To allow multiple schemas to validate, the data must be stored using one base class whether or not
a json schema format constraint exists in the schema.
See the below accessors for string data:
- type string + format: See schemas.as_date, schemas.as_datetime, schemas.as_decimal, schemas.as_uuid

In json schema, type: number with no format validates both integers and floats,
so int and float values are stored for type number.

<details>
  <summary>String + Date Example</summary>

For example the string payload '2023-12-20' is validates to both of these schemas:
1. string only
```
- type: string
```
2. string and date format
```
- type: string
  format: date
```
Because of use cases like this, a datetime.date is allowed as an input to this schema, but the data
is stored as a string.
</details>

## Getting Started

Please follow the [installation procedure](#installation) and then run the following:

```python
import ahs_orchestator_client
from ahs_orchestator_client.configurations import api_configuration
from ahs_orchestator_client.apis.tags import default_api
from pprint import pprint
used_configuration = api_configuration.ApiConfiguration(
)
# Enter a context with an instance of the API client
with ahs_orchestator_client.ApiClient(used_configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)

    # example, this endpoint has no required or optional parameters
    try:
        # Welcome
        api_response = api_instance.welcome__get()
        pprint(api_response)
    except ahs_orchestator_client.ApiException as e:
        print("Exception when calling DefaultApi->welcome__get: %s\n" % e)
```

## Servers
server_index | Class | Description
------------ | ----- | ------------
0 | [Server0](docs/servers/server_0.md) |

## Endpoints

All URIs are relative to the selected server
- The server is selected by passing in server_info and server_index into api_configuration.ApiConfiguration
- Code samples in endpoints documents show how to do this
- server_index can also be passed in to endpoint calls, see endpoint documentation

HTTP request | Method | Description
------------ | ------ | -------------
/ **get** | [DefaultApi](docs/apis/tags/default_api.md).[welcome__get](docs/paths/solidus/get.md)  | Welcome
/api/v1/casfirmware **get** | [CasFirmwareApi](docs/apis/tags/cas_firmware_api.md).[get_cas_firmware_api_v1_casfirmware_get](docs/paths/api_v1_casfirmware/get.md)  | Get Cas Firmware
/api/v1/correctiveactions/testbed/{build_number}/status **get** | [CorrectiveActionsApi](docs/apis/tags/corrective_actions_api.md).[get_testbed_cas_by_build_number_api_v1_correctiveactions_testbed__build_number__status_get](docs/paths/api_v1_correctiveactions_testbed_build_number_status/get.md)  | Get Testbed Cas By Build Number
/api/v1/correctiveactions/testbed/{testbed_id} **get** | [CorrectiveActionsApi](docs/apis/tags/corrective_actions_api.md).[check_cas_by_testbed_id_api_v1_correctiveactions_testbed__testbed_id__get](docs/paths/api_v1_correctiveactions_testbed_testbed_id/get.md)  | Check Cas By Testbed Id
/api/v1/correctiveactions/testbed/{testbed_id}/run **post** | [CorrectiveActionsApi](docs/apis/tags/corrective_actions_api.md).[trigger_cas_build_with_testbed_id_and_get_build_number_api_v1_correctiveactions_testbed__testbed_id__run_post](docs/paths/api_v1_correctiveactions_testbed_testbed_id_run/post.md)  | Trigger Cas Build With Testbed Id And Get Build Number
/api/v1/device/{device_id}/location **get** | [DeviceLocationsApi](docs/apis/tags/device_locations_api.md).[get_device_location_api_v1_device__device_id__location_get](docs/paths/api_v1_device_device_id_location/get.md)  | Get Device Location
/api/v1/health **get** | [HealthApi](docs/apis/tags/health_api.md).[health_api_v1_health_get](docs/paths/api_v1_health/get.md)  | Health
/api/v1/health/env **get** | [HealthApi](docs/apis/tags/health_api.md).[health_api_v1_health_env_get](docs/paths/api_v1_health_env/get.md)  | Health
/api/v1/healthchecks/testbed/build/{build_number}/status **get** | [HealthChecksApi](docs/apis/tags/health_checks_api.md).[get_testbed_health_by_build_number_api_v1_healthchecks_testbed_build__build_number__status_get](docs/paths/api_v1_healthchecks_testbed_build_build_number_status/get.md)  | Get Testbed Health By Build Number
/api/v1/healthchecks/testbed/{testbed_id}/run **post** | [HealthChecksApi](docs/apis/tags/health_checks_api.md).[trigger_build_with_testbed_id_and_get_build_number_api_v1_healthchecks_testbed__testbed_id__run_post](docs/paths/api_v1_healthchecks_testbed_testbed_id_run/post.md)  | Trigger Build With Testbed Id And Get Build Number
/api/v1/healthcheks **get** | [HealthChecksApi](docs/apis/tags/health_checks_api.md).[get_health_checks_api_v1_healthcheks_get](docs/paths/api_v1_healthcheks/get.md)  | Get Health Checks
/api/v1/healthcheks/{health_check_id} **get** | [HealthChecksApi](docs/apis/tags/health_checks_api.md).[get_health_checks_by_id_api_v1_healthcheks__health_check_id__get](docs/paths/api_v1_healthcheks_health_check_id/get.md)  | Get Health Checks By Id
/api/v1/healthchekssequence **get** | [HealthCheckSequencesApi](docs/apis/tags/health_check_sequences_api.md).[get_health_check_sequences_api_v1_healthchekssequence_get](docs/paths/api_v1_healthchekssequence/get.md)  | Get Health Check Sequences
/api/v1/healthchekssequence/{health_check_definition_id} **get** | [HealthCheckSequencesApi](docs/apis/tags/health_check_sequences_api.md).[get_health_check_sequence_by_id_api_v1_healthchekssequence__health_check_definition_id__get](docs/paths/api_v1_healthchekssequence_health_check_definition_id/get.md)  | Get Health Check Sequence By Id
/api/v1/jenkins/build/trigger **post** | [JenkinsApi](docs/apis/tags/jenkins_api.md).[trigger_build_api_v1_jenkins_build_trigger_post](docs/paths/api_v1_jenkins_build_trigger/post.md)  | Trigger Build
/api/v1/jenkins/build/{build_number}/status **get** | [JenkinsApi](docs/apis/tags/jenkins_api.md).[build_status_api_v1_jenkins_build__build_number__status_get](docs/paths/api_v1_jenkins_build_build_number_status/get.md)  | Build Status
/api/v1/jenkins/jobs **get** | [JenkinsApi](docs/apis/tags/jenkins_api.md).[job_info_api_v1_jenkins_jobs_get](docs/paths/api_v1_jenkins_jobs/get.md)  | Job Info
/api/v1/jenkins/queue/{queue_id} **get** | [JenkinsApi](docs/apis/tags/jenkins_api.md).[build_details_by_queue_api_v1_jenkins_queue__queue_id__get](docs/paths/api_v1_jenkins_queue_queue_id/get.md)  | Build Details By Queue
/api/v1/metric **post** | [MetricApi](docs/apis/tags/metric_api.md).[add_metric_api_v1_metric_post](docs/paths/api_v1_metric/post.md)  | Add Metric
/api/v1/metric **put** | [MetricApi](docs/apis/tags/metric_api.md).[update_metric_api_v1_metric_put](docs/paths/api_v1_metric/put.md)  | Update Metric
/api/v1/metric/{metric}/testbed/{testbed_id} **get** | [MetricApi](docs/apis/tags/metric_api.md).[get_testbed_metric_api_v1_metric__metric__testbed__testbed_id__get](docs/paths/api_v1_metric_metric_testbed_testbed_id/get.md)  | Get Testbed Metric
/api/v1/testbed **get** | [TestbedApi](docs/apis/tags/testbed_api.md).[get_testbeds_api_v1_testbed_get](docs/paths/api_v1_testbed/get.md)  | Get Testbeds
/api/v1/testbed **post** | [TestbedApi](docs/apis/tags/testbed_api.md).[add_testbed_api_v1_testbed_post](docs/paths/api_v1_testbed/post.md)  | Add Testbed
/api/v1/testbed **put** | [TestbedApi](docs/apis/tags/testbed_api.md).[update_testbed_api_v1_testbed_put](docs/paths/api_v1_testbed/put.md)  | Update Testbed
/api/v1/testbed/details **get** | [TestbedApi](docs/apis/tags/testbed_api.md).[get_testbeds_details_api_v1_testbed_details_get](docs/paths/api_v1_testbed_details/get.md)  | Get Testbeds Details
/api/v1/testbed/status **post** | [TestbedApi](docs/apis/tags/testbed_api.md).[override_testbed_status_api_v1_testbed_status_post](docs/paths/api_v1_testbed_status/post.md)  | Override Testbed Status
/api/v1/testbed/{testbed_id} **get** | [TestbedApi](docs/apis/tags/testbed_api.md).[get_testbed_by_id_api_v1_testbed__testbed_id__get](docs/paths/api_v1_testbed_testbed_id/get.md)  | Get Testbed By Id

## Component Schemas

Class | Description
----- | ------------
[BuildDetailsResponseModel](docs/components/schema/build_details_response_model.md) |
[BuildParameters](docs/components/schema/build_parameters.md) |
[CasFirmwareConfig](docs/components/schema/cas_firmware_config.md) |
[HTTPValidationError](docs/components/schema/http_validation_error.md) |
[Metric](docs/components/schema/metric.md) |
[PageResponseTestbed](docs/components/schema/page_response_testbed.md) |
[ResponseTestbed](docs/components/schema/response_testbed.md) |
[Testbed](docs/components/schema/testbed.md) |
[TestbedStatus](docs/components/schema/testbed_status.md) |
[TestbedStatusEnum](docs/components/schema/testbed_status_enum.md) | An enumeration.
[ValidationError](docs/components/schema/validation_error.md) |

## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in ahs_orchestator_client.apis.tags.tag_to_api and ahs_orchestator_client.components.schemas may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- tagged api: `from ahs_orchestator_client.apis.tags.default_api import DefaultApi`
- api for one path: `from ahs_orchestator_client.apis.paths.some_path import SomePath`
- api for one operation (path + verb): `from ahs_orchestator_client.paths.some_path.get import ApiForget`
- single model import: `from ahs_orchestator_client.components.schema.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import ahs_orchestator_client
from ahs_orchestator_client.apis.tags.tag_to_api import *
from ahs_orchestator_client.components.schemas import *
```
