# airflow-python-sdk
Apache Airflow management API.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project based on [the specs](https://github.com/zachliu/airflow-openapi-specs):

- API version: 1.0.0
- Package version: 0.0.5
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://github.com/zachliu](https://github.com/zachliu)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

The python package is hosted on PyPI, you can install directly using:

```sh
pip install airflow-python-sdk
```

Then import the package:
```python
import airflow_python_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import airflow_python_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import airflow_python_sdk
from pprint import pprint
from airflow_python_sdk.api import config_api
from airflow_python_sdk.model.config import Config
from airflow_python_sdk.model.error import Error
# Defining the host is optional and defaults to http://localhost/api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = airflow_python_sdk.Configuration(
    host = "http://localhost/api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = airflow_python_sdk.Configuration(
    host = "https://<your-airflow-2.0.0>/api/v1",
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)


# Enter a context with an instance of the API client
with airflow_python_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = config_api.ConfigApi(api_client)
    limit = 100 # int | The numbers of items to return. (optional) (default to 100)
offset = 0 # int | The number of items to skip before starting to collect the result set. (optional)

    try:
        # Get current configuration
        api_response = api_instance.get_config(limit=limit, offset=offset)
        pprint(api_response)
    except airflow_python_sdk.ApiException as e:
        print("Exception when calling ConfigApi->get_config: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ConfigApi* | [**get_config**](docs/ConfigApi.md#get_config) | **GET** /config | Get current configuration
*ConnectionApi* | [**create_connection**](docs/ConnectionApi.md#create_connection) | **POST** /connections | Create connection entry
*ConnectionApi* | [**delete_connection**](docs/ConnectionApi.md#delete_connection) | **DELETE** /connections/{connection_id} | Delete a connection entry
*ConnectionApi* | [**get_connection**](docs/ConnectionApi.md#get_connection) | **GET** /connections/{connection_id} | Get a connection entry
*ConnectionApi* | [**get_connections**](docs/ConnectionApi.md#get_connections) | **GET** /connections | Get all connection entries
*ConnectionApi* | [**patch_connection**](docs/ConnectionApi.md#patch_connection) | **PATCH** /connections/{connection_id} | Update a connection entry
*DAGApi* | [**get_dag**](docs/DAGApi.md#get_dag) | **GET** /dags/{dag_id} | Get basic information about a DAG
*DAGApi* | [**get_dag_source**](docs/DAGApi.md#get_dag_source) | **GET** /dagSources/{file_token} | Get source code using file token
*DAGApi* | [**get_dag_structure**](docs/DAGApi.md#get_dag_structure) | **GET** /dags/{dag_id}/structure | Get simplified representation of DAG.
*DAGApi* | [**get_dags**](docs/DAGApi.md#get_dags) | **GET** /dags | Get all DAGs
*DAGApi* | [**get_task**](docs/DAGApi.md#get_task) | **GET** /dags/{dag_id}/tasks/{task_id} | Get simplified representation of a task.
*DAGApi* | [**get_tasks**](docs/DAGApi.md#get_tasks) | **GET** /dags/{dag_id}/tasks | Get tasks for DAG
*DAGApi* | [**update_dag**](docs/DAGApi.md#update_dag) | **PATCH** /dags/{dag_id} | Update the specific DAG
*DAGRunApi* | [**delete_dag_run**](docs/DAGRunApi.md#delete_dag_run) | **DELETE** /dags/{dag_id}/dagRuns/{dag_run_id} | Delete a DAG Run
*DAGRunApi* | [**get_dag_run**](docs/DAGRunApi.md#get_dag_run) | **GET** /dags/{dag_id}/dagRuns/{dag_run_id} | Get a DAG Run
*DAGRunApi* | [**get_dag_runs**](docs/DAGRunApi.md#get_dag_runs) | **GET** /dags/{dag_id}/dagRuns | Get all DAG Runs
*DAGRunApi* | [**update_dag_run**](docs/DAGRunApi.md#update_dag_run) | **PATCH** /dags/{dag_id}/dagRuns/{dag_run_id} | Update a DAG Run
*EventLogApi* | [**create_event_log**](docs/EventLogApi.md#create_event_log) | **POST** /eventLogs | Create event log
*EventLogApi* | [**delete_event_log_entry**](docs/EventLogApi.md#delete_event_log_entry) | **DELETE** /eventLogs/{event_log_id} | Delete a log entry
*EventLogApi* | [**get_event_log**](docs/EventLogApi.md#get_event_log) | **GET** /eventLogs | Get all log entries from event log
*EventLogApi* | [**get_event_log_entry**](docs/EventLogApi.md#get_event_log_entry) | **GET** /eventLogs/{event_log_id} | Get a log entry
*EventLogApi* | [**update_event_log_entry**](docs/EventLogApi.md#update_event_log_entry) | **PATCH** /eventLogs/{event_log_id} | Update a log entry
*ImportErrorApi* | [**delete_import_error**](docs/ImportErrorApi.md#delete_import_error) | **DELETE** /importErrors/{import_error_id} | Delete an import error
*ImportErrorApi* | [**get_import_error**](docs/ImportErrorApi.md#get_import_error) | **GET** /importErrors/{import_error_id} | Get an import errors
*ImportErrorApi* | [**get_import_errors**](docs/ImportErrorApi.md#get_import_errors) | **GET** /importErrors | Get all import errors
*PoolApi* | [**create_pool**](docs/PoolApi.md#create_pool) | **POST** /pools | Create aa pool
*PoolApi* | [**delete_pool**](docs/PoolApi.md#delete_pool) | **DELETE** /pools/{pool_id} | Delete a pool
*PoolApi* | [**get_pool**](docs/PoolApi.md#get_pool) | **GET** /pools/{pool_id} | Get a pool
*PoolApi* | [**get_pools**](docs/PoolApi.md#get_pools) | **GET** /pools | Get all pools
*PoolApi* | [**get_task_instances**](docs/PoolApi.md#get_task_instances) | **GET** /dags/{dag_id}/taskInstances | Get list of task instance of DAG.
*PoolApi* | [**upadte_pool**](docs/PoolApi.md#upadte_pool) | **PATCH** /pools/{pool_id} | Update a pool
*TaskInstanceApi* | [**delete_task_instance**](docs/TaskInstanceApi.md#delete_task_instance) | **DELETE** /dags/{dag_id}/taskInstances/{task_id}/{execution_date} | Delete DAG Run
*TaskInstanceApi* | [**get_extra_links**](docs/TaskInstanceApi.md#get_extra_links) | **GET** /dags/{dag_id}/taskInstances/{task_id}/{execution_date}/links | Get extra links for task instance
*TaskInstanceApi* | [**get_logs**](docs/TaskInstanceApi.md#get_logs) | **GET** /dags/{dag_id}/taskInstances/{task_id}/{execution_date}/logs/{task_try_number} | Get logs for specific task instance
*TaskInstanceApi* | [**get_task_instance**](docs/TaskInstanceApi.md#get_task_instance) | **GET** /dags/{dag_id}/taskInstances/{task_id}/{execution_date} | Get a task instance
*TaskInstanceApi* | [**update_task_instance**](docs/TaskInstanceApi.md#update_task_instance) | **PATCH** /dags/{dag_id}/taskInstances/{task_id}/{execution_date} | Update a task instance
*VariableApi* | [**create_variable**](docs/VariableApi.md#create_variable) | **POST** /variables | Create a variables
*VariableApi* | [**delete_variable**](docs/VariableApi.md#delete_variable) | **DELETE** /variables/{variable_id} | Delete variable
*VariableApi* | [**get_variable**](docs/VariableApi.md#get_variable) | **GET** /variables/{variable_id} | Get a variables by id
*VariableApi* | [**get_variables**](docs/VariableApi.md#get_variables) | **GET** /variables | Get all variables
*VariableApi* | [**lookup_variable**](docs/VariableApi.md#lookup_variable) | **GET** /variables/lookup | Get variable using its key.
*VariableApi* | [**update_variable**](docs/VariableApi.md#update_variable) | **PATCH** /variables/{variable_id} | Update a variable by id
*XComApi* | [**delete_x_com_value**](docs/XComApi.md#delete_x_com_value) | **DELETE** /dags/{dag_id}/taskInstances/{task_id}/{execution_date}/xcomValues/{key} | Delete an XCom entry
*XComApi* | [**get_x_com_value**](docs/XComApi.md#get_x_com_value) | **GET** /dags/{dag_id}/taskInstances/{task_id}/{execution_date}/xcomValues/{key} | Get an XCom entry
*XComApi* | [**get_x_com_values**](docs/XComApi.md#get_x_com_values) | **GET** /dags/{dag_id}/taskInstances/{task_id}/{execution_date}/xcomValues | Get all XCom values
*XComApi* | [**update_x_com_value**](docs/XComApi.md#update_x_com_value) | **PATCH** /dags/{dag_id}/taskInstances/{task_id}/{execution_date}/xcomValues/{key} | Update an XCom entry
*XComApi* | [**update_x_com_values**](docs/XComApi.md#update_x_com_values) | **POST** /dags/{dag_id}/taskInstances/{task_id}/{execution_date}/xcomValues | Create an XCom entry


## Documentation For Models

 - [ClassReference](docs/ClassReference.md)
 - [CollectionInfo](docs/CollectionInfo.md)
 - [Color](docs/Color.md)
 - [Config](docs/Config.md)
 - [ConfigOption](docs/ConfigOption.md)
 - [ConfigSection](docs/ConfigSection.md)
 - [Connection](docs/Connection.md)
 - [ConnectionAllOf](docs/ConnectionAllOf.md)
 - [ConnectionCollection](docs/ConnectionCollection.md)
 - [ConnectionCollectionItem](docs/ConnectionCollectionItem.md)
 - [CronExpression](docs/CronExpression.md)
 - [DAG](docs/DAG.md)
 - [DAGCollection](docs/DAGCollection.md)
 - [DAGRun](docs/DAGRun.md)
 - [DAGRunCollection](docs/DAGRunCollection.md)
 - [DagState](docs/DagState.md)
 - [DagStructure](docs/DagStructure.md)
 - [DagStructureCollection](docs/DagStructureCollection.md)
 - [Error](docs/Error.md)
 - [EventLog](docs/EventLog.md)
 - [EventLogCollection](docs/EventLogCollection.md)
 - [ExtraLink](docs/ExtraLink.md)
 - [ExtraLinkCollection](docs/ExtraLinkCollection.md)
 - [ImportError](docs/ImportError.md)
 - [ImportErrorCollection](docs/ImportErrorCollection.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [Pool](docs/Pool.md)
 - [PoolCollection](docs/PoolCollection.md)
 - [RelativeDelta](docs/RelativeDelta.md)
 - [SLAMiss](docs/SLAMiss.md)
 - [SLAMissCollection](docs/SLAMissCollection.md)
 - [ScheduleInterval](docs/ScheduleInterval.md)
 - [Tag](docs/Tag.md)
 - [Task](docs/Task.md)
 - [TaskCollection](docs/TaskCollection.md)
 - [TaskExtraLinks](docs/TaskExtraLinks.md)
 - [TaskFail](docs/TaskFail.md)
 - [TaskInstance](docs/TaskInstance.md)
 - [TaskInstanceCollection](docs/TaskInstanceCollection.md)
 - [TaskState](docs/TaskState.md)
 - [TimeDelta](docs/TimeDelta.md)
 - [TriggerRule](docs/TriggerRule.md)
 - [Variable](docs/Variable.md)
 - [VariableAllOf](docs/VariableAllOf.md)
 - [VariableCollection](docs/VariableCollection.md)
 - [VariableCollectionItem](docs/VariableCollectionItem.md)
 - [WeightRule](docs/WeightRule.md)
 - [XCom](docs/XCom.md)
 - [XComCollection](docs/XComCollection.md)
 - [XComCollectionItem](docs/XComCollectionItem.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## Author

zach.z.liu@gmail.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in airflow_python_sdk.apis and airflow_python_sdk.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from airflow_python_sdk.api.default_api import DefaultApi`
- `from airflow_python_sdk.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import airflow_python_sdk
from airflow_python_sdk.apis import *
from airflow_python_sdk.models import *
```

