"""
    Airflow API (Stable)

    Apache Airflow management API.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: zach.z.liu@gmail.com
    Generated by: https://openapi-generator.tech
"""

from test.integration.conftest import BCOLORS

import logging
from dateutil.parser import parse

from airflow_python_sdk.model.list_task_instance_form import ListTaskInstanceForm


def test_get_task_instances(task_instance_api_setup):
    """Test the /dags/{dag_id}/dagRuns/{dag_run_id}/taskInstances API EP"""
    api_response = task_instance_api_setup.get_task_instances(
        dag_id="test_glue_partitions_sensor",
        dag_run_id="scheduled__2020-04-13T00:00:00+00:00",
    )
    logging.getLogger().info("%s", api_response)
    print(f"{BCOLORS.OKGREEN}OK{BCOLORS.ENDC}")


def test_get_task_instances_batch(task_instance_api_setup):
    """Test the /dags/~/dagRuns/~/taskInstances/list API EP"""
    list_task_instance_form = ListTaskInstanceForm(
        dag_ids=[
            "test_glue_partitions_sensor",
        ],
        # ====================================================
        # Uncomment the following to add to the filter
        # ====================================================
        # execution_date_gte=parse('1970-01-01T00:00:00.00Z'),
        # execution_date_lte=parse('1970-01-01T00:00:00.00Z'),
        # start_date_gte=parse('1970-01-01T00:00:00.00Z'),
        # start_date_lte=parse('1970-01-01T00:00:00.00Z'),
        # end_date_gte=parse('1970-01-01T00:00:00.00Z'),
        # end_date_lte=parse('1970-01-01T00:00:00.00Z'),
        # duration_gte=3.14,
        # duration_lte=3.14,
        # state=[
        #     "state_example",
        # ],
        # ====================================================
        pool=[
            "default_pool",
        ],
        # queue=[
        #     "queue_example",
        # ],
    ) # ListTaskInstanceForm |
    api_response = task_instance_api_setup.get_task_instances_batch(
        list_task_instance_form
    )
    logging.getLogger().info("%s", api_response)
    print(f"{BCOLORS.OKGREEN}OK{BCOLORS.ENDC}")
