"""
    Airflow API (Stable)

    Apache Airflow management API.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: zach.z.liu@gmail.com
    Generated by: https://openapi-generator.tech
"""

import logging

from test.integration.conftest import BCOLORS

from airflow_python_sdk.model.variable import Variable

VARIABLE_DICT = {
    "key": "test_variable",
    "value": "{1:2, 3:4}",
}

INIT_VARIABLE = Variable(**VARIABLE_DICT)

def test_create_variable(variable_api_setup):
    """Test the post /variables API EP"""
    api_response = variable_api_setup.post_variables(INIT_VARIABLE)
    logging.getLogger().info("%s", api_response)
    print(f"{BCOLORS.OKGREEN}OK{BCOLORS.ENDC}")

def test_update_variable(variable_api_setup):
    """Test the patch /variables/{variable_key} API EP"""
    VARIABLE_DICT["value"] = "{1:2,5:6}"
    updated_variable = Variable(**VARIABLE_DICT)
    api_response = variable_api_setup.patch_variable(
        "test_variable",
        updated_variable,
    )
    logging.getLogger().info("%s", api_response)
    print(f"{BCOLORS.OKGREEN}OK{BCOLORS.ENDC}")

def test_get_variable(variable_api_setup):
    """Test the get /variables/{variable_key} API EP"""
    VARIABLE_DICT["value"] = "{1:2,5:6}"
    updated_variable = Variable(**VARIABLE_DICT)
    api_response = variable_api_setup.get_variable("test_variable")
    logging.getLogger().info("%s", api_response)
    print(f"{BCOLORS.OKGREEN}OK{BCOLORS.ENDC}")
    assert api_response == updated_variable

def test_delete_variable(variable_api_setup):
    """Test the delete /variables/{variable_key} API EP"""
    api_response = variable_api_setup.delete_variable("test_variable")
    logging.getLogger().info("%s", api_response)
    print(f"{BCOLORS.OKGREEN}OK{BCOLORS.ENDC}")
