"""
    Airflow API (Stable)

    Apache Airflow management API.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: zach.z.liu@gmail.com
    Generated by: https://openapi-generator.tech
"""

import logging

from test.integration.conftest import BCOLORS

import pytest

from airflow_python_sdk.model.time_delta import TimeDelta

@pytest.mark.parametrize(
    "test_input, expected",
    [
        (["example_bash_operator"], TimeDelta(
            type="TimeDelta",
            days=0,
            seconds=3600,
            microseconds=0,
        )),
        (["test_glue_partitions_sensor"], None),
    ],
)
def test_get_dag_details(dag_api_setup, test_input, expected):
    """Test the /dags/{dag_id}/details API EP"""
    dag_id, = test_input
    api_response = dag_api_setup.get_dag_details(
        dag_id=dag_id,
    )
    logging.getLogger().info("%s", api_response)
    print(f"{BCOLORS.OKGREEN}OK{BCOLORS.ENDC}")
    assert api_response.dag_run_timeout == expected
