"""
    Airflow API (Stable)

    Apache Airflow management API.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: zach.z.liu@gmail.com
    Generated by: https://openapi-generator.tech
"""

import logging

from test.integration.conftest import BCOLORS

from airflow_python_sdk.model.dag import DAG


def test_update_dag(dag_api_setup):
    """Test the /dags/{dag_id} API EP (patch)"""
    dag_id = "example_bash_operator"
    dag_before_update = dag_api_setup.get_dag(dag_id=dag_id)
    logging.getLogger().info("Got dag: %s", dag_before_update)
    dag = DAG(
        is_paused=(not dag_before_update.is_paused),
    )
    update_mask = ["is_paused"]
    dag_before_update.is_paused = dag.is_paused
    logging.getLogger().info("Expect update: %s", dag_before_update)
    dag_after_update = dag_api_setup.patch_dag(
        dag_id,
        dag,
        update_mask=update_mask,
    )
    logging.getLogger().info("After update: %s", dag_after_update)
    print(f"{BCOLORS.OKGREEN}OK{BCOLORS.ENDC}")
    assert dag_after_update == dag_before_update
