# Copyright 2018 Google Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Auto generated wordnet mappings for imagenet values to categories."""

MAPPINGS = {
    "black stork/Ciconia nigra":
        "animal, animate being, beast, brute, creature, fauna",
    "drake":
        "animal, animate being, beast, brute, creature, fauna",
    "guinea pig/Cavia cobaya":
        "animal, animate being, beast, brute, creature, fauna",
    "golden retriever":
        "dog, domestic dog, Canis familiaris",
    "echidna/spiny anteater/anteater":
        "animal, animate being, beast, brute, creature, fauna",
    "printer":
        "electronic equipment",
    "ruffed grouse/partridge/Bonasa umbellus":
        "animal, animate being, beast, brute, creature, fauna",
    "beer glass":
        "bottle",
    "Airedale/Airedale terrier":
        "dog, domestic dog, Canis familiaris",
    "hot pot/hotpot":
        "food, nutrient",
    "barrow/garden cart/lawn cart/wheelbarrow":
        "wheeled vehicle",
    "sweatshirt":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "admiral":
        "animal, animate being, beast, brute, creature, fauna",
    "boa constrictor/Constrictor constrictor":
        "animal, animate being, beast, brute, creature, fauna",
    "pizza/pizza pie":
        "food, nutrient",
    "Border terrier":
        "dog, domestic dog, Canis familiaris",
    "chiton/coat-of-mail shell/sea cradle/polyplacophore":
        "animal, animate being, beast, brute, creature, fauna",
    "puffer/pufferfish/blowfish/globefish":
        "animal, animate being, beast, brute, creature, fauna",
    "toy poodle":
        "dog, domestic dog, Canis familiaris",
    "American chameleon/anole/Anolis carolinensis":
        "animal, animate being, beast, brute, creature, fauna",
    "thunder snake/worm snake/Carphophis amoenus":
        "animal, animate being, beast, brute, creature, fauna",
    "fur coat":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "Tibetan terrier/chrysanthemum dog":
        "dog, domestic dog, Canis familiaris",
    "ibex/Capra ibex":
        "animal, animate being, beast, brute, creature, fauna",
    "cricket":
        "animal, animate being, beast, brute, creature, fauna",
    "trench coat":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "ptarmigan":
        "animal, animate being, beast, brute, creature, fauna",
    "abaya":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "European fire salamander/Salamandra salamandra":
        "animal, animate being, beast, brute, creature, fauna",
    "hand-held computer/hand-held microcomputer":
        "computer, computing machine, computing device, data processor, "
        "electronic computer, information processing system",
    "stole":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "mongoose":
        "animal, animate being, beast, brute, creature, fauna",
    "bull mastiff":
        "dog, domestic dog, Canis familiaris",
    "lynx/catamount":
        "animal, animate being, beast, brute, creature, fauna",
    "cab/hack/taxi/taxicab":
        "wheeled vehicle",
    "basset/basset hound":
        "dog, domestic dog, Canis familiaris",
    "sea anemone/anemone":
        "animal, animate being, beast, brute, creature, fauna",
    "fiddler crab":
        "animal, animate being, beast, brute, creature, fauna",
    "Indian cobra/Naja naja":
        "animal, animate being, beast, brute, creature, fauna",
    "black-footed ferret/ferret/Mustela nigripes":
        "animal, animate being, beast, brute, creature, fauna",
    "leaf beetle/chrysomelid":
        "animal, animate being, beast, brute, creature, fauna",
    "bald eagle/American eagle/Haliaeetus leucocephalus":
        "animal, animate being, beast, brute, creature, fauna",
    "Irish terrier":
        "dog, domestic dog, Canis familiaris",
    "beer bottle":
        "bottle",
    "Dungeness crab/Cancer magister":
        "animal, animate being, beast, brute, creature, fauna",
    "basenji":
        "dog, domestic dog, Canis familiaris",
    "grand piano/grand":
        "musical instrument, instrument",
    "black-and-tan coonhound":
        "dog, domestic dog, Canis familiaris",
    "giant panda/panda/panda bear/coon bear/Ailuropoda melanoleuca":
        "animal, animate being, beast, brute, creature, fauna",
    "capuchin/ringtail/Cebus capucinus":
        "animal, animate being, beast, brute, creature, fauna",
    "lycaenid/lycaenid butterfly":
        "animal, animate being, beast, brute, creature, fauna",
    "ladybug/ladybeetle/lady beetle/ladybird/ladybird beetle":
        "animal, animate being, beast, brute, creature, fauna",
    "tarantula":
        "animal, animate being, beast, brute, creature, fauna",
    "American Staffordshire terrier/Staffordshire terrier/American pit bull "
    "terrier/pit bull terrier":
        "dog, domestic dog, Canis familiaris",
    "kite":
        "animal, animate being, beast, brute, creature, fauna",
    "red wine":
        "food, nutrient",
    "black grouse":
        "animal, animate being, beast, brute, creature, fauna",
    "porcupine/hedgehog":
        "animal, animate being, beast, brute, creature, fauna",
    "water jug":
        "bottle",
    "French loaf":
        "food, nutrient",
    "titi/titi monkey":
        "animal, animate being, beast, brute, creature, fauna",
    "Italian greyhound":
        "animal, animate being, beast, brute, creature, fauna",
    "police van/police wagon/paddy wagon/patrol wagon/wagon/black Maria":
        "wheeled vehicle",
    "pill bottle":
        "bottle",
    "iPod":
        "electronic equipment",
    "borzoi/Russian wolfhound":
        "dog, domestic dog, Canis familiaris",
    "tree frog/tree-frog":
        "animal, animate being, beast, brute, creature, fauna",
    "grey whale/gray whale/devilfish/Eschrichtius gibbosus/"
    "Eschrichtius robustus":
        "animal, animate being, beast, brute, creature, fauna",
    "spotted salamander/Ambystoma maculatum":
        "animal, animate being, beast, brute, creature, fauna",
    "wine bottle":
        "bottle",
    "sulphur-crested cockatoo/Kakatoe galerita/Cacatua galerita":
        "animal, animate being, beast, brute, creature, fauna",
    "modem":
        "electronic equipment",
    "red-backed sandpiper/dunlin/Erolia alpina":
        "animal, animate being, beast, brute, creature, fauna",
    "gazelle":
        "animal, animate being, beast, brute, creature, fauna",
    "Eskimo dog/husky":
        "dog, domestic dog, Canis familiaris",
    "digital watch":
        "timepiece, timekeeper, horologe",
    "cheetah/chetah/Acinonyx jubatus":
        "animal, animate being, beast, brute, creature, fauna",
    "sombrero":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "seat belt/seatbelt":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "burrito":
        "food, nutrient",
    "slide rule/slipstick":
        "computer, computing machine, computing device, data processor, "
        "electronic computer, information processing system",
    "Bouvier des Flandres/Bouviers des Flandres":
        "dog, domestic dog, Canis familiaris",
    "mask":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "Doberman/Doberman pinscher":
        "dog, domestic dog, Canis familiaris",
    "rhinoceros beetle":
        "animal, animate being, beast, brute, creature, fauna",
    "daisy":
        "plant, flora, plant life",
    "monitor":
        "electronic equipment",
    "Komodo dragon/Komodo lizard/dragon lizard/giant lizard/"
    "Varanus komodoensis":
        "animal, animate being, beast, brute, creature, fauna",
    "garbage truck/dustcart":
        "wheeled vehicle",
    "Rhodesian ridgeback":
        "dog, domestic dog, Canis familiaris",
    "half track":
        "wheeled vehicle",
    "starfish/sea star":
        "animal, animate being, beast, brute, creature, fauna",
    "brambling/Fringilla montifringilla":
        "animal, animate being, beast, brute, creature, fauna",
    "convertible":
        "wheeled vehicle",
    "long-horned beetle/longicorn/longicorn beetle":
        "animal, animate being, beast, brute, creature, fauna",
    "academic gown/academic robe/judge's robe":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "computer keyboard/keypad":
        "electronic equipment",
    "Norwich terrier":
        "dog, domestic dog, Canis familiaris",
    "meerkat/mierkat":
        "animal, animate being, beast, brute, creature, fauna",
    "overskirt":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "toucan":
        "animal, animate being, beast, brute, creature, fauna",
    "apron":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "stopwatch/stop watch":
        "timepiece, timekeeper, horologe",
    "lab coat/laboratory coat":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "screen/CRT screen":
        "electronic equipment",
    "golfcart/golf cart":
        "wheeled vehicle",
    "digital clock":
        "timepiece, timekeeper, horologe",
    "Leonberg":
        "dog, domestic dog, Canis familiaris",
    "African crocodile/Nile crocodile/Crocodylus niloticus":
        "animal, animate being, beast, brute, creature, fauna",
    "lemon":
        "edible fruit",
    "Siberian husky":
        "dog, domestic dog, Canis familiaris",
    "bagel/beigel":
        "food, nutrient",
    "badger":
        "animal, animate being, beast, brute, creature, fauna",
    "scorpion":
        "animal, animate being, beast, brute, creature, fauna",
    "chow/chow chow":
        "dog, domestic dog, Canis familiaris",
    "Labrador retriever":
        "dog, domestic dog, Canis familiaris",
    "guenon/guenon monkey":
        "animal, animate being, beast, brute, creature, fauna",
    "military uniform":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "wood rabbit/cottontail/cottontail rabbit":
        "animal, animate being, beast, brute, creature, fauna",
    "jackfruit/jak/jack":
        "edible fruit",
    "oscilloscope/scope/cathode-ray oscilloscope/CRO":
        "electronic equipment",
    "jellyfish":
        "animal, animate being, beast, brute, creature, fauna",
    "Arctic fox/white fox/Alopex lagopus":
        "animal, animate being, beast, brute, creature, fauna",
    "feather boa/boa":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "bathing cap/swimming cap":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "cairn/cairn terrier":
        "dog, domestic dog, Canis familiaris",
    "German short-haired pointer":
        "dog, domestic dog, Canis familiaris",
    "hammerhead/hammerhead shark":
        "animal, animate being, beast, brute, creature, fauna",
    "violin/fiddle":
        "musical instrument, instrument",
    "green mamba":
        "animal, animate being, beast, brute, creature, fauna",
    "vizsla/Hungarian pointer":
        "dog, domestic dog, Canis familiaris",
    "moving van":
        "wheeled vehicle",
    "monarch/monarch butterfly/milkweed butterfly/Danaus plexippus":
        "animal, animate being, beast, brute, creature, fauna",
    "standard schnauzer":
        "dog, domestic dog, Canis familiaris",
    "tick":
        "animal, animate being, beast, brute, creature, fauna",
    "Gila monster/Heloderma suspectum":
        "animal, animate being, beast, brute, creature, fauna",
    "stingray":
        "animal, animate being, beast, brute, creature, fauna",
    "trilobite":
        "animal, animate being, beast, brute, creature, fauna",
    "knee pad":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "Boston bull/Boston terrier":
        "dog, domestic dog, Canis familiaris",
    "plate":
        "food, nutrient",
    "football helmet":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "electric ray/crampfish/numbfish/torpedo":
        "animal, animate being, beast, brute, creature, fauna",
    "sea urchin":
        "animal, animate being, beast, brute, creature, fauna",
    "ice cream/icecream":
        "food, nutrient",
    "red-breasted merganser/Mergus serrator":
        "animal, animate being, beast, brute, creature, fauna",
    "lesser panda/red panda/panda/bear cat/cat bear/Ailurus fulgens":
        "animal, animate being, beast, brute, creature, fauna",
    "barn spider/Araneus cavaticus":
        "animal, animate being, beast, brute, creature, fauna",
    "sea cucumber/holothurian":
        "animal, animate being, beast, brute, creature, fauna",
    "bulbul":
        "animal, animate being, beast, brute, creature, fauna",
    "quail":
        "animal, animate being, beast, brute, creature, fauna",
    "lacewing/lacewing fly":
        "animal, animate being, beast, brute, creature, fauna",
    "sulphur butterfly/sulfur butterfly":
        "animal, animate being, beast, brute, creature, fauna",
    "bicycle-built-for-two/tandem bicycle/tandem":
        "wheeled vehicle",
    "cheeseburger":
        "food, nutrient",
    "dial telephone/dial phone":
        "electronic equipment",
    "Australian terrier":
        "dog, domestic dog, Canis familiaris",
    "laptop/laptop computer":
        "computer, computing machine, computing device, data processor, "
        "electronic computer, information processing system",
    "lorikeet":
        "animal, animate being, beast, brute, creature, fauna",
    "Bedlington terrier":
        "dog, domestic dog, Canis familiaris",
    "black widow/Latrodectus mactans":
        "animal, animate being, beast, brute, creature, fauna",
    "baboon":
        "animal, animate being, beast, brute, creature, fauna",
    "agama":
        "animal, animate being, beast, brute, creature, fauna",
    "Saluki/gazelle hound":
        "dog, domestic dog, Canis familiaris",
    "curly-coated retriever":
        "dog, domestic dog, Canis familiaris",
    "mobile home/manufactured home":
        "wheeled vehicle",
    "brassiere/bra/bandeau":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "sarong":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "Siamese cat/Siamese":
        "animal, animate being, beast, brute, creature, fauna",
    "accordion/piano accordion/squeeze box":
        "musical instrument, instrument",
    "malamute/malemute/Alaskan malamute":
        "dog, domestic dog, Canis familiaris",
    "Welsh springer spaniel":
        "dog, domestic dog, Canis familiaris",
    "robin/American robin/Turdus migratorius":
        "animal, animate being, beast, brute, creature, fauna",
    "Persian cat":
        "animal, animate being, beast, brute, creature, fauna",
    "sock":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "skunk/polecat/wood pussy":
        "animal, animate being, beast, brute, creature, fauna",
    "collie":
        "dog, domestic dog, Canis familiaris",
    "warthog":
        "animal, animate being, beast, brute, creature, fauna",
    "king penguin/Aptenodytes patagonica":
        "animal, animate being, beast, brute, creature, fauna",
    "Saint Bernard/St Bernard":
        "dog, domestic dog, Canis familiaris",
    "black swan/Cygnus atratus":
        "animal, animate being, beast, brute, creature, fauna",
    "axolotl/mud puppy/Ambystoma mexicanum":
        "animal, animate being, beast, brute, creature, fauna",
    "chocolate sauce/chocolate syrup":
        "food, nutrient",
    "Arabian camel/dromedary/Camelus dromedarius":
        "animal, animate being, beast, brute, creature, fauna",
    "frilled lizard/Chlamydosaurus kingi":
        "animal, animate being, beast, brute, creature, fauna",
    "shopping cart":
        "wheeled vehicle",
    "Brabancon griffon":
        "dog, domestic dog, Canis familiaris",
    "Sealyham terrier/Sealyham":
        "dog, domestic dog, Canis familiaris",
    "forklift":
        "wheeled vehicle",
    "ant/emmet/pismire":
        "animal, animate being, beast, brute, creature, fauna",
    "pop bottle/soda bottle":
        "bottle",
    "electric guitar":
        "musical instrument, instrument",
    "tape player":
        "electronic equipment",
    "hummingbird":
        "animal, animate being, beast, brute, creature, fauna",
    "Model T":
        "wheeled vehicle",
    "gown":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "fox squirrel/eastern fox squirrel/Sciurus niger":
        "animal, animate being, beast, brute, creature, fauna",
    "bikini/two-piece":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "redbone":
        "dog, domestic dog, Canis familiaris",
    "house finch/linnet/Carpodacus mexicanus":
        "animal, animate being, beast, brute, creature, fauna",
    "bighorn/bighorn sheep/cimarron/Rocky Mountain bighorn/Rocky Mountain "
    "sheep/Ovis canadensis":
        "animal, animate being, beast, brute, creature, fauna",
    "carbonara":
        "food, nutrient",
    "English foxhound":
        "dog, domestic dog, Canis familiaris",
    "banjo":
        "musical instrument, instrument",
    "organ/pipe organ":
        "musical instrument, instrument",
    "American black bear/black bear/Ursus americanus/Euarctos americanus":
        "animal, animate being, beast, brute, creature, fauna",
    "impala/Aepyceros melampus":
        "animal, animate being, beast, brute, creature, fauna",
    "sea snake":
        "animal, animate being, beast, brute, creature, fauna",
    "coyote/prairie wolf/brush wolf/Canis latrans":
        "animal, animate being, beast, brute, creature, fauna",
    "silky terrier/Sydney silky":
        "dog, domestic dog, Canis familiaris",
    "Samoyed/Samoyede":
        "dog, domestic dog, Canis familiaris",
    "cello/violoncello":
        "musical instrument, instrument",
    "pineapple/ananas":
        "edible fruit",
    "damselfly":
        "animal, animate being, beast, brute, creature, fauna",
    "sax/saxophone":
        "musical instrument, instrument",
    "Chihuahua":
        "dog, domestic dog, Canis familiaris",
    "beagle":
        "dog, domestic dog, Canis familiaris",
    "harp":
        "musical instrument, instrument",
    "African elephant/Loxodonta africana":
        "animal, animate being, beast, brute, creature, fauna",
    "miniskirt/mini":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "dalmatian/coach dog/carriage dog":
        "dog, domestic dog, Canis familiaris",
    "strawberry":
        "edible fruit",
    "komondor":
        "dog, domestic dog, Canis familiaris",
    "hare":
        "animal, animate being, beast, brute, creature, fauna",
    "trailer truck/tractor trailer/trucking rig/rig/articulated lorry/semi":
        "wheeled vehicle",
    "goldfinch/Carduelis carduelis":
        "animal, animate being, beast, brute, creature, fauna",
    "prairie chicken/prairie grouse/prairie fowl":
        "animal, animate being, beast, brute, creature, fauna",
    "bearskin/busby/shako":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "sidewinder/horned rattlesnake/Crotalus cerastes":
        "animal, animate being, beast, brute, creature, fauna",
    "pug/pug-dog":
        "dog, domestic dog, Canis familiaris",
    "moped":
        "wheeled vehicle",
    "English springer/English springer spaniel":
        "dog, domestic dog, Canis familiaris",
    "malinois":
        "dog, domestic dog, Canis familiaris",
    "American coot/marsh hen/mud hen/water hen/Fulica americana":
        "animal, animate being, beast, brute, creature, fauna",
    "sea slug/nudibranch":
        "animal, animate being, beast, brute, creature, fauna",
    "steam locomotive":
        "wheeled vehicle",
    "cocker spaniel/English cocker spaniel/cocker":
        "dog, domestic dog, Canis familiaris",
    "upright/upright piano":
        "musical instrument, instrument",
    "goblet":
        "bottle",
    "grey fox/gray fox/Urocyon cinereoargenteus":
        "animal, animate being, beast, brute, creature, fauna",
    "Norwegian elkhound/elkhound":
        "dog, domestic dog, Canis familiaris",
    "Great Pyrenees":
        "dog, domestic dog, Canis familiaris",
    "rock crab/Cancer irroratus":
        "animal, animate being, beast, brute, creature, fauna",
    "Kerry blue terrier":
        "dog, domestic dog, Canis familiaris",
    "quill/quill pen":
        "writing implement",
    "terrapin":
        "animal, animate being, beast, brute, creature, fauna",
    "crane":
        "animal, animate being, beast, brute, creature, fauna",
    "gong/tam-tam":
        "musical instrument, instrument",
    "pajama/pyjama/pj's/jammies":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "bolo tie/bolo/bola tie/bola":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "Weimaraner":
        "dog, domestic dog, Canis familiaris",
    "water buffalo/water ox/Asiatic buffalo/Bubalus bubalis":
        "animal, animate being, beast, brute, creature, fauna",
    "Shetland sheepdog/Shetland sheep dog/Shetland":
        "dog, domestic dog, Canis familiaris",
    "tench/Tinca tinca":
        "animal, animate being, beast, brute, creature, fauna",
    "siamang/Hylobates syndactylus/Symphalangus syndactylus":
        "animal, animate being, beast, brute, creature, fauna",
    "loggerhead/loggerhead turtle/Caretta caretta":
        "animal, animate being, beast, brute, creature, fauna",
    "dung beetle":
        "animal, animate being, beast, brute, creature, fauna",
    "Granny Smith":
        "edible fruit",
    "Angora/Angora rabbit":
        "animal, animate being, beast, brute, creature, fauna",
    "dough":
        "food, nutrient",
    "hen":
        "animal, animate being, beast, brute, creature, fauna",
    "CD player":
        "electronic equipment",
    "howler monkey/howler":
        "animal, animate being, beast, brute, creature, fauna",
    "English setter":
        "dog, domestic dog, Canis familiaris",
    "West Highland white terrier":
        "dog, domestic dog, Canis familiaris",
    "pomegranate":
        "edible fruit",
    "timber wolf/grey wolf/gray wolf/Canis lupus":
        "animal, animate being, beast, brute, creature, fauna",
    "go-kart":
        "wheeled vehicle",
    "hornbill":
        "animal, animate being, beast, brute, creature, fauna",
    "Christmas stocking":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "alligator lizard":
        "animal, animate being, beast, brute, creature, fauna",
    "tabby/tabby cat":
        "animal, animate being, beast, brute, creature, fauna",
    "crash helmet":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "parking meter":
        "timepiece, timekeeper, horologe",
    "mantis/mantid":
        "animal, animate being, beast, brute, creature, fauna",
    "marmoset":
        "animal, animate being, beast, brute, creature, fauna",
    "Rottweiler":
        "dog, domestic dog, Canis familiaris",
    "whiskey jug":
        "bottle",
    "leopard/Panthera pardus":
        "animal, animate being, beast, brute, creature, fauna",
    "ram/tup":
        "animal, animate being, beast, brute, creature, fauna",
    "bison":
        "animal, animate being, beast, brute, creature, fauna",
    "horned viper/cerastes/sand viper/horned asp/Cerastes cornutus":
        "animal, animate being, beast, brute, creature, fauna",
    "anemone fish":
        "animal, animate being, beast, brute, creature, fauna",
    "sports car/sport car":
        "wheeled vehicle",
    "red fox/Vulpes vulpes":
        "animal, animate being, beast, brute, creature, fauna",
    "hog/pig/grunter/squealer/Sus scrofa":
        "animal, animate being, beast, brute, creature, fauna",
    "unicycle/monocycle":
        "wheeled vehicle",
    "macaque":
        "animal, animate being, beast, brute, creature, fauna",
    "drum/membranophone/tympan":
        "musical instrument, instrument",
    "king snake/kingsnake":
        "animal, animate being, beast, brute, creature, fauna",
    "affenpinscher/monkey pinscher/monkey dog":
        "dog, domestic dog, Canis familiaris",
    "custard apple":
        "edible fruit",
    "meat loaf/meatloaf":
        "food, nutrient",
    "American egret/great white heron/Egretta albus":
        "animal, animate being, beast, brute, creature, fauna",
    "whiptail/whiptail lizard":
        "animal, animate being, beast, brute, creature, fauna",
    "joystick":
        "electronic equipment",
    "spoonbill":
        "animal, animate being, beast, brute, creature, fauna",
    "espresso":
        "food, nutrient",
    "mortarboard":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "jersey/T-shirt/tee shirt":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "kimono":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "squirrel monkey/Saimiri sciureus":
        "animal, animate being, beast, brute, creature, fauna",
    "hartebeest":
        "animal, animate being, beast, brute, creature, fauna",
    "marimba/xylophone":
        "musical instrument, instrument",
    "ice lolly/lolly/lollipop/popsicle":
        "food, nutrient",
    "marmot":
        "animal, animate being, beast, brute, creature, fauna",
    "beaver":
        "animal, animate being, beast, brute, creature, fauna",
    "Afghan hound/Afghan":
        "dog, domestic dog, Canis familiaris",
    "keeshond":
        "dog, domestic dog, Canis familiaris",
    "eggnog":
        "food, nutrient",
    "cougar/puma/catamount/mountain lion/painter/panther/Felis concolor":
        "animal, animate being, beast, brute, creature, fauna",
    "bonnet/poke bonnet":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "koala/koala bear/kangaroo bear/native bear/Phascolarctos cinereus":
        "animal, animate being, beast, brute, creature, fauna",
    "trombone":
        "musical instrument, instrument",
    "fig":
        "edible fruit",
    "gorilla/Gorilla gorilla":
        "animal, animate being, beast, brute, creature, fauna",
    "Japanese spaniel":
        "dog, domestic dog, Canis familiaris",
    "Lakeland terrier":
        "dog, domestic dog, Canis familiaris",
    "tiger cat":
        "animal, animate being, beast, brute, creature, fauna",
    "streetcar/tram/tramcar/trolley/trolley car":
        "wheeled vehicle",
    "tiger beetle":
        "animal, animate being, beast, brute, creature, fauna",
    "Pembroke/Pembroke Welsh corgi":
        "dog, domestic dog, Canis familiaris",
    "tank/army tank/armored combat vehicle/armoured combat vehicle":
        "wheeled vehicle",
    "ringneck snake/ring-necked snake/ring snake":
        "animal, animate being, beast, brute, creature, fauna",
    "Mexican hairless":
        "dog, domestic dog, Canis familiaris",
    "great grey owl/great gray owl/Strix nebulosa":
        "animal, animate being, beast, brute, creature, fauna",
    "bloodhound/sleuthhound":
        "dog, domestic dog, Canis familiaris",
    "racer/race car/racing car":
        "wheeled vehicle",
    "armadillo":
        "animal, animate being, beast, brute, creature, fauna",
    "bulletproof vest":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "triceratops":
        "animal, animate being, beast, brute, creature, fauna",
    "hyena/hyaena":
        "animal, animate being, beast, brute, creature, fauna",
    "ox":
        "animal, animate being, beast, brute, creature, fauna",
    "beach wagon/station wagon/wagon/estate car/beach waggon/station "
    "waggon/waggon":
        "wheeled vehicle",
    "wall clock":
        "timepiece, timekeeper, horologe",
    "mink":
        "animal, animate being, beast, brute, creature, fauna",
    "EntleBucher":
        "dog, domestic dog, Canis familiaris",
    "magpie":
        "animal, animate being, beast, brute, creature, fauna",
    "cockroach/roach":
        "animal, animate being, beast, brute, creature, fauna",
    "slug":
        "animal, animate being, beast, brute, creature, fauna",
    "albatross/mollymawk":
        "animal, animate being, beast, brute, creature, fauna",
    "Irish setter/red setter":
        "dog, domestic dog, Canis familiaris",
    "maraca":
        "musical instrument, instrument",
    "acoustic guitar":
        "musical instrument, instrument",
    "green snake/grass snake":
        "animal, animate being, beast, brute, creature, fauna",
    "yellow lady's slipper/yellow lady-slipper/Cypripedium "
    "calceolus/Cypripedium parviflorum":
        "plant, flora, plant life",
    "jaguar/panther/Panthera onca/Felis onca":
        "animal, animate being, beast, brute, creature, fauna",
    "dugong/Dugong dugon":
        "animal, animate being, beast, brute, creature, fauna",
    "potpie":
        "food, nutrient",
    "Madagascar cat/ring-tailed lemur/Lemur catta":
        "animal, animate being, beast, brute, creature, fauna",
    "hay":
        "food, nutrient",
    "fire engine/fire truck":
        "wheeled vehicle",
    "water bottle":
        "bottle",
    "tiger/Panthera tigris":
        "animal, animate being, beast, brute, creature, fauna",
    "redshank/Tringa totanus":
        "animal, animate being, beast, brute, creature, fauna",
    "tailed frog/bell toad/ribbed toad/tailed toad/Ascaphus trui":
        "animal, animate being, beast, brute, creature, fauna",
    "Yorkshire terrier":
        "dog, domestic dog, Canis familiaris",
    "freight car":
        "wheeled vehicle",
    "patas/hussar monkey/Erythrocebus patas":
        "animal, animate being, beast, brute, creature, fauna",
    "Norfolk terrier":
        "dog, domestic dog, Canis familiaris",
    "ringlet/ringlet butterfly":
        "animal, animate being, beast, brute, creature, fauna",
    "leafhopper":
        "animal, animate being, beast, brute, creature, fauna",
    "polecat/fitch/foulmart/foumart/Mustela putorius":
        "animal, animate being, beast, brute, creature, fauna",
    "zebra":
        "animal, animate being, beast, brute, creature, fauna",
    "ground beetle/carabid beetle":
        "animal, animate being, beast, brute, creature, fauna",
    "hermit crab":
        "animal, animate being, beast, brute, creature, fauna",
    "spider monkey/Ateles geoffroyi":
        "animal, animate being, beast, brute, creature, fauna",
    "analog clock":
        "timepiece, timekeeper, horologe",
    "limpkin/Aramus pictus":
        "animal, animate being, beast, brute, creature, fauna",
    "Irish water spaniel":
        "dog, domestic dog, Canis familiaris",
    "ballpoint/ballpoint pen/ballpen/Biro":
        "writing implement",
    "papillon":
        "dog, domestic dog, Canis familiaris",
    "banded gecko":
        "animal, animate being, beast, brute, creature, fauna",
    "Greater Swiss Mountain dog":
        "dog, domestic dog, Canis familiaris",
    "Staffordshire bullterrier/Staffordshire bull terrier":
        "dog, domestic dog, Canis familiaris",
    "bustard":
        "animal, animate being, beast, brute, creature, fauna",
    "night snake/Hypsiglena torquata":
        "animal, animate being, beast, brute, creature, fauna",
    "lion/king of beasts/Panthera leo":
        "animal, animate being, beast, brute, creature, fauna",
    "wig":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "flamingo":
        "animal, animate being, beast, brute, creature, fauna",
    "isopod":
        "animal, animate being, beast, brute, creature, fauna",
    "barracouta/snoek":
        "animal, animate being, beast, brute, creature, fauna",
    "swimming trunks/bathing trunks":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "Ibizan hound/Ibizan Podenco":
        "dog, domestic dog, Canis familiaris",
    "sundial":
        "timepiece, timekeeper, horologe",
    "fly":
        "animal, animate being, beast, brute, creature, fauna",
    "otter":
        "animal, animate being, beast, brute, creature, fauna",
    "banana":
        "edible fruit",
    "nematode/nematode worm/roundworm":
        "animal, animate being, beast, brute, creature, fauna",
    "green lizard/Lacerta viridis":
        "animal, animate being, beast, brute, creature, fauna",
    "bassoon":
        "musical instrument, instrument",
    "cellular telephone/cellular phone/cellphone/cell/mobile phone":
        "electronic equipment",
    "vestment":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "ruddy turnstone/Arenaria interpres":
        "animal, animate being, beast, brute, creature, fauna",
    "white wolf/Arctic wolf/Canis lupus tundrarum":
        "animal, animate being, beast, brute, creature, fauna",
    "vine snake":
        "animal, animate being, beast, brute, creature, fauna",
    "pelican":
        "animal, animate being, beast, brute, creature, fauna",
    "Windsor tie":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "tow truck/tow car/wrecker":
        "wheeled vehicle",
    "dingo/warrigal/warragal/Canis dingo":
        "animal, animate being, beast, brute, creature, fauna",
    "Appenzeller":
        "dog, domestic dog, Canis familiaris",
    "kit fox/Vulpes macrotis":
        "animal, animate being, beast, brute, creature, fauna",
    "ostrich/Struthio camelus":
        "animal, animate being, beast, brute, creature, fauna",
    "gar/garfish/garpike/billfish/Lepisosteus osseus":
        "animal, animate being, beast, brute, creature, fauna",
    "little blue heron/Egretta caerulea":
        "animal, animate being, beast, brute, creature, fauna",
    "French horn/horn":
        "musical instrument, instrument",
    "red wolf/maned wolf/Canis rufus/Canis niger":
        "animal, animate being, beast, brute, creature, fauna",
    "Great Dane":
        "dog, domestic dog, Canis familiaris",
    "pretzel":
        "food, nutrient",
    "Dandie Dinmont/Dandie Dinmont terrier":
        "dog, domestic dog, Canis familiaris",
    "macaw":
        "animal, animate being, beast, brute, creature, fauna",
    "Chesapeake Bay retriever":
        "dog, domestic dog, Canis familiaris",
    "diaper/nappy/napkin":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "French bulldog":
        "dog, domestic dog, Canis familiaris",
    "indri/indris/Indri indri/Indri brevicaudatus":
        "animal, animate being, beast, brute, creature, fauna",
    "flute/transverse flute":
        "musical instrument, instrument",
    "ocarina/sweet potato":
        "musical instrument, instrument",
    "tractor":
        "wheeled vehicle",
    "goldfish/Carassius auratus":
        "animal, animate being, beast, brute, creature, fauna",
    "toy terrier":
        "dog, domestic dog, Canis familiaris",
    "Blenheim spaniel":
        "dog, domestic dog, Canis familiaris",
    "orange":
        "edible fruit",
    "motor scooter/scooter":
        "wheeled vehicle",
    "snowmobile":
        "wheeled vehicle",
    "mitten":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "brown bear/bruin/Ursus arctos":
        "animal, animate being, beast, brute, creature, fauna",
    "shower cap":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "Border collie":
        "dog, domestic dog, Canis familiaris",
    "hourglass":
        "timepiece, timekeeper, horologe",
    "briard":
        "dog, domestic dog, Canis familiaris",
    "European gallinule/Porphyrio porphyrio":
        "animal, animate being, beast, brute, creature, fauna",
    "leatherback turtle/leatherback/leathery turtle/Dermochelys coriacea":
        "animal, animate being, beast, brute, creature, fauna",
    "tusker":
        "animal, animate being, beast, brute, creature, fauna",
    "Shih-Tzu":
        "dog, domestic dog, Canis familiaris",
    "proboscis monkey/Nasalis larvatus":
        "animal, animate being, beast, brute, creature, fauna",
    "otterhound/otter hound":
        "dog, domestic dog, Canis familiaris",
    "African chameleon/Chamaeleo chamaeleon":
        "animal, animate being, beast, brute, creature, fauna",
    "lionfish":
        "animal, animate being, beast, brute, creature, fauna",
    "water snake":
        "animal, animate being, beast, brute, creature, fauna",
    "recreational vehicle/RV/R.V.":
        "wheeled vehicle",
    "Brittany spaniel":
        "dog, domestic dog, Canis familiaris",
    "rock python/rock snake/Python sebae":
        "animal, animate being, beast, brute, creature, fauna",
    "menu":
        "food, nutrient",
    "eel":
        "animal, animate being, beast, brute, creature, fauna",
    "peacock":
        "animal, animate being, beast, brute, creature, fauna",
    "Bernese mountain dog":
        "dog, domestic dog, Canis familiaris",
    "desktop computer":
        "computer, computing machine, computing device, data processor, "
        "electronic computer, information processing system",
    "crayfish/crawfish/crawdad/crawdaddy":
        "animal, animate being, beast, brute, creature, fauna",
    "brain coral":
        "animal, animate being, beast, brute, creature, fauna",
    "oystercatcher/oyster catcher":
        "animal, animate being, beast, brute, creature, fauna",
    "killer whale/killer/orca/grampus/sea wolf/Orcinus orca":
        "animal, animate being, beast, brute, creature, fauna",
    "cup":
        "bottle",
    "giant schnauzer":
        "dog, domestic dog, Canis familiaris",
    "jean/blue jean/denim":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "wild boar/boar/Sus scrofa":
        "animal, animate being, beast, brute, creature, fauna",
    "steel drum":
        "musical instrument, instrument",
    "chime/bell/gong":
        "musical instrument, instrument",
    "snail":
        "animal, animate being, beast, brute, creature, fauna",
    "bluetick":
        "dog, domestic dog, Canis familiaris",
    "wire-haired fox terrier":
        "dog, domestic dog, Canis familiaris",
    "limousine/limo":
        "wheeled vehicle",
    "conch":
        "animal, animate being, beast, brute, creature, fauna",
    "Sussex spaniel":
        "dog, domestic dog, Canis familiaris",
    "Tibetan mastiff":
        "dog, domestic dog, Canis familiaris",
    "German shepherd/German shepherd dog/German police dog/alsatian":
        "dog, domestic dog, Canis familiaris",
    "schipperke":
        "dog, domestic dog, Canis familiaris",
    "goose":
        "animal, animate being, beast, brute, creature, fauna",
    "dhole/Cuon alpinus":
        "animal, animate being, beast, brute, creature, fauna",
    "soft-coated wheaten terrier":
        "dog, domestic dog, Canis familiaris",
    "oxcart":
        "wheeled vehicle",
    "flatworm/platyhelminth":
        "animal, animate being, beast, brute, creature, fauna",
    "clumber/clumber spaniel":
        "dog, domestic dog, Canis familiaris",
    "suit/suit of clothes":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "colobus/colobus monkey":
        "animal, animate being, beast, brute, creature, fauna",
    "Pomeranian":
        "dog, domestic dog, Canis familiaris",
    "mud turtle":
        "animal, animate being, beast, brute, creature, fauna",
    "cicada/cicala":
        "animal, animate being, beast, brute, creature, fauna",
    "orangutan/orang/orangutang/Pongo pygmaeus":
        "animal, animate being, beast, brute, creature, fauna",
    "Gordon setter":
        "dog, domestic dog, Canis familiaris",
    "panpipe/pandean pipe/syrinx":
        "musical instrument, instrument",
    "chambered nautilus/pearly nautilus/nautilus":
        "animal, animate being, beast, brute, creature, fauna",
    "harmonica/mouth organ/harp/mouth harp":
        "musical instrument, instrument",
    "snow leopard/ounce/Panthera uncia":
        "animal, animate being, beast, brute, creature, fauna",
    "cock":
        "animal, animate being, beast, brute, creature, fauna",
    "sloth bear/Melursus ursinus/Ursus ursinus":
        "animal, animate being, beast, brute, creature, fauna",
    "rock beauty/Holocanthus tricolor":
        "animal, animate being, beast, brute, creature, fauna",
    "hamster":
        "animal, animate being, beast, brute, creature, fauna",
    "miniature schnauzer":
        "dog, domestic dog, Canis familiaris",
    "horse cart/horse-cart":
        "wheeled vehicle",
    "African hunting dog/hyena dog/Cape hunting dog/Lycaon pictus":
        "animal, animate being, beast, brute, creature, fauna",
    "cabbage butterfly":
        "animal, animate being, beast, brute, creature, fauna",
    "great white shark/white shark/man-eater/man-eating shark/Carcharodon "
    "carcharias":
        "animal, animate being, beast, brute, creature, fauna",
    "flat-coated retriever":
        "dog, domestic dog, Canis familiaris",
    "llama":
        "animal, animate being, beast, brute, creature, fauna",
    "mashed potato":
        "food, nutrient",
    "groenendael":
        "dog, domestic dog, Canis familiaris",
    "centipede":
        "animal, animate being, beast, brute, creature, fauna",
    "whippet":
        "animal, animate being, beast, brute, creature, fauna",
    "jacamar":
        "animal, animate being, beast, brute, creature, fauna",
    "standard poodle":
        "dog, domestic dog, Canis familiaris",
    "Pekinese/Pekingese/Peke":
        "dog, domestic dog, Canis familiaris",
    "poncho":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "tricycle/trike/velocipede":
        "wheeled vehicle",
    "wolf spider/hunting spider":
        "animal, animate being, beast, brute, creature, fauna",
    "Walker hound/Walker foxhound":
        "dog, domestic dog, Canis familiaris",
    "hognose snake/puff adder/sand viper":
        "animal, animate being, beast, brute, creature, fauna",
    "miniature pinscher":
        "dog, domestic dog, Canis familiaris",
    "kuvasz":
        "dog, domestic dog, Canis familiaris",
    "dowitcher":
        "animal, animate being, beast, brute, creature, fauna",
    "notebook/notebook computer":
        "computer, computing machine, computing device, data processor, "
        "electronic computer, information processing system",
    "sorrel":
        "animal, animate being, beast, brute, creature, fauna",
    "chickadee":
        "animal, animate being, beast, brute, creature, fauna",
    "common iguana/iguana/Iguana iguana":
        "animal, animate being, beast, brute, creature, fauna",
    "snowplow/snowplough":
        "wheeled vehicle",
    "boxer":
        "dog, domestic dog, Canis familiaris",
    "diamondback/diamondback rattlesnake/Crotalus adamanteus":
        "animal, animate being, beast, brute, creature, fauna",
    "cornet/horn/trumpet/trump":
        "musical instrument, instrument",
    "Indian elephant/Elephas maximus":
        "animal, animate being, beast, brute, creature, fauna",
    "hippopotamus/hippo/river horse/Hippopotamus amphibius":
        "animal, animate being, beast, brute, creature, fauna",
    "ambulance":
        "wheeled vehicle",
    "weasel":
        "animal, animate being, beast, brute, creature, fauna",
    "cowboy hat/ten-gallon hat":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "American lobster/Northern lobster/Maine lobster/Homarus americanus":
        "animal, animate being, beast, brute, creature, fauna",
    "weevil":
        "animal, animate being, beast, brute, creature, fauna",
    "oboe/hautboy/hautbois":
        "musical instrument, instrument",
    "maillot":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "three-toed sloth/ai/Bradypus tridactylus":
        "animal, animate being, beast, brute, creature, fauna",
    "platypus/duckbill/duckbilled platypus/duck-billed "
    "platypus/Ornithorhynchus anatinus":
        "animal, animate being, beast, brute, creature, fauna",
    "white stork/Ciconia ciconia":
        "animal, animate being, beast, brute, creature, fauna",
    "bee eater":
        "animal, animate being, beast, brute, creature, fauna",
    "Newfoundland/Newfoundland dog":
        "dog, domestic dog, Canis familiaris",
    "dragonfly/darning needle/devil's darning needle/sewing needle/snake "
    "feeder/snake doctor/mosquito hawk/skeeter hawk":
        "animal, animate being, beast, brute, creature, fauna",
    "spiny lobster/langouste/rock lobster/crawfish/crayfish/sea crawfish":
        "animal, animate being, beast, brute, creature, fauna",
    "Old English sheepdog/bobtail":
        "dog, domestic dog, Canis familiaris",
    "partridge":
        "animal, animate being, beast, brute, creature, fauna",
    "Lhasa/Lhasa apso":
        "dog, domestic dog, Canis familiaris",
    "bee":
        "animal, animate being, beast, brute, creature, fauna",
    "American alligator/Alligator mississipiensis":
        "animal, animate being, beast, brute, creature, fauna",
    "harvestman/daddy longlegs/Phalangium opilio":
        "animal, animate being, beast, brute, creature, fauna",
    "common newt/Triturus vulgaris":
        "animal, animate being, beast, brute, creature, fauna",
    "water ouzel/dipper":
        "animal, animate being, beast, brute, creature, fauna",
    "jeep/landrover":
        "wheeled vehicle",
    "walking stick/walkingstick/stick insect":
        "animal, animate being, beast, brute, creature, fauna",
    "guacamole":
        "food, nutrient",
    "mountain bike/all-terrain bike/off-roader":
        "wheeled vehicle",
    "grasshopper/hopper":
        "animal, animate being, beast, brute, creature, fauna",
    "bullfrog/Rana catesbeiana":
        "animal, animate being, beast, brute, creature, fauna",
    "garden spider/Aranea diademata":
        "animal, animate being, beast, brute, creature, fauna",
    "amphibian/amphibious vehicle":
        "wheeled vehicle",
    "langur":
        "animal, animate being, beast, brute, creature, fauna",
    "vulture":
        "animal, animate being, beast, brute, creature, fauna",
    "wallaby/brush kangaroo":
        "animal, animate being, beast, brute, creature, fauna",
    "gibbon/Hylobates lar":
        "animal, animate being, beast, brute, creature, fauna",
    "bittern":
        "animal, animate being, beast, brute, creature, fauna",
    "ice bear/polar bear/Ursus Maritimus/Thalarctos maritimus":
        "animal, animate being, beast, brute, creature, fauna",
    "pickup/pickup truck":
        "wheeled vehicle",
    "fountain pen":
        "writing implement",
    "trifle":
        "food, nutrient",
    "pay-phone/pay-station":
        "electronic equipment",
    "Scotch terrier/Scottish terrier/Scottie":
        "dog, domestic dog, Canis familiaris",
    "web site/website/internet site/site":
        "computer, computing machine, computing device, data processor, "
        "electronic computer, information processing system",
    "coho/cohoe/coho salmon/blue jack/silver salmon/Oncorhynchus kisutch":
        "animal, animate being, beast, brute, creature, fauna",
    "Maltese dog/Maltese terrier/Maltese":
        "dog, domestic dog, Canis familiaris",
    "coucal":
        "animal, animate being, beast, brute, creature, fauna",
    "tiger shark/Galeocerdo cuvieri":
        "animal, animate being, beast, brute, creature, fauna",
    "indigo bunting/indigo finch/indigo bird/Passerina cyanea":
        "animal, animate being, beast, brute, creature, fauna",
    "hotdog/hot dog/red hot":
        "food, nutrient",
    "minivan":
        "wheeled vehicle",
    "passenger car/coach/carriage":
        "wheeled vehicle",
    "sea lion":
        "animal, animate being, beast, brute, creature, fauna",
    "cardigan":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "jinrikisha/ricksha/rickshaw":
        "wheeled vehicle",
    "chimpanzee/chimp/Pan troglodytes":
        "animal, animate being, beast, brute, creature, fauna",
    "African grey/African gray/Psittacus erithacus":
        "animal, animate being, beast, brute, creature, fauna",
    "black and gold garden spider/Argiope aurantia":
        "animal, animate being, beast, brute, creature, fauna",
    "miniature poodle":
        "dog, domestic dog, Canis familiaris",
    "electric locomotive":
        "wheeled vehicle",
    "Cardigan/Cardigan Welsh corgi":
        "dog, domestic dog, Canis familiaris",
    "box turtle/box tortoise":
        "animal, animate being, beast, brute, creature, fauna",
    "sturgeon":
        "animal, animate being, beast, brute, creature, fauna",
    "Irish wolfhound":
        "dog, domestic dog, Canis familiaris",
    "maillot/tank suit":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "kelpie":
        "dog, domestic dog, Canis familiaris",
    "cassette player":
        "electronic equipment",
    "hoopskirt/crinoline":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "bow tie/bow-tie/bowtie":
        "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "junco/snowbird":
        "animal, animate being, beast, brute, creature, fauna",
    "Scottish deerhound/deerhound":
        "dog, domestic dog, Canis familiaris",
    "king crab/Alaska crab/Alaskan king crab/Alaska king crab/Paralithodes "
    "camtschatica":
        "animal, animate being, beast, brute, creature, fauna",
    "Egyptian cat":
        "animal, animate being, beast, brute, creature, fauna",
    "jay":
        "animal, animate being, beast, brute, creature, fauna",
    "eft":
        "animal, animate being, beast, brute, creature, fauna",
    "garter snake/grass snake":
        "animal, animate being, beast, brute, creature, fauna",
    "wombat":
        "animal, animate being, beast, brute, creature, fauna",
    "consomme":
        "food, nutrient",
}

CATEGORIES = (
    "food, nutrient",
    "edible fruit",
    "electronic equipment",
    "wheeled vehicle",
    "dog, domestic dog, Canis familiaris",
    "animal, animate being, beast, brute, creature, fauna",
    "plant, flora, plant life",
    "clothing, article of clothing, vesture, wear, wearable, habiliment",
    "writing implement",
    "computer, computing machine, computing device, data processor, electronic"
    " computer, information processing system",
    "timepiece, timekeeper, horologe",
    "bottle",
    "musical instrument, instrument",
)
