# alegra-sdk-python
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1
- Package version: 1.0.0
- Generator version: 7.11.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openapi_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://sandbox-api.alegra.com/e-provider/col/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://sandbox-api.alegra.com/e-provider/col/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: auth
configuration = openapi_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CorreosRecepcinApi(api_client)
    nit = 'nit_example' # str | Nit de la empresa

    try:
        # Endpoint para la consulta del correo electrónico registrado por el facturador para la recepción de facturas electrónicas
        api_response = api_instance.get_reception_emails(nit)
        print("The response of CorreosRecepcinApi->get_reception_emails:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling CorreosRecepcinApi->get_reception_emails: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://sandbox-api.alegra.com/e-provider/col/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CorreosRecepcinApi* | [**get_reception_emails**](docs/CorreosRecepcinApi.md#get_reception_emails) | **GET** /reception-emails/{nit} | Endpoint para la consulta del correo electrónico registrado por el facturador para la recepción de facturas electrónicas
*DianApi* | [**get_contrat_types**](docs/DianApi.md#get_contrat_types) | **GET** /dian/contract-types | Endpoint para obtener la tabla de la DIAN con los tipos de contratos disponibles
*DianApi* | [**get_correction_concept_codes_nc**](docs/DianApi.md#get_correction_concept_codes_nc) | **GET** /dian/correction-concept-codes-nc | Endpoint para obtener la tabla de la DIAN con los tipos de concepto de corrección para notas crédito disponibles
*DianApi* | [**get_correction_concept_codes_nd**](docs/DianApi.md#get_correction_concept_codes_nd) | **GET** /dian/correction-concept-codes-nd | Endpoint para obtener la tabla de la DIAN con los tipos de concepto de corrección para notas débito disponibles
*DianApi* | [**get_countries**](docs/DianApi.md#get_countries) | **GET** /dian/countries | Endpoint para obtener la tabla de la DIAN con los países disponibles
*DianApi* | [**get_currencies**](docs/DianApi.md#get_currencies) | **GET** /dian/currencies | Endpoint para obtener la tabla de la DIAN con las monedas disponibles
*DianApi* | [**get_departments**](docs/DianApi.md#get_departments) | **GET** /dian/departments | Endpoint para obtener la tabla de la DIAN con los departamentos disponibles
*DianApi* | [**get_employee_sub_types**](docs/DianApi.md#get_employee_sub_types) | **GET** /dian/employee-sub-types | Endpoint para obtener la tabla de la DIAN con los subtipos de empleados disponibles
*DianApi* | [**get_employee_types**](docs/DianApi.md#get_employee_types) | **GET** /dian/employee-types | Endpoint para obtener la tabla de la DIAN con los tipos de empleados disponibles
*DianApi* | [**get_extra_hour_types**](docs/DianApi.md#get_extra_hour_types) | **GET** /dian/extra-hour-types | Endpoint para obtener la tabla de la DIAN con los tipos de hora extra disponibles
*DianApi* | [**get_fiscal_responsability_types**](docs/DianApi.md#get_fiscal_responsability_types) | **GET** /dian/fiscal-Responsability-types | Endpoint para obtener la tabla de la DIAN con los tipos de régimen/responsabilidades fiscales disponibles
*DianApi* | [**get_health_benefits_plan_types**](docs/DianApi.md#get_health_benefits_plan_types) | **GET** /dian/health-benefits-plan-types | Endpoint para obtener la tabla de la DIAN con los tipos de cobertura o plan de beneficios (Sector Salud) disponibles
*DianApi* | [**get_health_identification_types**](docs/DianApi.md#get_health_identification_types) | **GET** /dian/health-identification-types | Endpoint para obtener la tabla de la DIAN con los tipos de documento de identificación del usuario (Sector Salud) disponibles
*DianApi* | [**get_health_payment_methods**](docs/DianApi.md#get_health_payment_methods) | **GET** /dian/health-payment-methods | Endpoint para obtener la tabla de la DIAN con los tipos de modalidades de pago (Sector Salud) disponibles
*DianApi* | [**get_health_user_types**](docs/DianApi.md#get_health_user_types) | **GET** /dian/health-user-types | Endpoint para obtener la tabla de la DIAN con los tipos de usuario (Sector Salud) disponibles
*DianApi* | [**get_identification_types**](docs/DianApi.md#get_identification_types) | **GET** /dian/identification-types | Endpoint para obtener la tabla de la DIAN con los tipos de identificación disponibles
*DianApi* | [**get_inhability_types**](docs/DianApi.md#get_inhability_types) | **GET** /dian/inability-types | Endpoint para obtener la tabla de la DIAN con los tipos de incapacidad disponibles
*DianApi* | [**get_languages**](docs/DianApi.md#get_languages) | **GET** /dian/languages | Endpoint para obtener la tabla de la DIAN con los lenguajes disponibles
*DianApi* | [**get_municipalities**](docs/DianApi.md#get_municipalities) | **GET** /dian/municipalities | Endpoint para obtener la tabla de la DIAN con los municipios disponibles
*DianApi* | [**get_organization_types**](docs/DianApi.md#get_organization_types) | **GET** /dian/organization-types | Endpoint para obtener la tabla de la DIAN con los tipos de organización jurídica disponibles
*DianApi* | [**get_payment_forms**](docs/DianApi.md#get_payment_forms) | **GET** /dian/payment-forms | Endpoint para obtener la tabla de la DIAN con las formas de pago disponibles
*DianApi* | [**get_payment_methods**](docs/DianApi.md#get_payment_methods) | **GET** /dian/payment-methods | Endpoint para obtener la tabla de la DIAN con los métodos de pago disponibles
*DianApi* | [**get_payroll_periods**](docs/DianApi.md#get_payroll_periods) | **GET** /dian/payroll-periods | Endpoint para obtener la tabla de la DIAN con los periodos de nómina disponibles
*DianApi* | [**get_tax_types**](docs/DianApi.md#get_tax_types) | **GET** /dian/tax-types | Endpoint para obtener la tabla de la DIAN con los tipos de tributos/impuestos disponibles
*DianApi* | [**get_unit_codes**](docs/DianApi.md#get_unit_codes) | **GET** /dian/unit-codes | Endpoint para obtener la tabla de la DIAN con los tipos de unidades de cantidad disponibles
*DocumentosEquivalentesElectrnicosApi* | [**adjustment_note_equivalent_document_file**](docs/DocumentosEquivalentesElectrnicosApi.md#adjustment_note_equivalent_document_file) | **GET** /adjustment-note-equivalent-documents/{id}/files/{fileType} | Endpoint para obtener un archivo asociado a la nota de ajuste al documento equivalente electrónico
*DocumentosEquivalentesElectrnicosApi* | [**create_adjustment_note_equivalent_document**](docs/DocumentosEquivalentesElectrnicosApi.md#create_adjustment_note_equivalent_document) | **POST** /adjustment-note-equivalent-documents | Endpoint para emitir una nota de ajuste al documento equivalente electrónico a la DIAN
*DocumentosEquivalentesElectrnicosApi* | [**create_equivalent_document_pos**](docs/DocumentosEquivalentesElectrnicosApi.md#create_equivalent_document_pos) | **POST** /equivalent-documents/pos | Emisión Documento Equivalente POS a la DIAN
*DocumentosEquivalentesElectrnicosApi* | [**get_adjustment_note_equivalent_document**](docs/DocumentosEquivalentesElectrnicosApi.md#get_adjustment_note_equivalent_document) | **GET** /adjustment-note-equivalent-documents/{id} | Endpoint para consultar una nota de ajuste al documento equivalente electrónico
*DocumentosEquivalentesElectrnicosApi* | [**get_equivalent_document_pos**](docs/DocumentosEquivalentesElectrnicosApi.md#get_equivalent_document_pos) | **GET** /equivalent-documents/{id} | Endpoint para consultar un documento equivalente electrónico
*DocumentosEquivalentesElectrnicosApi* | [**get_equivalent_document_pos_file**](docs/DocumentosEquivalentesElectrnicosApi.md#get_equivalent_document_pos_file) | **GET** /equivalent-documents/{id}/files/{fileType} | Endpoint para obtener un archivo asociado al documento equivalente electrónico
*DocumentosSoporteElectrnicosApi* | [**adjustment_note_support_document_file**](docs/DocumentosSoporteElectrnicosApi.md#adjustment_note_support_document_file) | **GET** /adjustment-note-support-documents/{id}/files/{fileType} | Endpoint para obtener un archivo asociado a la nota de ajuste al documento soporte electrónico
*DocumentosSoporteElectrnicosApi* | [**create_adjustment_note_support_document**](docs/DocumentosSoporteElectrnicosApi.md#create_adjustment_note_support_document) | **POST** /adjustment-note-support-documents | Endpoint para emitir una nota de ajuste al documento soporte electrónico a la DIAN
*DocumentosSoporteElectrnicosApi* | [**create_support_document**](docs/DocumentosSoporteElectrnicosApi.md#create_support_document) | **POST** /support-documents | Endpoint para emitir un documento soporte electrónico a la DIAN
*DocumentosSoporteElectrnicosApi* | [**get_adjustment_note_support_document**](docs/DocumentosSoporteElectrnicosApi.md#get_adjustment_note_support_document) | **GET** /adjustment-note-support-documents/{id} | Endpoint para consultar una nota de ajuste al documento soporte electrónico
*DocumentosSoporteElectrnicosApi* | [**get_support_document**](docs/DocumentosSoporteElectrnicosApi.md#get_support_document) | **GET** /support-documents/{id} | Endpoint para consultar un documento soporte electrónico
*DocumentosSoporteElectrnicosApi* | [**get_support_document_file**](docs/DocumentosSoporteElectrnicosApi.md#get_support_document_file) | **GET** /support-documents/{id}/files/{fileType} | Endpoint para obtener un archivo asociado al documento soporte electrónico
*DocumentosSoporteElectrnicosApi* | [**get_support_documents**](docs/DocumentosSoporteElectrnicosApi.md#get_support_documents) | **GET** /support-documents | Endpoint para consultar documentos soporte electrónicos
*EmpresasApi* | [**create_company**](docs/EmpresasApi.md#create_company) | **POST** /companies | Endpoint para dar de alta a una empresa
*EmpresasApi* | [**get_companies**](docs/EmpresasApi.md#get_companies) | **GET** /companies | Endpoint para consultar el listado de empresas
*EmpresasApi* | [**get_company**](docs/EmpresasApi.md#get_company) | **GET** /companies/{id} | Endpoint para consultar la información de una empresa
*EmpresasApi* | [**get_self_company**](docs/EmpresasApi.md#get_self_company) | **GET** /company | Endpoint para consultar la información de la empresa asociada al token
*EmpresasApi* | [**update_company**](docs/EmpresasApi.md#update_company) | **PATCH** /companies/{id} | Endpoint para actualizar la información de una empresa
*EmpresasApi* | [**update_self_company**](docs/EmpresasApi.md#update_self_company) | **PATCH** /company | Endpoint para actualizar la información de la empresa asociada al token
*EnvioCorreoElectrnicoApi* | [**send_email_post**](docs/EnvioCorreoElectrnicoApi.md#send_email_post) | **POST** /send-email | Endpoint para enviar una notificación de un documento electrónico por correo
*EventosElectrnicosApi* | [**create_event**](docs/EventosElectrnicosApi.md#create_event) | **POST** /events | Endpoint para emitir un evento relacionado a una factura electrónica
*EventosElectrnicosApi* | [**create_event_from_xml**](docs/EventosElectrnicosApi.md#create_event_from_xml) | **POST** /events/from-xml | Endpoint para emitir un evento relacionado a una factura electrónica a partir de su AttachedDocument
*EventosElectrnicosApi* | [**get_event**](docs/EventosElectrnicosApi.md#get_event) | **GET** /events/{id} | Endpoint para consultar la información de un evento por su id
*EventosElectrnicosApi* | [**get_event_file**](docs/EventosElectrnicosApi.md#get_event_file) | **GET** /events/{id}/files/{fileType} | Endpoint para obtener un archivo asociado a un evento electrónico
*EventosElectrnicosApi* | [**get_invoice_events**](docs/EventosElectrnicosApi.md#get_invoice_events) | **GET** /events/invoice/{cufe} | Endpoint para consultar los eventos asociados a una factura hasta la fecha
*FacturasDeVentaElectrnicasApi* | [**create_invoice**](docs/FacturasDeVentaElectrnicasApi.md#create_invoice) | **POST** /invoices | Endpoint para emitir una factura electrónica a la DIAN
*FacturasDeVentaElectrnicasApi* | [**get_invoice**](docs/FacturasDeVentaElectrnicasApi.md#get_invoice) | **GET** /invoices/{id} | Endpoint para consultar una factura electrónica
*FacturasDeVentaElectrnicasApi* | [**get_invoice_file**](docs/FacturasDeVentaElectrnicasApi.md#get_invoice_file) | **GET** /invoices/{id}/files/{fileType} | Endpoint para obtener un archivo asociado a la factura electrónica
*FacturasDeVentaElectrnicasApi* | [**get_invoices**](docs/FacturasDeVentaElectrnicasApi.md#get_invoices) | **GET** /invoices | Endpoint para consultar facturas electrónicas
*NminasElectrnicasApi* | [**adjust_payroll**](docs/NminasElectrnicasApi.md#adjust_payroll) | **POST** /payrolls/{id}/replace | Endpoint para reemplazar/ajustar una nómina electrónica
*NminasElectrnicasApi* | [**cancel_payroll**](docs/NminasElectrnicasApi.md#cancel_payroll) | **POST** /payrolls/{id}/cancel | Endpoint para anular una nómina electrónica
*NminasElectrnicasApi* | [**create_payroll**](docs/NminasElectrnicasApi.md#create_payroll) | **POST** /payrolls | Endpoint para emitir una nómina a la DIAN
*NminasElectrnicasApi* | [**get_payroll**](docs/NminasElectrnicasApi.md#get_payroll) | **GET** /payrolls/{id} | Endpoint para consultar una nómina electrónica
*NminasElectrnicasApi* | [**get_payroll_adjustments**](docs/NminasElectrnicasApi.md#get_payroll_adjustments) | **GET** /payroll-adjustments | Endpoint para consultar ajustes de nóminas electrónicas
*NminasElectrnicasApi* | [**get_payroll_cancellations**](docs/NminasElectrnicasApi.md#get_payroll_cancellations) | **GET** /payroll-cancellations | Endpoint para consultar cancelaciones de nóminas electrónicas
*NminasElectrnicasApi* | [**get_payroll_file**](docs/NminasElectrnicasApi.md#get_payroll_file) | **GET** /payrolls/{id}/files/{fileType} | Endpoint para obtener un archivo asociado a la nómina electrónica
*NminasElectrnicasApi* | [**get_payrolls**](docs/NminasElectrnicasApi.md#get_payrolls) | **GET** /payrolls | Endpoint para consultar nóminas electrónicas
*NotasCrditoElectrnicasApi* | [**create_credit_note**](docs/NotasCrditoElectrnicasApi.md#create_credit_note) | **POST** /credit-notes | Endpoint para emitir una nota crédito electrónica a la DIAN
*NotasCrditoElectrnicasApi* | [**get_credit_note**](docs/NotasCrditoElectrnicasApi.md#get_credit_note) | **GET** /credit-notes/{id} | Endpoint para consultar una nota crédito electrónica
*NotasCrditoElectrnicasApi* | [**get_credit_note_file**](docs/NotasCrditoElectrnicasApi.md#get_credit_note_file) | **GET** /credit-notes/{id}/files/{fileType} | Endpoint para obtener un archivo asociado a la nota crédito electrónica
*NotasCrditoElectrnicasApi* | [**get_credit_notes**](docs/NotasCrditoElectrnicasApi.md#get_credit_notes) | **GET** /credit-notes | Endpoint para consultar notas crédito electrónicas
*NotasDbitoElectrnicasApi* | [**create_debit_note**](docs/NotasDbitoElectrnicasApi.md#create_debit_note) | **POST** /debit-notes | Endpoint para emitir una nota débito electrónica a la DIAN
*NotasDbitoElectrnicasApi* | [**get_debit_note**](docs/NotasDbitoElectrnicasApi.md#get_debit_note) | **GET** /debit-notes/{id} | Endpoint para consultar una nota débito electrónica
*NotasDbitoElectrnicasApi* | [**get_debit_note_file**](docs/NotasDbitoElectrnicasApi.md#get_debit_note_file) | **GET** /debit-notes/{id}/files/{fileType} | Endpoint para obtener un archivo asociado a la nota débito electrónica
*NotasDbitoElectrnicasApi* | [**get_debit_notes**](docs/NotasDbitoElectrnicasApi.md#get_debit_notes) | **GET** /debit-notes | Endpoint para consultar notas débito electrónicas
*ReportsApi* | [**get_daily_document_report**](docs/ReportsApi.md#get_daily_document_report) | **GET** /reports/daily | Endpoint para obtener un reporte de emisiones por día
*ResolucionesApi* | [**get_resolutions**](docs/ResolucionesApi.md#get_resolutions) | **GET** /resolutions/{nit} | Endpoint para la consulta de Rangos de Numeración registrados en la DIAN (Resoluciones)
*SetsDePruebasApi* | [**create_test_set**](docs/SetsDePruebasApi.md#create_test_set) | **POST** /test-sets | Endpoint para crear un set de pruebas
*SetsDePruebasApi* | [**get_test_set**](docs/SetsDePruebasApi.md#get_test_set) | **GET** /test-sets/{id} | Endpoint para consultar la información de un set de pruebas
*SetsDePruebasApi* | [**get_test_set_by_government_id**](docs/SetsDePruebasApi.md#get_test_set_by_government_id) | **GET** /test-sets | Endpoint para consultar un set de pruebas por governmentId


## Documentation For Models

 - [AddressDataFE](docs/AddressDataFE.md)
 - [AdjustPayrollRequest](docs/AdjustPayrollRequest.md)
 - [AssociatedDocument](docs/AssociatedDocument.md)
 - [CancelPayroll200Response](docs/CancelPayroll200Response.md)
 - [CancelPayrollRequest](docs/CancelPayrollRequest.md)
 - [CompanyInvoice](docs/CompanyInvoice.md)
 - [ContactCompany](docs/ContactCompany.md)
 - [ContactCustomer](docs/ContactCustomer.md)
 - [CreateAdjustmentNoteEquivalentDocument200Response](docs/CreateAdjustmentNoteEquivalentDocument200Response.md)
 - [CreateAdjustmentNoteEquivalentDocument200ResponseAdjustmentNoteEquivalentdocument](docs/CreateAdjustmentNoteEquivalentDocument200ResponseAdjustmentNoteEquivalentdocument.md)
 - [CreateAdjustmentNoteEquivalentDocumentRequest](docs/CreateAdjustmentNoteEquivalentDocumentRequest.md)
 - [CreateAdjustmentNoteEquivalentDocumentRequestCustomer](docs/CreateAdjustmentNoteEquivalentDocumentRequestCustomer.md)
 - [CreateAdjustmentNoteEquivalentDocumentRequestDelivery](docs/CreateAdjustmentNoteEquivalentDocumentRequestDelivery.md)
 - [CreateAdjustmentNoteEquivalentDocumentRequestDeliveryAddress](docs/CreateAdjustmentNoteEquivalentDocumentRequestDeliveryAddress.md)
 - [CreateAdjustmentNoteEquivalentDocumentRequestDeliveryDeliveryCompany](docs/CreateAdjustmentNoteEquivalentDocumentRequestDeliveryDeliveryCompany.md)
 - [CreateAdjustmentNoteEquivalentDocumentRequestDeliveryDeliveryCompanyAddress](docs/CreateAdjustmentNoteEquivalentDocumentRequestDeliveryDeliveryCompanyAddress.md)
 - [CreateAdjustmentNoteEquivalentDocumentRequestDeliveryDeliveryCompanyTaxScheme](docs/CreateAdjustmentNoteEquivalentDocumentRequestDeliveryDeliveryCompanyTaxScheme.md)
 - [CreateAdjustmentNoteEquivalentDocumentRequestDeliveryDeliveryCompanyTaxSchemeAddress](docs/CreateAdjustmentNoteEquivalentDocumentRequestDeliveryDeliveryCompanyTaxSchemeAddress.md)
 - [CreateAdjustmentNoteEquivalentDocumentRequestDiscrepancy](docs/CreateAdjustmentNoteEquivalentDocumentRequestDiscrepancy.md)
 - [CreateAdjustmentNoteEquivalentDocumentRequestDocumentReference](docs/CreateAdjustmentNoteEquivalentDocumentRequestDocumentReference.md)
 - [CreateAdjustmentNoteEquivalentDocumentRequestItemsInner](docs/CreateAdjustmentNoteEquivalentDocumentRequestItemsInner.md)
 - [CreateAdjustmentNoteEquivalentDocumentRequestItemsInnerCode](docs/CreateAdjustmentNoteEquivalentDocumentRequestItemsInnerCode.md)
 - [CreateAdjustmentNoteSupportDocument200Response](docs/CreateAdjustmentNoteSupportDocument200Response.md)
 - [CreateAdjustmentNoteSupportDocument200ResponseInvoice](docs/CreateAdjustmentNoteSupportDocument200ResponseInvoice.md)
 - [CreateAdjustmentNoteSupportDocumentRequest](docs/CreateAdjustmentNoteSupportDocumentRequest.md)
 - [CreateAdjustmentNoteSupportDocumentRequestCompany](docs/CreateAdjustmentNoteSupportDocumentRequestCompany.md)
 - [CreateAdjustmentNoteSupportDocumentRequestCompanyTaxCode](docs/CreateAdjustmentNoteSupportDocumentRequestCompanyTaxCode.md)
 - [CreateAdjustmentNoteSupportDocumentRequestDiscountsAndChargesInner](docs/CreateAdjustmentNoteSupportDocumentRequestDiscountsAndChargesInner.md)
 - [CreateAdjustmentNoteSupportDocumentRequestDiscrepanciesInner](docs/CreateAdjustmentNoteSupportDocumentRequestDiscrepanciesInner.md)
 - [CreateAdjustmentNoteSupportDocumentRequestInvoiceDocumentReference](docs/CreateAdjustmentNoteSupportDocumentRequestInvoiceDocumentReference.md)
 - [CreateAdjustmentNoteSupportDocumentRequestItemsInner](docs/CreateAdjustmentNoteSupportDocumentRequestItemsInner.md)
 - [CreateAdjustmentNoteSupportDocumentRequestPaymentsInner](docs/CreateAdjustmentNoteSupportDocumentRequestPaymentsInner.md)
 - [CreateAdjustmentNoteSupportDocumentRequestSupplier](docs/CreateAdjustmentNoteSupportDocumentRequestSupplier.md)
 - [CreateAdjustmentNoteSupportDocumentRequestSupplierAddress](docs/CreateAdjustmentNoteSupportDocumentRequestSupplierAddress.md)
 - [CreateCompany200Response](docs/CreateCompany200Response.md)
 - [CreateCompany200ResponseCompany](docs/CreateCompany200ResponseCompany.md)
 - [CreateCompanyRequest](docs/CreateCompanyRequest.md)
 - [CreateCompanyRequestAllOfAddress](docs/CreateCompanyRequestAllOfAddress.md)
 - [CreateCompanyRequestAllOfCertificate](docs/CreateCompanyRequestAllOfCertificate.md)
 - [CreateCompanyRequestAllOfNotificationByEmail](docs/CreateCompanyRequestAllOfNotificationByEmail.md)
 - [CreateCompanyRequestAllOfWebhooks](docs/CreateCompanyRequestAllOfWebhooks.md)
 - [CreateCompanyRequestAllOfWebhooksCreditNotes](docs/CreateCompanyRequestAllOfWebhooksCreditNotes.md)
 - [CreateCompanyRequestAllOfWebhooksDebitNotes](docs/CreateCompanyRequestAllOfWebhooksDebitNotes.md)
 - [CreateCompanyRequestAllOfWebhooksGeneral](docs/CreateCompanyRequestAllOfWebhooksGeneral.md)
 - [CreateCompanyRequestAllOfWebhooksGeneralGovernmentStatusChanged](docs/CreateCompanyRequestAllOfWebhooksGeneralGovernmentStatusChanged.md)
 - [CreateCompanyRequestAllOfWebhooksInvoices](docs/CreateCompanyRequestAllOfWebhooksInvoices.md)
 - [CreateCompanyRequestAllOfWebhooksPayrolls](docs/CreateCompanyRequestAllOfWebhooksPayrolls.md)
 - [CreateCreditNoteRequest](docs/CreateCreditNoteRequest.md)
 - [CreateCreditNoteRequestAssociatedDocumentsInner](docs/CreateCreditNoteRequestAssociatedDocumentsInner.md)
 - [CreateCreditNoteRequestItemsInner](docs/CreateCreditNoteRequestItemsInner.md)
 - [CreateCreditNoteRequestItemsInnerAllOfTransportSector](docs/CreateCreditNoteRequestItemsInnerAllOfTransportSector.md)
 - [CreateDebitNote200Response](docs/CreateDebitNote200Response.md)
 - [CreateDebitNoteRequest](docs/CreateDebitNoteRequest.md)
 - [CreateEquivalentDocumentPos200Response](docs/CreateEquivalentDocumentPos200Response.md)
 - [CreateEquivalentDocumentPos200ResponseEquivalentDocument](docs/CreateEquivalentDocumentPos200ResponseEquivalentDocument.md)
 - [CreateEquivalentDocumentPos200ResponseEquivalentDocumentErrorsInner](docs/CreateEquivalentDocumentPos200ResponseEquivalentDocumentErrorsInner.md)
 - [CreateEquivalentDocumentPosRequest](docs/CreateEquivalentDocumentPosRequest.md)
 - [CreateEquivalentDocumentPosRequestAdditionalDocumentReference](docs/CreateEquivalentDocumentPosRequestAdditionalDocumentReference.md)
 - [CreateEquivalentDocumentPosRequestBuyerBenefits](docs/CreateEquivalentDocumentPosRequestBuyerBenefits.md)
 - [CreateEquivalentDocumentPosRequestCashRegister](docs/CreateEquivalentDocumentPosRequestCashRegister.md)
 - [CreateEquivalentDocumentPosRequestCompany](docs/CreateEquivalentDocumentPosRequestCompany.md)
 - [CreateEquivalentDocumentPosRequestCompanyContact](docs/CreateEquivalentDocumentPosRequestCompanyContact.md)
 - [CreateEquivalentDocumentPosRequestCompanyTaxCode](docs/CreateEquivalentDocumentPosRequestCompanyTaxCode.md)
 - [CreateEquivalentDocumentPosRequestCustomer](docs/CreateEquivalentDocumentPosRequestCustomer.md)
 - [CreateEquivalentDocumentPosRequestCustomerContact](docs/CreateEquivalentDocumentPosRequestCustomerContact.md)
 - [CreateEquivalentDocumentPosRequestCustomerTaxCode](docs/CreateEquivalentDocumentPosRequestCustomerTaxCode.md)
 - [CreateEquivalentDocumentPosRequestDiscountsAndChargesInner](docs/CreateEquivalentDocumentPosRequestDiscountsAndChargesInner.md)
 - [CreateEquivalentDocumentPosRequestExchangeRate](docs/CreateEquivalentDocumentPosRequestExchangeRate.md)
 - [CreateEquivalentDocumentPosRequestItemsInner](docs/CreateEquivalentDocumentPosRequestItemsInner.md)
 - [CreateEquivalentDocumentPosRequestItemsInnerAdditionalItemPropertiesInner](docs/CreateEquivalentDocumentPosRequestItemsInnerAdditionalItemPropertiesInner.md)
 - [CreateEquivalentDocumentPosRequestItemsInnerCode](docs/CreateEquivalentDocumentPosRequestItemsInnerCode.md)
 - [CreateEquivalentDocumentPosRequestItemsInnerTaxesInner](docs/CreateEquivalentDocumentPosRequestItemsInnerTaxesInner.md)
 - [CreateEquivalentDocumentPosRequestPaymentsInner](docs/CreateEquivalentDocumentPosRequestPaymentsInner.md)
 - [CreateEquivalentDocumentPosRequestResolution](docs/CreateEquivalentDocumentPosRequestResolution.md)
 - [CreateEquivalentDocumentPosRequestTotalAmounts](docs/CreateEquivalentDocumentPosRequestTotalAmounts.md)
 - [CreateEvent200Response](docs/CreateEvent200Response.md)
 - [CreateEvent200ResponseEvent](docs/CreateEvent200ResponseEvent.md)
 - [CreateEvent200ResponseEventReceiver](docs/CreateEvent200ResponseEventReceiver.md)
 - [CreateEvent200ResponseEventType](docs/CreateEvent200ResponseEventType.md)
 - [CreateEventFromXmlRequest](docs/CreateEventFromXmlRequest.md)
 - [CreateEventFromXmlRequestCompany](docs/CreateEventFromXmlRequestCompany.md)
 - [CreateEventRequest](docs/CreateEventRequest.md)
 - [CreateEventRequestAssociatedDocument](docs/CreateEventRequestAssociatedDocument.md)
 - [CreateEventRequestCompany](docs/CreateEventRequestCompany.md)
 - [CreateEventRequestEmail](docs/CreateEventRequestEmail.md)
 - [CreateEventRequestIssuerParty](docs/CreateEventRequestIssuerParty.md)
 - [CreateEventRequestReceiverParty](docs/CreateEventRequestReceiverParty.md)
 - [CreateInvoice200Response](docs/CreateInvoice200Response.md)
 - [CreateInvoiceRequest](docs/CreateInvoiceRequest.md)
 - [CreateInvoiceRequestAdditionalDocumentReference](docs/CreateInvoiceRequestAdditionalDocumentReference.md)
 - [CreateInvoiceRequestAdvancePaymentsInner](docs/CreateInvoiceRequestAdvancePaymentsInner.md)
 - [CreateInvoiceRequestCompany](docs/CreateInvoiceRequestCompany.md)
 - [CreateInvoiceRequestCompanyAddress](docs/CreateInvoiceRequestCompanyAddress.md)
 - [CreateInvoiceRequestCompanyShareholdersInner](docs/CreateInvoiceRequestCompanyShareholdersInner.md)
 - [CreateInvoiceRequestCompanyTaxAddress](docs/CreateInvoiceRequestCompanyTaxAddress.md)
 - [CreateInvoiceRequestCompanyTaxCode](docs/CreateInvoiceRequestCompanyTaxCode.md)
 - [CreateInvoiceRequestCustomer](docs/CreateInvoiceRequestCustomer.md)
 - [CreateInvoiceRequestCustomerAddress](docs/CreateInvoiceRequestCustomerAddress.md)
 - [CreateInvoiceRequestCustomerContact](docs/CreateInvoiceRequestCustomerContact.md)
 - [CreateInvoiceRequestCustomerTaxAddress](docs/CreateInvoiceRequestCustomerTaxAddress.md)
 - [CreateInvoiceRequestCustomerTaxCode](docs/CreateInvoiceRequestCustomerTaxCode.md)
 - [CreateInvoiceRequestDiscountsAndChargesInner](docs/CreateInvoiceRequestDiscountsAndChargesInner.md)
 - [CreateInvoiceRequestHealthSectorGeneral](docs/CreateInvoiceRequestHealthSectorGeneral.md)
 - [CreateInvoiceRequestHealthSectorGeneralPrepaidPaymentsInner](docs/CreateInvoiceRequestHealthSectorGeneralPrepaidPaymentsInner.md)
 - [CreateInvoiceRequestInvoicePeriod](docs/CreateInvoiceRequestInvoicePeriod.md)
 - [CreateInvoiceRequestItemsInner](docs/CreateInvoiceRequestItemsInner.md)
 - [CreateInvoiceRequestItemsInnerAllOfPriceReference](docs/CreateInvoiceRequestItemsInnerAllOfPriceReference.md)
 - [CreateInvoiceRequestItemsInnerAllOfTaxesInner](docs/CreateInvoiceRequestItemsInnerAllOfTaxesInner.md)
 - [CreateInvoiceRequestItemsInnerAllOfThirdPartyInformation](docs/CreateInvoiceRequestItemsInnerAllOfThirdPartyInformation.md)
 - [CreateInvoiceRequestItemsInnerAllOfTransportSector](docs/CreateInvoiceRequestItemsInnerAllOfTransportSector.md)
 - [CreateInvoiceRequestOrderReference](docs/CreateInvoiceRequestOrderReference.md)
 - [CreateInvoiceRequestResolution](docs/CreateInvoiceRequestResolution.md)
 - [CreatePayrollRequest](docs/CreatePayrollRequest.md)
 - [CreatePayrollRequestCompany](docs/CreatePayrollRequestCompany.md)
 - [CreatePayrollRequestGovernmentData](docs/CreatePayrollRequestGovernmentData.md)
 - [CreatePayrollRequestGovernmentDataDeducciones](docs/CreatePayrollRequestGovernmentDataDeducciones.md)
 - [CreatePayrollRequestGovernmentDataDeduccionesAnticipos](docs/CreatePayrollRequestGovernmentDataDeduccionesAnticipos.md)
 - [CreatePayrollRequestGovernmentDataDeduccionesFondoPension](docs/CreatePayrollRequestGovernmentDataDeduccionesFondoPension.md)
 - [CreatePayrollRequestGovernmentDataDeduccionesFondoSP](docs/CreatePayrollRequestGovernmentDataDeduccionesFondoSP.md)
 - [CreatePayrollRequestGovernmentDataDeduccionesLibranzas](docs/CreatePayrollRequestGovernmentDataDeduccionesLibranzas.md)
 - [CreatePayrollRequestGovernmentDataDeduccionesLibranzasLibranzaInner](docs/CreatePayrollRequestGovernmentDataDeduccionesLibranzasLibranzaInner.md)
 - [CreatePayrollRequestGovernmentDataDeduccionesOtrasDeducciones](docs/CreatePayrollRequestGovernmentDataDeduccionesOtrasDeducciones.md)
 - [CreatePayrollRequestGovernmentDataDeduccionesPagosTerceros](docs/CreatePayrollRequestGovernmentDataDeduccionesPagosTerceros.md)
 - [CreatePayrollRequestGovernmentDataDeduccionesSalud](docs/CreatePayrollRequestGovernmentDataDeduccionesSalud.md)
 - [CreatePayrollRequestGovernmentDataDeduccionesSanciones](docs/CreatePayrollRequestGovernmentDataDeduccionesSanciones.md)
 - [CreatePayrollRequestGovernmentDataDeduccionesSancionesSancionInner](docs/CreatePayrollRequestGovernmentDataDeduccionesSancionesSancionInner.md)
 - [CreatePayrollRequestGovernmentDataDeduccionesSindicatos](docs/CreatePayrollRequestGovernmentDataDeduccionesSindicatos.md)
 - [CreatePayrollRequestGovernmentDataDeduccionesSindicatosSindicatoInner](docs/CreatePayrollRequestGovernmentDataDeduccionesSindicatosSindicatoInner.md)
 - [CreatePayrollRequestGovernmentDataDevengados](docs/CreatePayrollRequestGovernmentDataDevengados.md)
 - [CreatePayrollRequestGovernmentDataDevengadosAnticipos](docs/CreatePayrollRequestGovernmentDataDevengadosAnticipos.md)
 - [CreatePayrollRequestGovernmentDataDevengadosAuxilios](docs/CreatePayrollRequestGovernmentDataDevengadosAuxilios.md)
 - [CreatePayrollRequestGovernmentDataDevengadosAuxiliosAuxilioInner](docs/CreatePayrollRequestGovernmentDataDevengadosAuxiliosAuxilioInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosBasico](docs/CreatePayrollRequestGovernmentDataDevengadosBasico.md)
 - [CreatePayrollRequestGovernmentDataDevengadosBonificaciones](docs/CreatePayrollRequestGovernmentDataDevengadosBonificaciones.md)
 - [CreatePayrollRequestGovernmentDataDevengadosBonificacionesBonificacionInner](docs/CreatePayrollRequestGovernmentDataDevengadosBonificacionesBonificacionInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosBonoEPCTVs](docs/CreatePayrollRequestGovernmentDataDevengadosBonoEPCTVs.md)
 - [CreatePayrollRequestGovernmentDataDevengadosBonoEPCTVsBonoEPCTVInner](docs/CreatePayrollRequestGovernmentDataDevengadosBonoEPCTVsBonoEPCTVInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosCesantias](docs/CreatePayrollRequestGovernmentDataDevengadosCesantias.md)
 - [CreatePayrollRequestGovernmentDataDevengadosComisiones](docs/CreatePayrollRequestGovernmentDataDevengadosComisiones.md)
 - [CreatePayrollRequestGovernmentDataDevengadosCompensaciones](docs/CreatePayrollRequestGovernmentDataDevengadosCompensaciones.md)
 - [CreatePayrollRequestGovernmentDataDevengadosCompensacionesCompensacionInner](docs/CreatePayrollRequestGovernmentDataDevengadosCompensacionesCompensacionInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHEDDFs](docs/CreatePayrollRequestGovernmentDataDevengadosHEDDFs.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHEDDFsHEDDFInner](docs/CreatePayrollRequestGovernmentDataDevengadosHEDDFsHEDDFInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHEDs](docs/CreatePayrollRequestGovernmentDataDevengadosHEDs.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHEDsHEDInner](docs/CreatePayrollRequestGovernmentDataDevengadosHEDsHEDInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHENDFs](docs/CreatePayrollRequestGovernmentDataDevengadosHENDFs.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHENDFsHENDFInner](docs/CreatePayrollRequestGovernmentDataDevengadosHENDFsHENDFInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHENs](docs/CreatePayrollRequestGovernmentDataDevengadosHENs.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHENsHENInner](docs/CreatePayrollRequestGovernmentDataDevengadosHENsHENInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHRDDFs](docs/CreatePayrollRequestGovernmentDataDevengadosHRDDFs.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHRDDFsHRDDFInner](docs/CreatePayrollRequestGovernmentDataDevengadosHRDDFsHRDDFInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHRNDFs](docs/CreatePayrollRequestGovernmentDataDevengadosHRNDFs.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHRNDFsHRNDFInner](docs/CreatePayrollRequestGovernmentDataDevengadosHRNDFsHRNDFInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHRNs](docs/CreatePayrollRequestGovernmentDataDevengadosHRNs.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHRNsHRNInner](docs/CreatePayrollRequestGovernmentDataDevengadosHRNsHRNInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHuelgasLegales](docs/CreatePayrollRequestGovernmentDataDevengadosHuelgasLegales.md)
 - [CreatePayrollRequestGovernmentDataDevengadosHuelgasLegalesHuelgaLegalInner](docs/CreatePayrollRequestGovernmentDataDevengadosHuelgasLegalesHuelgaLegalInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosIncapacidades](docs/CreatePayrollRequestGovernmentDataDevengadosIncapacidades.md)
 - [CreatePayrollRequestGovernmentDataDevengadosIncapacidadesIncapacidadInner](docs/CreatePayrollRequestGovernmentDataDevengadosIncapacidadesIncapacidadInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosLicencias](docs/CreatePayrollRequestGovernmentDataDevengadosLicencias.md)
 - [CreatePayrollRequestGovernmentDataDevengadosLicenciasLicenciaMPInner](docs/CreatePayrollRequestGovernmentDataDevengadosLicenciasLicenciaMPInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosLicenciasLicenciaNRInner](docs/CreatePayrollRequestGovernmentDataDevengadosLicenciasLicenciaNRInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosLicenciasLicenciaRInner](docs/CreatePayrollRequestGovernmentDataDevengadosLicenciasLicenciaRInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosOtrosConceptos](docs/CreatePayrollRequestGovernmentDataDevengadosOtrosConceptos.md)
 - [CreatePayrollRequestGovernmentDataDevengadosOtrosConceptosOtroConceptoInner](docs/CreatePayrollRequestGovernmentDataDevengadosOtrosConceptosOtroConceptoInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosPagosTerceros](docs/CreatePayrollRequestGovernmentDataDevengadosPagosTerceros.md)
 - [CreatePayrollRequestGovernmentDataDevengadosPrimas](docs/CreatePayrollRequestGovernmentDataDevengadosPrimas.md)
 - [CreatePayrollRequestGovernmentDataDevengadosTransporteInner](docs/CreatePayrollRequestGovernmentDataDevengadosTransporteInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosVacaciones](docs/CreatePayrollRequestGovernmentDataDevengadosVacaciones.md)
 - [CreatePayrollRequestGovernmentDataDevengadosVacacionesVacacionesCompensadasInner](docs/CreatePayrollRequestGovernmentDataDevengadosVacacionesVacacionesCompensadasInner.md)
 - [CreatePayrollRequestGovernmentDataDevengadosVacacionesVacacionesComunesInner](docs/CreatePayrollRequestGovernmentDataDevengadosVacacionesVacacionesComunesInner.md)
 - [CreatePayrollRequestGovernmentDataEmpleador](docs/CreatePayrollRequestGovernmentDataEmpleador.md)
 - [CreatePayrollRequestGovernmentDataFechasPagos](docs/CreatePayrollRequestGovernmentDataFechasPagos.md)
 - [CreatePayrollRequestGovernmentDataInformacionGeneral](docs/CreatePayrollRequestGovernmentDataInformacionGeneral.md)
 - [CreatePayrollRequestGovernmentDataLugarGeneracionXML](docs/CreatePayrollRequestGovernmentDataLugarGeneracionXML.md)
 - [CreatePayrollRequestGovernmentDataNovedad](docs/CreatePayrollRequestGovernmentDataNovedad.md)
 - [CreatePayrollRequestGovernmentDataPago](docs/CreatePayrollRequestGovernmentDataPago.md)
 - [CreatePayrollRequestGovernmentDataPeriodo](docs/CreatePayrollRequestGovernmentDataPeriodo.md)
 - [CreatePayrollRequestGovernmentDataTrabajador](docs/CreatePayrollRequestGovernmentDataTrabajador.md)
 - [CreateSupportDocument200Response](docs/CreateSupportDocument200Response.md)
 - [CreateSupportDocumentRequest](docs/CreateSupportDocumentRequest.md)
 - [CreateSupportDocumentRequestBillingReference](docs/CreateSupportDocumentRequestBillingReference.md)
 - [CreateSupportDocumentRequestCompany](docs/CreateSupportDocumentRequestCompany.md)
 - [CreateSupportDocumentRequestCompanyTaxCode](docs/CreateSupportDocumentRequestCompanyTaxCode.md)
 - [CreateSupportDocumentRequestDiscountsAndChargesInner](docs/CreateSupportDocumentRequestDiscountsAndChargesInner.md)
 - [CreateSupportDocumentRequestDocumentCurrency](docs/CreateSupportDocumentRequestDocumentCurrency.md)
 - [CreateSupportDocumentRequestItemsInner](docs/CreateSupportDocumentRequestItemsInner.md)
 - [CreateSupportDocumentRequestItemsInnerInvoicePeriod](docs/CreateSupportDocumentRequestItemsInnerInvoicePeriod.md)
 - [CreateSupportDocumentRequestItemsInnerStandardCode](docs/CreateSupportDocumentRequestItemsInnerStandardCode.md)
 - [CreateSupportDocumentRequestItemsInnerTaxesInner](docs/CreateSupportDocumentRequestItemsInnerTaxesInner.md)
 - [CreateSupportDocumentRequestItemsInnerWithholdingsInner](docs/CreateSupportDocumentRequestItemsInnerWithholdingsInner.md)
 - [CreateSupportDocumentRequestOrderReference](docs/CreateSupportDocumentRequestOrderReference.md)
 - [CreateSupportDocumentRequestPaymentsInner](docs/CreateSupportDocumentRequestPaymentsInner.md)
 - [CreateSupportDocumentRequestResolution](docs/CreateSupportDocumentRequestResolution.md)
 - [CreateSupportDocumentRequestSupplier](docs/CreateSupportDocumentRequestSupplier.md)
 - [CreateSupportDocumentRequestSupplierAddress](docs/CreateSupportDocumentRequestSupplierAddress.md)
 - [CreateSupportDocumentRequestTotalAmounts](docs/CreateSupportDocumentRequestTotalAmounts.md)
 - [CreateTestSet200Response](docs/CreateTestSet200Response.md)
 - [CreateTestSet200ResponseTestSetsInner](docs/CreateTestSet200ResponseTestSetsInner.md)
 - [CreateTestSetRequest](docs/CreateTestSetRequest.md)
 - [CreateTestSetRequestCompany](docs/CreateTestSetRequestCompany.md)
 - [Customer](docs/Customer.md)
 - [CustomerTaxCode](docs/CustomerTaxCode.md)
 - [DiscountAndCharge](docs/DiscountAndCharge.md)
 - [Email](docs/Email.md)
 - [Error](docs/Error.md)
 - [ExchangeRate](docs/ExchangeRate.md)
 - [GetCompanies200Response](docs/GetCompanies200Response.md)
 - [GetCompanies200ResponseCompaniesInner](docs/GetCompanies200ResponseCompaniesInner.md)
 - [GetCompanies200ResponseCompaniesInnerAddress](docs/GetCompanies200ResponseCompaniesInnerAddress.md)
 - [GetCompanies200ResponseCompaniesInnerCertificate](docs/GetCompanies200ResponseCompaniesInnerCertificate.md)
 - [GetCompanies200ResponseCompaniesInnerGovernmentStatus](docs/GetCompanies200ResponseCompaniesInnerGovernmentStatus.md)
 - [GetCompanies200ResponseCompaniesInnerNotificationByEmail](docs/GetCompanies200ResponseCompaniesInnerNotificationByEmail.md)
 - [GetCompanies200ResponseCompaniesInnerTaxCode](docs/GetCompanies200ResponseCompaniesInnerTaxCode.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooks](docs/GetCompanies200ResponseCompaniesInnerWebhooks.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooksCreditNotes](docs/GetCompanies200ResponseCompaniesInnerWebhooksCreditNotes.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooksCreditNotesEmissionFinished](docs/GetCompanies200ResponseCompaniesInnerWebhooksCreditNotesEmissionFinished.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooksDebitNotes](docs/GetCompanies200ResponseCompaniesInnerWebhooksDebitNotes.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooksDebitNotesEmissionFinished](docs/GetCompanies200ResponseCompaniesInnerWebhooksDebitNotesEmissionFinished.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooksEquivalentDocuments](docs/GetCompanies200ResponseCompaniesInnerWebhooksEquivalentDocuments.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooksEquivalentDocumentsEmissionFinished](docs/GetCompanies200ResponseCompaniesInnerWebhooksEquivalentDocumentsEmissionFinished.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooksGeneral](docs/GetCompanies200ResponseCompaniesInnerWebhooksGeneral.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooksGeneralGovernmentStatusChanged](docs/GetCompanies200ResponseCompaniesInnerWebhooksGeneralGovernmentStatusChanged.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooksInvoices](docs/GetCompanies200ResponseCompaniesInnerWebhooksInvoices.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooksInvoicesEmissionFinished](docs/GetCompanies200ResponseCompaniesInnerWebhooksInvoicesEmissionFinished.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooksPayrolls](docs/GetCompanies200ResponseCompaniesInnerWebhooksPayrolls.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooksPayrollsEmissionFinished](docs/GetCompanies200ResponseCompaniesInnerWebhooksPayrollsEmissionFinished.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooksSupportDocuments](docs/GetCompanies200ResponseCompaniesInnerWebhooksSupportDocuments.md)
 - [GetCompanies200ResponseCompaniesInnerWebhooksSupportDocumentsEmissionFinished](docs/GetCompanies200ResponseCompaniesInnerWebhooksSupportDocumentsEmissionFinished.md)
 - [GetCreditNote200Response](docs/GetCreditNote200Response.md)
 - [GetCreditNotes200Response](docs/GetCreditNotes200Response.md)
 - [GetCreditNotes200ResponseInvoicesInner](docs/GetCreditNotes200ResponseInvoicesInner.md)
 - [GetDailyDocumentReport200Response](docs/GetDailyDocumentReport200Response.md)
 - [GetDailyDocumentReport400ResponseInner](docs/GetDailyDocumentReport400ResponseInner.md)
 - [GetDebitNotes200Response](docs/GetDebitNotes200Response.md)
 - [GetDebitNotes200ResponseInvoicesInner](docs/GetDebitNotes200ResponseInvoicesInner.md)
 - [GetIdentificationTypes200Response](docs/GetIdentificationTypes200Response.md)
 - [GetIdentificationTypes200ResponseTableInner](docs/GetIdentificationTypes200ResponseTableInner.md)
 - [GetInvoiceEvents200Response](docs/GetInvoiceEvents200Response.md)
 - [GetInvoiceEvents200ResponseEventsInner](docs/GetInvoiceEvents200ResponseEventsInner.md)
 - [GetInvoiceEvents200ResponseEventsInnerDocumentReference](docs/GetInvoiceEvents200ResponseEventsInnerDocumentReference.md)
 - [GetInvoiceEvents200ResponseEventsInnerIssuerParty](docs/GetInvoiceEvents200ResponseEventsInnerIssuerParty.md)
 - [GetInvoiceEvents200ResponseEventsInnerReceiverParty](docs/GetInvoiceEvents200ResponseEventsInnerReceiverParty.md)
 - [GetInvoiceEvents503Response](docs/GetInvoiceEvents503Response.md)
 - [GetInvoices200Response](docs/GetInvoices200Response.md)
 - [GetInvoices200ResponseInvoicesInner](docs/GetInvoices200ResponseInvoicesInner.md)
 - [GetPayrollAdjustments200Response](docs/GetPayrollAdjustments200Response.md)
 - [GetPayrollCancellations200Response](docs/GetPayrollCancellations200Response.md)
 - [GetPayrollFile200Response](docs/GetPayrollFile200Response.md)
 - [GetPayrollFile200ResponseFile](docs/GetPayrollFile200ResponseFile.md)
 - [GetPayrolls200Response](docs/GetPayrolls200Response.md)
 - [GetPayrolls200ResponseMetadata](docs/GetPayrolls200ResponseMetadata.md)
 - [GetReceptionEmails200Response](docs/GetReceptionEmails200Response.md)
 - [GetResolutions200Response](docs/GetResolutions200Response.md)
 - [GetResolutions200ResponseResolutionsInner](docs/GetResolutions200ResponseResolutionsInner.md)
 - [GetSupportDocuments200Response](docs/GetSupportDocuments200Response.md)
 - [GetSupportDocuments200ResponseSupportDocumentsInner](docs/GetSupportDocuments200ResponseSupportDocumentsInner.md)
 - [GetTestSet200Response](docs/GetTestSet200Response.md)
 - [GetTestSetByGovernmentId200Response](docs/GetTestSetByGovernmentId200Response.md)
 - [GetTestSetByGovernmentId200ResponseEmission](docs/GetTestSetByGovernmentId200ResponseEmission.md)
 - [GetTestSetByGovernmentId200ResponseEmissionGovernmentResponse](docs/GetTestSetByGovernmentId200ResponseEmissionGovernmentResponse.md)
 - [InvoiceFile](docs/InvoiceFile.md)
 - [Item](docs/Item.md)
 - [ItemsInner](docs/ItemsInner.md)
 - [Metadata](docs/Metadata.md)
 - [Payment](docs/Payment.md)
 - [Resolution](docs/Resolution.md)
 - [SendEmailPost200Response](docs/SendEmailPost200Response.md)
 - [SendEmailPost200ResponseData](docs/SendEmailPost200ResponseData.md)
 - [SendEmailPost200ResponseDataCompany](docs/SendEmailPost200ResponseDataCompany.md)
 - [SendEmailPost200ResponseDataDocument](docs/SendEmailPost200ResponseDataDocument.md)
 - [SendEmailPost200ResponseDataReceiver](docs/SendEmailPost200ResponseDataReceiver.md)
 - [SendEmailPostRequest](docs/SendEmailPostRequest.md)
 - [SendEmailPostRequestEmail](docs/SendEmailPostRequestEmail.md)
 - [Supplier](docs/Supplier.md)
 - [Tax](docs/Tax.md)
 - [TotalAmounts](docs/TotalAmounts.md)
 - [UpdateCompanyRequest](docs/UpdateCompanyRequest.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="auth"></a>
### auth

- **Type**: Bearer authentication


## Author




