# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_adjustment_note_support_document_request_company import CreateAdjustmentNoteSupportDocumentRequestCompany
from openapi_client.models.create_adjustment_note_support_document_request_discounts_and_charges_inner import CreateAdjustmentNoteSupportDocumentRequestDiscountsAndChargesInner
from openapi_client.models.create_adjustment_note_support_document_request_discrepancies_inner import CreateAdjustmentNoteSupportDocumentRequestDiscrepanciesInner
from openapi_client.models.create_adjustment_note_support_document_request_invoice_document_reference import CreateAdjustmentNoteSupportDocumentRequestInvoiceDocumentReference
from openapi_client.models.create_adjustment_note_support_document_request_items_inner import CreateAdjustmentNoteSupportDocumentRequestItemsInner
from openapi_client.models.create_adjustment_note_support_document_request_payments_inner import CreateAdjustmentNoteSupportDocumentRequestPaymentsInner
from openapi_client.models.create_adjustment_note_support_document_request_supplier import CreateAdjustmentNoteSupportDocumentRequestSupplier
from openapi_client.models.create_support_document_request_document_currency import CreateSupportDocumentRequestDocumentCurrency
from openapi_client.models.create_support_document_request_order_reference import CreateSupportDocumentRequestOrderReference
from openapi_client.models.create_support_document_request_total_amounts import CreateSupportDocumentRequestTotalAmounts
from typing import Optional, Set
from typing_extensions import Self

class CreateAdjustmentNoteSupportDocumentRequest(BaseModel):
    """
    CreateAdjustmentNoteSupportDocumentRequest
    """ # noqa: E501
    document_currency: Optional[CreateSupportDocumentRequestDocumentCurrency] = Field(default=None, alias="documentCurrency")
    number: Union[StrictFloat, StrictInt] = Field(description="Número de la nota de ajuste del Documento Soporte Electrónico. <br><i>Campo oficial DIAN &lt;ID&gt;</i>")
    prefix: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="Indica el prefijo asignado a las notas de ajuste. <br><i>Campo oficial DIAN &lt;ID&gt;</i>")
    note: Optional[Annotated[str, Field(min_length=15, strict=True, max_length=5000)]] = Field(default=None, description="Información adicional: Texto libre, relativo al documento")
    invoice_document_reference: CreateAdjustmentNoteSupportDocumentRequestInvoiceDocumentReference = Field(alias="invoiceDocumentReference")
    discrepancies: List[CreateAdjustmentNoteSupportDocumentRequestDiscrepanciesInner] = Field(description="Array que contiene el listado de objetos que explican la naturaleza de la Nota de ajuste al documento soporte")
    company: CreateAdjustmentNoteSupportDocumentRequestCompany
    supplier: CreateAdjustmentNoteSupportDocumentRequestSupplier
    items: List[CreateAdjustmentNoteSupportDocumentRequestItemsInner] = Field(description="Array que contiene el listado de articulos y/o servicios")
    total_amounts: CreateSupportDocumentRequestTotalAmounts = Field(alias="totalAmounts")
    payments: List[CreateAdjustmentNoteSupportDocumentRequestPaymentsInner] = Field(description="Array con el listado de pagos. Grupo de campos para información relacionadas con el pago de la factura. <br><i>Grupo de información oficial DIAN &lt;PaymentMeans&gt;</i>")
    discounts_and_charges: Optional[List[CreateAdjustmentNoteSupportDocumentRequestDiscountsAndChargesInner]] = Field(default=None, description="Descuentos o cargos a nivel del DSE, estos descuentos o cargos no afectan las bases gravables. Si se desea agregar un descuento o cargo que afecte la base gravable se debe informan a nivel de items en el elemento `discountAmount`. <br><i>Grupo de información oficial DIAN &lt;AllowanceCharge&gt;</i>", alias="discountsAndCharges")
    order_reference: Optional[CreateSupportDocumentRequestOrderReference] = Field(default=None, alias="orderReference")
    __properties: ClassVar[List[str]] = ["documentCurrency", "number", "prefix", "note", "invoiceDocumentReference", "discrepancies", "company", "supplier", "items", "totalAmounts", "payments", "discountsAndCharges", "orderReference"]

    @field_validator('prefix')
    def prefix_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateAdjustmentNoteSupportDocumentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of document_currency
        if self.document_currency:
            _dict['documentCurrency'] = self.document_currency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of invoice_document_reference
        if self.invoice_document_reference:
            _dict['invoiceDocumentReference'] = self.invoice_document_reference.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in discrepancies (list)
        _items = []
        if self.discrepancies:
            for _item_discrepancies in self.discrepancies:
                if _item_discrepancies:
                    _items.append(_item_discrepancies.to_dict())
            _dict['discrepancies'] = _items
        # override the default output from pydantic by calling `to_dict()` of company
        if self.company:
            _dict['company'] = self.company.to_dict()
        # override the default output from pydantic by calling `to_dict()` of supplier
        if self.supplier:
            _dict['supplier'] = self.supplier.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of total_amounts
        if self.total_amounts:
            _dict['totalAmounts'] = self.total_amounts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in payments (list)
        _items = []
        if self.payments:
            for _item_payments in self.payments:
                if _item_payments:
                    _items.append(_item_payments.to_dict())
            _dict['payments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in discounts_and_charges (list)
        _items = []
        if self.discounts_and_charges:
            for _item_discounts_and_charges in self.discounts_and_charges:
                if _item_discounts_and_charges:
                    _items.append(_item_discounts_and_charges.to_dict())
            _dict['discountsAndCharges'] = _items
        # override the default output from pydantic by calling `to_dict()` of order_reference
        if self.order_reference:
            _dict['orderReference'] = self.order_reference.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateAdjustmentNoteSupportDocumentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "documentCurrency": CreateSupportDocumentRequestDocumentCurrency.from_dict(obj["documentCurrency"]) if obj.get("documentCurrency") is not None else None,
            "number": obj.get("number"),
            "prefix": obj.get("prefix"),
            "note": obj.get("note"),
            "invoiceDocumentReference": CreateAdjustmentNoteSupportDocumentRequestInvoiceDocumentReference.from_dict(obj["invoiceDocumentReference"]) if obj.get("invoiceDocumentReference") is not None else None,
            "discrepancies": [CreateAdjustmentNoteSupportDocumentRequestDiscrepanciesInner.from_dict(_item) for _item in obj["discrepancies"]] if obj.get("discrepancies") is not None else None,
            "company": CreateAdjustmentNoteSupportDocumentRequestCompany.from_dict(obj["company"]) if obj.get("company") is not None else None,
            "supplier": CreateAdjustmentNoteSupportDocumentRequestSupplier.from_dict(obj["supplier"]) if obj.get("supplier") is not None else None,
            "items": [CreateAdjustmentNoteSupportDocumentRequestItemsInner.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "totalAmounts": CreateSupportDocumentRequestTotalAmounts.from_dict(obj["totalAmounts"]) if obj.get("totalAmounts") is not None else None,
            "payments": [CreateAdjustmentNoteSupportDocumentRequestPaymentsInner.from_dict(_item) for _item in obj["payments"]] if obj.get("payments") is not None else None,
            "discountsAndCharges": [CreateAdjustmentNoteSupportDocumentRequestDiscountsAndChargesInner.from_dict(_item) for _item in obj["discountsAndCharges"]] if obj.get("discountsAndCharges") is not None else None,
            "orderReference": CreateSupportDocumentRequestOrderReference.from_dict(obj["orderReference"]) if obj.get("orderReference") is not None else None
        })
        return _obj


