# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.create_event_request_associated_document import CreateEventRequestAssociatedDocument
from openapi_client.models.create_event_request_company import CreateEventRequestCompany
from openapi_client.models.create_event_request_email import CreateEventRequestEmail
from openapi_client.models.create_event_request_issuer_party import CreateEventRequestIssuerParty
from openapi_client.models.create_event_request_receiver_party import CreateEventRequestReceiverParty
from typing import Optional, Set
from typing_extensions import Self

class CreateEventRequest(BaseModel):
    """
    CreateEventRequest
    """ # noqa: E501
    number: StrictStr = Field(description="Número del evento que se emite, el valor es alfanumérico y único por evento dentro de la misma compañia")
    type: StrictStr = Field(description="Código relacionado al tipo de evento que se quiere emitir. Recibo de Factura (030). Reclamo de la Factura Electrónica de Venta (031). Recibo Bienes y Servicios (032). Aceptación Expresa (033). Aceptación Tácita (034)")
    company: Optional[CreateEventRequestCompany] = None
    associated_document: CreateEventRequestAssociatedDocument = Field(alias="associatedDocument")
    receiver_party: Optional[CreateEventRequestReceiverParty] = Field(default=None, alias="receiverParty")
    issuer_party: Optional[CreateEventRequestIssuerParty] = Field(default=None, alias="issuerParty")
    claim_code: Optional[StrictStr] = Field(default=None, description="Código del motivo de rechazo según la tabla DIAN. Documento con inconsistencias (01). Mercancía no entregada totalmente (02). Mercancía no entregada parcialmente (03). Servicio no prestado (04). Campo requerido únicamente en los eventos de rechazo de factura o documento electrónico", alias="claimCode")
    email: Optional[CreateEventRequestEmail] = None
    __properties: ClassVar[List[str]] = ["number", "type", "company", "associatedDocument", "receiverParty", "issuerParty", "claimCode", "email"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['030', '031', '032', '033', '034']):
            raise ValueError("must be one of enum values ('030', '031', '032', '033', '034')")
        return value

    @field_validator('claim_code')
    def claim_code_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['01', '02', '03', '04']):
            raise ValueError("must be one of enum values ('01', '02', '03', '04')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateEventRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of company
        if self.company:
            _dict['company'] = self.company.to_dict()
        # override the default output from pydantic by calling `to_dict()` of associated_document
        if self.associated_document:
            _dict['associatedDocument'] = self.associated_document.to_dict()
        # override the default output from pydantic by calling `to_dict()` of receiver_party
        if self.receiver_party:
            _dict['receiverParty'] = self.receiver_party.to_dict()
        # override the default output from pydantic by calling `to_dict()` of issuer_party
        if self.issuer_party:
            _dict['issuerParty'] = self.issuer_party.to_dict()
        # override the default output from pydantic by calling `to_dict()` of email
        if self.email:
            _dict['email'] = self.email.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateEventRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "number": obj.get("number"),
            "type": obj.get("type"),
            "company": CreateEventRequestCompany.from_dict(obj["company"]) if obj.get("company") is not None else None,
            "associatedDocument": CreateEventRequestAssociatedDocument.from_dict(obj["associatedDocument"]) if obj.get("associatedDocument") is not None else None,
            "receiverParty": CreateEventRequestReceiverParty.from_dict(obj["receiverParty"]) if obj.get("receiverParty") is not None else None,
            "issuerParty": CreateEventRequestIssuerParty.from_dict(obj["issuerParty"]) if obj.get("issuerParty") is not None else None,
            "claimCode": obj.get("claimCode"),
            "email": CreateEventRequestEmail.from_dict(obj["email"]) if obj.get("email") is not None else None
        })
        return _obj


