# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateEventRequestIssuerParty(BaseModel):
    """
    Informa quién recibió la factura electrónica o el bien y servicio. Solo es requerido en los eventos Recibo de Factura y Recibo de bienes y/o servicios
    """ # noqa: E501
    identification_type: Optional[StrictStr] = Field(default=None, description="Tipo de identificador fiscal", alias="identificationType")
    dv: Optional[StrictStr] = Field(default=None, description="Requerido si el tipo de identificador es 31 equivalente a NIT")
    identification_number: Optional[StrictStr] = Field(default=None, description="Número de identificación de la persona", alias="identificationNumber")
    first_name: Optional[StrictStr] = Field(default=None, description="Nombre de la persona que recibió la factura o los bienes y/o servicios", alias="firstName")
    family_name: Optional[StrictStr] = Field(default=None, description="Apellido de la persona que recibió la factura o los bienes y/o servicios", alias="familyName")
    job_title: Optional[StrictStr] = Field(default=None, description="Cargo de la persona que recibió la factura o los bienes y/o servicios", alias="jobTitle")
    organization_department: Optional[StrictStr] = Field(default=None, description="Area, sección o departamento de la persona que recibió la factura o los bienes y/o servicios", alias="organizationDepartment")
    __properties: ClassVar[List[str]] = ["identificationType", "dv", "identificationNumber", "firstName", "familyName", "jobTitle", "organizationDepartment"]

    @field_validator('identification_type')
    def identification_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['11', '12', '13', '21', '22', '31', '41', '42', '47', '50', '91']):
            raise ValueError("must be one of enum values ('11', '12', '13', '21', '22', '31', '41', '42', '47', '50', '91')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateEventRequestIssuerParty from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateEventRequestIssuerParty from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "identificationType": obj.get("identificationType"),
            "dv": obj.get("dv"),
            "identificationNumber": obj.get("identificationNumber"),
            "firstName": obj.get("firstName"),
            "familyName": obj.get("familyName"),
            "jobTitle": obj.get("jobTitle"),
            "organizationDepartment": obj.get("organizationDepartment")
        })
        return _obj


