# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CreatePayrollRequestGovernmentDataTrabajador(BaseModel):
    """
    Objeto con la información del trabajador
    """ # noqa: E501
    tipo_trabajador: Annotated[str, Field(strict=True, max_length=2)] = Field(description="Código del tipo de trabajador del Ministerio de salud. Aportes a Seguridad Social de Activos. Se debe colocar el Codigo que corresponda de la tabla de tipos de trabajador de la DIAN", alias="TipoTrabajador")
    sub_tipo_trabajador: Annotated[str, Field(strict=True, max_length=2)] = Field(description="Código del Sub tipo de trabajador del Ministerio de salud. Aportes a Seguridad Social de Activos. Se debe colocar el Codigo que corresponda de la tabla de subtipos de trabajador de la DIAN", alias="SubTipoTrabajador")
    alto_riesgo_pension: StrictBool = Field(description="Si el trabajador desarrollo durante el presente periodo alguna de las actividades descritas en el Decreto 2090 de 2003, o la norma que lo modifique, adicione o sustituya.", alias="AltoRiesgoPension")
    tipo_documento: Annotated[str, Field(strict=True, max_length=2)] = Field(description="Tipo de documento de identificación que actualmente tiene el trabajador, aprendiz, o pasante. Se debe colocar el Codigo que corresponda de la tabla de tipos de identificación de la DIAN", alias="TipoDocumento")
    numero_documento: Union[Annotated[float, Field(strict=True)], Annotated[int, Field(strict=True)]] = Field(description="Numero de identificación que actualmente el trabajador o aprendiz", alias="NumeroDocumento")
    primer_apellido: Annotated[str, Field(strict=True, max_length=60)] = Field(description="Primer Apellido del trabajador o aprendiz", alias="PrimerApellido")
    segundo_apellido: Optional[Annotated[str, Field(strict=True, max_length=60)]] = Field(default=None, description="Segundo Apellido del trabajador o aprendiz", alias="SegundoApellido")
    primer_nombre: Annotated[str, Field(strict=True, max_length=60)] = Field(description="Primer Nombre del trabajador o aprendiz", alias="PrimerNombre")
    otros_nombres: Optional[Annotated[str, Field(strict=True, max_length=60)]] = Field(default=None, description="Otros Nombres del trabajador o aprendiz", alias="OtrosNombres")
    lugar_trabajo_pais: Optional[Annotated[str, Field(strict=True, max_length=2)]] = Field(default=None, description="Código del país actual donde se encontraba ubicado el trabajador o aprendiz en el mes reportado. Se debe colocar el Codigo del país", alias="LugarTrabajoPais")
    lugar_trabajo_municipio_ciudad: Annotated[str, Field(strict=True, max_length=5)] = Field(description="Código del municipio o ciudad actual donde se encontraba ubicado el trabajador o aprendiz en el mes reportado. Se debe colocar el Codigo que corresponda de la tabla de municipios de la DIAN", alias="LugarTrabajoMunicipioCiudad")
    lugar_trabajo_direccion: StrictStr = Field(description="Debe corresponder a la dirección del lugar físico donde vive el empleado.", alias="LugarTrabajoDireccion")
    salario_integral: StrictBool = Field(description="Si el trabajador tiene un salario integral, el cual es el tipo de remuneración que incluye todos los conceptos que puedan constituir salario en un solo monto o pago (prestaciones sociales y recargos nocturno, dominical y festivo, y el trabajo extra) y que sea superior a 10 SMLMV mas un 30% correspondiente a factor prestacional.", alias="SalarioIntegral")
    tipo_contrato: StrictStr = Field(description="Tipo de Contrato que posee el empleado con el Empleador. Se debe colocar el Codigo que corresponda de la tabla de tipos de contratos de la DIAN", alias="TipoContrato")
    sueldo: Union[StrictFloat, StrictInt] = Field(description="Corresponde al valor que el empleador paga de forma periódica al trabajador como contraprestación por el trabajo realizado, este puede ser fijo o variable de acuerdo a la unidad de tiempo en que las partes hayan acordado el pago, teniendo como base el día o la hora trabajada.", alias="Sueldo")
    codigo_trabajador: Optional[StrictStr] = Field(default=None, description="Codigo del Trabajador", alias="CodigoTrabajador")
    __properties: ClassVar[List[str]] = ["TipoTrabajador", "SubTipoTrabajador", "AltoRiesgoPension", "TipoDocumento", "NumeroDocumento", "PrimerApellido", "SegundoApellido", "PrimerNombre", "OtrosNombres", "LugarTrabajoPais", "LugarTrabajoMunicipioCiudad", "LugarTrabajoDireccion", "SalarioIntegral", "TipoContrato", "Sueldo", "CodigoTrabajador"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreatePayrollRequestGovernmentDataTrabajador from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreatePayrollRequestGovernmentDataTrabajador from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "TipoTrabajador": obj.get("TipoTrabajador"),
            "SubTipoTrabajador": obj.get("SubTipoTrabajador"),
            "AltoRiesgoPension": obj.get("AltoRiesgoPension"),
            "TipoDocumento": obj.get("TipoDocumento"),
            "NumeroDocumento": obj.get("NumeroDocumento"),
            "PrimerApellido": obj.get("PrimerApellido"),
            "SegundoApellido": obj.get("SegundoApellido"),
            "PrimerNombre": obj.get("PrimerNombre"),
            "OtrosNombres": obj.get("OtrosNombres"),
            "LugarTrabajoPais": obj.get("LugarTrabajoPais"),
            "LugarTrabajoMunicipioCiudad": obj.get("LugarTrabajoMunicipioCiudad"),
            "LugarTrabajoDireccion": obj.get("LugarTrabajoDireccion"),
            "SalarioIntegral": obj.get("SalarioIntegral"),
            "TipoContrato": obj.get("TipoContrato"),
            "Sueldo": obj.get("Sueldo"),
            "CodigoTrabajador": obj.get("CodigoTrabajador")
        })
        return _obj


