# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.get_companies200_response_companies_inner_address import GetCompanies200ResponseCompaniesInnerAddress
from openapi_client.models.get_companies200_response_companies_inner_certificate import GetCompanies200ResponseCompaniesInnerCertificate
from openapi_client.models.get_companies200_response_companies_inner_government_status import GetCompanies200ResponseCompaniesInnerGovernmentStatus
from openapi_client.models.get_companies200_response_companies_inner_notification_by_email import GetCompanies200ResponseCompaniesInnerNotificationByEmail
from openapi_client.models.get_companies200_response_companies_inner_tax_code import GetCompanies200ResponseCompaniesInnerTaxCode
from openapi_client.models.get_companies200_response_companies_inner_webhooks import GetCompanies200ResponseCompaniesInnerWebhooks
from typing import Optional, Set
from typing_extensions import Self

class GetCompanies200ResponseCompaniesInner(BaseModel):
    """
    GetCompanies200ResponseCompaniesInner
    """ # noqa: E501
    name: StrictStr = Field(description="Nombre/Razón Social de la empresa")
    trade_name: Optional[StrictStr] = Field(default=None, description="Nombre Comercial de la empresa", alias="tradeName")
    identification: StrictStr = Field(description="Identificación de la empresa")
    dv: Annotated[str, Field(strict=True)] = Field(description="Dígito verificador de la identificación de la empresa")
    use_alegra_certificate: StrictBool = Field(description="True si deseas usar el certificado de Alegra", alias="useAlegraCertificate")
    government_status: Optional[GetCompanies200ResponseCompaniesInnerGovernmentStatus] = Field(default=None, alias="governmentStatus")
    certificate: Optional[GetCompanies200ResponseCompaniesInnerCertificate] = None
    notification_by_email: Optional[GetCompanies200ResponseCompaniesInnerNotificationByEmail] = Field(default=None, alias="notificationByEmail")
    webhooks: Optional[GetCompanies200ResponseCompaniesInnerWebhooks] = None
    organization_type: Optional[Union[Annotated[float, Field(strict=True)], Annotated[int, Field(strict=True)]]] = Field(default=None, description="Identificador de tipo de organización jurídica de la persona o empresa. Se debe colocar el Código que corresponda de la tabla de tipos de organización jurídica de la DIAN. <br><i>Campo oficial DIAN &lt;AdditionalAccountID&gt;</i>", alias="organizationType")
    identification_type: Optional[Annotated[str, Field(strict=True, max_length=2)]] = Field(default=None, description="Tipo de documento de identificación de la empresa. Se debe colocar el Código que corresponda de la tabla de tipos de identificación de la DIAN", alias="identificationType")
    regime_code: Optional[StrictStr] = Field(default=None, description="Régimen al que pertenece la empresa. Se debe colocar el Código que corresponda de la tabla de tipos de régimen/responsabilidades fiscales de la DIAN. Para reportar varias obligaciones / responsabilidades, se deben reportar separando cada uno de los valores de la lista con ';'. Ejemplo O‐13;O‐15;", alias="regimeCode")
    tax_code: Optional[GetCompanies200ResponseCompaniesInnerTaxCode] = Field(default=None, alias="taxCode")
    email: Optional[StrictStr] = Field(default=None, description="Correo electrónico de la empresa. Se debe colocar el correo de recepción para documentos e instrumentos electrónicos")
    phone: Optional[StrictStr] = Field(default=None, description="Número de teléfono, celular u otro")
    address: Optional[GetCompanies200ResponseCompaniesInnerAddress] = None
    __properties: ClassVar[List[str]] = ["name", "tradeName", "identification", "dv", "useAlegraCertificate", "governmentStatus", "certificate", "notificationByEmail", "webhooks", "organizationType", "identificationType", "regimeCode", "taxCode", "email", "phone", "address"]

    @field_validator('dv')
    def dv_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([0-9]{1})$", value):
            raise ValueError(r"must validate the regular expression /^([0-9]{1})$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetCompanies200ResponseCompaniesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of government_status
        if self.government_status:
            _dict['governmentStatus'] = self.government_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of certificate
        if self.certificate:
            _dict['certificate'] = self.certificate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of notification_by_email
        if self.notification_by_email:
            _dict['notificationByEmail'] = self.notification_by_email.to_dict()
        # override the default output from pydantic by calling `to_dict()` of webhooks
        if self.webhooks:
            _dict['webhooks'] = self.webhooks.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tax_code
        if self.tax_code:
            _dict['taxCode'] = self.tax_code.to_dict()
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetCompanies200ResponseCompaniesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "tradeName": obj.get("tradeName"),
            "identification": obj.get("identification"),
            "dv": obj.get("dv"),
            "useAlegraCertificate": obj.get("useAlegraCertificate"),
            "governmentStatus": GetCompanies200ResponseCompaniesInnerGovernmentStatus.from_dict(obj["governmentStatus"]) if obj.get("governmentStatus") is not None else None,
            "certificate": GetCompanies200ResponseCompaniesInnerCertificate.from_dict(obj["certificate"]) if obj.get("certificate") is not None else None,
            "notificationByEmail": GetCompanies200ResponseCompaniesInnerNotificationByEmail.from_dict(obj["notificationByEmail"]) if obj.get("notificationByEmail") is not None else None,
            "webhooks": GetCompanies200ResponseCompaniesInnerWebhooks.from_dict(obj["webhooks"]) if obj.get("webhooks") is not None else None,
            "organizationType": obj.get("organizationType"),
            "identificationType": obj.get("identificationType"),
            "regimeCode": obj.get("regimeCode"),
            "taxCode": GetCompanies200ResponseCompaniesInnerTaxCode.from_dict(obj["taxCode"]) if obj.get("taxCode") is not None else None,
            "email": obj.get("email"),
            "phone": obj.get("phone"),
            "address": GetCompanies200ResponseCompaniesInnerAddress.from_dict(obj["address"]) if obj.get("address") is not None else None
        })
        return _obj


