# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_equivalent_document_pos_request_customer_tax_code import CreateEquivalentDocumentPosRequestCustomerTaxCode
from openapi_client.models.get_companies200_response_companies_inner_address import GetCompanies200ResponseCompaniesInnerAddress
from typing import Optional, Set
from typing_extensions import Self

class CreateAdjustmentNoteEquivalentDocumentRequestCustomer(BaseModel):
    """
    Objeto que contiene la información del adquiriente del documento electrónico. Si el cliente no requiere el documento a su nombre no se deberá enviar el grupo y se emitirá al Consumidor Final. Si se requiere que el documento POS electrónico salga a su nombre se deberán enviar los datos marcados como obligatorios. <br><i>Grupo de información oficial DIAN &lt;AccountingCustomerParty&gt;</i>
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Nombre del adquiriente. <br><i>Campo oficial DIAN &lt;Name&gt;</i>")
    organization_type: Union[Annotated[float, Field(strict=True)], Annotated[int, Field(strict=True)]] = Field(description="Identificador de tipo de organización jurídica de la persona o adquiriente. Se debe colocar el Código que corresponda de la tabla de tipos de organización jurídica de la DIAN. <br><i>Campo oficial DIAN &lt;AdditionalAccountID&gt;</i>", alias="organizationType")
    identification_type: Annotated[str, Field(strict=True, max_length=2)] = Field(description="Tipo de documento de identificación del adquiriente. Se debe colocar el Código que corresponda de la tabla de tipos de identificación de la DIAN. <br><i>Campo oficial DIAN &lt;@schemeName&gt;</i>", alias="identificationType")
    identification_number: StrictStr = Field(description="Número de identificación del adquiriente. <br><i>Campo oficial DIAN &lt;ID&gt;</i>", alias="identificationNumber")
    dv: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="DV del NIT del adquiriente. Es obligatorio si identificationType = 31. <br><i>Campo oficial DIAN &lt;@schemeID&gt;</i>")
    regime_code: Optional[StrictStr] = Field(default=None, description="Régimen o tipo de obligación o responsabilidad del adquiriente. Se debe colocar el Código que corresponda de la tabla de tipos de régimen/responsabilidades fiscales de la DIAN. Para reportar varias obligaciones / responsabilidades, se deben reportar separando cada uno de los valores de la lista con ';'. Ejemplo O‐13;O‐15; <br><i>Campo oficial DIAN &lt;TaxLevelCode&gt;</i>", alias="regimeCode")
    tax_code: Optional[CreateEquivalentDocumentPosRequestCustomerTaxCode] = Field(default=None, alias="taxCode")
    trade_name: Optional[StrictStr] = Field(default=None, description="Nombre Comercial del adquiriente. <br><i>Campo oficial DIAN &lt;PartyName/Name&gt;</i>", alias="tradeName")
    address: Optional[GetCompanies200ResponseCompaniesInnerAddress] = None
    __properties: ClassVar[List[str]] = ["name", "organizationType", "identificationType", "identificationNumber", "dv", "regimeCode", "taxCode", "tradeName", "address"]

    @field_validator('dv')
    def dv_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^([0-9]{1})$", value):
            raise ValueError(r"must validate the regular expression /^([0-9]{1})$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateAdjustmentNoteEquivalentDocumentRequestCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tax_code
        if self.tax_code:
            _dict['taxCode'] = self.tax_code.to_dict()
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateAdjustmentNoteEquivalentDocumentRequestCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "organizationType": obj.get("organizationType"),
            "identificationType": obj.get("identificationType"),
            "identificationNumber": obj.get("identificationNumber"),
            "dv": obj.get("dv"),
            "regimeCode": obj.get("regimeCode"),
            "taxCode": CreateEquivalentDocumentPosRequestCustomerTaxCode.from_dict(obj["taxCode"]) if obj.get("taxCode") is not None else None,
            "tradeName": obj.get("tradeName"),
            "address": GetCompanies200ResponseCompaniesInnerAddress.from_dict(obj["address"]) if obj.get("address") is not None else None
        })
        return _obj


