# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_equivalent_document_pos_request_company_contact import CreateEquivalentDocumentPosRequestCompanyContact
from openapi_client.models.create_invoice_request_company_shareholders_inner import CreateInvoiceRequestCompanyShareholdersInner
from openapi_client.models.create_invoice_request_company_tax_code import CreateInvoiceRequestCompanyTaxCode
from typing import Optional, Set
from typing_extensions import Self

class CreateInvoiceRequestCompany(BaseModel):
    """
    Objeto que contiene la información del obligado a facturar o emisor del documento electrónico. <br><i>Grupo de información oficial DIAN &lt;AccountingSupplierParty&gt;</i>
    """ # noqa: E501
    id: StrictStr = Field(description="Id de la empresa. Id único generado por la API")
    organization_type: Optional[Union[Annotated[float, Field(strict=True)], Annotated[int, Field(strict=True)]]] = Field(default=None, description="Identificador de tipo de organización jurídica de la de persona, puede ser una de las siguientes opciones: `1` Persona Jurídica y asimiladas; `2` Persona Natural y asimiladas. <br><i>Campo oficial DIAN &lt;AdditionalAccountID&gt;</i>", alias="organizationType")
    identification_number: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=30)]] = Field(default=None, description="Número de identificación o NIT del emisor, sin guiones ni DV. <br><i>Campo oficial DIAN &lt;CompanyID&gt;</i>", alias="identificationNumber")
    dv: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="DV del NIT del emisor. Es obligatorio si identificationType = 31. <br><i>Campo oficial DIAN &lt;@schemeID&gt;</i>")
    name: Optional[Annotated[str, Field(min_length=5, strict=True, max_length=450)]] = Field(default=None, description="Nombre (Razón Social) del Emisor. Si no se envía, se tomará el Nombre/Razón Social de la compañía. <br><i>Campo oficial DIAN &lt;RegistrationName&gt;</i>")
    trade_name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=450)]] = Field(default=None, description="Nombre Comercial del Emisor. <br><i>Campo oficial DIAN &lt;Name&gt;</i>", alias="tradeName")
    regime_code: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Obligaciones o responsabilidades tributarias del emisor. El elemento acepta las siguientes opciones: `O-13` Gran contribuyente; `O-15` Autorretenedor; `O-23` Agente de retención IVA; `O-47` Régimen simple de tributación; `R-99-PN` No aplica – Otros. Para reportar varias obligaciones / responsabilidades se deben separar los valores con ';'. Ejemplo O‐13;O‐15; <br><i>Campo oficial DIAN &lt;TaxLevelCode&gt;</i>", alias="regimeCode")
    tax_code: Optional[CreateInvoiceRequestCompanyTaxCode] = Field(default=None, alias="taxCode")
    economic_activities: Optional[Annotated[List[Annotated[str, Field(strict=True)]], Field(min_length=1)]] = Field(default=None, description="Lista de actividades económicas de la empresa. Debe informar el código según lista CIIU", alias="economicActivities")
    email: Optional[StrictStr] = Field(default=None, description="Correo electrónico. Se debe colocar el correo de recepción para documentos e instrumentos electrónicos. <br><i>Campo oficial DIAN &lt;ElectronicMail&gt;</i>")
    phone: Optional[StrictStr] = Field(default=None, description="Número de teléfono, celular u otro. <br><i>Campo oficial DIAN &lt;Telephone&gt;</i>")
    address: Optional[object] = Field(default=None, description="Objeto que contiene la información con respeto a la dirección del lugar físico donde se expidió el documento. Si no se envía el objeto 'taxAddress', la información de este objeto se usará también para 'taxAddress' por defecto. <br><i>Grupo de información oficial DIAN &lt;PhysicalLocation&gt;</i>")
    tax_address: Optional[object] = Field(default=None, description="Objeto que contiene la información con respeto a la dirección fiscal del emisor. Si no se envía este objeto se replicará la información que se envía en 'address'. <br><i>Grupo de información oficial DIAN &lt;RegistrationAddress&gt;</i>", alias="taxAddress")
    shareholders: Optional[List[CreateInvoiceRequestCompanyShareholdersInner]] = Field(default=None, description="Grupo de elementos que permiten registrar la información de los participantes de un **Consorcio o Unión temporal**. Se debe completar un grupo de elementos por cada participante del consorcio. <br><i>Grupo de información oficial DIAN &lt;ShareholderParty&gt;</i>")
    contact: Optional[CreateEquivalentDocumentPosRequestCompanyContact] = None
    __properties: ClassVar[List[str]] = ["id", "organizationType", "identificationNumber", "dv", "name", "tradeName", "regimeCode", "taxCode", "economicActivities", "email", "phone", "address", "taxAddress", "shareholders", "contact"]

    @field_validator('organization_type')
    def organization_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([1, 2]):
            raise ValueError("must be one of enum values (1, 2)")
        return value

    @field_validator('dv')
    def dv_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^([0-9]{1})$", value):
            raise ValueError(r"must validate the regular expression /^([0-9]{1})$/")
        return value

    @field_validator('regime_code')
    def regime_code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(O-(13|15|23|47|48|49)|R-99-PN)(;(O-(13|15|23|47|48|49)|R-99-PN))*$", value):
            raise ValueError(r"must validate the regular expression /^(O-(13|15|23|47|48|49)|R-99-PN)(;(O-(13|15|23|47|48|49)|R-99-PN))*$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateInvoiceRequestCompany from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tax_code
        if self.tax_code:
            _dict['taxCode'] = self.tax_code.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in shareholders (list)
        _items = []
        if self.shareholders:
            for _item_shareholders in self.shareholders:
                if _item_shareholders:
                    _items.append(_item_shareholders.to_dict())
            _dict['shareholders'] = _items
        # override the default output from pydantic by calling `to_dict()` of contact
        if self.contact:
            _dict['contact'] = self.contact.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateInvoiceRequestCompany from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "organizationType": obj.get("organizationType"),
            "identificationNumber": obj.get("identificationNumber"),
            "dv": obj.get("dv"),
            "name": obj.get("name"),
            "tradeName": obj.get("tradeName"),
            "regimeCode": obj.get("regimeCode"),
            "taxCode": CreateInvoiceRequestCompanyTaxCode.from_dict(obj["taxCode"]) if obj.get("taxCode") is not None else None,
            "economicActivities": obj.get("economicActivities"),
            "email": obj.get("email"),
            "phone": obj.get("phone"),
            "address": obj.get("address"),
            "taxAddress": obj.get("taxAddress"),
            "shareholders": [CreateInvoiceRequestCompanyShareholdersInner.from_dict(_item) for _item in obj["shareholders"]] if obj.get("shareholders") is not None else None,
            "contact": CreateEquivalentDocumentPosRequestCompanyContact.from_dict(obj["contact"]) if obj.get("contact") is not None else None
        })
        return _obj


