# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_equivalent_document_pos200_response_equivalent_document_errors_inner import CreateEquivalentDocumentPos200ResponseEquivalentDocumentErrorsInner
from openapi_client.models.get_test_set_by_government_id200_response_emission_government_response import GetTestSetByGovernmentId200ResponseEmissionGovernmentResponse
from typing import Optional, Set
from typing_extensions import Self

class CreateAdjustmentNoteSupportDocument200ResponseInvoice(BaseModel):
    """
    CreateAdjustmentNoteSupportDocument200ResponseInvoice
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Id de la nota de ajuste al documento soporte electrónico")
    invoice_document_reference: Optional[StrictStr] = Field(default=None, description="Identificador unico del documento de soporte afectado por la nota de ajuste", alias="invoiceDocumentReference")
    var_date: Optional[datetime] = Field(default=None, description="Fecha de emisión de una una nota de ajuste al documento soporte electrónico", alias="date")
    status: Optional[StrictStr] = Field(default=None, description="Estado de una una nota de ajuste al documento soporte electrónico")
    legal_status: Optional[StrictStr] = Field(default=None, description="Estado legal del documento soporte electrónico ante la DIAN", alias="legalStatus")
    company_identification: Optional[StrictStr] = Field(default=None, description="Identificación de la empresa empleadora", alias="companyIdentification")
    supplier_identification: Optional[StrictStr] = Field(default=None, description="Identificación del proveedor", alias="supplierIdentification")
    cuds: Optional[StrictStr] = Field(default=None, description="Código único de la una nota de ajuste al documento soporte electrónico asignado para el documento")
    prefix: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="Prefijo de la una nota de ajuste al documento soporte electrónico")
    number: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Número de la una nota de ajuste al documento soporte electrónico")
    full_number: Optional[StrictStr] = Field(default=None, description="Número de la una nota de ajuste al documento soporte electrónico (Incluye prefijo y número)", alias="fullNumber")
    government_response: Optional[GetTestSetByGovernmentId200ResponseEmissionGovernmentResponse] = Field(default=None, alias="governmentResponse")
    xml_file_name: Optional[StrictStr] = Field(default=None, description="Nombre del archivo XML que se envió a la DIAN", alias="xmlFileName")
    zip_file_name: Optional[StrictStr] = Field(default=None, description="Nombre del archivo Zip que se envió a la DIAN", alias="zipFileName")
    xml: Optional[StrictStr] = Field(default=None, description="Link de descarga a el XML que se envia a la DIAN. Este enlace solo dura por 60 minutos, para renovar el link solicite nuevamente el documento.")
    application_response: Optional[StrictStr] = Field(default=None, description="Link de descarga a el ApplicationResponse obetenido como respuesta de al DIAN al enviar el archivo XML. Este campo solo se añade al tener una respuesta de la DIAN. Este enlace solo dura por 60 minutos, para renovar el link solicite nuevamente el documento.", alias="applicationResponse")
    errors: Optional[List[CreateEquivalentDocumentPos200ResponseEquivalentDocumentErrorsInner]] = Field(default=None, description="Array con mensajes de error generados en el sistema")
    __properties: ClassVar[List[str]] = ["id", "invoiceDocumentReference", "date", "status", "legalStatus", "companyIdentification", "supplierIdentification", "cuds", "prefix", "number", "fullNumber", "governmentResponse", "xmlFileName", "zipFileName", "xml", "applicationResponse", "errors"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['REGISTERED', 'RETRYING_SEND', 'WAITING_RESPONSE', 'FAILED', 'SENT', 'CANCELED', 'REPLACED']):
            raise ValueError("must be one of enum values ('REGISTERED', 'RETRYING_SEND', 'WAITING_RESPONSE', 'FAILED', 'SENT', 'CANCELED', 'REPLACED')")
        return value

    @field_validator('legal_status')
    def legal_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ACCEPTED', 'ACCEPTED_WITH_OBSERVATIONS', 'REJECTED']):
            raise ValueError("must be one of enum values ('ACCEPTED', 'ACCEPTED_WITH_OBSERVATIONS', 'REJECTED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateAdjustmentNoteSupportDocument200ResponseInvoice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of government_response
        if self.government_response:
            _dict['governmentResponse'] = self.government_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item_errors in self.errors:
                if _item_errors:
                    _items.append(_item_errors.to_dict())
            _dict['errors'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateAdjustmentNoteSupportDocument200ResponseInvoice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "invoiceDocumentReference": obj.get("invoiceDocumentReference"),
            "date": obj.get("date"),
            "status": obj.get("status"),
            "legalStatus": obj.get("legalStatus"),
            "companyIdentification": obj.get("companyIdentification"),
            "supplierIdentification": obj.get("supplierIdentification"),
            "cuds": obj.get("cuds"),
            "prefix": obj.get("prefix"),
            "number": obj.get("number"),
            "fullNumber": obj.get("fullNumber"),
            "governmentResponse": GetTestSetByGovernmentId200ResponseEmissionGovernmentResponse.from_dict(obj["governmentResponse"]) if obj.get("governmentResponse") is not None else None,
            "xmlFileName": obj.get("xmlFileName"),
            "zipFileName": obj.get("zipFileName"),
            "xml": obj.get("xml"),
            "applicationResponse": obj.get("applicationResponse"),
            "errors": [CreateEquivalentDocumentPos200ResponseEquivalentDocumentErrorsInner.from_dict(_item) for _item in obj["errors"]] if obj.get("errors") is not None else None
        })
        return _obj


