# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_credit_note_request_associated_documents_inner import CreateCreditNoteRequestAssociatedDocumentsInner
from openapi_client.models.create_credit_note_request_items_inner import CreateCreditNoteRequestItemsInner
from openapi_client.models.create_equivalent_document_pos_request_payments_inner import CreateEquivalentDocumentPosRequestPaymentsInner
from openapi_client.models.create_equivalent_document_pos_request_total_amounts import CreateEquivalentDocumentPosRequestTotalAmounts
from openapi_client.models.create_invoice_request_advance_payments_inner import CreateInvoiceRequestAdvancePaymentsInner
from openapi_client.models.create_invoice_request_company import CreateInvoiceRequestCompany
from openapi_client.models.create_invoice_request_customer import CreateInvoiceRequestCustomer
from openapi_client.models.create_invoice_request_discounts_and_charges_inner import CreateInvoiceRequestDiscountsAndChargesInner
from openapi_client.models.create_invoice_request_invoice_period import CreateInvoiceRequestInvoicePeriod
from typing import Optional, Set
from typing_extensions import Self

class CreateDebitNoteRequest(BaseModel):
    """
    CreateDebitNoteRequest
    """ # noqa: E501
    prefix: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="Prefijo de la nota débito electrónica")
    number: Union[StrictFloat, StrictInt] = Field(description="Número de la nota débito electrónica")
    concept_code: StrictStr = Field(description="Concepto por el cual se genera la nota débito. Se debe colocar el Código que corresponda de la tabla de tipos de concepto de corrección para Notas débito disponibles de la DIAN", alias="conceptCode")
    note: Optional[Annotated[str, Field(strict=True, max_length=500)]] = Field(default=None, description="Nota o información adicional: Texto libre, relativo al documento. <br><i>Campo oficial DIAN &lt;Note&gt;</i>")
    associated_documents: Annotated[List[CreateCreditNoteRequestAssociatedDocumentsInner], Field(min_length=1)] = Field(description="Array que contiene la información de las facturas electrónicas afectadas por la Nota. Todas las facturas afectadas deben ser de un mismo adquiriente", alias="associatedDocuments")
    company: CreateInvoiceRequestCompany
    customer: CreateInvoiceRequestCustomer
    items: List[CreateCreditNoteRequestItemsInner] = Field(description="Array que contiene el listado de artículos y/o servicios")
    discounts_and_charges: Optional[List[CreateInvoiceRequestDiscountsAndChargesInner]] = Field(default=None, description="Array con el listado de Descuentos o Cargos a nivel de factura. Grupo de campos para información relacionada con los descuentos o cargos que no afectan las bases gravables. Los descuentos o cargos que afectan bases gravables se deben informar a nivel de ítem. <br><i>Grupo de información oficial DIAN &lt;AllowanceCharge&gt;</i>", alias="discountsAndCharges")
    total_amounts: CreateEquivalentDocumentPosRequestTotalAmounts = Field(alias="totalAmounts")
    payments: List[CreateEquivalentDocumentPosRequestPaymentsInner] = Field(description="Array con el listado de pagos. Grupo de campos para información relacionadas con el pago de la factura. <br><i>Grupo de información oficial DIAN &lt;PaymentMeans&gt;</i>")
    advance_payments: Optional[List[CreateInvoiceRequestAdvancePaymentsInner]] = Field(default=None, description="Array con el listado de anticipos. Grupo de campos para información relacionadas con un anticipo. <br><i>Grupo de información oficial DIAN &lt;PrePaidPayment&gt;</i>", alias="advancePayments")
    invoice_period: Optional[CreateInvoiceRequestInvoicePeriod] = Field(default=None, alias="invoicePeriod")
    __properties: ClassVar[List[str]] = ["prefix", "number", "conceptCode", "note", "associatedDocuments", "company", "customer", "items", "discountsAndCharges", "totalAmounts", "payments", "advancePayments", "invoicePeriod"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateDebitNoteRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in associated_documents (list)
        _items = []
        if self.associated_documents:
            for _item_associated_documents in self.associated_documents:
                if _item_associated_documents:
                    _items.append(_item_associated_documents.to_dict())
            _dict['associatedDocuments'] = _items
        # override the default output from pydantic by calling `to_dict()` of company
        if self.company:
            _dict['company'] = self.company.to_dict()
        # override the default output from pydantic by calling `to_dict()` of customer
        if self.customer:
            _dict['customer'] = self.customer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in discounts_and_charges (list)
        _items = []
        if self.discounts_and_charges:
            for _item_discounts_and_charges in self.discounts_and_charges:
                if _item_discounts_and_charges:
                    _items.append(_item_discounts_and_charges.to_dict())
            _dict['discountsAndCharges'] = _items
        # override the default output from pydantic by calling `to_dict()` of total_amounts
        if self.total_amounts:
            _dict['totalAmounts'] = self.total_amounts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in payments (list)
        _items = []
        if self.payments:
            for _item_payments in self.payments:
                if _item_payments:
                    _items.append(_item_payments.to_dict())
            _dict['payments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in advance_payments (list)
        _items = []
        if self.advance_payments:
            for _item_advance_payments in self.advance_payments:
                if _item_advance_payments:
                    _items.append(_item_advance_payments.to_dict())
            _dict['advancePayments'] = _items
        # override the default output from pydantic by calling `to_dict()` of invoice_period
        if self.invoice_period:
            _dict['invoicePeriod'] = self.invoice_period.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateDebitNoteRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "prefix": obj.get("prefix"),
            "number": obj.get("number"),
            "conceptCode": obj.get("conceptCode"),
            "note": obj.get("note"),
            "associatedDocuments": [CreateCreditNoteRequestAssociatedDocumentsInner.from_dict(_item) for _item in obj["associatedDocuments"]] if obj.get("associatedDocuments") is not None else None,
            "company": CreateInvoiceRequestCompany.from_dict(obj["company"]) if obj.get("company") is not None else None,
            "customer": CreateInvoiceRequestCustomer.from_dict(obj["customer"]) if obj.get("customer") is not None else None,
            "items": [CreateCreditNoteRequestItemsInner.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "discountsAndCharges": [CreateInvoiceRequestDiscountsAndChargesInner.from_dict(_item) for _item in obj["discountsAndCharges"]] if obj.get("discountsAndCharges") is not None else None,
            "totalAmounts": CreateEquivalentDocumentPosRequestTotalAmounts.from_dict(obj["totalAmounts"]) if obj.get("totalAmounts") is not None else None,
            "payments": [CreateEquivalentDocumentPosRequestPaymentsInner.from_dict(_item) for _item in obj["payments"]] if obj.get("payments") is not None else None,
            "advancePayments": [CreateInvoiceRequestAdvancePaymentsInner.from_dict(_item) for _item in obj["advancePayments"]] if obj.get("advancePayments") is not None else None,
            "invoicePeriod": CreateInvoiceRequestInvoicePeriod.from_dict(obj["invoicePeriod"]) if obj.get("invoicePeriod") is not None else None
        })
        return _obj


