# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_invoice_request_customer_address import CreateInvoiceRequestCustomerAddress
from openapi_client.models.create_invoice_request_customer_contact import CreateInvoiceRequestCustomerContact
from openapi_client.models.create_invoice_request_customer_tax_code import CreateInvoiceRequestCustomerTaxCode
from typing import Optional, Set
from typing_extensions import Self

class CreateInvoiceRequestCustomer(BaseModel):
    """
    Objeto que contiene la información del adquiriente del documento electrónico. <br><i>Grupo de información oficial DIAN &lt;AccountingCustomerParty&gt;</i>
    """ # noqa: E501
    name: StrictStr = Field(description="Nombre del adquiriente. <br><i>Campo oficial DIAN &lt;Name&gt;</i>")
    trade_name: Optional[StrictStr] = Field(default=None, description="NoOpcional si desea agregar el nombre comercial del cliente en la representación gráfica del documento. El nombre del adquiriente persona física y la razón social del adquiriente persona jurídica deben ser informados en el elemento **name**. <br><i>Campo oficial DIAN &lt;Name del grupo PartyName&gt;</i>", alias="tradeName")
    organization_type: Optional[Union[Annotated[float, Field(strict=True)], Annotated[int, Field(strict=True)]]] = Field(default=None, description="Identificador de tipo de organización jurídica del adquiriente, puede ser una de las siguientes opciones: `1` Persona Jurídica y asimiladas; `2` Persona Natural y asimiladas. Default: `2`. <br><i>Campo oficial DIAN &lt;AdditionalAccountID&gt;</i>", alias="organizationType")
    identification_type: Annotated[str, Field(strict=True, max_length=2)] = Field(description="Tipo de documento de identificación del adquiriente. Se debe colocar el Código que corresponda de la tabla de tipos de identificación de la DIAN. <br><i>Campo oficial DIAN &lt;@schemeName&gt;</i>", alias="identificationType")
    identification_number: StrictStr = Field(description="Número de identificación del adquiriente. <br><i>Campo oficial DIAN &lt;ID&gt;</i>", alias="identificationNumber")
    dv: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="DV del NIT del adquiriente. Es obligatorio si identificationType = 31. <br><i>Campo oficial DIAN &lt;@schemeID&gt;</i>")
    regime_code: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Obligaciones o responsabilidades tributarias del adquiriente. El elemento acepta las siguientes opciones: `O-13` Gran contribuyente; `O-15` Autorretenedor; `O-23` Agente de retención IVA; `O-47` Régimen simple de tributación; `R-99-PN` No aplica – Otros. Para reportar varias obligaciones / responsabilidades se deben separar los valores con ';'. Ejemplo O‐13;O‐15; <br><i>Campo oficial DIAN &lt;TaxLevelCode&gt;</i>", alias="regimeCode")
    tax_code: Optional[CreateInvoiceRequestCustomerTaxCode] = Field(default=None, alias="taxCode")
    commercial_registration_number: Optional[Annotated[str, Field(min_length=9, strict=True, max_length=9)]] = Field(default=None, description="Número de matrícula mercantil del adquiriente. <br><i>Campo oficial DIAN &lt;CorporateRegistrationScheme/Name&gt;</i>", alias="commercialRegistrationNumber")
    email: Optional[StrictStr] = Field(default=None, description="Correo electrónico. El correo de notificación será enviado a esta dirección en caso de tener habilitado notificationByEmail en Compañía. <br><i>Campo oficial DIAN &lt;ElectronicMail&gt;</i>")
    phone: Optional[StrictStr] = Field(default=None, description="Número de teléfono, celular u otro. <br><i>Campo oficial DIAN &lt;Telephone&gt;</i>")
    address: Optional[CreateInvoiceRequestCustomerAddress] = None
    tax_address: Optional[object] = Field(default=None, description="Objeto que contiene la información con respeto a la dirección fiscal del adquiriente. Esta información es opcional y se utiliza cuando desea enviar la dirección fiscal registrada en el RUT del cliente. <br><i>Grupo de información oficial DIAN &lt;RegistrationAddress&gt;</i>", alias="taxAddress")
    contact: Optional[CreateInvoiceRequestCustomerContact] = None
    __properties: ClassVar[List[str]] = ["name", "tradeName", "organizationType", "identificationType", "identificationNumber", "dv", "regimeCode", "taxCode", "commercialRegistrationNumber", "email", "phone", "address", "taxAddress", "contact"]

    @field_validator('organization_type')
    def organization_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([1, 2]):
            raise ValueError("must be one of enum values (1, 2)")
        return value

    @field_validator('dv')
    def dv_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^([0-9]{1})$", value):
            raise ValueError(r"must validate the regular expression /^([0-9]{1})$/")
        return value

    @field_validator('regime_code')
    def regime_code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(O-(13|15|23|47)|R-99-PN)(;(O-(13|15|23|47)|R-99-PN))*$", value):
            raise ValueError(r"must validate the regular expression /^(O-(13|15|23|47)|R-99-PN)(;(O-(13|15|23|47)|R-99-PN))*$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateInvoiceRequestCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tax_code
        if self.tax_code:
            _dict['taxCode'] = self.tax_code.to_dict()
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of contact
        if self.contact:
            _dict['contact'] = self.contact.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateInvoiceRequestCustomer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "tradeName": obj.get("tradeName"),
            "organizationType": obj.get("organizationType"),
            "identificationType": obj.get("identificationType"),
            "identificationNumber": obj.get("identificationNumber"),
            "dv": obj.get("dv"),
            "regimeCode": obj.get("regimeCode"),
            "taxCode": CreateInvoiceRequestCustomerTaxCode.from_dict(obj["taxCode"]) if obj.get("taxCode") is not None else None,
            "commercialRegistrationNumber": obj.get("commercialRegistrationNumber"),
            "email": obj.get("email"),
            "phone": obj.get("phone"),
            "address": CreateInvoiceRequestCustomerAddress.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "taxAddress": obj.get("taxAddress"),
            "contact": CreateInvoiceRequestCustomerContact.from_dict(obj["contact"]) if obj.get("contact") is not None else None
        })
        return _obj


