# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CreateInvoiceRequestDiscountsAndChargesInner(BaseModel):
    """
    Información de un cargo o descuento
    """ # noqa: E501
    is_charge: StrictBool = Field(description="True si se desea informar un cargo o false si se desea informar un descuento. <br><i>Campo oficial DIAN &lt;ChargeIndicator&gt;</i>", alias="isCharge")
    reason: Annotated[str, Field(strict=True)] = Field(description="Razón (texto): Texto libre para informar la razón del cargo o descuento. <br><i>Campo oficial DIAN &lt;AllowanceChargeReason&gt;</i>")
    reason_code: Optional[StrictStr] = Field(default=None, description="Código para categorizar el descuento o el recargo a nivel de documento, este elemento acepta una de las siguientes opciones: `00` Descuento no condicionado; `01` Descuento condicionado; `02` Recargo no condicionado; `03` Recargo condicionado. Es obligatorio enviar el código cuando se desee aplicar un descuento. Para descuentos solo se pueden enviar `00` y `01` por default es `01`, para recargos solo se puede enviar `02` y `03`.<br><i>Campo oficial DIAN &lt;AllowanceChargeReasonCode&gt;</i>", alias="reasonCode")
    percentage_amount: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(description="Porcentaje a aplicar. <br><i>Campo oficial DIAN &lt;MultiplierFactorNumeric&gt;</i>", alias="percentageAmount")
    amount: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(description="Valor total del cargo o descuento. <br><i>Campo oficial DIAN &lt;Amount&gt;</i>")
    base_amount: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(description="Valor Base para calcular el descuento o el cargo. <br><i>Campo oficial DIAN &lt;BaseAmount&gt;</i>", alias="baseAmount")
    __properties: ClassVar[List[str]] = ["isCharge", "reason", "reasonCode", "percentageAmount", "amount", "baseAmount"]

    @field_validator('reason_code')
    def reason_code_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['00', '01', '02', '03']):
            raise ValueError("must be one of enum values ('00', '01', '02', '03')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateInvoiceRequestDiscountsAndChargesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateInvoiceRequestDiscountsAndChargesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "isCharge": obj.get("isCharge"),
            "reason": obj.get("reason"),
            "reasonCode": obj.get("reasonCode"),
            "percentageAmount": obj.get("percentageAmount"),
            "amount": obj.get("amount"),
            "baseAmount": obj.get("baseAmount")
        })
        return _obj


