# Example

Below is a showcase of various examples of unit testing real and sample Algorand Python smart contracts using `algorand-python-testing`.

| Contract Name       | Test File                                                                                                                             | Key Features Demonstrated                                                                                                                                                                                        | Test versions of Algopy Abstractions used                                                               |
| ------------------- | ------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| Auction             | [test_contract.py](https://github.com/algorandfoundation/puya/blob/main/algopy_testing/examples/auction/test_contract.py)             | - Use of algopy_testing_context<br>- Mocking of global state and transaction fields<br>- Testing of ARC4 contract methods<br>- Emulation of asset creation and transfers<br>- Verification of inner transactions | - **ARC4Contract**<br>- **Global**<br>- **Txn**<br>- **Asset**<br>- **Account**                         |
| Proof of Attendance | [test_contract.py](https://github.com/algorandfoundation/puya/blob/main/algopy_testing/examples/proof_of_attendance/test_contract.py) | - Creation and management of dummy assets<br>- Testing of box storage operations<br>- Verification of inner transactions for asset transfers<br>- Use of any\_\* methods for generating test data                | - **Contract**<br>- **Box**<br>- **Asset**<br>- **Account**<br>- **op** (for various operations)        |
| Simple Voting       | [test_contract.py](https://github.com/algorandfoundation/puya/blob/main/algopy_testing/examples/simple_voting/test_contract.py)       | - Testing of global and local state operations<br>- Verification of transaction group operations<br>- Mocking of payment transactions                                                                            | - **Contract**<br>- **GlobalState**<br>- **LocalState**<br>- **Txn**<br>- **GTxn** (group transactions) |
| ZK Whitelist        | [test_contract.py](https://github.com/algorandfoundation/puya/blob/main/algopy_testing/examples/zk_whitelist/test_contract.py)        | - Testing of zero-knowledge proof verification<br>- Mocking of external application calls<br>- Use of ARC4 types and methods                                                                                     | - **ARC4Contract**<br>- **arc4 types** (Address, DynamicArray, StaticArray, etc.)<br>- Application logs |
| HTLC LogicSig       | [test_signature.py](https://github.com/algorandfoundation/puya/blob/main/algopy_testing/examples/htlc_logicsig/test_signature.py)     | - Testing of LogicSig contracts<br>- Verification of time-based conditions<br>- Mocking of transaction parameters                                                                                                | - **LogicSig**<br>- **Txn**<br>- **Global**                                                             |
