# Glossary

| Term                                                                                                                                       | Definition                                                                                                                                                                                                                         |
| ------------------------------------------------------------------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [**Test Context**](testing-guide/concepts.md#test-context)                                                                                 | A context manager that provides a simulated Algorand environment for testing Python smart contracts.                                                                                                                               |
| [**Algorand Virtual Machine (AVM)**](https://developer.algorand.org/docs/get-details/dapps/avm/)                                           | The AVM is the runtime environment for Algorand smart contracts.                                                                                                                                                                   |
| [**Operational codes**](https://developer.algorand.org/docs/get-details/dapps/avm/teal/opcodes/?from_query=OPcodes#template-modal-overlay) | AVM instructions that are executed directly by the AVM, provided by `algopy` stubs and emulated/implemented or mocked by `algorand-python-testing`.                                                                                |
| [**Value generators**](testing-guide/concepts.md#value-generators)                                                                         | Helper methods that generate randomized values for testing when the value of the tested type is not needed. Represented by instance methods on the context manager, prefixed with `any_*` (or `arc.any_*` in case of ARC 4 types). |
