# Coverage

See which `algorand-python` stubs are implemented by the `algorand-python-testing` library. See the [Concepts](testing-guide/concepts.md#types-of-algopy-stub-implementations) section for more details on the implementation categories. Refer to the [`algorand-python` stubs API](api.md) for the full list of stubs for which the `algorand-python-testing` library provides implementations referenced in the table below.

| Name                                        | Implementation type |
|---------------------------------------------|---------------------|
| algopy.Account                              | Emulated            |
| algopy.Application                          | Emulated            |
| algopy.Asset                                | Emulated            |
| algopy.Array                                | Native              |
| algopy.BigUInt                              | Native              |
| algopy.Box                                  | Emulated            |
| algopy.BoxMap                               | Emulated            |
| algopy.BoxRef                               | Emulated            |
| algopy.Bytes                                | Native              |
| algopy.BytesBacked                          | Native              |
| algopy.CompiledContract                     | Mockable            |
| algopy.CompiledLogicSig                     | Mockable            |
| algopy.Contract                             | Emulated            |
| algopy.FixedArray                           | Native              |
| algopy.Global                               | Emulated            |
| algopy.GlobalState                          | Emulated            |
| algopy.ImmutableArray                       | Native              |
| algopy.ImmutableFixedArray                  | Native              |
| algopy.LocalState                           | Emulated            |
| algopy.LogicSig                             | Emulated            |
| algopy.OnCompleteAction                     | Native              |
| algopy.OpUpFeeSource                        | Native              |
| algopy.ReferenceArray                       | Native              |
| algopy.StateTotals                          | Emulated            |
| algopy.String                               | Native              |
| algopy.Struct                               | Native              |
| algopy.TemplateVar                          | Emulated            |
| algopy.TransactionType                      | Native              |
| algopy.Txn                                  | Emulated            |
| algopy.UInt64                               | Native              |
| algopy.compile_contract                     | Mockable            |
| algopy.compile_logicsig                     | Mockable            |
| algopy.ensure_budget                        | Emulated            |
| algopy.log                                  | Emulated            |
| algopy.logicsig                             | Emulated            |
| algopy.size_of                              | Emulated            |
| algopy.subroutine                           | Native              |
| algopy.uenumerate                           | Native              |
| algopy.urange                               | Native              |
| algopy.arc4.ARC4Client                      | Emulated            |
| algopy.arc4.ARC4Contract                    | Emulated            |
| algopy.arc4.Address                         | Native              |
| algopy.arc4.BigUFixedNxM                    | Native              |
| algopy.arc4.BigUIntN                        | Native              |
| algopy.arc4.Bool                            | Native              |
| algopy.arc4.Byte                            | Native              |
| algopy.arc4.DynamicArray                    | Native              |
| algopy.arc4.DynamicBytes                    | Native              |
| algopy.arc4.StaticArray                     | Native              |
| algopy.arc4.String                          | Native              |
| algopy.arc4.Struct                          | Native              |
| algopy.arc4.Tuple                           | Native              |
| algopy.arc4.UFixedNxM                       | Native              |
| algopy.arc4.UInt128                         | Native              |
| algopy.arc4.UInt16                          | Native              |
| algopy.arc4.UInt256                         | Native              |
| algopy.arc4.UInt32                          | Native              |
| algopy.arc4.UInt512                         | Native              |
| algopy.arc4.UInt64                          | Native              |
| algopy.arc4.UInt8                           | Native              |
| algopy.arc4.UIntN                           | Native              |
| algopy.arc4.abimethod                       | Emulated            |
| algopy.arc4.arc4_signature                  | Native              |
| algopy.arc4.baremethod                      | Emulated            |
| algopy.arc4.emit                            | Emulated            |
| algopy.arc4.abi_call                        | Mockable            |
| algopy.arc4.arc4_create                     | Mockable            |
| algopy.arc4.arc4_update                     | Mockable            |
| algopy.gtxn.ApplicationCallTransaction      | Emulated            |
| algopy.gtxn.AssetConfigTransaction          | Emulated            |
| algopy.gtxn.AssetFreezeTransaction          | Emulated            |
| algopy.gtxn.AssetTransferTransaction        | Emulated            |
| algopy.gtxn.KeyRegistrationTransaction      | Emulated            |
| algopy.gtxn.PaymentTransaction              | Emulated            |
| algopy.gtxn.Transaction                     | Emulated            |
| algopy.gtxn.TransactionBase                 | Emulated            |
| algopy.itxn.ApplicationCall                 | Emulated            |
| algopy.itxn.ApplicationCallInnerTransaction | Emulated            |
| algopy.itxn.AssetConfig                     | Emulated            |
| algopy.itxn.AssetConfigInnerTransaction     | Emulated            |
| algopy.itxn.AssetFreeze                     | Emulated            |
| algopy.itxn.AssetFreezeInnerTransaction     | Emulated            |
| algopy.itxn.AssetTransfer                   | Emulated            |
| algopy.itxn.AssetTransferInnerTransaction   | Emulated            |
| algopy.itxn.InnerTransaction                | Emulated            |
| algopy.itxn.InnerTransactionResult          | Emulated            |
| algopy.itxn.KeyRegistration                 | Emulated            |
| algopy.itxn.KeyRegistrationInnerTransaction | Emulated            |
| algopy.itxn.Payment                         | Emulated            |
| algopy.itxn.PaymentInnerTransaction         | Emulated            |
| algopy.itxn.submit_txns                     | Emulated            |
| algopy.op.Base64                            | Native              |
| algopy.op.EC                                | Native              |
| algopy.op.ECDSA                             | Native              |
| algopy.op.JsonRef                           | Native              |
| algopy.op.addw                              | Native              |
| algopy.op.arg                               | Emulated            |
| algopy.op.base64_decode                     | Native              |
| algopy.op.bitlen                            | Native              |
| algopy.op.bsqrt                             | Native              |
| algopy.op.btoi                              | Native              |
| algopy.op.bzero                             | Native              |
| algopy.op.concat                            | Native              |
| algopy.op.divmodw                           | Native              |
| algopy.op.divw                              | Native              |
| algopy.op.ecdsa_pk_decompress               | Native              |
| algopy.op.ecdsa_pk_recover                  | Native              |
| algopy.op.ecdsa_verify                      | Native              |
| algopy.op.ed25519verify                     | Native              |
| algopy.op.ed25519verify_bare                | Native              |
| algopy.op.err                               | Native              |
| algopy.op.exit                              | Native              |
| algopy.op.exp                               | Native              |
| algopy.op.expw                              | Native              |
| algopy.op.extract                           | Native              |
| algopy.op.extract_uint16                    | Native              |
| algopy.op.extract_uint32                    | Native              |
| algopy.op.extract_uint64                    | Native              |
| algopy.op.getbit                            | Native              |
| algopy.op.getbyte                           | Native              |
| algopy.op.itob                              | Native              |
| algopy.op.keccak256                         | Native              |
| algopy.op.mulw                              | Native              |
| algopy.op.replace                           | Native              |
| algopy.op.select_bytes                      | Native              |
| algopy.op.select_uint64                     | Native              |
| algopy.op.setbit_bytes                      | Native              |
| algopy.op.setbit_uint64                     | Native              |
| algopy.op.setbyte                           | Native              |
| algopy.op.sha256                            | Native              |
| algopy.op.sha3_256                          | Native              |
| algopy.op.sha512_256                        | Native              |
| algopy.op.shl                               | Native              |
| algopy.op.shr                               | Native              |
| algopy.op.sqrt                              | Native              |
| algopy.op.substring                         | Native              |
| algopy.op.AppGlobal                         | Emulated            |
| algopy.op.AppLocal                          | Emulated            |
| algopy.op.AppParamsGet                      | Emulated            |
| algopy.op.AssetHoldingGet                   | Emulated            |
| algopy.op.AssetParamsGet                    | Emulated            |
| algopy.op.Block                             | Emulated            |
| algopy.op.Box                               | Emulated            |
| algopy.op.GITxn                             | Emulated            |
| algopy.op.GTxn                              | Emulated            |
| algopy.op.Global                            | Emulated            |
| algopy.op.ITxn                              | Emulated            |
| algopy.op.ITxnCreate                        | Emulated            |
| algopy.op.Scratch                           | Emulated            |
| algopy.op.Txn                               | Emulated            |
| algopy.op.app_opted_in                      | Emulated            |
| algopy.op.balance                           | Emulated            |
| algopy.op.gaid                              | Emulated            |
| algopy.op.gload_bytes                       | Emulated            |
| algopy.op.gload_uint64                      | Emulated            |
| algopy.op.min_balance                       | Emulated            |
| algopy.op.AcctParamsGet                     | Emulated            |
| algopy.op.EllipticCurve                     | Mockable            |
| algopy.op.VrfVerify                         | Mockable            |
| algopy.op.vrf_verify                        | Mockable            |
| algopy.op.falcon_verify                     | Mockable            |
