import pandas as pd
import torch
import torch.nn.functional as F
import numpy as np
import matplotlib.pyplot as plt


class Analyse(object):

    def __init__(self, pandas_df):
        self.test = pandas_df

    def new_test(self, column_name=None):
        value_list = self.test[column_name].drop_duplicates().to_list()
        self.test[column_name] = self.test[column_name].\
            apply(lambda x:value_list[np.random.randint(0, len(value_list))])

    def compare(self, x, y):
        kl = F.kl_div(x.softmax(dim=-1).log(), y.softmax(dim=-1), reduction='sum')
        return kl

    def dis_analyse(self, x, y):
        self.test.plot.scatter(x, y)
        plt.show()



# '''
# 此开卷第一回也。作者自云：因曾历过一番梦幻之后，故将真事隐去，而借“通灵”之说，撰此lt;lt;石头记gt;gt;一书也。故曰“甄士隐”云云。但书中所记何事何人？自又云：“今风尘碌碌，一事无成，忽念及当日所有之女子，一一细考较去，觉其行止见识，皆出于我之上。何我堂堂须眉，诚不若彼裙钗哉？实愧则有余，悔又无益之大无可如何之日也！当此，则自欲将已往所赖天恩祖德，锦衣纨э之时，饫甘餍肥之日，背父兄教育之恩，负师友规谈之德，以至今日一技无成，半生潦倒之罪，编述一集，以告天下人：我之罪固不免，然闺阁中本自历历有人，万不可因我之不肖，自护己短，一并使其泯灭也。虽今日之茅椽蓬牖，瓦灶绳床，其晨夕风露，阶柳庭花，亦未有妨我之襟怀笔墨者。虽我未学，下笔无文，又何妨用假语村言，敷演出一段故事来，亦可使闺阁昭传，复可悦世之目，破人愁闷，不亦宜乎？”故曰“贾雨村”云云。
#
#     此回中凡用“梦”用“幻”等字，是提醒阅者眼目，亦是此书立意本旨。
#
#     列位看官：你道此书从何而来？说起根由虽近荒唐，细按则深有趣味。待在下将此来历注明，方使阅者了然不惑。
#
#     原来女娲氏炼石补天之时，于大荒山无稽崖练成高经十二丈，方经二十四丈顽石三万六千五百零一块。娲皇氏只用了三万六千五百块，只单单剩了一块未用，便弃在此山青埂峰下。谁知此石自经煅炼之后，灵性已通，因见众石俱得补天，独自己无材不堪入选，遂自怨自叹，日夜悲号惭愧。
#
#     一日，正当嗟悼之际，俄见一僧一道远远而来，生得骨格不凡，丰神迥异，说说笑笑来至峰下，坐于石边高谈快论。先是说些云山雾海神仙玄幻之事，后便说到红尘中荣华富贵。此石听了，不觉打动凡心，也想要到人间去享一享这荣华富贵，但自恨粗蠢，不得已，便口吐人言，向那僧道说道：“大师，弟子蠢物，不能见礼了。适闻二位谈那人世间荣耀繁华，心切慕之。弟子质虽粗蠢，性却稍通，况见二师仙形道体，定非凡品，必有补天济世之材，利物济人之德。如蒙发一点慈心，携带弟子得入红尘，在那富贵场中，温柔乡里受享几年，自当永佩洪恩，万劫不忘也。”二仙师听毕，齐憨笑道：“善哉，善哉！那红尘中有却有些乐事，但不能永远依恃，况又有。美中不足，好事多魔'八个字紧相连属，瞬息间则又乐极悲生，人非物换，究竟是到头一梦，万境归空，倒不如不去的好。”这石凡心已炽，那里听得进这话去，乃复苦求再四。二仙知不可强制，乃叹道：“此亦静极怂级*，无中生有之数也。既如此，我们便携你去受享受享，只是到不得意时，切莫后悔。”石道：“自然，自然。”那僧又道：“若说你性灵，却又如此质蠢，并更无奇贵之处。如此也只好踮脚而已。也罢，我如今大施佛法助你助，待劫终之日，复还本质，以了此案。你道好否？”石头听了，感谢不尽。那僧便念咒书符，大展幻术，将一块大石登时变成一块鲜明莹洁的美玉，且又缩成扇坠大小的可佩可拿。那僧托于掌上，笑道：“形体倒也是个宝物了！还只没有，实在的好处，须得再镌上数字，使人一见便知是奇物方妙。然后携你到那昌明隆盛之邦，诗礼簪缨之族，花柳繁华地，温柔富贵乡去安身乐业。”石头听了，喜不能禁，乃问：“不知赐了弟子那几件奇处，又不知携了弟子到何地方？望乞明示，使弟子不惑。”那僧笑道：“你且莫问，日后自然明白的。”说着，便袖了这石，同那道人飘然而去，竟不知投奔何方何舍。
#
#     后来，又不知过了几世几劫，因有个空空道人访道求仙，忽从这大荒山无稽崖青埂峰下经过，忽见一大块石上字迹分明，编述历历。空空道人乃从头一看，原来就是无材补天，幻形入世，蒙茫茫大士，渺渺真人携入红尘，历尽离合悲欢炎凉世态的一段故事。后面又有一首偈云：
#
#     无材可去补苍天，枉入红尘若许年。
#
#     此系身前身后事，倩谁记去作奇传？诗后便是此石坠落之乡，投胎之处，亲自经历的一段陈迹故事。其中家庭闺阁琐事，以及闲情诗词倒还全备，或可适趣解闷，然朝代年纪，地舆邦国，却反失落无考。
#
#     空空道人遂向石头说道：“石兄，你这一段故事，据你自己说有些趣味，故编写在此，意欲问世传奇。据我看来，第一件，无朝代年纪可考，第二件，并无大贤大忠理朝廷治风俗的善政，其中只不过几个异样女子，或情或痴，或小才微善，亦无班姑，蔡女之德能。我纵抄去，恐世人不爱看呢。”石头笑答道：“我师何太痴耶！若云无朝代可考，今我师竟假借汉唐等年纪添缀，又有何难？
#
#     但我想，历来野史，皆蹈一辙，莫如我这不借此套者，反倒新奇别致，不过只取其事体情理罢了，又何必拘拘于朝代年纪哉！再者，市井俗人喜看理治之书者甚少，爱适趣闲文者特多。历来野史，或讪谤君相，或贬人妻女，**凶恶，不可胜数。更有一种风月笔墨，其淫秽污臭，屠毒笔墨，坏人子弟，又不可胜数。至若佳人才子等书，则又千部共出一套，且其中终不能不涉于淫滥，以致满纸潘安，子建，西子，文君，不过作者要写出自己的那两首情诗艳赋来，故假拟出男女二人名姓，又必旁出一小人其间拨乱，亦如剧中之小丑然。且鬟婢开口即者也之乎，非文即理。故逐一看去，悉皆自相矛盾，大不近情理之话，竟不如我半世亲睹亲闻的这几个女子，虽不敢说强似前代书中所有之人，但事迹原委，亦可以消愁破闷，也有几首歪诗熟话，可以喷饭供酒。至若离合悲欢，兴衰际遇，则又追踪蹑迹，不敢稍加穿凿，徒为供人之目而反失其真传者。今之人，贫者日为衣食所累，富者又怀不足之心，纵然一时稍闲，又有贪淫恋色，好货寻愁之事，那里去有工夫看那理治之书？所以我这一段故事，也不愿世人称奇道妙，也不定要世人喜悦检读，只愿他们当那醉淫饱卧之时，或避世去愁之际，把此一玩，岂不省了些寿命筋力？就比那谋虚逐妄，却也省了口舌是非之害，腿脚奔忙之苦。再者，亦令世人换新眼目，不比那些胡牵乱扯，忽离忽遇，满纸才人淑女，子建文君红娘小玉等通共熟套之旧稿。我师意为何如？“
#
#     空空道人听如此说，思忖半晌，将lt;lt;石头记gt;gt;再检阅一遍，因见上面虽有些指奸责佞贬恶诛邪之语，亦非伤时骂世之旨，及至君仁臣良父慈子孝，凡伦常所关之处，皆是称功颂德，眷眷无穷，实非别书之可比。虽其中大旨谈情，亦不过实录其事，又非假拟妄称，一味淫邀艳约，私订偷盟之可比。因毫不干涉时世，方从头至尾抄录回来，问世传奇。从此空空道人因空见色，由色生情，传情入色，自色悟空，遂易名为情僧，改lt;lt;石头记gt;gt;为lt;lt;情僧录gt;gt;。东鲁孔梅溪则题曰lt;lt;风月宝鉴gt;gt;。后因曹雪芹于悼红轩中披阅十载，增删五次，纂成目录，分出章回，则题曰lt;lt;金陵十二钗gt;gt;。并题一绝云：
#
#     满纸荒唐言，一把辛酸泪！
#
#     都云作者痴，谁解其中味？
#
#     出则既明，且看石上是何故事。按那石上书云：
#
#     当日地陷东南，这东南一隅有处曰姑苏，有城曰阊门者，最是红尘中一二等富贵风流之地。
#
#     这阊门外有个十里街，街内有个仁清巷，巷内有个古庙，因地方窄狭，人皆呼作葫芦庙。庙旁住着一家乡宦，姓甄，名费，字士隐。嫡妻封氏，情性贤淑，深明礼义。家中虽不甚富贵，然本地便也推他为望族了。因这甄士隐禀性恬淡，不以功名为念，每日只以观花修竹，酌酒吟诗为乐，倒是神仙一流人品。只是一件不足：如今年已半百，膝下无儿，只有一女，乳名唤作英莲，年方三岁。
#
#     一日，炎夏永昼，士隐于书房闲坐，至手倦抛书，伏几少憩，不觉朦胧睡去。梦至一处，不辨是何地方。忽见那厢来了一僧一道，且行且谈。只听道人问道：“你携了这蠢物，意欲何往？”那僧笑道：“你放心，如今现有一段风流公案正该了结，这一干风流冤家，尚未投胎入世。趁此机会，就将此蠢物夹带于中，使他去经历经历。”那道人道：“原来近日风流冤孽又将造劫历世去不成？
#
#     但不知落于何方何处？“那僧笑道：”此事说来好笑，竟是千古未闻的罕事。只因西方灵河岸上三生石畔，有绛珠草一株，时有赤瑕宫神瑛侍者，日以甘露灌溉，这绛珠草始得久延岁月。后来既受天地精华，复得雨露滋养，遂得脱却草胎木质，得换人形，仅修成个女体，终日游于离恨天外，饥则食蜜青果为膳，渴则饮灌愁海水为汤。只因尚未酬报灌溉之德，故其五内便郁结着一段缠绵不尽之意。恰近日这神瑛侍者凡心偶炽，乘此昌明太平朝世，意欲下凡造历幻缘，已在警幻仙子案前挂了号。警幻亦曾问及，灌溉之情未偿，趁此倒可了结的。那绛珠仙子道：。他是甘露之惠，我并无此水可还。他既下世为人，我也去下世为人，但把我一生所有的眼泪还他，也偿还得过他了。'因此一事，就勾出多少风流冤家来，陪他们去了结此案。“那道人道：”果是罕闻。实未闻有还泪之说。想来这一段故事，比历来风月事故更加琐碎细腻了。“那僧道：”历来几个风流人物，不过传其大概以及诗词篇章而已，至家庭闺阁中一饮一食，总未述记。再者，大半风月故事，不过偷香窃玉，暗约私奔而已，并不曾将儿女之真情发泄一二。想这一干人入世，其情痴色鬼，贤愚不肖者，悉与前人传述不同矣。“那道人道：”趁此何不你我也去下世度脱几个，岂不是一场功德？“那僧道：”正合吾意，你且同我到警幻仙子宫中，将蠢物交割清楚，待这一干风流孽鬼下世已完，你我再去。如今虽已有一半落尘，然犹未全集。“道人道：”既如此，便随你去来。“
#
#     却说甄士隐俱听得明白，但不知所云“蠢物”系何东西。遂不禁上前施礼，笑问道：“二仙师请了。”那僧道也忙答礼相问。士隐因说道：“适闻仙师所谈因果，实人世罕闻者。但弟子愚浊，不能洞悉明白，若蒙大开痴顽，备细一闻，弟子则洗耳谛听，稍能警省，亦可免沉伦之苦。”二仙笑道：“此乃玄机不可预泄者。到那时不要忘我二人，便可跳出火坑矣。”士隐听了，不便再问。因笑道：“玄机不可预泄，但适云。蠢物'，不知为何，或可一见否？”那僧道：“若问此物，倒有一面之缘。”说着，取出递与士隐。士隐接了看时，原来是块鲜明美玉，上面字迹分明，镌着“通灵宝玉”四字，后面还有几行小字。正欲细看时，那僧便说已到幻境，便强从手中夺了去，与道人竟过一大石牌坊，上书四个大字，乃是“太虚幻境”。两边又有一幅对联，道是：
#
#     假作真时真亦假，无为有处有还无。士隐意欲也跟了过去，方举步时，忽听一声霹雳，有若山崩地陷。士隐大叫一声，定睛一看，只见烈日炎炎，芭蕉冉冉，所梦之事便忘了大半。又见奶母正抱了英莲走来。士隐见女儿越发生得粉妆玉琢，乖觉可喜，便伸手接来，抱在怀内，斗他顽耍一回，又带至街前，看那过会的热闹。方欲进来时，只见从那边来了一僧一道：那僧则癞头跣脚，那道则跛足蓬头，疯疯癫癫，挥霍谈笑而至。及至到了他门前，看见士隐抱着英莲，那僧便大哭起来，又向士隐道：“施主，你把这有命无运，累及爹娘之物，抱在怀内作甚？”士隐听了，知是疯话，也不去睬他。那僧还说：“舍我罢，舍我罢！”士隐不耐烦，便抱女儿撤身要进去，那僧乃指着他大笑，口内念了四句言词道：
#
#     惯养娇生笑你痴，菱花空对雪澌澌。
#
#     好防佳节元宵后，便是烟消火灭时。士隐听得明白，心下犹豫，意欲问他们来历。只听道人说道：“你我不必同行，就此分手，各干营生去罢。三劫后，我在北邙山等你，会齐了同往太虚幻境销号。”那僧道：“最妙，最妙！”说毕，二人一去，再不见个踪影了。士隐心中此时自忖：这两个人必有来历，该试一问，如今悔却晚也。
#
#     这士隐正痴想，忽见隔壁葫芦庙内寄居的一个穷儒-姓贾名化，表字时飞，别号雨村者走了出来。这贾雨村原系胡州人氏，也是诗书仕宦之族，因他生于末世，父母祖宗根基已尽，人口衰丧，只剩得他一身一口，在家乡无益，因进京求取功名，再整基业。自前岁来此，又淹蹇住了，暂寄庙中安身，每日卖字作文为生，故士隐常与他交接。当下雨村见了士隐，忙施礼陪笑道：“老先生倚门伫望，敢是街市上有甚新闻否？”士隐笑道：“非也。适因小女啼哭，引他出来作耍，正是无聊之甚，兄来得正妙，请入小斋一谈，彼此皆可消此永昼。”说着，便令人送女儿进去，自与雨村携手来至书房中。小童献茶。方谈得三五句话，忽家人飞报：“严老爷来拜。”士隐慌的忙起身谢罪道：“恕诳驾之罪，略坐，弟即来陪。”雨村忙起身亦让道：“老先生请便。晚生乃常造之客，稍候何妨。”说着，士隐已出前厅去了。
#
#     这里雨村且翻弄书籍解闷。忽听得窗外有女子嗽声，雨村遂起身往窗外一看，原来是一个丫鬟，在那里撷花，生得仪容不俗，眉目清明，虽无十分姿色，却亦有动人之处。雨村不觉看的呆了。那甄家丫鬟撷了花，方欲走时，猛抬头见窗内有人，敝巾旧服，虽是贫窘，然生得腰圆背厚，面阔口方，更兼剑眉星眼，直鼻权腮。这丫鬟忙转身回避，心下乃想：“这人生的这样雄壮，却又这样褴褛，想他定是我家主人常说的什么贾雨村了，每有意帮助周济，只是没甚机会。我家并无这样贫窘亲友，想定是此人无疑了。怪道又说他必非久困之人。”如此想来，不免又回头两次。雨村见他回了头，便自为这女子心中有意于他，便狂喜不尽，自为此女子必是个巨眼英雄，风尘中之知己也。一时小童进来，雨村打听得前面留饭，不可久待，遂从夹道中自便出门去了。士隐待客既散，知雨村自便，也不去再邀。
#
#     一日，早又中秋佳节。士隐家宴已毕，乃又另具一席于书房，却自己步月至庙中来邀雨村。
#
#     原来雨村自那日见了甄家之婢曾回顾他两次，自为是个知己，便时刻放在心上。今又正值中秋，不免对月有怀，因而口占五言一律云：
#
#     未卜三生愿，频添一段愁。
#
#     闷来时敛额，行去几回头。
#
#     自顾风前影，谁堪月下俦？
#
#     蟾光如有意，先上玉人楼。雨村吟罢，因又思及平生抱负，苦未逢时，乃又搔首对天长叹，复高吟一联曰：
#
#     玉在中求善价，钗于奁内待时飞。恰值士隐走来听见，笑道：“雨村兄真抱负不浅也！”雨村忙笑道：“不过偶吟前人之句，何敢狂诞至此。”因问：“老先生何兴至此？”士隐笑道：“今夜中秋，俗谓。团圆之节'，想尊兄旅寄僧房，不无寂寥之感，故特具小酌，邀兄到敝斋一饮，不知可纳芹意否？”雨村听了，并不推辞，便笑道：“既蒙厚爱，何敢拂此盛情。”说着，便同士隐复过这边书院中来。须臾茶毕，早已设下杯盘，那美酒佳肴自不必说。二人归坐，先是款斟漫饮，次渐谈至兴浓，不觉飞觥限起来。当时街坊上家家箫管，户户弦歌，当头一轮明月，飞彩凝辉，二人愈添豪兴，酒到杯干。雨村此时已有七八分酒意，狂兴不禁，乃对月寓怀，口号一绝云：
#
#     时逢三五便团圆，满把晴光护玉栏。
#
#     天上一轮才捧出，人间万姓仰头看。士隐听了，大叫：“妙哉！吾每谓兄必非久居人下者，今所吟之句，飞腾之兆已见，不日可接履于云霓之上矣。可贺，可贺！”乃亲斟一斗为贺。雨村因干过，叹道：“非晚生酒后狂言，若论时尚之学，晚生也或可去充数沽名，只是目今行囊路费一概无措，神京路远，非赖卖字撰文即能到者。”士隐不待说完，便道：“兄何不早言。愚每有此心，但每遇兄时，兄并未谈及，愚故未敢唐突。今既及此，愚虽不才，。义利'二字却还识得。且喜明岁正当大比，兄宜作速入都，春闱一战，方不负兄之所学也。其盘费余事，弟自代为处置，亦不枉兄之谬识矣！”当下即命小童进去，速封五十两白银，并两套冬衣。又云：“十九日乃黄道之期，兄可即买舟西上，待雄飞高举，明冬再晤，岂非大快之事耶！”雨村收了银衣，不过略谢一语，并不介意，仍是吃酒谈笑。那天已交了三更，二人方散。士隐送雨村去后，回房一觉，直至红日三竿方醒。因思昨夜之事，意欲再写两封荐书与雨村带至神都，使雨村投谒个仕宦之家为寄足之地。因使人过去请时，那家人去了回来说：“和尚说，贾爷今日五鼓已进京去了，也曾留下话与和尚转达老爷，说。读书人不在黄道黑道，总以事理为要，不及面辞了。'”士隐听了，也只得罢了。真是闲处光阴易过，倏忽又是元霄佳节矣。士隐命家人霍启抱了英莲去看社火花灯，半夜中，霍启因要小解，便将英莲放在一家门槛上坐着。待他小解完了来抱时，那有英莲的踪影？急得霍启直寻了半夜，至天明不见，那霍启也就不敢回来见主人，便逃往他乡去了。那士隐夫妇，见女儿一夜不归，便知有些不妥，再使几人去寻找，回来皆云连音响皆无。夫妻二人，半世只生此女，一旦失落，岂不思想，因此昼夜啼哭，几乎不曾寻死。看看的一月，士隐先就得了一病，当时封氏孺人也因思女构疾，日日请医疗治。
#
#     不想这日三月十五，葫芦庙中炸供，那些和尚不加小心，致使油锅火逸，便烧着窗纸。此方人家多用竹篱木壁者，大抵也因劫数，于是接二连三，牵五挂四，将一条街烧得如火焰山一般。
#
#     彼时虽有军民来救，那火已成了势，如何救得下？直烧了一夜，方渐渐的熄去，也不知烧了几家。
#
#     只可怜甄家在隔壁，早已烧成一片瓦砾场了。只有他夫妇并几个家人的性命不曾伤了。急得士隐惟跌足长叹而已。只得与妻子商议，且到田庄上去安身。偏值近年水旱不收，鼠盗蜂起，无非抢田夺地，鼠窃狗偷，民不安生，因此官兵剿捕，难以安身。士隐只得将田庄都折变了，便携了妻子与两个丫鬟投他岳丈家去。
#
#     他岳丈名唤封肃，本贯大如州人氏，虽是务农，家中都还殷实。今见女婿这等狼狈而来，心中便有些不乐。幸而士隐还有折变田地的银子未曾用完，拿出来托他随分就价薄置些须房地，为后日衣食之计。那封肃便半哄半赚，些须与他些薄田朽屋。士隐乃读书之人，不惯生理稼穑等事，勉强支持了一二年，越觉穷了下去。封肃每见面时，便说些现成话，且人前人后又怨他们不善过活，只一味好吃懒作等语。士隐知投人不着，心中未免悔恨，再兼上年惊唬，急忿怨痛，已有积伤，暮年之人，贫病交攻，竟渐渐的露出那下世的光景来。
#
#     可巧这日拄了拐杖挣挫到街前散散心时，忽见那边来了一个跛足道人，疯癫落脱，麻屣鹑衣，口内念着几句言词，道是：
#
#     世人都晓神仙好，惟有功名忘不了！
#
#     古今将相在何方？荒冢一堆草没了。
#
#     世人都晓神仙好，只有金银忘不了！
#
#     终朝只恨聚无多，及到多时眼闭了。
#
#     世人都晓神仙好，只有姣妻忘不了！
#
#     君生日日说恩情，君死又随人去了。
#
#     世人都晓神仙好，只有儿孙忘不了！
#
#     痴心父母古来多，孝顺儿孙谁见了？士隐听了，便迎上来道：你满口说些什么？只听见些。
#
#     好了好了那道人笑道：“你若果听见。好了二字，还算你明白。可知世上万般，好便是了，了便是好。若不了，便不好，若要好，须是了。我这歌儿，便名lt;lt;好了歌gt;gt;”士隐本是有宿慧的，一闻此言，心中早已彻悟。因笑道：“且住！待我将你这lt;lt;好了歌gt;gt;解注出来何如？”道人笑道：“你解，你解。”士隐乃说道：
#
#     陋室空堂，当年笏满床，衰草枯杨，曾为歌舞场。蛛丝儿结满雕梁，绿纱今又糊在蓬窗上。说什么脂正浓，粉正香，如何两鬓又成霜？昨日黄土陇头送白骨，今宵红灯帐底卧鸳鸯。金满箱，银满箱，展眼乞丐人皆谤。正叹他人命不长，那知自己归来丧！训有方，保不定日后作强梁。择膏粱，谁承望流落在烟花巷！因嫌纱帽小，致使锁枷杠，昨怜破袄寒，今嫌紫蟒长：乱烘烘你方唱罢我登场，反认他乡是故乡。甚荒唐，到头来都是为他人作嫁衣裳！那疯跛道人听了，拍掌笑道：“解得切，解得切！”士隐便说一声“走罢！”将道人肩上褡裢抢了过来背着，竟不回家，同了疯道人飘飘而去。当下烘动街坊，众人当作一件新闻传说。封氏闻得此信，哭个死去活来，只得与父亲商议，遣人各处访寻，那讨音信？无奈何，少不得依靠着他父母度日。幸而身边还有两个旧日的丫鬟伏侍，主仆三人，日夜作些针线发卖，帮着父亲用度。那封肃虽然日日抱怨，也无可奈何了。
#
#     这日，那甄家大丫鬟在门前买线，忽听街上喝道之声，众人都说新太爷到任。丫鬟于是隐在门内看时，只见军牢快手，一对一对的过去，俄而大轿抬着一个乌帽猩袍的官府过去。丫鬟倒发了个怔，自思这官好面善，倒象在那里见过的。于是进入房中，也就丢过不在心上。至晚间，正待歇息之时，忽听一片声打的门响，许多人乱嚷，说：“本府太爷差人来传人问话。”封肃听了，唬得目瞪口呆，不知有何祸事。
# '''
#
# '''
# 诗云
#
#     一局输赢料不真，香销茶尽尚逡巡。欲知目下兴衰兆，须问旁观冷眼人。
#
#     却说封肃因听见公差传唤，忙出来陪笑启问。那些人只嚷：“快请出甄爷来！”封肃忙陪笑道：“小人姓封，并不姓甄。只有当日小婿姓甄，今已出家一二年了，不知可是问他？”那些公人道：“我们也不知什么。真假，因奉太爷之命来问，他既是你女婿，便带了你去亲见太爷面禀，省得乱跑。”说着，不容封肃多言，大家推拥他去了。封家人个个都惊慌，不知何兆。
#
#     那天约二更时，只见封肃方回来，欢天喜地。众人忙问端的。他乃说道：“原来本府新升的太爷姓贾名化，本贯胡州人氏，曾与女婿旧日相交。方才在咱门前过去，因见娇杏那丫头买线，所以他只当女婿移住于此。我一一将原故回明，那太爷倒伤感叹息了一回，又问外孙女儿，我说看灯丢了。太爷说：不妨，我自使番役务必探访回来。说了一回话，临走倒送了我二两银子。”甄家娘子听了，不免心中伤感。一宿无话。至次日，早有雨村遣人送了两封银子，四匹锦缎，答谢甄家娘子，又寄一封密书与封肃，转托问甄家娘子要那娇杏作二房。封肃喜的屁滚尿流，巴不得去奉承，便在女儿前一力撺掇成了，乘夜只用一乘小轿，便把娇杏送进去了。雨村欢喜，自不必说，乃封百金赠封肃，外谢甄家娘子许多物事，令其好生养赡，以待寻访女儿下落。封肃回家无话。
#
#     却说娇杏这丫鬟，便是那年回顾雨村者。因偶然一顾，便弄出这段事来，亦是自己意料不到之奇缘。谁想他命运两济，不承望自到雨村身边，只一年便生了一子，又半载，雨村嫡妻忽染疾下世，雨村便将他扶侧作正室夫人了。正是：
#
#     偶因一着错，便为人上人。原来，雨村因那年士隐赠银之后，他于十六日便起身入都，至大比之期，不料他十分得意，已会了进士，选入外班，今已升了本府知府。虽才干优长，未免有些贪酷之弊，且又恃才侮上，那些官员皆侧目而视。不上一年，便被上司寻了个空隙，作成一本，参他生情狡猾，擅纂礼仪，大怒，即批革职。该部文书一到，本府官员无不喜悦。那雨村心中虽十分惭恨，却面上全无一点怨色，仍是嘻笑自若，交代过公事，将历年做官积的些资本并家小人属送至原籍，安排妥协，却是自己担风袖月，游览天下胜迹。
#
#     那日，偶又游至维扬地面，因闻得今岁鹾政点的是林如海。这林如海姓林名海，表字如海，乃是前科的探花，今已升至兰台寺大夫，本贯姑苏人氏，今钦点出为巡盐御史，到任方一月有余。
#
#     原来这林如海之祖，曾袭过列侯，今到如海，业经五世。起初时，只封袭三世，因当今隆恩盛德，远迈前代，额外加恩，至如海之父，又袭了一代；至如海，便从科第出身。虽系钟鼎之家，却亦是书香之族。只可惜这林家支庶不盛，子孙有限，虽有几门，却与如海俱是堂族而已，没甚亲支嫡派的。今如海年已四十，只有一个三岁之子，偏又于去岁死了。虽有几房姬妾，奈他命中无子，亦无可如何之事。今只有嫡妻贾氏，生得一女，乳名黛玉，年方五岁。夫妻无子，故爱如珍宝，且又见他聪明清秀，便也欲使他读书识得几个字，不过假充养子之意，聊解膝下荒凉之叹。
#
#     雨村正值偶感风寒，病在旅店，将一月光景方渐愈。一因身体劳倦，二因盘费不继，也正欲寻个合式之处，暂且歇下。幸有两个旧友，亦在此境居住，因闻得鹾政欲聘一西宾，雨村便相托友力，谋了进去，且作安身之计。妙在只一个女学生，并两个伴读丫鬟，这女学生年又小，身体又极怯弱，工课不限多寡，故十分省力。堪堪又是一载的光阴，谁知女学生之母贾氏夫人一疾而终。
#
#     女学生侍汤奉药，守丧尽哀，遂又将辞馆别图。林如海意欲令女守制读书，故又将他留下。近因女学生哀痛过伤，本自怯弱多病的，触犯旧症，遂连日不曾上学。雨村闲居无聊，每当风日晴和，饭后便出来闲步。
#
#     这日，偶至郭外，意欲赏鉴那村野风光。忽信步至一山环水旋，茂林深竹之处，隐隐的有座庙宇，门巷倾颓，墙垣朽败，门前有额，题着“智通寺”三字，门旁又有一副旧破的对联，曰
#
#     身后有余忘缩手，眼前无路想回头。雨村看了，因想到：“这两句话，文虽浅近，其意则深。我也曾游过些名山大刹，倒不曾见过这话头，其中想必有个翻过筋斗来的亦未可知，何不进去试试。”想着走入，只有一个龙钟老僧在那里煮粥。雨村见了，便不在意。及至问他两句话，那老僧既聋且昏，齿落舌钝，所答非所问。
#
#     雨村不耐烦，便仍出来，意欲到那村肆中沽饮三杯，以助野趣，于是款步行来。将入肆门，只见座上吃酒之客有一人起身大笑，接了出来，口内说：“奇遇，奇遇。”雨村忙看时，此人是都中在古董行中贸易的号冷子兴者，旧日在都相识。雨村最赞这冷子兴是个有作为大本领的人，这子兴又借雨村斯文之名，故二人说话投机，最相契合。雨村忙笑问道：“老兄何日到此？弟竟不知。
#
#     今日偶遇，真奇缘也。“子兴道。”去年岁底到家，今因还要入都，从此顺路找个敝友说一句话，承他之情，留我多住两日。我也无紧事，且盘桓两日，待月半时也就起身了。今日敝友有事，我因闲步至此，且歇歇脚，不期这样巧遇！“一面说，一面让雨村同席坐了，另整上酒肴来。二人闲谈漫饮，叙些别后之事。
#
#     雨村因问：“近日都中可有新闻没有？”子兴道：“倒没有什么新闻，倒是老先生你贵同宗家，出了一件小小的异事。”雨村笑道：“弟族中无人在都，何谈及此？”子兴笑道：“你们同姓，岂非同宗一族？”雨村问是谁家。子兴道：“荣国府贾府中，可也玷辱了先生的门楣么？”雨村笑道：“原来是他家。若论起来，寒族人丁却不少，自东汉贾复以来，支派繁盛，各省皆有，谁逐细考查得来？
#
#     若论荣国一支，却是同谱。但他那等荣耀，我们不便去攀扯，至今故越发生疏难认了。子兴叹道。老先生休如此说。如今的这宁荣两门，也都萧疏了，不比先时的光景。雨村道。当日宁荣两宅的人口也极多，如何就萧疏了？“冷子兴道。”正是，说来也话长。“雨村道。”去岁我到金陵地界，因欲游览六朝遗迹，那日进了石头城，从他老宅门前经过。街东是宁国府，街西是荣国府，二宅相连，竟将大半条街占了。大门前虽冷落无人，隔着围墙一望，里面厅殿楼阁，也还都峥嵘轩峻，就是后一带花园子里面树木山石，也还都有蓊蔚洇润之气，那里象个衰败之家？冷子兴笑道。亏你是进士出身，原来不通！古人有云：百足之虫，死而不僵。如今虽说不及先年那样兴盛，较之平常仕宦之家，到底气象不同。如今生齿日繁，事务日盛，主仆上下，安富尊荣者尽多，运筹谋画者无一，其日用排场费用，又不能将就省俭，如今外面的架子虽未甚倒，内囊却也尽上来了。这还是小事。更有一件大事：谁知这样钟鸣鼎食之家，翰墨诗书之族，如今的儿孙，竟一代不如一代了！雨村听说，也纳罕道。”这样诗礼之家，岂有不善教育之理？别门不知，只说这宁，荣二宅，是最教子有方的。
#
#     子兴叹道：正说的是这两门呢。待我告诉你：当日宁国公与荣国公是一母同胞弟兄两个。
#
#     宁公居长，生了四个儿子。宁公死后，贾代化袭了官，也养了两个儿子：长名贾敷，至八九岁上便死了，只剩了次子贾敬袭了官，如今一味好道，只爱烧丹炼汞，余者一概不在心上。幸而早年留下一子，名唤贾珍，因他父亲一心想作神仙，把官倒让他袭了。他父亲又不肯回原籍来，只在都中城外和道士们胡羼。这位珍爷倒生了一个儿子，今年才十六岁，名叫贾蓉。如今敬老爹一概不管。这珍爷那里肯读书，只一味高乐不了，把宁国府竟翻了过来，也没有人敢来管他。再说荣府你听，方才所说异事，就出在这里。自荣公死后，长子贾代善袭了官，娶的也是金陵世勋史侯家的小姐为妻，生了两个儿子：长子贾赦，次子贾政。如今代善早已去世，太夫人尚在，长子贾赦袭着官，次子贾政，自幼酷喜捕潦*，祖父最疼，原欲以科甲出身的，不料代善临终时遗本一上，皇上因恤先臣，即时令长子袭官外，问还有几子，立刻引见，遂额外赐了这政老爹一个主事之衔，令其入部习学，如今现已升了员外郎了。这政老爹的夫人王氏，头胎生的公子，名唤贾珠，十四岁进学，不到二十岁就娶了妻生了子，一病死了。第二胎生了一位小姐，生在大年初一，这就奇了，不想后来又生一位公子，说来更奇，一落胎胞，嘴里便衔下一块五彩晶莹的玉来，上面还有许多字迹，就取名叫作宝玉。你道是新奇异事不是？
#
#     雨村笑道：“果然奇异。只怕这人来历不小。”子兴冷笑道：“万人皆如此说，因而乃祖母便先爱如珍宝。那年周岁时，政老爹便要试他将来的志向，便将那世上所有之物摆了无数，与他抓取。
#
#     谁知他一概不取，伸手只把些脂粉钗环抓来。政老爹便大怒了，说：将来酒色之徒耳！'因此便大不喜悦。独那史老太君还是命根一样。说来又奇，如今长了七八岁，虽然淘气异常，但其聪明乖觉处，百个不及他一个。说起孩子话来也奇怪，他说：女儿是水作的骨肉，男人是泥作的骨肉。
#
#     我见了女儿，我便清爽，见了男子，便觉浊臭逼人。你道好笑不好笑？将来色鬼无疑了！“雨村罕然厉色忙止道。”非也！可惜你们不知道这人来历。大约政老前辈也错以淫魔色鬼看待了。若非多读书识事，加以致知格物之功，悟道参玄之力，不能知也。
#
#     子兴见他说得这样重大，忙请教其端。雨村道：天地生人，除大仁大恶两种，余者皆无大异。
#
#     若大仁者，则应运而生，大恶者，则应劫而生。运生世治，劫生世危。尧，舜，禹，汤，文，武，周，召，孔，孟，董，韩，周，程，张，朱，皆应运而生者。蚩尤，共工，桀，纣，始皇，王莽，曹操，桓温，安禄山，秦桧等，皆应劫而生者。大仁者，修治天下，大恶者，挠乱天下。清明灵秀，天地之正气，仁者之所秉也，残忍乖僻，天地之邪气，恶者之所秉也。今当运隆祚永之朝，太平无为之世，清明灵秀之气所秉者，上至朝廷，下及草野，比比皆是。所余之秀气，漫无所归，遂为甘露，为和风，洽然溉及四海。彼残忍乖僻之邪气，不能荡溢于光天化日之中，遂凝结充塞于深沟大壑之内，偶因风荡，或被云催，略有摇动感发之意，一丝半缕误而泄出者，偶值灵秀之气适过，正不容邪，邪复妒正，两不相下，亦如风水雷电，地中既遇，既不能消，又不能让，必至搏击掀发后始尽。故其气亦必赋人，发泄一尽始散。使男女偶秉此气而生者，在上则不能成仁人君子，下亦不能为大凶大恶。置之于万万人中，其聪俊灵秀之气，则在万万人之上，其乖僻邪谬不近人情之态，又在万万人之下。若生于公侯富贵之家，则为情痴情种，若生于诗书清贫之族，则为逸士高人，纵再偶生于薄祚寒门，断不能为走卒健仆，甘遭庸人驱制驾驭，必为奇优名倡。如前代之许由，陶潜，阮籍，嵇康，刘伶，王谢二族，顾虎头，陈后主，唐明皇，宋徽宗，刘庭芝，温飞卿，米南宫，石曼卿，柳耆卿，秦少游，近日之倪云林，唐伯虎，祝枝山，再如李龟年，黄幡绰，敬新磨，卓文君，红拂，薛涛，崔莺，朝云之流，此皆易地则同之人也。
#
#     子兴道：“依你说，成则王侯败则贼了。”雨村道：“正是这意。你还不知，我自革职以来，这两年遍游各省，也曾遇见两个异样孩子。所以，方才你一说这宝玉，我就猜着了八九亦是这一派人物。不用远说，只金陵城内，钦差金陵省体仁院总裁甄家，你可知么？”子兴道：“谁人不知！这甄府和贾府就是老亲，又系世交。两家来往，极其亲热的。便在下也和他家来往非止一日了。”
#
#     雨村笑道：“去岁我在金陵，也曾有人荐我到甄府处馆。我进去看其光景，谁知他家那等显贵，却是个富而好礼之家，倒是个难得之馆。但这一个学生，虽是启蒙，却比一个举业的还劳神。
#
#     说起来更可笑，他说：必得两个女儿伴着我读书，我方能认得字，心里也明白，不然我自己心里糊涂。又常对跟他的小厮们说。这女儿两个字，极尊贵，极清净的，比那阿弥陀佛，元始天尊的这两个宝号还更尊荣无对的呢！你们这浊口臭舌，万不可唐突了这两个字，要紧。但凡要说时，必须先用清水香茶漱了口才可，设若失错，便要凿牙穿腮等事。其暴虐浮躁，顽劣憨痴，种种异常。只一放了学，进去见了那些女儿们，其温厚和平，聪敏文雅，竟又变了一个。因此，他令尊也曾下死笞楚过几次，无奈竟不能改。每打的吃疼不过时，他便。姐姐'。妹妹'乱叫起来。后来听得里面女儿们拿他取笑：。因何打急了只管叫姐妹做甚？莫不是求姐妹去说情讨饶？你岂不愧些！他回答的最妙。他说。急疼之时，只叫。姐姐'妹妹'字样，或可解疼也未可知，因叫了一声，便果觉不疼了，遂得了秘法：每疼痛之极，便连叫姐妹起来了。你说可笑不可笑？也因祖母溺爱不明，每因孙辱师责子，因此我就辞了馆出来。如今在这巡盐御史林家做馆了。你看，这等子弟，必不能守祖父之根基，从师长之规谏的。只可惜他家几个姊妹都是少有的。
#
#     子兴道：便是贾府中，现有的三个也不错。政老爹的长女，名元春，现因贤孝才德，选入宫作女史去了。二小姐乃赦老爹之妾所出，名迎春，三小姐乃政老爹之庶出，名探春，四小姐乃宁府珍爷之胞妹，名唤惜春。因史老夫人极爱孙女，都跟在祖母这边一处读书，听得个个不错。雨村道。更妙在甄家的风俗，女儿之名，亦皆从男子之名命字，不似别家另外用这些。春红香玉'等艳字的。何得贾府亦乐此俗套？子兴道。不然。只因现今大小姐是正月初一日所生，故名元春，余者方从了。春字。上一辈的，却也是从兄弟而来的。现有对证：目今你贵东家林公之夫人，即荣府中赦，政二公之胞妹，在家时名唤贾敏。不信时，你回去细访可知。雨村拍案笑道。怪道这女学生读至凡书中有。敏字，皆念作。密字，每每如是，写字遇着。敏字，又减一二笔，我心中就有些疑惑。今听你说的，是为此无疑矣。怪道我这女学生言语举止另是一样，不与近日女子相同，度其母必不凡，方得其女，今知为荣府之孙，又不足罕矣，可伤上月竟亡故了。子兴叹道。老姊妹四个，这一个是极小的，又没了。长一辈的姊妹，一个也没了。只看这小一辈的，将来之东床如何呢。
#
#     雨村道：“正是。方才说这政公，已有衔玉之儿，又有长子所遗一个弱孙。这赦老竟无一个不成？”子兴道：“政公既有玉儿之后，其妾又生了一个，倒不知其好歹。只眼前现有二子一孙，却不知将来如何。若问那赦公，也有二子，长名贾琏，今已二十来往了，亲上作亲，娶的就是政老爹夫人王氏之内侄女，今已娶了二年。这位琏爷身上现捐的是个同知，也是不肯读书，于世路上好机变，言谈去的，所以如今只在乃叔政老爷家住着，帮着料理些家务。谁知自娶了他令夫人之后，倒上下无一人不称颂他夫人的，琏爷倒退了一射之地：说模样又极标致，言谈又爽利，心机又极深细，竟是个男人万不及一的。”
#
#     雨村听了，笑道：“可知我前言不谬。你我方才所说的这几个人，都只怕是那正邪两赋而来一路之人，未可知也。”子兴道：“邪也罢，正也罢，只顾算别人家的帐，你也吃一杯酒才好。”雨村道：“正是，只顾说话，竟多吃了几杯。”子兴笑道：“说着别人家的闲话，正好下酒，即多吃几杯何妨。”雨村向窗外看道：“天也晚了，仔细关了城。我们慢慢的进城再谈，未为不可。”于是，二人起身，算还酒帐。方欲走时，又听得后面有人叫道：“雨村兄，恭喜了！特来报个喜信的。”雨村忙回头看时。
#
# # '''
# '''
#     却说雨村忙回头看时，不是别人，乃是当日同僚一案参革的号张如圭者。他本系此地人，革后家居，今打听得都中奏准起复旧员之信，他便四下里寻情找门路，忽遇见雨村，故忙道喜。二人见了礼，张如圭便将此信告诉雨村，雨村自是欢喜，忙忙的叙了两句，遂作别各自回家。冷子兴听得此言，便忙献计，令雨村央烦林如海，转向都中去央烦贾政。雨村领其意，作别回至馆中，忙寻邸报看真确了。
#
#     次日，面谋之如海。如海道：“天缘凑巧，因贱荆去世，都中家岳母念及小女无人依傍教育，前已遣了男女船只来接，因小女未曾大痊，故未及行。此刻正思向蒙训教之恩未经酬报，遇此机会，岂有不尽心图报之理。但请放心。弟已预为筹画至此，已修下荐书一封，转托内兄务为周全协佐，方可稍尽弟之鄙诚，即有所费用之例，弟于内兄信中已注明白，亦不劳尊兄多虑矣。”雨村一面打恭，谢不释口，一面又问：“不知令亲大人现居何职？只怕晚生草率，不敢骤然入都干渎。”如海笑道：“若论舍亲，与尊兄犹系同谱，乃荣公之孙：大内兄现袭一等将军，名赦，字恩侯，二内兄名政，字存周，现任工部员外郎，其为人谦恭厚道，大有祖父遗风，非膏粱轻薄仕宦之流，故弟方致书烦托。否则不但有污尊兄之清操，即弟亦不屑为矣。”雨村听了，心下方信了昨日子兴之言，于是又谢了林如海。如海乃说：“已择了出月初二日小女入都，尊兄即同路而往，岂不两便？”雨村唯唯听命，心中十分得意。如海遂打点礼物并饯行之事，雨村一一领了。
#
#     那女学生黛玉，身体方愈，原不忍弃父而往，无奈他外祖母致意务去，且兼如海说：“汝父年将半百，再无续室之意，且汝多病，年又极小，上无亲母教养，下无姊妹兄弟扶持，今依傍外祖母及舅氏姊妹去，正好减我顾盼之忧，何反云不往？”黛玉听了，方洒泪拜别，随了奶娘及荣府几个老妇人登舟而去。雨村另有一只船，带两个小童，依附黛玉而行。
#
#     有日到了都中，进入神京，雨村先整了衣冠，带了小童，拿着宗侄的名帖，至荣府的门前投了。彼时贾政已看了妹丈之书，即忙请入相会。见雨村相貌魁伟，言语不俗，且这贾政最喜读书人，礼贤下士，济弱扶危，大有祖风，况又系妹丈致意，因此优待雨村，更又不同，便竭力内中协助，题奏之日，轻轻谋了一个复职候缺，不上两个月，金陵应天府缺出，便谋补了此缺，拜辞了贾政，择日上任去了。不在话下。
#
#     且说黛玉自那日弃舟登岸时，便有荣国府打发了轿子并拉行李的车辆久候了。这林黛玉常听得母亲说过，他外祖母家与别家不同。他近日所见的这几个三等仆妇，吃穿用度，已是不凡了，何况今至其家。因此步步留心，时时在意，不肯轻易多说一句话，多行一步路，惟恐被人耻笑了他去。自上了轿，进入城中从纱窗向外瞧了一瞧，其街市之繁华，人烟之阜盛，自与别处不同。又行了半日，忽见街北蹲着两个大石狮子，三间兽头大门，门前列坐着十来个华冠丽服之人。正门却不开，只有东西两角门有人出入。正门之上有一匾，匾上大书“敕造宁国府”五个大字。黛玉想道：这必是外祖之长房了。想着，又往西行，不多远，照样也是三间大门，方是荣国府了。却不进正门，只进了西边角门。那轿夫抬进去，走了一射之地，将转弯时，便歇下退出去了。后面的婆子们已都下了轿，赶上前来。另换了三四个衣帽周全十七八岁的小厮上来，复抬起轿子。众婆子步下围随至一垂花门前落下。众小厮退出，众婆子上来打起轿帘，扶黛玉下轿。林黛玉扶着婆子的手，进了垂花门，两边是抄手游廊，当中是穿堂，当地放着一个紫檀架子大理石的大插屏。转过插屏，小小的三间厅，厅后就是后面的正房大院。正面五间上房，皆雕梁画栋，两边穿山游廊厢房，挂着各色鹦鹉，画眉等鸟雀。台矶之上，坐着几个穿红着绿的丫头，一见他们来了，便忙都笑迎上来，说：“刚才老太太还念呢，可巧就来了。”于是三四人争着打起帘笼，一面听得人回话：“林姑娘到了。”
#
#     黛玉方进入房时，只见两个人搀着一位鬓发如银的老母迎上来，黛玉便知是他外祖母。方欲拜见时，早被他外祖母一把搂入怀中，心肝儿肉叫着大哭起来。当下地下侍立之人，无不掩面涕泣，黛玉也哭个不住。一时众人慢慢解劝住了，黛玉方拜见了外祖母。____此即冷子兴所云之史氏太君，贾赦贾政之母也。当下贾母一一指与黛玉：“这是你大舅母，这是你二舅母，这是你先珠大哥的媳妇珠大嫂子。”黛玉一一拜见过。贾母又说：“请姑娘们来。今日远客才来，可以不必上学去了。”众人答应了一声，便去了两个。
#
#     不一时，只见三个奶嬷嬷并五六个丫鬟，簇拥着三个姊妹来了。第一个肌肤微丰，合中身材，腮凝新荔，鼻腻鹅脂，温柔沉默，观之可亲。第二个削肩细腰，长挑身材，鸭蛋脸面，俊眼修眉，顾盼神飞，文彩精华，见之忘俗。第三个身量未足，形容尚小。其钗环裙袄，三人皆是一样的妆饰。
#
#     黛玉忙起身迎上来见礼，互相厮认过，大家归了坐。丫鬟们斟上茶来。不过说些黛玉之母如何得病，如何请医服药，如何送死发丧。不免贾母又伤感起来，因说：“我这些儿女，所疼者独有你母，今日一旦先舍我而去，连面也不能一见，今见了你，我怎不伤心！”说着，搂了黛玉在怀，又呜咽起来。众人忙都宽慰解释，方略略止住。
#
#     众人见黛玉年貌虽小，其举止言谈不俗，身体面庞虽怯弱不胜，却有一段自然的风流态度，便知他有不足之症。因问：“常服何药，如何不急为疗治？”黛玉道：“我自来是如此，从会吃饮食时便吃药，到今日未断，请了多少名医修方配药，皆不见效。那一年我三岁时，听得说来了一个癞头和尚，说要化我去出家，我父母固是不从。他又说：既舍不得他，只怕他的病一生也不能好的了。若要好时，除非从此以后总不许见哭声，除父母之外，凡有外姓亲友之人，一概不见，方可平安了此一世。'疯疯癫癫，说了这些不经之谈，也没人理他。如今还是吃人参养荣丸。”贾母道：“正好，我这里正配丸药呢。叫他们多配一料就是了。
#
#     一语未了，只听后院中有人笑声，说：“我来迟了，不曾迎接远客！”黛玉纳罕道：“这些人个个皆敛声屏气，恭肃严整如此，这来者系谁，这样放诞无礼？”心下想时，只见一群媳妇丫鬟围拥着一个人从后房门进来。这个人打扮与众姑娘不同，彩绣辉煌，恍若神妃仙子：头上戴着金丝八宝攒珠髻，绾着朝阳五凤挂珠钗，项上戴着赤金盘螭璎珞圈，裙边系着豆绿宫绦，双衡比目玫瑰佩，身上穿着缕金百蝶穿花大红洋缎窄e袄，外罩五彩刻丝石青银鼠褂，下着翡翠撒花洋绉裙。
#
#     一双丹凤三角眼，两弯柳叶吊梢眉，身量苗条，体格风骚，粉面含春威不露，丹唇未起笑先闻。黛玉连忙起身接见。贾母笑道，“你不认得他，他是我们这里有名的一个泼皮破落户儿，南省俗谓作。辣子'，你只叫他。凤辣子'就是了。”黛玉正不知以何称呼，只见众姊妹都忙告诉他道：“这是琏嫂子。”黛玉虽不识，也曾听见母亲说过，大舅贾赦之子贾琏，娶的就是二舅母王氏之内侄女，自幼假充男儿教养的，学名王熙凤。黛玉忙陪笑见礼，以“嫂”呼之。这熙凤携着黛玉的手，上下细细打谅了一回，仍送至贾母身边坐下，因笑道：“天下真有这样标致的人物，我今儿才算见了！
#
#     况且这通身的气派，竟不象老祖宗的外孙女儿，竟是个嫡亲的孙女，怨不得老祖宗天天口头心头一时不忘。只可怜我这妹妹这样命苦，怎么姑妈偏就去世了！“说着，便用帕拭泪。贾母笑道。”我才好了，你倒来招我。你妹妹远路才来，身子又弱，也才劝住了，快再休提前话。“这熙凤听了，忙转悲为喜道。”正是呢！我一见了妹妹，一心都在他身上了，又是喜欢，又是伤心，竟忘记了老祖宗。该打，该打！“又忙携黛玉之手，问。”妹妹几岁了？可也上过学？现吃什么药？在这里不要想家，想要什么吃的，什么玩的，只管告诉我，丫头老婆们不好了，也只管告诉我。“一面又问婆子们。”林姑娘的行李东西可搬进来了？带了几个人来？你们赶早打扫两间下房，让他们去歇歇。“
#
#     说话时，已摆了茶果上来。熙凤亲为捧茶捧果。又见二舅母问他：“月钱放过了不曾？”熙凤道：“月钱已放完了。才刚带着人到后楼上找缎子，找了这半日，也并没有见昨日太太说的那样的，想是太太记错了？”王夫人道：“有没有，什么要紧。”因又说道：“该随手拿出两个来给你这妹妹去裁衣裳的，等晚上想着叫人再去拿罢，可别忘了。”熙凤道：“这倒是我先料着了，知道妹妹不过这两日到的，我已预备下了，等太太回去过了目好送来。”王夫人一笑，点头不语。
#
#     当下茶果已撤，贾母命两个老嬷嬷带了黛玉去见两个母舅。时贾赦之妻邢氏忙亦起身，笑回道：“我带了外甥女过去，倒也便宜。”贾母笑道：“正是呢，你也去罢，不必过来了。”邢夫人答应了一声“是”字，遂带了黛玉与王夫人作辞，大家送至穿堂前。出了垂花门，早有众小厮们拉过一辆翠幄青h车*，邢夫人携了黛玉，坐在上面，众婆子们放下车帘，方命小厮们抬起，拉至宽处，方驾上驯骡，亦出了西角门，往东过荣府正门，便入一黑油大门中，至仪门前方下来。众小厮退出，方打起车帘，邢夫人搀着黛玉的手，进入院中。黛玉度其房屋院宇，必是荣府中花园隔断过来的。进入三层仪门，果见正房厢庑游廊，悉皆小巧别致，不似方才那边轩峻壮丽，且院中随处之树木山石皆在。一时进入正室，早有许多盛妆丽服之姬妾丫鬟迎着，邢夫人让黛玉坐了，一面命人到外面书房去请贾赦。一时人来回话说：“老爷说了：连日身上不好，见了姑娘彼此倒伤心，暂且不忍相见。劝姑娘不要伤心想家，跟着老太太和舅母，即同家里一样。姊妹们虽拙，大家一处伴着，亦可以解些烦闷。或有委屈之处，只管说得，不要外道才是。'”黛玉忙站起来，一一听了。
#
#     再坐一刻，便告辞。邢夫人苦留吃过晚饭去，黛玉笑回道：“舅母爱惜赐饭，原不应辞，只是还要过去拜见二舅舅，恐领了赐去不恭，异日再领，未为不可。望舅母容谅。”邢夫人听说，笑道：“这倒是了。”遂令两三个嬷嬷用方才的车好生送了姑娘过去，于是黛玉告辞。邢夫人送至仪门前，又嘱咐了众人几句，眼看着车去了方回来。
#
#     一时黛玉进了荣府，下了车。众嬷嬷引着，便往东转弯，穿过一个东西的穿堂，向南大厅之后，仪门内大院落，上面五间大正房，两边厢房鹿顶耳房钻山，四通八达，轩昂壮丽，比贾母处不同。黛玉便知这方是正经正内室，一条大甬路，直接出大门的。进入堂屋中，抬头迎面先看见一个赤金九龙青地大匾，匾上写着斗大的三个大字，是“荣禧堂”，后有一行小字：“某年月日，书赐荣国公贾源”，又有“万几宸翰之宝”。大紫檀雕螭案上，设着三尺来高青绿古铜鼎，悬着待漏随朝墨龙大画，一边是金ы彝，一边是玻璃ニ。地下两溜十六张楠木交椅，又有一副对联，乃乌木联牌，镶着錾银的字迹，道是：
#
#     座上珠玑昭日月，堂前黼黻焕烟霞。下面一行小字，道是：“同乡世教弟勋袭东安郡王穆莳拜手书”。
#
#     原来王夫人时常居坐宴息，亦不在这正室，只在这正室东边的三间耳房内。于是老嬷嬷引黛玉进东房门来。临窗大炕上铺着猩红洋や，正面设着大红金钱蟒靠背，石青金钱蟒引枕，秋香色金钱蟒大条褥。两边设一对梅花式洋漆小几。左边几上文王鼎匙箸香盒，右边几上汝窑美人觚____觚内插着时鲜花卉，并茗碗痰盒等物。地下面西一溜四张椅上，都搭着银红撒花椅搭，底下四副脚踏。椅之两边，也有一对高几，几上茗碗瓶花俱备。其余陈设，自不必细说。老嬷嬷们让黛玉炕上坐，炕沿上却有两个锦褥对设，黛玉度其位次，便不上炕，只向东边椅子上坐了。本房内的丫鬟忙捧上茶来。黛玉一面吃茶，一面打谅这些丫鬟们，妆饰衣裙，举止行动，果亦与别家不同。
#
#     茶未吃了，只见一个穿红绫袄青缎掐牙背心的丫鬟走来笑说道：“太太说，请林姑娘到那边坐罢。”老嬷嬷听了，于是又引黛玉出来，到了东廊三间小正房内。正房炕上横设一张炕桌，桌上磊着书籍茶具，靠东壁面西设着半旧的青缎靠背引枕。王夫人却坐在西边下首，亦是半旧的青缎靠背坐褥。见黛玉来了，便往东让。黛玉心中料定这是贾政之位。因见挨炕一溜三张椅子上，也搭着半旧的弹墨椅袱，黛玉便向椅上坐了。王夫人再四携他上炕，他方挨王夫人坐了。王夫人因说：“你舅舅今日斋戒去了，再见罢。只是有一句话嘱咐你：你三个姊妹倒都极好，以后一处念书认字学针线，或是偶一顽笑，都有尽让的。但我不放心的最是一件：我有一个孽根祸胎，是家里的。混世魔王'，今日因庙里还愿去了，尚未回来，晚间你看见便知了。你只以后不要睬他，你这些姊妹都不敢沾惹他的。”
#
#     黛玉亦常听得母亲说过，二舅母生的有个表兄，乃衔玉而诞，顽劣异常，极恶读书，最喜在内帏厮混，外祖母又极溺爱，无人敢管。今见王夫人如此说，便知说的是这表兄了。因陪笑道：“舅母说的，可是衔玉所生的这位哥哥？在家时亦曾听见母亲常说，这位哥哥比我大一岁，小名就唤宝玉，虽极憨顽，说在姊妹情中极好的。况我来了，自然只和姊妹同处，兄弟们自是别院另室的，岂得去沾惹之理？”王夫人笑道：“你不知道原故：他与别人不同，自幼因老太太疼爱，原系同姊妹们一处娇养惯了的。若姊妹们有日不理他，他倒还安静些，纵然他没趣，不过出了二门，背地里拿着他两个小幺儿出气，咕唧一会子就完了。若这一日姊妹们和他多说一句话，他心里一乐，便生出多少事来。所以嘱咐你别睬他。他嘴里一时甜言蜜语，一时有天无日，一时又疯疯傻傻，只休信他。”
#
#     黛玉一一的都答应着。只见一个丫鬟来回：“老太太那里传晚饭了。”王夫人忙携黛玉从后房门由后廊往西，出了角门，是一条南北宽夹道。南边是倒座三间小小的抱厦厅，北边立着一个粉油大影壁，后有一半大门，小小一所房室。王夫人笑指向黛玉道：“这是你凤姐姐的屋子，回来你好往这里找他来，少什么东西，你只管和他说就是了。”这院门上也有四五个才总角的小厮，都垂手侍立。王夫人遂携黛玉穿过一个东西穿堂，便是贾母的后院了。于是，进入后房门，已有多人在此伺候，见王夫人来了，方安设桌椅。贾珠之妻李氏捧饭，熙凤安箸，王夫人进羹。贾母正面榻上独坐，两边四张空椅，熙凤忙拉了黛玉在左边第一张椅上坐了，黛玉十分推让。贾母笑道：“你舅母你嫂子们不在这里吃饭。你是客，原应如此坐的。”黛玉方告了座，坐了。贾母命王夫人坐了。迎春姊妹三个告了座方上来。迎春便坐右手第一，探春左第二，惜春右第二。旁边丫鬟执着拂尘，漱盂，巾帕。李，凤二人立于案旁布让。外间伺候之媳妇丫鬟虽多，却连一声咳嗽不闻。
#
#     寂然饭毕，各有丫鬟用小茶盘捧上茶来。当日林如海教女以惜福养身，云饭后务待饭粒咽尽，过一时再吃茶，方不伤脾胃。今黛玉见了这里许多事情不合家中之式，不得不随的，少不得一一改过来，因而接了茶。早见人又捧过漱盂来，黛玉也照样漱了口。プ手毕，又捧上茶来，这方是吃的茶。贾母便说：“你们去罢，让我们自在说话儿。”王夫人听了，忙起身，又说了两句闲话，方引凤，李二人去了。贾母因问黛玉念何书。黛玉道：“只刚念了lt;lt;四书gt;gt;。”黛玉又问姊妹们读何书。贾母道：“读的是什么书，不过是认得两个字，不是睁眼的瞎子罢了！”
#
#     一语未了，只听外面一阵脚步响，丫鬟进来笑道：“宝玉来了！”黛玉心中正疑惑着：“这个宝玉，不知是怎生个惫懒人物，懵懂顽童？”____倒不见那蠢物也罢了。心中想着，忽见丫鬟话未报完，已进来了一位年轻的公子：头上戴着束发嵌宝紫金冠，齐眉勒着二龙抢珠金抹额，穿一件二色金百蝶穿花大红箭袖，束着五彩丝攒花结长穗宫绦，外罩石青起花八团倭锻排穗褂，登着青缎粉底小朝靴。面若中秋之月，色如春晓之花，鬓若刀裁，眉如墨画，面如桃瓣，目若秋波。虽怒时而若笑，即视而有情。项上金螭璎珞，又有一根五色丝绦，系着一块美玉。黛玉一见，便吃一大惊，心下想道：“好生奇怪，倒象在那里见过一般，何等眼熟到如此！”只见这宝玉向贾母请了安，贾母便命：“去见你娘来。”宝玉即转身去了。一时回来，再看，已换了冠带：头上周围一转的短发，都结成小辫，红丝结束，共攒至顶中胎发，总编一根大辫，黑亮如漆，从顶至梢，一串四颗大珠，用金八宝坠角，身上穿着银红撒花半旧大袄，仍旧带着项圈，宝玉，寄名锁，护身符等物，下面半露松花撒花绫裤腿，锦边弹墨袜，厚底大红鞋。越显得面如敷粉，唇若施脂，转盼多情，语言常笑。天然一段风骚，全在眉梢，平生万种情思，悉堆眼角。看其外貌最是极好，却难知其底细。
#
#     后人有lt;lt;西江月gt;gt;二词，批宝玉极恰，其词曰：
#
#     无故寻愁觅恨，有时似傻如狂。纵然生得好皮囊，腹内
#
#     原来草莽。潦倒不通世务，愚顽怕读文章。行为偏僻
#
#     性乖张，那管世人诽谤！
#
#     富贵不知乐业，贫穷难耐凄凉。可怜辜负好韶光，于国于家无望。天下无能第一，古今不肖无双。寄言纨э
#
#     与膏粱：莫效此儿形状！
#
#     贾母因笑道：“外客未见，就脱了衣裳，还不去见你妹妹！”宝玉早已看见多了一个姊妹，便料定是林姑妈之女，忙来作揖。厮见毕归坐，细看形容，与众各别：两弯似蹙非蹙ズ烟眉，一双似喜非喜含情目。态生两ь之愁，娇袭一身之病。泪光点点，娇喘微微。闲静时如姣花照水，行动处似弱柳扶风。心较比干多一窍，病如西子胜三分。宝玉看罢，因笑道：“这个妹妹我曾见过的。”贾母笑道：“可又是胡说，你又何曾见过他？”宝玉笑道：“虽然未曾见过他，然我看着面善，心里就算是旧相识，今日只作远别重逢，亦未为不可。”贾母笑道：“更好，更好，若如此，更相和睦了。”宝玉便走近黛玉身边坐下，又细细打量一番，因问：“妹妹可曾读书？”黛玉道：“不曾读，只上了一年学，些须认得几个字。”宝玉又道：“妹妹尊名是那两个字？”黛玉便说了名。宝玉又问表字。
#
#     黛玉道：“无字。”宝玉笑道：“我送妹妹一妙字，莫若。颦颦'二字极妙。”探春便问何出。宝玉道：“lt;lt;古今人物通考gt;gt;上说：。西方有石名黛，可代画眉之墨。'况这林妹妹眉尖若蹙，用取这两个字，岂不两妙！”探春笑道：“只恐又是你的杜撰。”宝玉笑道：“除lt;lt;四书gt;gt;外，杜撰的太多，偏只我是杜撰不成？”又问黛玉：“可也有玉没有？”众人不解其语，黛玉便忖度着因他有玉，故问我有也无，因答道：“我没有那个。想来那玉是一件罕物，岂能人人有的。”宝玉听了，登时发作起痴狂病来，摘下那玉，就狠命摔去，骂道：“什么罕物，连人之高低不择，还说。通灵'不。通灵'呢！我也不要这劳什子了！”吓的众人一拥争去拾玉。贾母急的搂了宝玉道：“孽障！你生气，要打骂人容易，何苦摔那命根子！”宝玉满面泪痕泣道：“家里姐姐妹妹都没有，单我有，我说没趣，如今来了这们一个神仙似的妹妹也没有，可知这不是个好东西。”贾母忙哄他道：“你这妹妹原有这个来的，因你姑妈去世时，舍不得你妹妹，无法处，遂将他的玉带了去了：一则全殉葬之礼，尽你妹妹之孝心，二则你姑妈之灵，亦可权作见了女儿之意。因此他只说没有这个，不便自己夸张之意。
#
#     你如今怎比得他？还不好生慎重带上，仔细你娘知道了。“说着，便向丫鬟手中接来，亲与他带上。
#
#     宝玉听如此说，想一想大有情理，也就不生别论了。
#
#     当下，奶娘来请问黛玉之房舍。贾母说：“今将宝玉挪出来，同我在套间暖阁儿里，把你林姑娘暂安置碧纱橱里。等过了残冬，春天再与他们收拾房屋，另作一番安置罢。”宝玉道：“好祖宗，我就在碧纱橱外的床上很妥当，何必又出来闹的老祖宗不得安静。”贾母想了一想说：“也罢了。”每人一个奶娘并一个丫头照管，余者在外间上夜听唤。一面早有熙凤命人送了一顶藕合色花帐，并几件锦被缎褥之类。
#
#     黛玉只带了两个人来：一个是自幼奶娘王嬷嬷，一个是十岁的小丫头，亦是自幼随身的，名唤作雪雁。贾母见雪雁甚小，一团孩气，王嬷嬷又极老，料黛玉皆不遂心省力的，便将自己身边的一个二等丫头，名唤鹦哥者与了黛玉。外亦如迎春等例，每人除自幼乳母外，另有四个教引嬷嬷，除贴身掌管钗钏プ沐两个丫鬟外，另有五六个洒扫房屋来往使役的小丫鬟。当下，王嬷嬷与鹦哥陪侍黛玉在碧纱橱内。宝玉之乳母李嬷嬷，并大丫鬟名唤袭人者，陪侍在外面大床上。
#
#     原来这袭人亦是贾母之婢，本名珍珠。贾母因溺爱宝玉，生恐宝玉之婢无竭力尽忠之人，素喜袭人心地纯良，克尽职任，遂与了宝玉。宝玉因知他本姓花，又曾见旧人诗句上有“花气袭人”之句，遂回明贾母，更名袭人。这袭人亦有些痴处：伏侍贾母时，心中眼中只有一个贾母，如今服侍宝玉，心中眼中又只有一个宝玉。只因宝玉性情乖僻，每每规谏宝玉，心中着实忧郁。
#
#     是晚，宝玉李嬷嬷已睡了，他见里面黛玉和鹦哥犹未安息，他自卸了妆，悄悄进来，笑问：“姑娘怎么还不安息？”黛玉忙让：“姐姐请坐。”袭人在床沿上坐了。鹦哥笑道：“林姑娘正在这里伤心，自己淌眼抹泪的说：。今儿才来，就惹出你家哥儿的狂病，倘或摔坏了那玉，岂不是因我之过！'因此便伤心，我好容易劝好了”。袭人道：“姑娘快休如此，将来只怕比这个更奇怪的笑话儿还有呢！若为他这种行止，你多心伤感，只怕你伤感不了呢。快别多心！”黛玉道：“姐姐们说的，我记着就是了。究竟那玉不知是怎么个来历？上面还有字迹？”袭人道：“连一家子也不知来历，上头还有现成的眼儿，听得说，落草时是从他口里掏出来的。等我拿来你看便知。”黛玉忙止道：“罢了，此刻夜深，明日再看也不迟。”大家又叙了一回，方才安歇。
#
#     次日起来，省过贾母，因往王夫人处来，正值王夫人与熙凤在一处拆金陵来的书信看，又有王夫人之兄嫂处遣了两个媳妇来说话的。黛玉虽不知原委，探春等却都晓得是议论金陵城中所居的薛家姨母之子姨表兄薛蟠，倚财仗势，打死人命，现在应天府案下审理。如今母舅王子腾得了信息，故遣他家内的人来告诉这边，意欲唤取进京之意。'''
#
