"""
we’ve loaded a modified version of FiveThirtyEight’s Candy Power Ranking data. Here, we have a rating column that’s binary and indicates whether or not a candy had a winning percentage >= 50% (1) or not (0). Using the rating column as the target variable and the rest of the columns (barring winpercent and competitorname) as the predictor variables, we’ve trained and tested a logistic regression model.

Calculate the area under the ROC curve that this model would generate and save it as roc_auc
Use the roc_curve function in scikit-learn to get the thresholds corresponding to different false and true positive rates. Find the optimal value of the threshold that gives us the best classification model among the list generated by the function and save it as optimal_threshold.
"""

import pandas as pd
import numpy as np
from sklearn.linear_model import LogisticRegression
from sklearn.model_selection import train_test_split
from sklearn.metrics import roc_curve, roc_auc_score

df = pd.read_csv('candy_rating_binary.csv')
#print(df.head())

#Define target and predictor variables
y = df.rating
X = df[['chocolate', 'fruity', 'caramel', 'peanutyalmondy',
       'nougat', 'crispedricewafer', 'hard', 'bar', 'pluribus', 'sugarpercent',
       'pricepercent']]

#Train-test split and fit a LR model
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.2, random_state=23)
lr = LogisticRegression()
lr.fit(X_train,y_train)

# Predict the probabilities of positive class
y_score = lr.predict_proba(X_test)[:,1]

# Calculate the ROC AUC
roc_auc = roc_auc_score(y_test, y_score)
print(f'ROC AUC score: {roc_auc}')

# Get the False Positive Rate, True Posisive Rate and Thresholds
fpr, tpr, thresholds = roc_curve(y_test, y_score)

# Get the optimal threshold
optimal_idx = np.argmax(tpr - fpr)
optimal_threshold = thresholds[optimal_idx]
print(f'Optimal threshold value: {optimal_threshold}')


