#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *


class AlipayOpenMiniOrderInstallmentCloseModel(object):

    def __init__(self):
        self._installment_order_id = None
        self._open_id = None
        self._order_id = None
        self._out_installment_order_id = None
        self._out_order_id = None
        self._user_id = None

    @property
    def installment_order_id(self):
        return self._installment_order_id

    @installment_order_id.setter
    def installment_order_id(self, value):
        self._installment_order_id = value
    @property
    def open_id(self):
        return self._open_id

    @open_id.setter
    def open_id(self, value):
        self._open_id = value
    @property
    def order_id(self):
        return self._order_id

    @order_id.setter
    def order_id(self, value):
        self._order_id = value
    @property
    def out_installment_order_id(self):
        return self._out_installment_order_id

    @out_installment_order_id.setter
    def out_installment_order_id(self, value):
        self._out_installment_order_id = value
    @property
    def out_order_id(self):
        return self._out_order_id

    @out_order_id.setter
    def out_order_id(self, value):
        self._out_order_id = value
    @property
    def user_id(self):
        return self._user_id

    @user_id.setter
    def user_id(self, value):
        self._user_id = value


    def to_alipay_dict(self):
        params = dict()
        if self.installment_order_id:
            if hasattr(self.installment_order_id, 'to_alipay_dict'):
                params['installment_order_id'] = self.installment_order_id.to_alipay_dict()
            else:
                params['installment_order_id'] = self.installment_order_id
        if self.open_id:
            if hasattr(self.open_id, 'to_alipay_dict'):
                params['open_id'] = self.open_id.to_alipay_dict()
            else:
                params['open_id'] = self.open_id
        if self.order_id:
            if hasattr(self.order_id, 'to_alipay_dict'):
                params['order_id'] = self.order_id.to_alipay_dict()
            else:
                params['order_id'] = self.order_id
        if self.out_installment_order_id:
            if hasattr(self.out_installment_order_id, 'to_alipay_dict'):
                params['out_installment_order_id'] = self.out_installment_order_id.to_alipay_dict()
            else:
                params['out_installment_order_id'] = self.out_installment_order_id
        if self.out_order_id:
            if hasattr(self.out_order_id, 'to_alipay_dict'):
                params['out_order_id'] = self.out_order_id.to_alipay_dict()
            else:
                params['out_order_id'] = self.out_order_id
        if self.user_id:
            if hasattr(self.user_id, 'to_alipay_dict'):
                params['user_id'] = self.user_id.to_alipay_dict()
            else:
                params['user_id'] = self.user_id
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = AlipayOpenMiniOrderInstallmentCloseModel()
        if 'installment_order_id' in d:
            o.installment_order_id = d['installment_order_id']
        if 'open_id' in d:
            o.open_id = d['open_id']
        if 'order_id' in d:
            o.order_id = d['order_id']
        if 'out_installment_order_id' in d:
            o.out_installment_order_id = d['out_installment_order_id']
        if 'out_order_id' in d:
            o.out_order_id = d['out_order_id']
        if 'user_id' in d:
            o.user_id = d['user_id']
        return o


