#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *
from alipay.aop.api.domain.CcCrowdOperations import CcCrowdOperations


class CcSyncCrowdInfo(object):

    def __init__(self):
        self._app_name = None
        self._app_token = None
        self._biz_code = None
        self._operations = None
        self._target_id = None
        self._target_type = None

    @property
    def app_name(self):
        return self._app_name

    @app_name.setter
    def app_name(self, value):
        self._app_name = value
    @property
    def app_token(self):
        return self._app_token

    @app_token.setter
    def app_token(self, value):
        self._app_token = value
    @property
    def biz_code(self):
        return self._biz_code

    @biz_code.setter
    def biz_code(self, value):
        self._biz_code = value
    @property
    def operations(self):
        return self._operations

    @operations.setter
    def operations(self, value):
        if isinstance(value, list):
            self._operations = list()
            for i in value:
                if isinstance(i, CcCrowdOperations):
                    self._operations.append(i)
                else:
                    self._operations.append(CcCrowdOperations.from_alipay_dict(i))
    @property
    def target_id(self):
        return self._target_id

    @target_id.setter
    def target_id(self, value):
        self._target_id = value
    @property
    def target_type(self):
        return self._target_type

    @target_type.setter
    def target_type(self, value):
        self._target_type = value


    def to_alipay_dict(self):
        params = dict()
        if self.app_name:
            if hasattr(self.app_name, 'to_alipay_dict'):
                params['app_name'] = self.app_name.to_alipay_dict()
            else:
                params['app_name'] = self.app_name
        if self.app_token:
            if hasattr(self.app_token, 'to_alipay_dict'):
                params['app_token'] = self.app_token.to_alipay_dict()
            else:
                params['app_token'] = self.app_token
        if self.biz_code:
            if hasattr(self.biz_code, 'to_alipay_dict'):
                params['biz_code'] = self.biz_code.to_alipay_dict()
            else:
                params['biz_code'] = self.biz_code
        if self.operations:
            if isinstance(self.operations, list):
                for i in range(0, len(self.operations)):
                    element = self.operations[i]
                    if hasattr(element, 'to_alipay_dict'):
                        self.operations[i] = element.to_alipay_dict()
            if hasattr(self.operations, 'to_alipay_dict'):
                params['operations'] = self.operations.to_alipay_dict()
            else:
                params['operations'] = self.operations
        if self.target_id:
            if hasattr(self.target_id, 'to_alipay_dict'):
                params['target_id'] = self.target_id.to_alipay_dict()
            else:
                params['target_id'] = self.target_id
        if self.target_type:
            if hasattr(self.target_type, 'to_alipay_dict'):
                params['target_type'] = self.target_type.to_alipay_dict()
            else:
                params['target_type'] = self.target_type
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = CcSyncCrowdInfo()
        if 'app_name' in d:
            o.app_name = d['app_name']
        if 'app_token' in d:
            o.app_token = d['app_token']
        if 'biz_code' in d:
            o.biz_code = d['biz_code']
        if 'operations' in d:
            o.operations = d['operations']
        if 'target_id' in d:
            o.target_id = d['target_id']
        if 'target_type' in d:
            o.target_type = d['target_type']
        return o


