#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *


class InstallmentPlan(object):

    def __init__(self):
        self._end_date = None
        self._installment_no = None
        self._interest = None
        self._principal = None
        self._promotion_amount = None
        self._total_amount = None

    @property
    def end_date(self):
        return self._end_date

    @end_date.setter
    def end_date(self, value):
        self._end_date = value
    @property
    def installment_no(self):
        return self._installment_no

    @installment_no.setter
    def installment_no(self, value):
        self._installment_no = value
    @property
    def interest(self):
        return self._interest

    @interest.setter
    def interest(self, value):
        self._interest = value
    @property
    def principal(self):
        return self._principal

    @principal.setter
    def principal(self, value):
        self._principal = value
    @property
    def promotion_amount(self):
        return self._promotion_amount

    @promotion_amount.setter
    def promotion_amount(self, value):
        self._promotion_amount = value
    @property
    def total_amount(self):
        return self._total_amount

    @total_amount.setter
    def total_amount(self, value):
        self._total_amount = value


    def to_alipay_dict(self):
        params = dict()
        if self.end_date:
            if hasattr(self.end_date, 'to_alipay_dict'):
                params['end_date'] = self.end_date.to_alipay_dict()
            else:
                params['end_date'] = self.end_date
        if self.installment_no:
            if hasattr(self.installment_no, 'to_alipay_dict'):
                params['installment_no'] = self.installment_no.to_alipay_dict()
            else:
                params['installment_no'] = self.installment_no
        if self.interest:
            if hasattr(self.interest, 'to_alipay_dict'):
                params['interest'] = self.interest.to_alipay_dict()
            else:
                params['interest'] = self.interest
        if self.principal:
            if hasattr(self.principal, 'to_alipay_dict'):
                params['principal'] = self.principal.to_alipay_dict()
            else:
                params['principal'] = self.principal
        if self.promotion_amount:
            if hasattr(self.promotion_amount, 'to_alipay_dict'):
                params['promotion_amount'] = self.promotion_amount.to_alipay_dict()
            else:
                params['promotion_amount'] = self.promotion_amount
        if self.total_amount:
            if hasattr(self.total_amount, 'to_alipay_dict'):
                params['total_amount'] = self.total_amount.to_alipay_dict()
            else:
                params['total_amount'] = self.total_amount
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = InstallmentPlan()
        if 'end_date' in d:
            o.end_date = d['end_date']
        if 'installment_no' in d:
            o.installment_no = d['installment_no']
        if 'interest' in d:
            o.interest = d['interest']
        if 'principal' in d:
            o.principal = d['principal']
        if 'promotion_amount' in d:
            o.promotion_amount = d['promotion_amount']
        if 'total_amount' in d:
            o.total_amount = d['total_amount']
        return o


