#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.response.AlipayResponse import AlipayResponse
from alipay.aop.api.domain.CfbudmacBizBudgetDTO import CfbudmacBizBudgetDTO


class MyxiaojinFinanceBudgetBatchqueryResponse(AlipayResponse):

    def __init__(self):
        super(MyxiaojinFinanceBudgetBatchqueryResponse, self).__init__()
        self._page_num = None
        self._page_size = None
        self._result_data = None
        self._result_msg = None
        self._total_count = None

    @property
    def page_num(self):
        return self._page_num

    @page_num.setter
    def page_num(self, value):
        self._page_num = value
    @property
    def page_size(self):
        return self._page_size

    @page_size.setter
    def page_size(self, value):
        self._page_size = value
    @property
    def result_data(self):
        return self._result_data

    @result_data.setter
    def result_data(self, value):
        if isinstance(value, list):
            self._result_data = list()
            for i in value:
                if isinstance(i, CfbudmacBizBudgetDTO):
                    self._result_data.append(i)
                else:
                    self._result_data.append(CfbudmacBizBudgetDTO.from_alipay_dict(i))
    @property
    def result_msg(self):
        return self._result_msg

    @result_msg.setter
    def result_msg(self, value):
        self._result_msg = value
    @property
    def total_count(self):
        return self._total_count

    @total_count.setter
    def total_count(self, value):
        self._total_count = value

    def parse_response_content(self, response_content):
        response = super(MyxiaojinFinanceBudgetBatchqueryResponse, self).parse_response_content(response_content)
        if 'page_num' in response:
            self.page_num = response['page_num']
        if 'page_size' in response:
            self.page_size = response['page_size']
        if 'result_data' in response:
            self.result_data = response['result_data']
        if 'result_msg' in response:
            self.result_msg = response['result_msg']
        if 'total_count' in response:
            self.total_count = response['total_count']
