#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *
from alipay.aop.api.domain.MiniRefundGoodsInfoDTO import MiniRefundGoodsInfoDTO


class AlipayOpenMiniOrderRefundModel(object):

    def __init__(self):
        self._installment_order_id = None
        self._item_infos = None
        self._open_id = None
        self._order_id = None
        self._out_order_id = None
        self._out_refund_id = None
        self._refund = None
        self._refund_reason = None
        self._user_id = None

    @property
    def installment_order_id(self):
        return self._installment_order_id

    @installment_order_id.setter
    def installment_order_id(self, value):
        self._installment_order_id = value
    @property
    def item_infos(self):
        return self._item_infos

    @item_infos.setter
    def item_infos(self, value):
        if isinstance(value, list):
            self._item_infos = list()
            for i in value:
                if isinstance(i, MiniRefundGoodsInfoDTO):
                    self._item_infos.append(i)
                else:
                    self._item_infos.append(MiniRefundGoodsInfoDTO.from_alipay_dict(i))
    @property
    def open_id(self):
        return self._open_id

    @open_id.setter
    def open_id(self, value):
        self._open_id = value
    @property
    def order_id(self):
        return self._order_id

    @order_id.setter
    def order_id(self, value):
        self._order_id = value
    @property
    def out_order_id(self):
        return self._out_order_id

    @out_order_id.setter
    def out_order_id(self, value):
        self._out_order_id = value
    @property
    def out_refund_id(self):
        return self._out_refund_id

    @out_refund_id.setter
    def out_refund_id(self, value):
        self._out_refund_id = value
    @property
    def refund(self):
        return self._refund

    @refund.setter
    def refund(self, value):
        self._refund = value
    @property
    def refund_reason(self):
        return self._refund_reason

    @refund_reason.setter
    def refund_reason(self, value):
        self._refund_reason = value
    @property
    def user_id(self):
        return self._user_id

    @user_id.setter
    def user_id(self, value):
        self._user_id = value


    def to_alipay_dict(self):
        params = dict()
        if self.installment_order_id:
            if hasattr(self.installment_order_id, 'to_alipay_dict'):
                params['installment_order_id'] = self.installment_order_id.to_alipay_dict()
            else:
                params['installment_order_id'] = self.installment_order_id
        if self.item_infos:
            if isinstance(self.item_infos, list):
                for i in range(0, len(self.item_infos)):
                    element = self.item_infos[i]
                    if hasattr(element, 'to_alipay_dict'):
                        self.item_infos[i] = element.to_alipay_dict()
            if hasattr(self.item_infos, 'to_alipay_dict'):
                params['item_infos'] = self.item_infos.to_alipay_dict()
            else:
                params['item_infos'] = self.item_infos
        if self.open_id:
            if hasattr(self.open_id, 'to_alipay_dict'):
                params['open_id'] = self.open_id.to_alipay_dict()
            else:
                params['open_id'] = self.open_id
        if self.order_id:
            if hasattr(self.order_id, 'to_alipay_dict'):
                params['order_id'] = self.order_id.to_alipay_dict()
            else:
                params['order_id'] = self.order_id
        if self.out_order_id:
            if hasattr(self.out_order_id, 'to_alipay_dict'):
                params['out_order_id'] = self.out_order_id.to_alipay_dict()
            else:
                params['out_order_id'] = self.out_order_id
        if self.out_refund_id:
            if hasattr(self.out_refund_id, 'to_alipay_dict'):
                params['out_refund_id'] = self.out_refund_id.to_alipay_dict()
            else:
                params['out_refund_id'] = self.out_refund_id
        if self.refund:
            if hasattr(self.refund, 'to_alipay_dict'):
                params['refund'] = self.refund.to_alipay_dict()
            else:
                params['refund'] = self.refund
        if self.refund_reason:
            if hasattr(self.refund_reason, 'to_alipay_dict'):
                params['refund_reason'] = self.refund_reason.to_alipay_dict()
            else:
                params['refund_reason'] = self.refund_reason
        if self.user_id:
            if hasattr(self.user_id, 'to_alipay_dict'):
                params['user_id'] = self.user_id.to_alipay_dict()
            else:
                params['user_id'] = self.user_id
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = AlipayOpenMiniOrderRefundModel()
        if 'installment_order_id' in d:
            o.installment_order_id = d['installment_order_id']
        if 'item_infos' in d:
            o.item_infos = d['item_infos']
        if 'open_id' in d:
            o.open_id = d['open_id']
        if 'order_id' in d:
            o.order_id = d['order_id']
        if 'out_order_id' in d:
            o.out_order_id = d['out_order_id']
        if 'out_refund_id' in d:
            o.out_refund_id = d['out_refund_id']
        if 'refund' in d:
            o.refund = d['refund']
        if 'refund_reason' in d:
            o.refund_reason = d['refund_reason']
        if 'user_id' in d:
            o.user_id = d['user_id']
        return o


