#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *
from alipay.aop.api.domain.OpenApiRefundFundDetailPojo import OpenApiRefundFundDetailPojo


class AlipayTradeRefundApplyModel(object):

    def __init__(self):
        self._extend_params = None
        self._operator_id = None
        self._out_request_no = None
        self._out_trade_no = None
        self._refund_amount = None
        self._refund_fund_details = None
        self._refund_reason = None
        self._store_id = None
        self._terminal_id = None
        self._trade_no = None

    @property
    def extend_params(self):
        return self._extend_params

    @extend_params.setter
    def extend_params(self, value):
        self._extend_params = value
    @property
    def operator_id(self):
        return self._operator_id

    @operator_id.setter
    def operator_id(self, value):
        self._operator_id = value
    @property
    def out_request_no(self):
        return self._out_request_no

    @out_request_no.setter
    def out_request_no(self, value):
        self._out_request_no = value
    @property
    def out_trade_no(self):
        return self._out_trade_no

    @out_trade_no.setter
    def out_trade_no(self, value):
        self._out_trade_no = value
    @property
    def refund_amount(self):
        return self._refund_amount

    @refund_amount.setter
    def refund_amount(self, value):
        self._refund_amount = value
    @property
    def refund_fund_details(self):
        return self._refund_fund_details

    @refund_fund_details.setter
    def refund_fund_details(self, value):
        if isinstance(value, list):
            self._refund_fund_details = list()
            for i in value:
                if isinstance(i, OpenApiRefundFundDetailPojo):
                    self._refund_fund_details.append(i)
                else:
                    self._refund_fund_details.append(OpenApiRefundFundDetailPojo.from_alipay_dict(i))
    @property
    def refund_reason(self):
        return self._refund_reason

    @refund_reason.setter
    def refund_reason(self, value):
        self._refund_reason = value
    @property
    def store_id(self):
        return self._store_id

    @store_id.setter
    def store_id(self, value):
        self._store_id = value
    @property
    def terminal_id(self):
        return self._terminal_id

    @terminal_id.setter
    def terminal_id(self, value):
        self._terminal_id = value
    @property
    def trade_no(self):
        return self._trade_no

    @trade_no.setter
    def trade_no(self, value):
        self._trade_no = value


    def to_alipay_dict(self):
        params = dict()
        if self.extend_params:
            if hasattr(self.extend_params, 'to_alipay_dict'):
                params['extend_params'] = self.extend_params.to_alipay_dict()
            else:
                params['extend_params'] = self.extend_params
        if self.operator_id:
            if hasattr(self.operator_id, 'to_alipay_dict'):
                params['operator_id'] = self.operator_id.to_alipay_dict()
            else:
                params['operator_id'] = self.operator_id
        if self.out_request_no:
            if hasattr(self.out_request_no, 'to_alipay_dict'):
                params['out_request_no'] = self.out_request_no.to_alipay_dict()
            else:
                params['out_request_no'] = self.out_request_no
        if self.out_trade_no:
            if hasattr(self.out_trade_no, 'to_alipay_dict'):
                params['out_trade_no'] = self.out_trade_no.to_alipay_dict()
            else:
                params['out_trade_no'] = self.out_trade_no
        if self.refund_amount:
            if hasattr(self.refund_amount, 'to_alipay_dict'):
                params['refund_amount'] = self.refund_amount.to_alipay_dict()
            else:
                params['refund_amount'] = self.refund_amount
        if self.refund_fund_details:
            if isinstance(self.refund_fund_details, list):
                for i in range(0, len(self.refund_fund_details)):
                    element = self.refund_fund_details[i]
                    if hasattr(element, 'to_alipay_dict'):
                        self.refund_fund_details[i] = element.to_alipay_dict()
            if hasattr(self.refund_fund_details, 'to_alipay_dict'):
                params['refund_fund_details'] = self.refund_fund_details.to_alipay_dict()
            else:
                params['refund_fund_details'] = self.refund_fund_details
        if self.refund_reason:
            if hasattr(self.refund_reason, 'to_alipay_dict'):
                params['refund_reason'] = self.refund_reason.to_alipay_dict()
            else:
                params['refund_reason'] = self.refund_reason
        if self.store_id:
            if hasattr(self.store_id, 'to_alipay_dict'):
                params['store_id'] = self.store_id.to_alipay_dict()
            else:
                params['store_id'] = self.store_id
        if self.terminal_id:
            if hasattr(self.terminal_id, 'to_alipay_dict'):
                params['terminal_id'] = self.terminal_id.to_alipay_dict()
            else:
                params['terminal_id'] = self.terminal_id
        if self.trade_no:
            if hasattr(self.trade_no, 'to_alipay_dict'):
                params['trade_no'] = self.trade_no.to_alipay_dict()
            else:
                params['trade_no'] = self.trade_no
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = AlipayTradeRefundApplyModel()
        if 'extend_params' in d:
            o.extend_params = d['extend_params']
        if 'operator_id' in d:
            o.operator_id = d['operator_id']
        if 'out_request_no' in d:
            o.out_request_no = d['out_request_no']
        if 'out_trade_no' in d:
            o.out_trade_no = d['out_trade_no']
        if 'refund_amount' in d:
            o.refund_amount = d['refund_amount']
        if 'refund_fund_details' in d:
            o.refund_fund_details = d['refund_fund_details']
        if 'refund_reason' in d:
            o.refund_reason = d['refund_reason']
        if 'store_id' in d:
            o.store_id = d['store_id']
        if 'terminal_id' in d:
            o.terminal_id = d['terminal_id']
        if 'trade_no' in d:
            o.trade_no = d['trade_no']
        return o


