# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest
class CreateClusterRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'Emr', '2016-04-08', 'CreateCluster')

	def get_EcsOrder(self):
		return self.get_query_params().get('EcsOrder')

	def set_EcsOrder(self,EcsOrder):
		"""
		this.ecsOrders = ecsOrders;
		for (int i = 0; i < ecsOrders.size(); i++) {
			putQueryParameter("EcsOrder." + (i + 1) + ".Index" , ecsOrders.get(i).getIndex());
			putQueryParameter("EcsOrder." + (i + 1) + ".NodeCount" , ecsOrders.get(i).getNodeCount());
			putQueryParameter("EcsOrder." + (i + 1) + ".NodeType" , ecsOrders.get(i).getNodeType());
			putQueryParameter("EcsOrder." + (i + 1) + ".InstanceType" , ecsOrders.get(i).getInstanceType());
			putQueryParameter("EcsOrder." + (i + 1) + ".DiskType" , ecsOrders.get(i).getDiskType());
			putQueryParameter("EcsOrder." + (i + 1) + ".DiskCapacity" , ecsOrders.get(i).getDiskCapacity());
			putQueryParameter("EcsOrder." + (i + 1) + ".DiskCount" , ecsOrders.get(i).getDiskCount());
		}
		:param EcsOrder:
		:return:
		"""
		# self.add_query_param('EcsOrder',EcsOrder)
		for i in range(0, len(EcsOrder)):
			self.add_query_param('EcsOrder.' + str(i + 1) + ".Index", EcsOrder[i]['Index'])
			self.add_query_param('EcsOrder.' + str(i + 1) + ".NodeCount", EcsOrder[i]['NodeCount'])
			self.add_query_param('EcsOrder.' + str(i + 1) + ".NodeType", EcsOrder[i]['NodeType'])
			self.add_query_param('EcsOrder.' + str(i + 1) + ".InstanceType", EcsOrder[i]['InstanceType'])
			self.add_query_param('EcsOrder.' + str(i + 1) + ".DiskType", EcsOrder[i]['DiskType'])
			self.add_query_param('EcsOrder.' + str(i + 1) + ".DiskCapacity", EcsOrder[i]['DiskCapacity'])
			self.add_query_param('EcsOrder.' + str(i + 1) + ".DiskCount", EcsOrder[i]['DiskCount'])


	def get_BootstrapAction(self):
		return self.get_query_params().get('BootstrapAction')

	def set_BootstrapAction(self,BootstrapAction):
		self.add_query_param('BootstrapAction',BootstrapAction)

	def get_ResourceOwnerId(self):
		return self.get_query_params().get('ResourceOwnerId')

	def set_ResourceOwnerId(self,ResourceOwnerId):
		self.add_query_param('ResourceOwnerId',ResourceOwnerId)

	def get_Name(self):
		return self.get_query_params().get('Name')

	def set_Name(self,Name):
		self.add_query_param('Name',Name)

	def get_ZoneId(self):
		return self.get_query_params().get('ZoneId')

	def set_ZoneId(self,ZoneId):
		self.add_query_param('ZoneId',ZoneId)

	def get_LogEnable(self):
		return self.get_query_params().get('LogEnable')

	def set_LogEnable(self,LogEnable):
		self.add_query_param('LogEnable',LogEnable)

	def get_LogPath(self):
		return self.get_query_params().get('LogPath')

	def set_LogPath(self,LogPath):
		self.add_query_param('LogPath',LogPath)

	def get_SecurityGroupId(self):
		return self.get_query_params().get('SecurityGroupId')

	def set_SecurityGroupId(self,SecurityGroupId):
		self.add_query_param('SecurityGroupId',SecurityGroupId)

	def get_IsOpenPublicIp(self):
		return self.get_query_params().get('IsOpenPublicIp')

	def set_IsOpenPublicIp(self,IsOpenPublicIp):
		self.add_query_param('IsOpenPublicIp',IsOpenPublicIp)

	def get_SecurityGroupName(self):
		return self.get_query_params().get('SecurityGroupName')

	def set_SecurityGroupName(self,SecurityGroupName):
		self.add_query_param('SecurityGroupName',SecurityGroupName)

	def get_ChargeType(self):
		return self.get_query_params().get('ChargeType')

	def set_ChargeType(self,ChargeType):
		self.add_query_param('ChargeType',ChargeType)

	def get_Period(self):
		return self.get_query_params().get('Period')

	def set_Period(self,Period):
		self.add_query_param('Period',Period)

	def get_AutoRenew(self):
		return self.get_query_params().get('AutoRenew')

	def set_AutoRenew(self,AutoRenew):
		self.add_query_param('AutoRenew',AutoRenew)

	def get_AutoRenewPeriod(self):
		return self.get_query_params().get('AutoRenewPeriod')

	def set_AutoRenewPeriod(self,AutoRenewPeriod):
		self.add_query_param('AutoRenewPeriod',AutoRenewPeriod)

	def get_VpcId(self):
		return self.get_query_params().get('VpcId')

	def set_VpcId(self,VpcId):
		self.add_query_param('VpcId',VpcId)

	def get_VSwitchId(self):
		return self.get_query_params().get('VSwitchId')

	def set_VSwitchId(self,VSwitchId):
		self.add_query_param('VSwitchId',VSwitchId)

	def get_NetType(self):
		return self.get_query_params().get('NetType')

	def set_NetType(self,NetType):
		self.add_query_param('NetType',NetType)

	def get_EmrVer(self):
		return self.get_query_params().get('EmrVer')

	def set_EmrVer(self,EmrVer):
		self.add_query_param('EmrVer',EmrVer)

	def get_ClusterType(self):
		return self.get_query_params().get('ClusterType')

	def set_ClusterType(self,ClusterType):
		self.add_query_param('ClusterType',ClusterType)

	def get_HighAvailableEnable(self):
		return self.get_query_params().get('HighAvailableEnable')

	def set_HighAvailableEnable(self,HighAvailableEnable):
		self.add_query_param('HighAvailableEnable',HighAvailableEnable)

	def get_MasterPwdEnable(self):
		return self.get_query_params().get('MasterPwdEnable')

	def set_MasterPwdEnable(self,MasterPwdEnable):
		self.add_query_param('MasterPwdEnable',MasterPwdEnable)

	def get_MasterPwd(self):
		return self.get_query_params().get('MasterPwd')

	def set_MasterPwd(self,MasterPwd):
		self.add_query_param('MasterPwd',MasterPwd)

	def get_Configurations(self):
		return self.get_query_params().get('Configurations')

	def set_Configurations(self,Configurations):
		self.add_query_param('Configurations',Configurations)


	def get_RegionId(self):
		return self.get_query_params().get('RegionId')

	def set_RegionId(self, RegionId):
		self.add_query_param('RegionId', RegionId)
