# coding: utf-8

"""
    allure-testops-service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 525u01
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from allure_client.models.environment_set_dto import EnvironmentSetDto
from allure_client.models.external_link_dto import ExternalLinkDto
from allure_client.models.issue_dto import IssueDto
from allure_client.models.job_mapping import JobMapping
from allure_client.models.job_parameter_dto import JobParameterDto
from allure_client.models.launch_tag_dto import LaunchTagDto
from allure_client.models.test_case_selection_dto_v2 import TestCaseSelectionDtoV2
from typing import Optional, Set
from typing_extensions import Self

class TestCaseRunBulkNewLaunchDto(BaseModel):
    """
    TestCaseRunBulkNewLaunchDto
    """ # noqa: E501
    jobs_mapping: Optional[List[JobMapping]] = Field(default=None, alias="jobsMapping")
    launch_name: Annotated[str, Field(min_length=1, strict=True, max_length=255)] = Field(alias="launchName")
    env_var_value_sets: Optional[List[EnvironmentSetDto]] = Field(default=None, alias="envVarValueSets")
    tree_folder: Optional[StrictBool] = Field(default=None, alias="treeFolder")
    selection: TestCaseSelectionDtoV2
    release_id: Optional[StrictInt] = Field(default=None, alias="releaseId")
    jobs_params: Optional[List[JobParameterDto]] = Field(default=None, alias="jobsParams")
    assignees: Optional[List[StrictStr]] = None
    links: Optional[List[ExternalLinkDto]] = None
    issues: Optional[List[IssueDto]] = None
    tags: Optional[List[LaunchTagDto]] = None
    __properties: ClassVar[List[str]] = ["jobsMapping", "launchName", "envVarValueSets", "treeFolder", "selection", "releaseId", "jobsParams", "assignees", "links", "issues", "tags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestCaseRunBulkNewLaunchDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in jobs_mapping (list)
        _items = []
        if self.jobs_mapping:
            for _item_jobs_mapping in self.jobs_mapping:
                if _item_jobs_mapping:
                    _items.append(_item_jobs_mapping.to_dict())
            _dict['jobsMapping'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in env_var_value_sets (list)
        _items = []
        if self.env_var_value_sets:
            for _item_env_var_value_sets in self.env_var_value_sets:
                if _item_env_var_value_sets:
                    _items.append(_item_env_var_value_sets.to_dict())
            _dict['envVarValueSets'] = _items
        # override the default output from pydantic by calling `to_dict()` of selection
        if self.selection:
            _dict['selection'] = self.selection.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in jobs_params (list)
        _items = []
        if self.jobs_params:
            for _item_jobs_params in self.jobs_params:
                if _item_jobs_params:
                    _items.append(_item_jobs_params.to_dict())
            _dict['jobsParams'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item_links in self.links:
                if _item_links:
                    _items.append(_item_links.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in issues (list)
        _items = []
        if self.issues:
            for _item_issues in self.issues:
                if _item_issues:
                    _items.append(_item_issues.to_dict())
            _dict['issues'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestCaseRunBulkNewLaunchDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "jobsMapping": [JobMapping.from_dict(_item) for _item in obj["jobsMapping"]] if obj.get("jobsMapping") is not None else None,
            "launchName": obj.get("launchName"),
            "envVarValueSets": [EnvironmentSetDto.from_dict(_item) for _item in obj["envVarValueSets"]] if obj.get("envVarValueSets") is not None else None,
            "treeFolder": obj.get("treeFolder"),
            "selection": TestCaseSelectionDtoV2.from_dict(obj["selection"]) if obj.get("selection") is not None else None,
            "releaseId": obj.get("releaseId"),
            "jobsParams": [JobParameterDto.from_dict(_item) for _item in obj["jobsParams"]] if obj.get("jobsParams") is not None else None,
            "assignees": obj.get("assignees"),
            "links": [ExternalLinkDto.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
            "issues": [IssueDto.from_dict(_item) for _item in obj["issues"]] if obj.get("issues") is not None else None,
            "tags": [LaunchTagDto.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None
        })
        return _obj


