# coding: utf-8

"""
    allure-testops-service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 525u01
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from allure_client.models.defect_issue_link_dto import DefectIssueLinkDto
from allure_client.models.issue_to_create_dto import IssueToCreateDto
from allure_client.models.test_result_defect_matcher_dto import TestResultDefectMatcherDto
from typing import Optional, Set
from typing_extensions import Self

class TestResultNewDefectDto(BaseModel):
    """
    TestResultNewDefectDto
    """ # noqa: E501
    issue: Optional[IssueToCreateDto] = None
    link_issue: Optional[DefectIssueLinkDto] = Field(default=None, alias="linkIssue")
    name: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None
    description: Optional[StrictStr] = None
    matcher: Optional[TestResultDefectMatcherDto] = None
    __properties: ClassVar[List[str]] = ["issue", "linkIssue", "name", "description", "matcher"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestResultNewDefectDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of issue
        if self.issue:
            _dict['issue'] = self.issue.to_dict()
        # override the default output from pydantic by calling `to_dict()` of link_issue
        if self.link_issue:
            _dict['linkIssue'] = self.link_issue.to_dict()
        # override the default output from pydantic by calling `to_dict()` of matcher
        if self.matcher:
            _dict['matcher'] = self.matcher.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestResultNewDefectDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "issue": IssueToCreateDto.from_dict(obj["issue"]) if obj.get("issue") is not None else None,
            "linkIssue": DefectIssueLinkDto.from_dict(obj["linkIssue"]) if obj.get("linkIssue") is not None else None,
            "name": obj.get("name"),
            "description": obj.get("description"),
            "matcher": TestResultDefectMatcherDto.from_dict(obj["matcher"]) if obj.get("matcher") is not None else None
        })
        return _obj


