# allure-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 525u01
- Package version: 1.0.0
- Generator version: 7.19.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/fenixnow/allure-client.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/fenixnow/allure-client.git`)

Then import the package:
```python
import allure_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import allure_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import allure_client
from allure_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = allure_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with allure_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = allure_client.AccessGroupBulkControllerApi(api_client)
    access_group_bulk_dto = allure_client.AccessGroupBulkDto() # AccessGroupBulkDto | 

    try:
        # Bulk delete teams
        api_instance.accessgroup_bulk_delete_post(access_group_bulk_dto)
    except ApiException as e:
        print("Exception when calling AccessGroupBulkControllerApi->accessgroup_bulk_delete_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessGroupBulkControllerApi* | [**accessgroup_bulk_delete_post**](docs/AccessGroupBulkControllerApi.md#accessgroup_bulk_delete_post) | **POST** /api/accessgroup/bulk/delete | Bulk delete teams
*AccessGroupControllerApi* | [**accessgroup_get**](docs/AccessGroupControllerApi.md#accessgroup_get) | **GET** /api/accessgroup | Find all groups
*AccessGroupControllerApi* | [**accessgroup_id_delete**](docs/AccessGroupControllerApi.md#accessgroup_id_delete) | **DELETE** /api/accessgroup/{id} | Delete group by id
*AccessGroupControllerApi* | [**accessgroup_id_get**](docs/AccessGroupControllerApi.md#accessgroup_id_get) | **GET** /api/accessgroup/{id} | Find group by id
*AccessGroupControllerApi* | [**accessgroup_id_patch**](docs/AccessGroupControllerApi.md#accessgroup_id_patch) | **PATCH** /api/accessgroup/{id} | Patch group
*AccessGroupControllerApi* | [**accessgroup_id_project_delete**](docs/AccessGroupControllerApi.md#accessgroup_id_project_delete) | **DELETE** /api/accessgroup/{id}/project | Delete projects from group
*AccessGroupControllerApi* | [**accessgroup_id_project_get**](docs/AccessGroupControllerApi.md#accessgroup_id_project_get) | **GET** /api/accessgroup/{id}/project | Get group&#39;s projects
*AccessGroupControllerApi* | [**accessgroup_id_project_post**](docs/AccessGroupControllerApi.md#accessgroup_id_project_post) | **POST** /api/accessgroup/{id}/project | Add projects to group
*AccessGroupControllerApi* | [**accessgroup_id_user_delete**](docs/AccessGroupControllerApi.md#accessgroup_id_user_delete) | **DELETE** /api/accessgroup/{id}/user | Delete users from group
*AccessGroupControllerApi* | [**accessgroup_id_user_get**](docs/AccessGroupControllerApi.md#accessgroup_id_user_get) | **GET** /api/accessgroup/{id}/user | Get group&#39;s users
*AccessGroupControllerApi* | [**accessgroup_id_user_post**](docs/AccessGroupControllerApi.md#accessgroup_id_user_post) | **POST** /api/accessgroup/{id}/user | Add users to group
*AccessGroupControllerApi* | [**accessgroup_post**](docs/AccessGroupControllerApi.md#accessgroup_post) | **POST** /api/accessgroup | Create a new group
*AccessGroupControllerApi* | [**accessgroup_suggest_get**](docs/AccessGroupControllerApi.md#accessgroup_suggest_get) | **GET** /api/accessgroup/suggest | Suggests groups
*AccountAdminControllerApi* | [**account_account_id_authority_post**](docs/AccountAdminControllerApi.md#account_account_id_authority_post) | **POST** /api/account/{accountId}/authority | Set account authorities
*AccountAdminControllerApi* | [**account_account_id_delete**](docs/AccountAdminControllerApi.md#account_account_id_delete) | **DELETE** /api/account/{accountId} | delete account authority
*AccountAdminControllerApi* | [**account_account_id_password_reset_post**](docs/AccountAdminControllerApi.md#account_account_id_password_reset_post) | **POST** /api/account/{accountId}/password/reset | Reset the password for account
*AccountAdminControllerApi* | [**account_account_id_password_send_post**](docs/AccountAdminControllerApi.md#account_account_id_password_send_post) | **POST** /api/account/{accountId}/password/send | Send the password to user
*AccountAdminControllerApi* | [**account_get**](docs/AccountAdminControllerApi.md#account_get) | **GET** /api/account | Find all accounts
*AccountAdminControllerApi* | [**account_id_approve_post**](docs/AccountAdminControllerApi.md#account_id_approve_post) | **POST** /api/account/{id}/approve | Approve/refuse account
*AccountAdminControllerApi* | [**account_id_enable_post**](docs/AccountAdminControllerApi.md#account_id_enable_post) | **POST** /api/account/{id}/enable | Enabled/disable account
*AccountAdminControllerApi* | [**account_id_find_get**](docs/AccountAdminControllerApi.md#account_id_find_get) | **GET** /api/account/{id}/find | Get user&#39;s account by id or username
*AccountAdminControllerApi* | [**account_register_post**](docs/AccountAdminControllerApi.md#account_register_post) | **POST** /api/account/register | Register new account
*AccountManagementBulkControllerApi* | [**admin_account_bulk_activate_post**](docs/AccountManagementBulkControllerApi.md#admin_account_bulk_activate_post) | **POST** /api/admin/account/bulk/activate | Bulk activate accounts
*AccountManagementBulkControllerApi* | [**admin_account_bulk_deactivate_post**](docs/AccountManagementBulkControllerApi.md#admin_account_bulk_deactivate_post) | **POST** /api/admin/account/bulk/deactivate | Bulk deactivate account
*AccountManagementBulkControllerApi* | [**admin_account_bulk_role_post**](docs/AccountManagementBulkControllerApi.md#admin_account_bulk_role_post) | **POST** /api/admin/account/bulk/role | Bulk change role
*AccountManagementControllerApi* | [**admin_account_deactivated_get**](docs/AccountManagementControllerApi.md#admin_account_deactivated_get) | **GET** /api/admin/account/deactivated | Get deactivated accounts
*AccountManagementControllerApi* | [**admin_account_get**](docs/AccountManagementControllerApi.md#admin_account_get) | **GET** /api/admin/account | Get member by username
*AccountManagementControllerApi* | [**admin_account_guest_get**](docs/AccountManagementControllerApi.md#admin_account_guest_get) | **GET** /api/admin/account/guest | Get guest list
*AccountManagementControllerApi* | [**admin_account_id_activate_post**](docs/AccountManagementControllerApi.md#admin_account_id_activate_post) | **POST** /api/admin/account/{id}/activate | Activate account
*AccountManagementControllerApi* | [**admin_account_id_deactivate_post**](docs/AccountManagementControllerApi.md#admin_account_id_deactivate_post) | **POST** /api/admin/account/{id}/deactivate | Deactivate account
*AccountManagementControllerApi* | [**admin_account_id_patch**](docs/AccountManagementControllerApi.md#admin_account_id_patch) | **PATCH** /api/admin/account/{id} | Edit account profile
*AccountManagementControllerApi* | [**admin_account_id_role_post**](docs/AccountManagementControllerApi.md#admin_account_id_role_post) | **POST** /api/admin/account/{id}/role | Change account role
*AccountManagementControllerApi* | [**admin_account_info_get**](docs/AccountManagementControllerApi.md#admin_account_info_get) | **GET** /api/admin/account/info | Get info about tabs and licenses
*AccountManagementControllerApi* | [**admin_account_member_get**](docs/AccountManagementControllerApi.md#admin_account_member_get) | **GET** /api/admin/account/member | Get members list
*AccountManagementControllerApi* | [**admin_account_suggest_get**](docs/AccountManagementControllerApi.md#admin_account_suggest_get) | **GET** /api/admin/account/suggest | Get list of members and guests
*AccountUserControllerApi* | [**account_id_get**](docs/AccountUserControllerApi.md#account_id_get) | **GET** /api/account/{id} | Get user&#39;s account by id or username
*AccountUserControllerApi* | [**account_id_patch**](docs/AccountUserControllerApi.md#account_id_patch) | **PATCH** /api/account/{id} | Patch account
*AccountUserControllerApi* | [**account_me_get**](docs/AccountUserControllerApi.md#account_me_get) | **GET** /api/account/me | Get current user&#39;s account
*AccountUserControllerApi* | [**account_password_forgot_post**](docs/AccountUserControllerApi.md#account_password_forgot_post) | **POST** /api/account/password/forgot | Restore account password by email
*AccountUserControllerApi* | [**account_password_post**](docs/AccountUserControllerApi.md#account_password_post) | **POST** /api/account/password | Change your account password
*AccountUserControllerApi* | [**account_password_reset_post**](docs/AccountUserControllerApi.md#account_password_reset_post) | **POST** /api/account/password/reset | Reset account password
*AccountUserControllerApi* | [**account_password_resetbyemail_post**](docs/AccountUserControllerApi.md#account_password_resetbyemail_post) | **POST** /api/account/password/resetbyemail | Reset current password
*AdminMiscControllerApi* | [**misc_session_stat_get**](docs/AdminMiscControllerApi.md#misc_session_stat_get) | **GET** /api/misc/session-stat | Find accounts and enrich them by last session date in Redis cache if exists
*AnalyticControllerApi* | [**analytic_id_automation_chart_get**](docs/AnalyticControllerApi.md#analytic_id_automation_chart_get) | **GET** /api/analytic/{id}/automation_chart | 
*AnalyticControllerApi* | [**analytic_id_group_by_automation_get**](docs/AnalyticControllerApi.md#analytic_id_group_by_automation_get) | **GET** /api/analytic/{id}/group_by_automation | 
*AnalyticControllerApi* | [**analytic_id_group_by_status_get**](docs/AnalyticControllerApi.md#analytic_id_group_by_status_get) | **GET** /api/analytic/{id}/group_by_status | 
*AnalyticControllerApi* | [**analytic_id_launch_duration_histogram_get**](docs/AnalyticControllerApi.md#analytic_id_launch_duration_histogram_get) | **GET** /api/analytic/{id}/launch_duration_histogram | 
*AnalyticControllerApi* | [**analytic_id_mute_trend_get**](docs/AnalyticControllerApi.md#analytic_id_mute_trend_get) | **GET** /api/analytic/{id}/mute_trend | 
*AnalyticControllerApi* | [**analytic_id_statistic_trend_get**](docs/AnalyticControllerApi.md#analytic_id_statistic_trend_get) | **GET** /api/analytic/{id}/statistic_trend | 
*AnalyticControllerApi* | [**analytic_id_tc_last_result_get**](docs/AnalyticControllerApi.md#analytic_id_tc_last_result_get) | **GET** /api/analytic/{id}/tc_last_result | 
*AnalyticControllerApi* | [**analytic_id_tc_success_rate_get**](docs/AnalyticControllerApi.md#analytic_id_tc_success_rate_get) | **GET** /api/analytic/{id}/tc_success_rate | 
*ApiTokenControllerApi* | [**token_get**](docs/ApiTokenControllerApi.md#token_get) | **GET** /api/token | Find all user&#39;s api tokens
*ApiTokenControllerApi* | [**token_id_delete**](docs/ApiTokenControllerApi.md#token_id_delete) | **DELETE** /api/token/{id} | Delete api token by id
*ApiTokenControllerApi* | [**token_post**](docs/ApiTokenControllerApi.md#token_post) | **POST** /api/token | Create a new api token
*AsyncJobControllerApi* | [**migration_job_get**](docs/AsyncJobControllerApi.md#migration_job_get) | **GET** /api/migration/job | Find migration jobs
*AsyncJobControllerApi* | [**migration_job_job_id_cancel_post**](docs/AsyncJobControllerApi.md#migration_job_job_id_cancel_post) | **POST** /api/migration/job/{jobId}/cancel | Cancel the specified migration job
*AsyncJobControllerApi* | [**migration_job_job_id_get**](docs/AsyncJobControllerApi.md#migration_job_job_id_get) | **GET** /api/migration/job/{jobId} | Get the specified migration job by id including its steps
*AuthenticationControllerApi* | [**login_props_get**](docs/AuthenticationControllerApi.md#login_props_get) | **GET** /api/login/props | 
*BlobStorageControllerApi* | [**storage_stats_get**](docs/BlobStorageControllerApi.md#storage_stats_get) | **GET** /api/storage/stats | Get blob storage statistic
*BlobStorageUpgradeControllerApi* | [**storage_upgrade_v2_get**](docs/BlobStorageUpgradeControllerApi.md#storage_upgrade_v2_get) | **GET** /api/storage/upgrade/v2 | 
*BlobStorageUpgradeControllerApi* | [**storage_upgrade_v2_test_case_attachment_post**](docs/BlobStorageUpgradeControllerApi.md#storage_upgrade_v2_test_case_attachment_post) | **POST** /api/storage/upgrade/v2/test-case-attachment | 
*BlobStorageUpgradeControllerApi* | [**storage_upgrade_v2_test_fixture_result_attachment_post**](docs/BlobStorageUpgradeControllerApi.md#storage_upgrade_v2_test_fixture_result_attachment_post) | **POST** /api/storage/upgrade/v2/test-fixture-result-attachment | 
*BlobStorageUpgradeControllerApi* | [**storage_upgrade_v2_test_fixture_result_post**](docs/BlobStorageUpgradeControllerApi.md#storage_upgrade_v2_test_fixture_result_post) | **POST** /api/storage/upgrade/v2/test-fixture-result | 
*BlobStorageUpgradeControllerApi* | [**storage_upgrade_v2_test_result_attachment_post**](docs/BlobStorageUpgradeControllerApi.md#storage_upgrade_v2_test_result_attachment_post) | **POST** /api/storage/upgrade/v2/test-result-attachment | 
*BlobStorageUpgradeControllerApi* | [**storage_upgrade_v2_test_result_post**](docs/BlobStorageUpgradeControllerApi.md#storage_upgrade_v2_test_result_post) | **POST** /api/storage/upgrade/v2/test-result | 
*BusinessMetricControllerApi* | [**business_metric_get**](docs/BusinessMetricControllerApi.md#business_metric_get) | **GET** /api/business-metric | Find all business metrics
*CategoryControllerApi* | [**category_get**](docs/CategoryControllerApi.md#category_get) | **GET** /api/category | 
*CategoryControllerApi* | [**category_id_delete**](docs/CategoryControllerApi.md#category_id_delete) | **DELETE** /api/category/{id} | 
*CategoryControllerApi* | [**category_id_patch**](docs/CategoryControllerApi.md#category_id_patch) | **PATCH** /api/category/{id} | 
*CategoryControllerApi* | [**category_post**](docs/CategoryControllerApi.md#category_post) | **POST** /api/category | 
*CategoryControllerApi* | [**category_suggest_get**](docs/CategoryControllerApi.md#category_suggest_get) | **GET** /api/category/suggest | 
*CategoryMatcherControllerApi* | [**categorymatcher_get**](docs/CategoryMatcherControllerApi.md#categorymatcher_get) | **GET** /api/categorymatcher | 
*CategoryMatcherControllerApi* | [**categorymatcher_id_delete**](docs/CategoryMatcherControllerApi.md#categorymatcher_id_delete) | **DELETE** /api/categorymatcher/{id} | 
*CategoryMatcherControllerApi* | [**categorymatcher_id_patch**](docs/CategoryMatcherControllerApi.md#categorymatcher_id_patch) | **PATCH** /api/categorymatcher/{id} | 
*CategoryMatcherControllerApi* | [**categorymatcher_post**](docs/CategoryMatcherControllerApi.md#categorymatcher_post) | **POST** /api/categorymatcher | 
*CleanerSchemaControllerApi* | [**cleanerschema_get**](docs/CleanerSchemaControllerApi.md#cleanerschema_get) | **GET** /api/cleanerschema | Find all cleaner schemas for given project
*CleanerSchemaControllerApi* | [**cleanerschema_global_get**](docs/CleanerSchemaControllerApi.md#cleanerschema_global_get) | **GET** /api/cleanerschema/global | Find all global cleaner schemas
*CleanerSchemaControllerApi* | [**cleanerschema_id_delete**](docs/CleanerSchemaControllerApi.md#cleanerschema_id_delete) | **DELETE** /api/cleanerschema/{id} | Delete cleaner schema by id
*CleanerSchemaControllerApi* | [**cleanerschema_id_get**](docs/CleanerSchemaControllerApi.md#cleanerschema_id_get) | **GET** /api/cleanerschema/{id} | Find cleaner schema by id
*CleanerSchemaControllerApi* | [**cleanerschema_id_patch**](docs/CleanerSchemaControllerApi.md#cleanerschema_id_patch) | **PATCH** /api/cleanerschema/{id} | Patch cleaner schema
*CleanerSchemaControllerApi* | [**cleanerschema_post**](docs/CleanerSchemaControllerApi.md#cleanerschema_post) | **POST** /api/cleanerschema | Create a new cleaner schema
*CleanupControllerApi* | [**cleanup_launch_post**](docs/CleanupControllerApi.md#cleanup_launch_post) | **POST** /api/cleanup/launch | 
*CleanupControllerApi* | [**cleanup_scheduler_blob_remove_task_post**](docs/CleanupControllerApi.md#cleanup_scheduler_blob_remove_task_post) | **POST** /api/cleanup/scheduler/blob_remove_task | 
*CleanupControllerApi* | [**cleanup_scheduler_cleaner_schema_global_post**](docs/CleanupControllerApi.md#cleanup_scheduler_cleaner_schema_global_post) | **POST** /api/cleanup/scheduler/cleaner_schema_global | 
*CleanupControllerApi* | [**cleanup_scheduler_cleaner_schema_project_post**](docs/CleanupControllerApi.md#cleanup_scheduler_cleaner_schema_project_post) | **POST** /api/cleanup/scheduler/cleaner_schema_project | 
*CommentControllerApi* | [**comment_get**](docs/CommentControllerApi.md#comment_get) | **GET** /api/comment | Find all comments
*CommentControllerApi* | [**comment_id_delete**](docs/CommentControllerApi.md#comment_id_delete) | **DELETE** /api/comment/{id} | Delete comment by id
*CommentControllerApi* | [**comment_id_get**](docs/CommentControllerApi.md#comment_id_get) | **GET** /api/comment/{id} | Find comment by id
*CommentControllerApi* | [**comment_id_patch**](docs/CommentControllerApi.md#comment_id_patch) | **PATCH** /api/comment/{id} | Dynamic update comment
*CommentControllerApi* | [**comment_post**](docs/CommentControllerApi.md#comment_post) | **POST** /api/comment | Create a new comment
*CustomFieldBulkControllerApi* | [**cfbulk_add_to_projects_post**](docs/CustomFieldBulkControllerApi.md#cfbulk_add_to_projects_post) | **POST** /api/cfbulk/add-to-projects | Add custom fields to projects
*CustomFieldBulkControllerApi* | [**cfbulk_archive_post**](docs/CustomFieldBulkControllerApi.md#cfbulk_archive_post) | **POST** /api/cfbulk/archive | Archive/restore custom fields
*CustomFieldControllerApi* | [**cf_count_usage_get**](docs/CustomFieldControllerApi.md#cf_count_usage_get) | **GET** /api/cf/count-usage | Count custom fields usage in projects
*CustomFieldControllerApi* | [**cf_get**](docs/CustomFieldControllerApi.md#cf_get) | **GET** /api/cf | Deprecated. Use GET /api/project/{projectId}/cf instead
*CustomFieldControllerApi* | [**cf_id_archived_post**](docs/CustomFieldControllerApi.md#cf_id_archived_post) | **POST** /api/cf/{id}/archived | Soft delete custom field
*CustomFieldControllerApi* | [**cf_id_delete**](docs/CustomFieldControllerApi.md#cf_id_delete) | **DELETE** /api/cf/{id} | 
*CustomFieldControllerApi* | [**cf_id_get**](docs/CustomFieldControllerApi.md#cf_id_get) | **GET** /api/cf/{id} | 
*CustomFieldControllerApi* | [**cf_id_patch**](docs/CustomFieldControllerApi.md#cf_id_patch) | **PATCH** /api/cf/{id} | 
*CustomFieldControllerApi* | [**cf_merge_post**](docs/CustomFieldControllerApi.md#cf_merge_post) | **POST** /api/cf/merge | 
*CustomFieldControllerApi* | [**cf_post**](docs/CustomFieldControllerApi.md#cf_post) | **POST** /api/cf | 
*CustomFieldControllerApi* | [**cf_suggest_get**](docs/CustomFieldControllerApi.md#cf_suggest_get) | **GET** /api/cf/suggest | 
*CustomFieldProjectControllerApi* | [**cfproject_add_post**](docs/CustomFieldProjectControllerApi.md#cfproject_add_post) | **POST** /api/cfproject/add | Add custom field to projects
*CustomFieldProjectControllerApi* | [**cfproject_add_to_project_post**](docs/CustomFieldProjectControllerApi.md#cfproject_add_to_project_post) | **POST** /api/cfproject/add-to-project | Add custom fields to project
*CustomFieldProjectControllerApi* | [**cfproject_default_post**](docs/CustomFieldProjectControllerApi.md#cfproject_default_post) | **POST** /api/cfproject/default | Deprecated. Use PATCH /api/project/{projectId}/cf/{cfId} instead
*CustomFieldProjectControllerApi* | [**cfproject_delta_post**](docs/CustomFieldProjectControllerApi.md#cfproject_delta_post) | **POST** /api/cfproject/delta | Find missing custom fields
*CustomFieldProjectControllerApi* | [**cfproject_get**](docs/CustomFieldProjectControllerApi.md#cfproject_get) | **GET** /api/cfproject | 
*CustomFieldProjectControllerApi* | [**cfproject_in_projects_get**](docs/CustomFieldProjectControllerApi.md#cfproject_in_projects_get) | **GET** /api/cfproject/in-projects | Find projects that use specified custom field
*CustomFieldProjectControllerApi* | [**cfproject_remove_delete**](docs/CustomFieldProjectControllerApi.md#cfproject_remove_delete) | **DELETE** /api/cfproject/remove | Remove custom field from project
*CustomFieldProjectControllerApi* | [**cfproject_required_post**](docs/CustomFieldProjectControllerApi.md#cfproject_required_post) | **POST** /api/cfproject/required | Deprecated. Use PATCH /api/project/{projectId}/cf/{cfId} instead
*CustomFieldProjectControllerV2Api* | [**project_project_id_cf_cf_id_patch**](docs/CustomFieldProjectControllerV2Api.md#project_project_id_cf_cf_id_patch) | **PATCH** /api/project/{projectId}/cf/{cfId} | 
*CustomFieldProjectControllerV2Api* | [**project_project_id_cf_get**](docs/CustomFieldProjectControllerV2Api.md#project_project_id_cf_get) | **GET** /api/project/{projectId}/cf | Find custom fields used in specified project
*CustomFieldSchemaControllerApi* | [**cfschema_count_mappings_get**](docs/CustomFieldSchemaControllerApi.md#cfschema_count_mappings_get) | **GET** /api/cfschema/count-mappings | Count custom fields mappings
*CustomFieldSchemaControllerApi* | [**cfschema_get**](docs/CustomFieldSchemaControllerApi.md#cfschema_get) | **GET** /api/cfschema | Find all custom field schemas for specified project and custom field
*CustomFieldSchemaControllerApi* | [**cfschema_id_delete**](docs/CustomFieldSchemaControllerApi.md#cfschema_id_delete) | **DELETE** /api/cfschema/{id} | Delete custom field schema by id
*CustomFieldSchemaControllerApi* | [**cfschema_id_get**](docs/CustomFieldSchemaControllerApi.md#cfschema_id_get) | **GET** /api/cfschema/{id} | Find custom field schema by id
*CustomFieldSchemaControllerApi* | [**cfschema_id_patch**](docs/CustomFieldSchemaControllerApi.md#cfschema_id_patch) | **PATCH** /api/cfschema/{id} | Patch custom field schema
*CustomFieldSchemaControllerApi* | [**cfschema_post**](docs/CustomFieldSchemaControllerApi.md#cfschema_post) | **POST** /api/cfschema | Create a new custom field schema
*CustomFieldValueBulkControllerApi* | [**cfvbulk_delete_delete**](docs/CustomFieldValueBulkControllerApi.md#cfvbulk_delete_delete) | **DELETE** /api/cfvbulk/delete | Delete custom field values from project
*CustomFieldValueBulkControllerApi* | [**cfvbulk_merge_post**](docs/CustomFieldValueBulkControllerApi.md#cfvbulk_merge_post) | **POST** /api/cfvbulk/merge | Deprecated. Use POST /api/cfv/merge-by-name or /api/cfv/merge-by-id instead
*CustomFieldValueControllerApi* | [**cfv_get**](docs/CustomFieldValueControllerApi.md#cfv_get) | **GET** /api/cfv | Find all custom field values
*CustomFieldValueControllerApi* | [**cfv_id_delete**](docs/CustomFieldValueControllerApi.md#cfv_id_delete) | **DELETE** /api/cfv/{id} | Delete custom field value by id
*CustomFieldValueControllerApi* | [**cfv_id_get**](docs/CustomFieldValueControllerApi.md#cfv_id_get) | **GET** /api/cfv/{id} | Find custom field value by id
*CustomFieldValueControllerApi* | [**cfv_id_patch**](docs/CustomFieldValueControllerApi.md#cfv_id_patch) | **PATCH** /api/cfv/{id} | Patch custom field value
*CustomFieldValueControllerApi* | [**cfv_id_rename_post**](docs/CustomFieldValueControllerApi.md#cfv_id_rename_post) | **POST** /api/cfv/{id}/rename | Deprecated. Use PUT /api/project/{projectId}/cfv/{cvfId}/name instead
*CustomFieldValueControllerApi* | [**cfv_merge_post**](docs/CustomFieldValueControllerApi.md#cfv_merge_post) | **POST** /api/cfv/merge | Merge project custom field values into new global
*CustomFieldValueControllerApi* | [**cfv_merge_to_to_cfv_id_post**](docs/CustomFieldValueControllerApi.md#cfv_merge_to_to_cfv_id_post) | **POST** /api/cfv/merge-to/{toCfvId} | Merge project custom field values into existing global
*CustomFieldValueControllerApi* | [**cfv_post**](docs/CustomFieldValueControllerApi.md#cfv_post) | **POST** /api/cfv | Deprecated. Use POST /api/project/{projectId}/cfv instead
*CustomFieldValueControllerApi* | [**cfv_suggest_get**](docs/CustomFieldValueControllerApi.md#cfv_suggest_get) | **GET** /api/cfv/suggest | Suggest custom field values
*CustomFieldValueControllerApi* | [**cfv_suggest_project_id_get**](docs/CustomFieldValueControllerApi.md#cfv_suggest_project_id_get) | **GET** /api/cfv/suggest/{projectId} | Suggest custom field values
*CustomFieldValueProjectControllerApi* | [**project_project_id_cfv_cfv_id_patch**](docs/CustomFieldValueProjectControllerApi.md#project_project_id_cfv_cfv_id_patch) | **PATCH** /api/project/{projectId}/cfv/{cfvId} | Patch specified custom field value, test results won&#39;t be affected
*CustomFieldValueProjectControllerApi* | [**project_project_id_cfv_get**](docs/CustomFieldValueProjectControllerApi.md#project_project_id_cfv_get) | **GET** /api/project/{projectId}/cfv | Find all custom field values for specified project
*CustomFieldValueProjectControllerApi* | [**project_project_id_cfv_id_delete**](docs/CustomFieldValueProjectControllerApi.md#project_project_id_cfv_id_delete) | **DELETE** /api/project/{projectId}/cfv/{id} | Delete specified custom field value for specified project
*CustomFieldValueProjectControllerApi* | [**project_project_id_cfv_merge_post**](docs/CustomFieldValueProjectControllerApi.md#project_project_id_cfv_merge_post) | **POST** /api/project/{projectId}/cfv/merge | Merge custom field values to new record
*CustomFieldValueProjectControllerApi* | [**project_project_id_cfv_merge_to_to_cfv_id_post**](docs/CustomFieldValueProjectControllerApi.md#project_project_id_cfv_merge_to_to_cfv_id_post) | **POST** /api/project/{projectId}/cfv/merge-to/{toCfvId} | Merge custom field values to existing record by id
*CustomFieldValueProjectControllerApi* | [**project_project_id_cfv_post**](docs/CustomFieldValueProjectControllerApi.md#project_project_id_cfv_post) | **POST** /api/project/{projectId}/cfv | Create a new custom field value for specified project
*DashboardControllerApi* | [**dashboard_get**](docs/DashboardControllerApi.md#dashboard_get) | **GET** /api/dashboard | 
*DashboardControllerApi* | [**dashboard_id_copy_post**](docs/DashboardControllerApi.md#dashboard_id_copy_post) | **POST** /api/dashboard/{id}/copy | 
*DashboardControllerApi* | [**dashboard_id_delete**](docs/DashboardControllerApi.md#dashboard_id_delete) | **DELETE** /api/dashboard/{id} | 
*DashboardControllerApi* | [**dashboard_id_drag_and_drop_post**](docs/DashboardControllerApi.md#dashboard_id_drag_and_drop_post) | **POST** /api/dashboard/{id}/drag-and-drop | 
*DashboardControllerApi* | [**dashboard_id_get**](docs/DashboardControllerApi.md#dashboard_id_get) | **GET** /api/dashboard/{id} | 
*DashboardControllerApi* | [**dashboard_id_patch**](docs/DashboardControllerApi.md#dashboard_id_patch) | **PATCH** /api/dashboard/{id} | 
*DashboardControllerApi* | [**dashboard_id_put**](docs/DashboardControllerApi.md#dashboard_id_put) | **PUT** /api/dashboard/{id} | 
*DashboardControllerApi* | [**dashboard_post**](docs/DashboardControllerApi.md#dashboard_post) | **POST** /api/dashboard | 
*DashboardTemplateControllerApi* | [**dashboard_template_get**](docs/DashboardTemplateControllerApi.md#dashboard_template_get) | **GET** /api/dashboard-template | 
*DashboardTemplateControllerApi* | [**dashboard_template_id_get**](docs/DashboardTemplateControllerApi.md#dashboard_template_id_get) | **GET** /api/dashboard-template/{id} | 
*DefectBulkControllerApi* | [**defect_bulk_close_post**](docs/DefectBulkControllerApi.md#defect_bulk_close_post) | **POST** /api/defect/bulk/close | 
*DefectBulkControllerApi* | [**defect_bulk_remove_post**](docs/DefectBulkControllerApi.md#defect_bulk_remove_post) | **POST** /api/defect/bulk/remove | 
*DefectBulkControllerApi* | [**defect_bulk_reopen_post**](docs/DefectBulkControllerApi.md#defect_bulk_reopen_post) | **POST** /api/defect/bulk/reopen | 
*DefectControllerApi* | [**defect_get**](docs/DefectControllerApi.md#defect_get) | **GET** /api/defect | 
*DefectControllerApi* | [**defect_id_createissue_post**](docs/DefectControllerApi.md#defect_id_createissue_post) | **POST** /api/defect/{id}/createissue | 
*DefectControllerApi* | [**defect_id_delete**](docs/DefectControllerApi.md#defect_id_delete) | **DELETE** /api/defect/{id} | 
*DefectControllerApi* | [**defect_id_get**](docs/DefectControllerApi.md#defect_id_get) | **GET** /api/defect/{id} | 
*DefectControllerApi* | [**defect_id_issue_delete**](docs/DefectControllerApi.md#defect_id_issue_delete) | **DELETE** /api/defect/{id}/issue | 
*DefectControllerApi* | [**defect_id_issue_post**](docs/DefectControllerApi.md#defect_id_issue_post) | **POST** /api/defect/{id}/issue | 
*DefectControllerApi* | [**defect_id_launch_get**](docs/DefectControllerApi.md#defect_id_launch_get) | **GET** /api/defect/{id}/launch | 
*DefectControllerApi* | [**defect_id_matcher_get**](docs/DefectControllerApi.md#defect_id_matcher_get) | **GET** /api/defect/{id}/matcher | 
*DefectControllerApi* | [**defect_id_patch**](docs/DefectControllerApi.md#defect_id_patch) | **PATCH** /api/defect/{id} | 
*DefectControllerApi* | [**defect_id_testcase_get**](docs/DefectControllerApi.md#defect_id_testcase_get) | **GET** /api/defect/{id}/testcase | 
*DefectControllerApi* | [**defect_id_testresult_get**](docs/DefectControllerApi.md#defect_id_testresult_get) | **GET** /api/defect/{id}/testresult | 
*DefectControllerApi* | [**defect_post**](docs/DefectControllerApi.md#defect_post) | **POST** /api/defect | 
*DefectControllerApi* | [**defect_suggest_get**](docs/DefectControllerApi.md#defect_suggest_get) | **GET** /api/defect/suggest | 
*DefectMatcherControllerApi* | [**defect_matcher_id_delete**](docs/DefectMatcherControllerApi.md#defect_matcher_id_delete) | **DELETE** /api/defect/matcher/{id} | 
*DefectMatcherControllerApi* | [**defect_matcher_id_patch**](docs/DefectMatcherControllerApi.md#defect_matcher_id_patch) | **PATCH** /api/defect/matcher/{id} | 
*DefectMatcherControllerApi* | [**defect_matcher_post**](docs/DefectMatcherControllerApi.md#defect_matcher_post) | **POST** /api/defect/matcher | 
*EnvVarControllerApi* | [**environment_get**](docs/EnvVarControllerApi.md#environment_get) | **GET** /api/environment | Find all environment variables
*EnvVarControllerApi* | [**environment_id_delete**](docs/EnvVarControllerApi.md#environment_id_delete) | **DELETE** /api/environment/{id} | Delete environment variable by id
*EnvVarControllerApi* | [**environment_id_get**](docs/EnvVarControllerApi.md#environment_id_get) | **GET** /api/environment/{id} | Find environment variable by id
*EnvVarControllerApi* | [**environment_id_patch**](docs/EnvVarControllerApi.md#environment_id_patch) | **PATCH** /api/environment/{id} | Patch environment variable
*EnvVarControllerApi* | [**environment_merge_post**](docs/EnvVarControllerApi.md#environment_merge_post) | **POST** /api/environment/merge | Merge environment variables
*EnvVarControllerApi* | [**environment_post**](docs/EnvVarControllerApi.md#environment_post) | **POST** /api/environment | Create a new environment variable
*EnvVarControllerApi* | [**environment_suggest_get**](docs/EnvVarControllerApi.md#environment_suggest_get) | **GET** /api/environment/suggest | Suggest environment variables
*EnvVarControllerApi* | [**ev_get**](docs/EnvVarControllerApi.md#ev_get) | **GET** /api/ev | Find all environment variables
*EnvVarControllerApi* | [**ev_id_delete**](docs/EnvVarControllerApi.md#ev_id_delete) | **DELETE** /api/ev/{id} | Delete environment variable by id
*EnvVarControllerApi* | [**ev_id_get**](docs/EnvVarControllerApi.md#ev_id_get) | **GET** /api/ev/{id} | Find environment variable by id
*EnvVarControllerApi* | [**ev_id_patch**](docs/EnvVarControllerApi.md#ev_id_patch) | **PATCH** /api/ev/{id} | Patch environment variable
*EnvVarControllerApi* | [**ev_merge_post**](docs/EnvVarControllerApi.md#ev_merge_post) | **POST** /api/ev/merge | Merge environment variables
*EnvVarControllerApi* | [**ev_post**](docs/EnvVarControllerApi.md#ev_post) | **POST** /api/ev | Create a new environment variable
*EnvVarControllerApi* | [**ev_suggest_get**](docs/EnvVarControllerApi.md#ev_suggest_get) | **GET** /api/ev/suggest | Suggest environment variables
*EnvVarSchemaControllerApi* | [**evschema_get**](docs/EnvVarSchemaControllerApi.md#evschema_get) | **GET** /api/evschema | Find all env var schemas for given project
*EnvVarSchemaControllerApi* | [**evschema_id_delete**](docs/EnvVarSchemaControllerApi.md#evschema_id_delete) | **DELETE** /api/evschema/{id} | Delete env var schema by id
*EnvVarSchemaControllerApi* | [**evschema_id_get**](docs/EnvVarSchemaControllerApi.md#evschema_id_get) | **GET** /api/evschema/{id} | Find env var schema by id
*EnvVarSchemaControllerApi* | [**evschema_id_patch**](docs/EnvVarSchemaControllerApi.md#evschema_id_patch) | **PATCH** /api/evschema/{id} | Patch env var schema
*EnvVarSchemaControllerApi* | [**evschema_post**](docs/EnvVarSchemaControllerApi.md#evschema_post) | **POST** /api/evschema | Create a new env var schema
*EnvVarValueControllerApi* | [**evv_get**](docs/EnvVarValueControllerApi.md#evv_get) | **GET** /api/evv | Find all environment values
*EnvVarValueControllerApi* | [**evv_id_delete**](docs/EnvVarValueControllerApi.md#evv_id_delete) | **DELETE** /api/evv/{id} | Delete environment value by id
*EnvVarValueControllerApi* | [**evv_id_get**](docs/EnvVarValueControllerApi.md#evv_id_get) | **GET** /api/evv/{id} | Find environment value by id
*EnvVarValueControllerApi* | [**evv_id_patch**](docs/EnvVarValueControllerApi.md#evv_id_patch) | **PATCH** /api/evv/{id} | Patch environment value
*EnvVarValueControllerApi* | [**evv_post**](docs/EnvVarValueControllerApi.md#evv_post) | **POST** /api/evv | Create a new environment value
*EnvVarValueControllerApi* | [**evv_suggest_get**](docs/EnvVarValueControllerApi.md#evv_suggest_get) | **GET** /api/evv/suggest | Suggest environment values
*ExportControllerApi* | [**export_launch_pdf_post**](docs/ExportControllerApi.md#export_launch_pdf_post) | **POST** /api/export/launch/pdf | Generate launch pdf report
*ExportControllerApi* | [**export_launch_pdf_structure_get**](docs/ExportControllerApi.md#export_launch_pdf_structure_get) | **GET** /api/export/launch/pdf/structure | Get supported launch pdf report parts
*ExportControllerApi* | [**export_testcase_csv_mapping_get**](docs/ExportControllerApi.md#export_testcase_csv_mapping_get) | **GET** /api/export/testcase/csv/mapping | Get supported test case export fields
*ExportControllerApi* | [**export_testcase_csv_post**](docs/ExportControllerApi.md#export_testcase_csv_post) | **POST** /api/export/testcase/csv | Generate test cases csv report
*ExportControllerApi* | [**export_testcase_pdf_post**](docs/ExportControllerApi.md#export_testcase_pdf_post) | **POST** /api/export/testcase/pdf | Generate test cases pdf report
*ExportControllerApi* | [**export_testresult_csv_mapping_get**](docs/ExportControllerApi.md#export_testresult_csv_mapping_get) | **GET** /api/export/testresult/csv/mapping | Get supported test result export fields
*ExportControllerApi* | [**export_testresult_csv_post**](docs/ExportControllerApi.md#export_testresult_csv_post) | **POST** /api/export/testresult/csv | Generate test results csv report
*ExportRequestControllerApi* | [**export_download_export_request_id_get**](docs/ExportRequestControllerApi.md#export_download_export_request_id_get) | **GET** /api/export/download/{exportRequestId} | Download prepared export
*ExportRequestControllerApi* | [**export_get**](docs/ExportRequestControllerApi.md#export_get) | **GET** /api/export | Find all reports
*ExportRequestControllerApi* | [**export_id_delete**](docs/ExportRequestControllerApi.md#export_id_delete) | **DELETE** /api/export/{id} | Delete report
*ExportRequestControllerApi* | [**export_id_get**](docs/ExportRequestControllerApi.md#export_id_get) | **GET** /api/export/{id} | Find report by id
*FeatureFlagControllerApi* | [**account_account_id_feature_flag_feature_flag_name_put**](docs/FeatureFlagControllerApi.md#account_account_id_feature_flag_feature_flag_name_put) | **PUT** /api/account/{accountId}/feature-flag/{featureFlagName} | Set feature flag for account
*FeatureFlagControllerApi* | [**account_account_id_feature_flag_get**](docs/FeatureFlagControllerApi.md#account_account_id_feature_flag_get) | **GET** /api/account/{accountId}/feature-flag | Get feature flags by accountId
*FeatureFlagControllerApi* | [**account_feature_flag_me_get**](docs/FeatureFlagControllerApi.md#account_feature_flag_me_get) | **GET** /api/account/feature-flag/me | Get feature flags for current account
*FeatureFlagControllerApi* | [**feature_flag_feature_flag_name_put**](docs/FeatureFlagControllerApi.md#feature_flag_feature_flag_name_put) | **PUT** /api/feature-flag/{featureFlagName} | Set feature flag for all accounts
*FeatureFlagControllerApi* | [**feature_flag_post**](docs/FeatureFlagControllerApi.md#feature_flag_post) | **POST** /api/feature-flag | Add new feature flag
*FilterControllerApi* | [**filter_base_get**](docs/FilterControllerApi.md#filter_base_get) | **GET** /api/filter/base | Get default filter
*FilterControllerApi* | [**filter_base_post**](docs/FilterControllerApi.md#filter_base_post) | **POST** /api/filter/base | Set filter as default
*FilterControllerApi* | [**filter_get**](docs/FilterControllerApi.md#filter_get) | **GET** /api/filter | Find all filters by given project
*FilterControllerApi* | [**filter_id_delete**](docs/FilterControllerApi.md#filter_id_delete) | **DELETE** /api/filter/{id} | Delete filter by id
*FilterControllerApi* | [**filter_id_get**](docs/FilterControllerApi.md#filter_id_get) | **GET** /api/filter/{id} | Find filter by id
*FilterControllerApi* | [**filter_id_patch**](docs/FilterControllerApi.md#filter_id_patch) | **PATCH** /api/filter/{id} | Patch filter
*FilterControllerApi* | [**filter_post**](docs/FilterControllerApi.md#filter_post) | **POST** /api/filter | Create a new filter
*FilterControllerApi* | [**filter_suggest_get**](docs/FilterControllerApi.md#filter_suggest_get) | **GET** /api/filter/suggest | Get suggest for filters
*GlobalSettingsControllerApi* | [**globalsettings_get**](docs/GlobalSettingsControllerApi.md#globalsettings_get) | **GET** /api/globalsettings | Returns global settings
*GlobalSettingsControllerApi* | [**globalsettings_globalpermissions_get**](docs/GlobalSettingsControllerApi.md#globalsettings_globalpermissions_get) | **GET** /api/globalsettings/globalpermissions | Returns all global permissions for user
*GlobalSettingsControllerApi* | [**globalsettings_mfa_get**](docs/GlobalSettingsControllerApi.md#globalsettings_mfa_get) | **GET** /api/globalsettings/mfa | Returns mfa settings
*GlobalSettingsControllerApi* | [**globalsettings_mfa_patch**](docs/GlobalSettingsControllerApi.md#globalsettings_mfa_patch) | **PATCH** /api/globalsettings/mfa | Patch MFA global settings
*GlobalSettingsControllerApi* | [**globalsettings_projectcreate_patch**](docs/GlobalSettingsControllerApi.md#globalsettings_projectcreate_patch) | **PATCH** /api/globalsettings/projectcreate | Patch global settings
*ImportRequestControllerApi* | [**importrequest_get**](docs/ImportRequestControllerApi.md#importrequest_get) | **GET** /api/importrequest | Find all imports
*ImportRequestControllerApi* | [**importrequest_id_delete**](docs/ImportRequestControllerApi.md#importrequest_id_delete) | **DELETE** /api/importrequest/{id} | Delete import
*ImportRequestControllerApi* | [**importrequest_id_get**](docs/ImportRequestControllerApi.md#importrequest_id_get) | **GET** /api/importrequest/{id} | Find import by id
*ImportRequestControllerApi* | [**importrequest_post**](docs/ImportRequestControllerApi.md#importrequest_post) | **POST** /api/importrequest | Upload import file
*InjectJsControllerApi* | [**inject_init_js_get**](docs/InjectJsControllerApi.md#inject_init_js_get) | **GET** /api/inject/init.js | 
*IntegrationControllerApi* | [**integration_available_get**](docs/IntegrationControllerApi.md#integration_available_get) | **GET** /api/integration/available | 
*IntegrationControllerApi* | [**integration_get**](docs/IntegrationControllerApi.md#integration_get) | **GET** /api/integration | 
*IntegrationControllerApi* | [**integration_globalfields_get**](docs/IntegrationControllerApi.md#integration_globalfields_get) | **GET** /api/integration/globalfields | 
*IntegrationControllerApi* | [**integration_id_delete**](docs/IntegrationControllerApi.md#integration_id_delete) | **DELETE** /api/integration/{id} | 
*IntegrationControllerApi* | [**integration_id_get**](docs/IntegrationControllerApi.md#integration_id_get) | **GET** /api/integration/{id} | 
*IntegrationControllerApi* | [**integration_id_patch**](docs/IntegrationControllerApi.md#integration_id_patch) | **PATCH** /api/integration/{id} | 
*IntegrationControllerApi* | [**integration_id_project_get**](docs/IntegrationControllerApi.md#integration_id_project_get) | **GET** /api/integration/{id}/project | 
*IntegrationControllerApi* | [**integration_integration_id_project_project_id_delete**](docs/IntegrationControllerApi.md#integration_integration_id_project_project_id_delete) | **DELETE** /api/integration/{integrationId}/project/{projectId} | 
*IntegrationControllerApi* | [**integration_integration_id_project_project_id_get**](docs/IntegrationControllerApi.md#integration_integration_id_project_project_id_get) | **GET** /api/integration/{integrationId}/project/{projectId} | 
*IntegrationControllerApi* | [**integration_integration_id_project_project_id_patch**](docs/IntegrationControllerApi.md#integration_integration_id_project_project_id_patch) | **PATCH** /api/integration/{integrationId}/project/{projectId} | 
*IntegrationControllerApi* | [**integration_post**](docs/IntegrationControllerApi.md#integration_post) | **POST** /api/integration | 
*IntegrationControllerApi* | [**integration_project_post**](docs/IntegrationControllerApi.md#integration_project_post) | **POST** /api/integration/project | 
*IntegrationControllerApi* | [**integration_project_project_id_available_get**](docs/IntegrationControllerApi.md#integration_project_project_id_available_get) | **GET** /api/integration/project/{projectId}/available | 
*IntegrationControllerApi* | [**integration_project_project_id_get**](docs/IntegrationControllerApi.md#integration_project_project_id_get) | **GET** /api/integration/project/{projectId} | 
*IntegrationControllerApi* | [**integration_project_validate_post**](docs/IntegrationControllerApi.md#integration_project_validate_post) | **POST** /api/integration/project/validate | 
*IntegrationControllerApi* | [**integration_projectfields_get**](docs/IntegrationControllerApi.md#integration_projectfields_get) | **GET** /api/integration/projectfields | 
*IntegrationControllerApi* | [**integration_suggest_get**](docs/IntegrationControllerApi.md#integration_suggest_get) | **GET** /api/integration/suggest | Suggest integrations
*IntegrationControllerApi* | [**integration_validate_post**](docs/IntegrationControllerApi.md#integration_validate_post) | **POST** /api/integration/validate | 
*IntegrationExportControllerApi* | [**integration_export_field_get**](docs/IntegrationExportControllerApi.md#integration_export_field_get) | **GET** /api/integration/export/field | Get export form fields for specified project integration
*IntegrationExportControllerApi* | [**integration_export_get**](docs/IntegrationExportControllerApi.md#integration_export_get) | **GET** /api/integration/export | 
*IntegrationExportControllerApi* | [**integration_export_id_delete**](docs/IntegrationExportControllerApi.md#integration_export_id_delete) | **DELETE** /api/integration/export/{id} | 
*IntegrationExportControllerApi* | [**integration_export_id_get**](docs/IntegrationExportControllerApi.md#integration_export_id_get) | **GET** /api/integration/export/{id} | 
*IntegrationExportControllerApi* | [**integration_export_id_patch**](docs/IntegrationExportControllerApi.md#integration_export_id_patch) | **PATCH** /api/integration/export/{id} | 
*IntegrationExportControllerApi* | [**integration_export_post**](docs/IntegrationExportControllerApi.md#integration_export_post) | **POST** /api/integration/export | 
*IntegrationIssueControllerApi* | [**integration_issue_field_get**](docs/IntegrationIssueControllerApi.md#integration_issue_field_get) | **GET** /api/integration/issue/field | Get available fields for specified project integration, project key and issue type
*IntegrationIssueControllerApi* | [**integration_issue_integration_id_fixlinks_post**](docs/IntegrationIssueControllerApi.md#integration_issue_integration_id_fixlinks_post) | **POST** /api/integration/issue/{integrationId}/fixlinks | Fix issue links without url
*IntegrationIssueControllerApi* | [**integration_issue_project_get**](docs/IntegrationIssueControllerApi.md#integration_issue_project_get) | **GET** /api/integration/issue/project | Get available projects for specified project integration
*IntegrationIssueControllerApi* | [**integration_issue_suggest_get**](docs/IntegrationIssueControllerApi.md#integration_issue_suggest_get) | **GET** /api/integration/issue/suggest | Get available issues for specified project integration
*IntegrationIssueControllerApi* | [**integration_issue_type_get**](docs/IntegrationIssueControllerApi.md#integration_issue_type_get) | **GET** /api/integration/issue/type | Get available issue types for specified project integration and project key
*IntegrationRequirementLinkControllerApi* | [**integration_requirement_integration_id_fix_links_post**](docs/IntegrationRequirementLinkControllerApi.md#integration_requirement_integration_id_fix_links_post) | **POST** /api/integration/requirement/{integrationId}/fix-links | Fix requirements without url
*IntegrationRequirementLinkControllerApi* | [**integration_requirement_suggest_get**](docs/IntegrationRequirementLinkControllerApi.md#integration_requirement_suggest_get) | **GET** /api/integration/requirement/suggest | Get available requirement for specified project integration
*IntegrationSelectControllerApi* | [**integration_select_get**](docs/IntegrationSelectControllerApi.md#integration_select_get) | **GET** /api/integration/select | 
*IntegrationTmsControllerApi* | [**integration_tms_projects_get**](docs/IntegrationTmsControllerApi.md#integration_tms_projects_get) | **GET** /api/integration/tms/projects | Get available projects for tms
*IntegrationWebhookControllerApi* | [**integration_webhook_get**](docs/IntegrationWebhookControllerApi.md#integration_webhook_get) | **GET** /api/integration/webhook | Find all webhook configs for integration
*IntegrationWebhookControllerApi* | [**integration_webhook_id_delete**](docs/IntegrationWebhookControllerApi.md#integration_webhook_id_delete) | **DELETE** /api/integration/webhook/{id} | Delete webhook config
*IntegrationWebhookControllerApi* | [**integration_webhook_id_patch**](docs/IntegrationWebhookControllerApi.md#integration_webhook_id_patch) | **PATCH** /api/integration/webhook/{id} | Patch webhook config
*IntegrationWebhookControllerApi* | [**integration_webhook_log_get**](docs/IntegrationWebhookControllerApi.md#integration_webhook_log_get) | **GET** /api/integration/webhook/log | Find all webhook logs by integration or webhook
*IntegrationWebhookControllerApi* | [**integration_webhook_post**](docs/IntegrationWebhookControllerApi.md#integration_webhook_post) | **POST** /api/integration/webhook | Create a new webhook config
*InviteBulkControllerApi* | [**invite_bulk_cancel_post**](docs/InviteBulkControllerApi.md#invite_bulk_cancel_post) | **POST** /api/invite/bulk/cancel | Bulk cancel invites
*InviteBulkControllerApi* | [**invite_bulk_resend_post**](docs/InviteBulkControllerApi.md#invite_bulk_resend_post) | **POST** /api/invite/bulk/resend | Bulk resend invites
*InviteControllerApi* | [**invite_get**](docs/InviteControllerApi.md#invite_get) | **GET** /api/invite | Get invites list
*InviteControllerApi* | [**invite_id_cancel_post**](docs/InviteControllerApi.md#invite_id_cancel_post) | **POST** /api/invite/{id}/cancel | Cancel invite
*InviteControllerApi* | [**invite_id_patch**](docs/InviteControllerApi.md#invite_id_patch) | **PATCH** /api/invite/{id} | Edit invite
*InviteControllerApi* | [**invite_id_resend_post**](docs/InviteControllerApi.md#invite_id_resend_post) | **POST** /api/invite/{id}/resend | Resend invite
*InviteControllerApi* | [**invite_post**](docs/InviteControllerApi.md#invite_post) | **POST** /api/invite | Send invite
*InviteControllerApi* | [**invite_token_validate_post**](docs/InviteControllerApi.md#invite_token_validate_post) | **POST** /api/invite/token/validate | Validate invite token
*InviteControllerApi* | [**invite_validate_post**](docs/InviteControllerApi.md#invite_validate_post) | **POST** /api/invite/validate | Validate invite email
*InviteLoginControllerApi* | [**login_invite_personal_post**](docs/InviteLoginControllerApi.md#login_invite_personal_post) | **POST** /api/login/invite-personal | 
*IssueControllerApi* | [**issue_get**](docs/IssueControllerApi.md#issue_get) | **GET** /api/issue | Find all issues
*IssueControllerApi* | [**issue_id_delete**](docs/IssueControllerApi.md#issue_id_delete) | **DELETE** /api/issue/{id} | Delete issue by id
*IssueControllerApi* | [**issue_id_get**](docs/IssueControllerApi.md#issue_id_get) | **GET** /api/issue/{id} | Find issue by id
*IssueControllerApi* | [**issue_id_patch**](docs/IssueControllerApi.md#issue_id_patch) | **PATCH** /api/issue/{id} | Patch issue schema
*IssueControllerApi* | [**issue_post**](docs/IssueControllerApi.md#issue_post) | **POST** /api/issue | Create a new issue
*IssueControllerApi* | [**issue_suggest_get**](docs/IssueControllerApi.md#issue_suggest_get) | **GET** /api/issue/suggest | Suggest issues
*IssueSchemaControllerApi* | [**issueschema_get**](docs/IssueSchemaControllerApi.md#issueschema_get) | **GET** /api/issueschema | Find all issue schemas for given project
*IssueSchemaControllerApi* | [**issueschema_id_delete**](docs/IssueSchemaControllerApi.md#issueschema_id_delete) | **DELETE** /api/issueschema/{id} | Delete an issue schema by id
*IssueSchemaControllerApi* | [**issueschema_id_get**](docs/IssueSchemaControllerApi.md#issueschema_id_get) | **GET** /api/issueschema/{id} | Find an issue schema by id
*IssueSchemaControllerApi* | [**issueschema_id_patch**](docs/IssueSchemaControllerApi.md#issueschema_id_patch) | **PATCH** /api/issueschema/{id} | Patch an issue schema
*IssueSchemaControllerApi* | [**issueschema_post**](docs/IssueSchemaControllerApi.md#issueschema_post) | **POST** /api/issueschema | Create a new issue schema
*JobControllerApi* | [**job_candidate_get**](docs/JobControllerApi.md#job_candidate_get) | **GET** /api/job/candidate | Get suggest for job candidate
*JobControllerApi* | [**job_get**](docs/JobControllerApi.md#job_get) | **GET** /api/job | Find job by given project and external id
*JobControllerApi* | [**job_id_delete**](docs/JobControllerApi.md#job_id_delete) | **DELETE** /api/job/{id} | Delete job by id
*JobControllerApi* | [**job_id_get**](docs/JobControllerApi.md#job_id_get) | **GET** /api/job/{id} | Find job by id
*JobControllerApi* | [**job_id_patch**](docs/JobControllerApi.md#job_id_patch) | **PATCH** /api/job/{id} | Patch job
*JobControllerApi* | [**job_id_run_post**](docs/JobControllerApi.md#job_id_run_post) | **POST** /api/job/{id}/run | Run job to a new launch
*JobControllerApi* | [**job_id_sync_post**](docs/JobControllerApi.md#job_id_sync_post) | **POST** /api/job/{id}/sync | Sync job with build server
*JobControllerApi* | [**job_id_tree_group_get**](docs/JobControllerApi.md#job_id_tree_group_get) | **GET** /api/job/{id}/tree/group | Find tree groups for node
*JobControllerApi* | [**job_id_tree_leaf_get**](docs/JobControllerApi.md#job_id_tree_leaf_get) | **GET** /api/job/{id}/tree/leaf | Find tree leaves for node
*JobControllerApi* | [**job_post**](docs/JobControllerApi.md#job_post) | **POST** /api/job | Create a new job
*JobControllerApi* | [**job_suggest_get**](docs/JobControllerApi.md#job_suggest_get) | **GET** /api/job/suggest | Suggest for jobs
*JobRunControllerApi* | [**jobrun_id_get**](docs/JobRunControllerApi.md#jobrun_id_get) | **GET** /api/jobrun/{id} | Get job run by id
*JobRunControllerApi* | [**jobrun_id_rerun_post**](docs/JobRunControllerApi.md#jobrun_id_rerun_post) | **POST** /api/jobrun/{id}/rerun | Rerun job
*JobRunControllerApi* | [**jobrun_id_upload_archive_post**](docs/JobRunControllerApi.md#jobrun_id_upload_archive_post) | **POST** /api/jobrun/{id}/upload/archive | Manually upload job run results
*JobRunControllerApi* | [**jobrun_id_upload_file_post**](docs/JobRunControllerApi.md#jobrun_id_upload_file_post) | **POST** /api/jobrun/{id}/upload/file | Manually upload job run results
*JobRunControllerApi* | [**jobrun_id_upload_post**](docs/JobRunControllerApi.md#jobrun_id_upload_post) | **POST** /api/jobrun/{id}/upload | Manually upload job run results
*JobRunTestPlanControllerApi* | [**jobrun_id_plan_get**](docs/JobRunTestPlanControllerApi.md#jobrun_id_plan_get) | **GET** /api/jobrun/{id}/plan | Find test plan for execution by external id
*LaunchControllerApi* | [**launch_get**](docs/LaunchControllerApi.md#launch_get) | **GET** /api/launch | Find all launches preview
*LaunchControllerApi* | [**launch_id_assignees_get**](docs/LaunchControllerApi.md#launch_id_assignees_get) | **GET** /api/launch/{id}/assignees | Get launch assignees
*LaunchControllerApi* | [**launch_id_category_get**](docs/LaunchControllerApi.md#launch_id_category_get) | **GET** /api/launch/{id}/category | Get launch error categories
*LaunchControllerApi* | [**launch_id_close_post**](docs/LaunchControllerApi.md#launch_id_close_post) | **POST** /api/launch/{id}/close | Close launch
*LaunchControllerApi* | [**launch_id_copy_post**](docs/LaunchControllerApi.md#launch_id_copy_post) | **POST** /api/launch/{id}/copy | Copy launch
*LaunchControllerApi* | [**launch_id_defect_apply_post**](docs/LaunchControllerApi.md#launch_id_defect_apply_post) | **POST** /api/launch/{id}/defect/apply | Apply defect matchers to launch
*LaunchControllerApi* | [**launch_id_defect_get**](docs/LaunchControllerApi.md#launch_id_defect_get) | **GET** /api/launch/{id}/defect | Get launch defects
*LaunchControllerApi* | [**launch_id_delete**](docs/LaunchControllerApi.md#launch_id_delete) | **DELETE** /api/launch/{id} | Delete launch by id
*LaunchControllerApi* | [**launch_id_duration_get**](docs/LaunchControllerApi.md#launch_id_duration_get) | **GET** /api/launch/{id}/duration | Get launch duration
*LaunchControllerApi* | [**launch_id_env_get**](docs/LaunchControllerApi.md#launch_id_env_get) | **GET** /api/launch/{id}/env | Get launch environment
*LaunchControllerApi* | [**launch_id_get**](docs/LaunchControllerApi.md#launch_id_get) | **GET** /api/launch/{id} | Find launch by id
*LaunchControllerApi* | [**launch_id_job_get**](docs/LaunchControllerApi.md#launch_id_job_get) | **GET** /api/launch/{id}/job | Get launch jobs
*LaunchControllerApi* | [**launch_id_job_suggest_get**](docs/LaunchControllerApi.md#launch_id_job_suggest_get) | **GET** /api/launch/{id}/job/suggest | Suggest launch jobs
*LaunchControllerApi* | [**launch_id_memberstats_get**](docs/LaunchControllerApi.md#launch_id_memberstats_get) | **GET** /api/launch/{id}/memberstats | Get member stats widget data
*LaunchControllerApi* | [**launch_id_muted_get**](docs/LaunchControllerApi.md#launch_id_muted_get) | **GET** /api/launch/{id}/muted | Get muted test results
*LaunchControllerApi* | [**launch_id_patch**](docs/LaunchControllerApi.md#launch_id_patch) | **PATCH** /api/launch/{id} | Patch launch
*LaunchControllerApi* | [**launch_id_progress_get**](docs/LaunchControllerApi.md#launch_id_progress_get) | **GET** /api/launch/{id}/progress | Get progress widget data
*LaunchControllerApi* | [**launch_id_release_patch**](docs/LaunchControllerApi.md#launch_id_release_patch) | **PATCH** /api/launch/{id}/release | Assign release to launch
*LaunchControllerApi* | [**launch_id_reopen_post**](docs/LaunchControllerApi.md#launch_id_reopen_post) | **POST** /api/launch/{id}/reopen | Reopen launch
*LaunchControllerApi* | [**launch_id_requirementstats_get**](docs/LaunchControllerApi.md#launch_id_requirementstats_get) | **GET** /api/launch/{id}/requirementstats | Get requirement stats widget data
*LaunchControllerApi* | [**launch_id_retries_get**](docs/LaunchControllerApi.md#launch_id_retries_get) | **GET** /api/launch/{id}/retries | Get retries widget data
*LaunchControllerApi* | [**launch_id_statistic_get**](docs/LaunchControllerApi.md#launch_id_statistic_get) | **GET** /api/launch/{id}/statistic | Get launch statistic
*LaunchControllerApi* | [**launch_id_testcase_add_post**](docs/LaunchControllerApi.md#launch_id_testcase_add_post) | **POST** /api/launch/{id}/testcase/add | Add test cases to launch
*LaunchControllerApi* | [**launch_id_tester_get**](docs/LaunchControllerApi.md#launch_id_tester_get) | **GET** /api/launch/{id}/tester | Get launch testers
*LaunchControllerApi* | [**launch_id_testplan_add_post**](docs/LaunchControllerApi.md#launch_id_testplan_add_post) | **POST** /api/launch/{id}/testplan/add | Add test plan to launch
*LaunchControllerApi* | [**launch_id_uncategorized_get**](docs/LaunchControllerApi.md#launch_id_uncategorized_get) | **GET** /api/launch/{id}/uncategorized | Get uncategorized test results
*LaunchControllerApi* | [**launch_id_unresolved_get**](docs/LaunchControllerApi.md#launch_id_unresolved_get) | **GET** /api/launch/{id}/unresolved | Get unresolved test results
*LaunchControllerApi* | [**launch_id_variables_get**](docs/LaunchControllerApi.md#launch_id_variables_get) | **GET** /api/launch/{id}/variables | Get variables widget data
*LaunchControllerApi* | [**launch_id_widget_tree_get**](docs/LaunchControllerApi.md#launch_id_widget_tree_get) | **GET** /api/launch/{id}/widget/tree | Get suites for tree data
*LaunchControllerApi* | [**launch_merge_post**](docs/LaunchControllerApi.md#launch_merge_post) | **POST** /api/launch/merge | Merge launches
*LaunchControllerApi* | [**launch_new_post**](docs/LaunchControllerApi.md#launch_new_post) | **POST** /api/launch/new | Create a new launch via event
*LaunchControllerApi* | [**launch_post**](docs/LaunchControllerApi.md#launch_post) | **POST** /api/launch | Create a new launch
*LaunchControllerApi* | [**launch_suggest_get**](docs/LaunchControllerApi.md#launch_suggest_get) | **GET** /api/launch/suggest | Suggest for launches
*LaunchDiffControllerApi* | [**launch_diff_failed_get**](docs/LaunchDiffControllerApi.md#launch_diff_failed_get) | **GET** /api/launch/diff/failed | Find failed
*LaunchDiffControllerApi* | [**launch_diff_fixed_get**](docs/LaunchDiffControllerApi.md#launch_diff_fixed_get) | **GET** /api/launch/diff/fixed | Find fixed
*LaunchDiffControllerApi* | [**launch_diff_matrix_get**](docs/LaunchDiffControllerApi.md#launch_diff_matrix_get) | **GET** /api/launch/diff/matrix | Get status matrix for given launches with overlay parameter
*LaunchDiffControllerApi* | [**launch_diff_missed_get**](docs/LaunchDiffControllerApi.md#launch_diff_missed_get) | **GET** /api/launch/diff/missed | Missed tests
*LaunchDiffControllerApi* | [**launch_diff_new_get**](docs/LaunchDiffControllerApi.md#launch_diff_new_get) | **GET** /api/launch/diff/new | New tests
*LaunchDiffControllerApi* | [**launch_diff_status_changed_get**](docs/LaunchDiffControllerApi.md#launch_diff_status_changed_get) | **GET** /api/launch/diff/status-changed | Find status changed difference
*LaunchIssueControllerApi* | [**launch_issue_get**](docs/LaunchIssueControllerApi.md#launch_issue_get) | **GET** /api/launch/issue | Get all issues used in launches
*LaunchIssueControllerApi* | [**launch_launch_id_issue_export_post**](docs/LaunchIssueControllerApi.md#launch_launch_id_issue_export_post) | **POST** /api/launch/{launchId}/issue/export | Export launch data to issue issueTracker
*LaunchSearchControllerApi* | [**launch_query_validate_get**](docs/LaunchSearchControllerApi.md#launch_query_validate_get) | **GET** /api/launch/query/validate | Find all launches by given AQL
*LaunchSearchControllerApi* | [**launch_search_get**](docs/LaunchSearchControllerApi.md#launch_search_get) | **GET** /api/launch/__search | Find all launches by given AQL
*LaunchTagControllerApi* | [**launch_tag_get**](docs/LaunchTagControllerApi.md#launch_tag_get) | **GET** /api/launch/tag | Find all tags
*LaunchTagControllerApi* | [**launch_tag_id_delete**](docs/LaunchTagControllerApi.md#launch_tag_id_delete) | **DELETE** /api/launch/tag/{id} | Delete Launch tag by id
*LaunchTagControllerApi* | [**launch_tag_id_get**](docs/LaunchTagControllerApi.md#launch_tag_id_get) | **GET** /api/launch/tag/{id} | Find Launch tag by id
*LaunchTagControllerApi* | [**launch_tag_id_patch**](docs/LaunchTagControllerApi.md#launch_tag_id_patch) | **PATCH** /api/launch/tag/{id} | Patch Launch tag
*LaunchTagControllerApi* | [**launch_tag_post**](docs/LaunchTagControllerApi.md#launch_tag_post) | **POST** /api/launch/tag | Create a new Launch tag
*LaunchTagControllerApi* | [**launch_tag_suggest_get**](docs/LaunchTagControllerApi.md#launch_tag_suggest_get) | **GET** /api/launch/tag/suggest | Suggest Launch Tags
*LaunchUploadControllerApi* | [**launch_launch_id_upload_archive_post**](docs/LaunchUploadControllerApi.md#launch_launch_id_upload_archive_post) | **POST** /api/launch/{launchId}/upload/archive | Manually upload launch results
*LaunchUploadControllerApi* | [**launch_launch_id_upload_file_post**](docs/LaunchUploadControllerApi.md#launch_launch_id_upload_file_post) | **POST** /api/launch/{launchId}/upload/file | Manually upload launch results
*LaunchUploadControllerApi* | [**launch_launch_id_upload_post**](docs/LaunchUploadControllerApi.md#launch_launch_id_upload_post) | **POST** /api/launch/{launchId}/upload | Manually upload launch results
*LaunchUploadControllerApi* | [**launch_upload_post**](docs/LaunchUploadControllerApi.md#launch_upload_post) | **POST** /api/launch/upload | Create launch from uploaded results
*LicenseControllerApi* | [**license_get**](docs/LicenseControllerApi.md#license_get) | **GET** /api/license | Returns application license
*LicenseControllerApi* | [**license_portal_post**](docs/LicenseControllerApi.md#license_portal_post) | **POST** /api/license/portal | 
*LicenseControllerApi* | [**license_post**](docs/LicenseControllerApi.md#license_post) | **POST** /api/license | Set license
*MailVerificationControllerApi* | [**email_verification_token_validate_post**](docs/MailVerificationControllerApi.md#email_verification_token_validate_post) | **POST** /api/email-verification/token/validate | Validate mail change token
*MailVerificationControllerApi* | [**email_verification_user_id_cancel_post**](docs/MailVerificationControllerApi.md#email_verification_user_id_cancel_post) | **POST** /api/email-verification/{userId}/cancel | Cancel email change
*MailVerificationControllerApi* | [**email_verification_user_id_get**](docs/MailVerificationControllerApi.md#email_verification_user_id_get) | **GET** /api/email-verification/{userId} | Get email change confirmation info
*MailVerificationControllerApi* | [**email_verification_user_id_patch**](docs/MailVerificationControllerApi.md#email_verification_user_id_patch) | **PATCH** /api/email-verification/{userId} | Edit email in mail confirmation token or send link to new email
*MailVerificationControllerApi* | [**email_verification_user_id_resend_post**](docs/MailVerificationControllerApi.md#email_verification_user_id_resend_post) | **POST** /api/email-verification/{userId}/resend | Resend email verification link
*MailVerificationControllerApi* | [**email_verification_verify_post**](docs/MailVerificationControllerApi.md#email_verification_verify_post) | **POST** /api/email-verification/verify | Verify email
*MarkdownPreviewControllerApi* | [**md_preview_get**](docs/MarkdownPreviewControllerApi.md#md_preview_get) | **GET** /api/md/preview | Converts markdown text to html
*MarkdownPreviewControllerApi* | [**md_preview_post**](docs/MarkdownPreviewControllerApi.md#md_preview_post) | **POST** /api/md/preview | Converts markdown text to html
*MemberControllerApi* | [**member_get**](docs/MemberControllerApi.md#member_get) | **GET** /api/member | Find all role users
*MemberControllerApi* | [**member_id_delete**](docs/MemberControllerApi.md#member_id_delete) | **DELETE** /api/member/{id} | Delete role user by id
*MemberControllerApi* | [**member_id_get**](docs/MemberControllerApi.md#member_id_get) | **GET** /api/member/{id} | Find role user by id
*MemberControllerApi* | [**member_id_patch**](docs/MemberControllerApi.md#member_id_patch) | **PATCH** /api/member/{id} | Patch role user
*MemberControllerApi* | [**member_post**](docs/MemberControllerApi.md#member_post) | **POST** /api/member | Create a new role user
*MemberControllerApi* | [**member_suggest_get**](docs/MemberControllerApi.md#member_suggest_get) | **GET** /api/member/suggest | Suggest members
*MfaControllerApi* | [**mfa_backup_codes_count_get**](docs/MfaControllerApi.md#mfa_backup_codes_count_get) | **GET** /api/mfa/backup-codes/count | 
*MfaControllerApi* | [**mfa_backup_codes_get**](docs/MfaControllerApi.md#mfa_backup_codes_get) | **GET** /api/mfa/backup-codes | 
*MfaControllerApi* | [**mfa_confirm_settings_post**](docs/MfaControllerApi.md#mfa_confirm_settings_post) | **POST** /api/mfa/confirm-settings | 
*MfaControllerApi* | [**mfa_disable_user_post**](docs/MfaControllerApi.md#mfa_disable_user_post) | **POST** /api/mfa/disable/user | 
*MfaControllerApi* | [**mfa_enable_user_post**](docs/MfaControllerApi.md#mfa_enable_user_post) | **POST** /api/mfa/enable/user | 
*MfaControllerApi* | [**mfa_generate_backup_codes_post**](docs/MfaControllerApi.md#mfa_generate_backup_codes_post) | **POST** /api/mfa/generate/backup-codes | 
*MfaControllerApi* | [**mfa_generate_init_settings_post**](docs/MfaControllerApi.md#mfa_generate_init_settings_post) | **POST** /api/mfa/generate/init-settings | 
*MfaControllerApi* | [**mfa_reset_settings_user_id_post**](docs/MfaControllerApi.md#mfa_reset_settings_user_id_post) | **POST** /api/mfa/reset/settings/{userID} | 
*MfaControllerApi* | [**mfa_status_get**](docs/MfaControllerApi.md#mfa_status_get) | **GET** /api/mfa/status | 
*MfaControllerApi* | [**mfa_verify_post**](docs/MfaControllerApi.md#mfa_verify_post) | **POST** /api/mfa/verify | 
*MuteControllerApi* | [**mute_get**](docs/MuteControllerApi.md#mute_get) | **GET** /api/mute | Find all mutes for test case
*MuteControllerApi* | [**mute_id_delete**](docs/MuteControllerApi.md#mute_id_delete) | **DELETE** /api/mute/{id} | Delete mute
*MuteControllerApi* | [**mute_post**](docs/MuteControllerApi.md#mute_post) | **POST** /api/mute | Create a new mute
*PermissionControllerApi* | [**permission_get**](docs/PermissionControllerApi.md#permission_get) | **GET** /api/permission | Get user permissions for project
*PermissionSetControllerApi* | [**permissionset_get**](docs/PermissionSetControllerApi.md#permissionset_get) | **GET** /api/permissionset | Find all permission sets
*PermissionSetControllerApi* | [**permissionset_id_delete**](docs/PermissionSetControllerApi.md#permissionset_id_delete) | **DELETE** /api/permissionset/{id} | Delete permission set by id
*PermissionSetControllerApi* | [**permissionset_id_get**](docs/PermissionSetControllerApi.md#permissionset_id_get) | **GET** /api/permissionset/{id} | Find permission set by id
*PermissionSetControllerApi* | [**permissionset_id_patch**](docs/PermissionSetControllerApi.md#permissionset_id_patch) | **PATCH** /api/permissionset/{id} | Patch permission set
*PermissionSetControllerApi* | [**permissionset_post**](docs/PermissionSetControllerApi.md#permissionset_post) | **POST** /api/permissionset | Create a new permission set
*PermissionSetControllerApi* | [**permissionset_suggest_get**](docs/PermissionSetControllerApi.md#permissionset_suggest_get) | **GET** /api/permissionset/suggest | Suggests permission sets
*ProjectAccessControllerApi* | [**project_access_project_id_collaborator_delete**](docs/ProjectAccessControllerApi.md#project_access_project_id_collaborator_delete) | **DELETE** /api/project/access/{projectId}/collaborator | Delete collaborators from project
*ProjectAccessControllerApi* | [**project_access_project_id_collaborator_get**](docs/ProjectAccessControllerApi.md#project_access_project_id_collaborator_get) | **GET** /api/project/access/{projectId}/collaborator | Get project collaborators
*ProjectAccessControllerApi* | [**project_access_project_id_collaborator_post**](docs/ProjectAccessControllerApi.md#project_access_project_id_collaborator_post) | **POST** /api/project/access/{projectId}/collaborator | Add collaborators to project
*ProjectAccessControllerApi* | [**project_access_project_id_group_delete**](docs/ProjectAccessControllerApi.md#project_access_project_id_group_delete) | **DELETE** /api/project/access/{projectId}/group | Delete groups from project
*ProjectAccessControllerApi* | [**project_access_project_id_group_get**](docs/ProjectAccessControllerApi.md#project_access_project_id_group_get) | **GET** /api/project/access/{projectId}/group | Get project access groups
*ProjectAccessControllerApi* | [**project_access_project_id_group_post**](docs/ProjectAccessControllerApi.md#project_access_project_id_group_post) | **POST** /api/project/access/{projectId}/group | Add groups to project
*ProjectCategoryControllerApi* | [**project_project_id_category_get**](docs/ProjectCategoryControllerApi.md#project_project_id_category_get) | **GET** /api/project/{projectId}/category | 
*ProjectCategoryControllerApi* | [**project_project_id_category_post**](docs/ProjectCategoryControllerApi.md#project_project_id_category_post) | **POST** /api/project/{projectId}/category | 
*ProjectCategoryControllerApi* | [**project_project_id_category_remove_post**](docs/ProjectCategoryControllerApi.md#project_project_id_category_remove_post) | **POST** /api/project/{projectId}/category/remove | 
*ProjectCategoryMatcherControllerApi* | [**project_project_id_categorymatcher_get**](docs/ProjectCategoryMatcherControllerApi.md#project_project_id_categorymatcher_get) | **GET** /api/project/{projectId}/categorymatcher | 
*ProjectCategoryMatcherControllerApi* | [**project_project_id_categorymatcher_post**](docs/ProjectCategoryMatcherControllerApi.md#project_project_id_categorymatcher_post) | **POST** /api/project/{projectId}/categorymatcher | 
*ProjectCategoryMatcherControllerApi* | [**project_project_id_categorymatcher_remove_post**](docs/ProjectCategoryMatcherControllerApi.md#project_project_id_categorymatcher_remove_post) | **POST** /api/project/{projectId}/categorymatcher/remove | 
*ProjectCollaboratorControllerApi* | [**project_id_collaborator_get**](docs/ProjectCollaboratorControllerApi.md#project_id_collaborator_get) | **GET** /api/project/{id}/collaborator | Find all permission sets
*ProjectCollaboratorControllerApi* | [**project_id_owner_get**](docs/ProjectCollaboratorControllerApi.md#project_id_owner_get) | **GET** /api/project/{id}/owner | Find project owners
*ProjectCollaboratorControllerApi* | [**project_id_suggest_get**](docs/ProjectCollaboratorControllerApi.md#project_id_suggest_get) | **GET** /api/project/{id}/suggest | Find all collaborators; the user with priorityUserId will be placed first in the list
*ProjectControllerApi* | [**project_count_test_cases_get**](docs/ProjectControllerApi.md#project_count_test_cases_get) | **GET** /api/project/count-test-cases | Count test cases in projects that use specified custom field
*ProjectControllerApi* | [**project_customfield_get**](docs/ProjectControllerApi.md#project_customfield_get) | **GET** /api/project/customfield | Find projects that use/do not use specified custom field
*ProjectControllerApi* | [**project_get**](docs/ProjectControllerApi.md#project_get) | **GET** /api/project | Find all projects
*ProjectControllerApi* | [**project_id_delete**](docs/ProjectControllerApi.md#project_id_delete) | **DELETE** /api/project/{id} | Delete project by id
*ProjectControllerApi* | [**project_id_favorite_post**](docs/ProjectControllerApi.md#project_id_favorite_post) | **POST** /api/project/{id}/favorite | Mark project as favorite
*ProjectControllerApi* | [**project_id_get**](docs/ProjectControllerApi.md#project_id_get) | **GET** /api/project/{id} | Find project by id
*ProjectControllerApi* | [**project_id_patch**](docs/ProjectControllerApi.md#project_id_patch) | **PATCH** /api/project/{id} | Patch project
*ProjectControllerApi* | [**project_id_stats_get**](docs/ProjectControllerApi.md#project_id_stats_get) | **GET** /api/project/{id}/stats | Find project stats by id
*ProjectControllerApi* | [**project_post**](docs/ProjectControllerApi.md#project_post) | **POST** /api/project | Create a new project
*ProjectControllerApi* | [**project_suggest_get**](docs/ProjectControllerApi.md#project_suggest_get) | **GET** /api/project/suggest | Suggest projects
*ProjectMetricControllerApi* | [**project_id_business_metric_get**](docs/ProjectMetricControllerApi.md#project_id_business_metric_get) | **GET** /api/project/{id}/business-metric | Find specific project metric for the period
*ProjectPropertyControllerApi* | [**projectproperty_get**](docs/ProjectPropertyControllerApi.md#projectproperty_get) | **GET** /api/projectproperty | Find all project properties
*ProjectPropertyControllerApi* | [**projectproperty_id_delete**](docs/ProjectPropertyControllerApi.md#projectproperty_id_delete) | **DELETE** /api/projectproperty/{id} | Delete project by id
*ProjectPropertyControllerApi* | [**projectproperty_id_get**](docs/ProjectPropertyControllerApi.md#projectproperty_id_get) | **GET** /api/projectproperty/{id} | Find project property by id
*ProjectPropertyControllerApi* | [**projectproperty_id_patch**](docs/ProjectPropertyControllerApi.md#projectproperty_id_patch) | **PATCH** /api/projectproperty/{id} | Patch project property
*ProjectPropertyControllerApi* | [**projectproperty_post**](docs/ProjectPropertyControllerApi.md#projectproperty_post) | **POST** /api/projectproperty | Create a new project property
*ProjectSettingsControllerApi* | [**projectsettings_launchclose_get**](docs/ProjectSettingsControllerApi.md#projectsettings_launchclose_get) | **GET** /api/projectsettings/launchclose | Get launch close config
*ProjectSettingsControllerApi* | [**projectsettings_launchclose_patch**](docs/ProjectSettingsControllerApi.md#projectsettings_launchclose_patch) | **PATCH** /api/projectsettings/launchclose | Save launch close config
*ProjectSettingsControllerApi* | [**projectsettings_launchlivedoc_get**](docs/ProjectSettingsControllerApi.md#projectsettings_launchlivedoc_get) | **GET** /api/projectsettings/launchlivedoc | Get launch live documentation config
*ProjectSettingsControllerApi* | [**projectsettings_launchlivedoc_patch**](docs/ProjectSettingsControllerApi.md#projectsettings_launchlivedoc_patch) | **PATCH** /api/projectsettings/launchlivedoc | Save launch live documentation config
*RegistrationControllerApi* | [**register_post**](docs/RegistrationControllerApi.md#register_post) | **POST** /api/register | Register a new user
*ReleaseControllerApi* | [**release_compare_get**](docs/ReleaseControllerApi.md#release_compare_get) | **GET** /api/release/compare | Get status matrix for all the launches assigned to given release with overlay parameter
*ReleaseControllerApi* | [**release_create_post**](docs/ReleaseControllerApi.md#release_create_post) | **POST** /api/release/create | Create a new release
*ReleaseControllerApi* | [**release_find_all_get**](docs/ReleaseControllerApi.md#release_find_all_get) | **GET** /api/release/findAll | Find all releases by project
*ReleaseControllerApi* | [**release_id_add_launches_post**](docs/ReleaseControllerApi.md#release_id_add_launches_post) | **POST** /api/release/{id}/add-launches | Assign launches to release
*ReleaseControllerApi* | [**release_id_get**](docs/ReleaseControllerApi.md#release_id_get) | **GET** /api/release/{id} | Find release by id
*ReleaseControllerApi* | [**release_id_patch**](docs/ReleaseControllerApi.md#release_id_patch) | **PATCH** /api/release/{id} | Update release (rename, close/open, delete/restore)
*ReleaseControllerApi* | [**release_suggest_get**](docs/ReleaseControllerApi.md#release_suggest_get) | **GET** /api/release/suggest | Suggest releases
*RequirementControllerApi* | [**requirement_id_delete**](docs/RequirementControllerApi.md#requirement_id_delete) | **DELETE** /api/requirement/{id} | Delete requirement link by id
*RequirementControllerApi* | [**requirement_id_get**](docs/RequirementControllerApi.md#requirement_id_get) | **GET** /api/requirement/{id} | Find requirement link by id
*RequirementControllerApi* | [**requirement_suggest_get**](docs/RequirementControllerApi.md#requirement_suggest_get) | **GET** /api/requirement/suggest | Suggest requirements
*RoleControllerApi* | [**role_get**](docs/RoleControllerApi.md#role_get) | **GET** /api/role | Find all roles
*RoleControllerApi* | [**role_id_delete**](docs/RoleControllerApi.md#role_id_delete) | **DELETE** /api/role/{id} | Delete role by id
*RoleControllerApi* | [**role_id_get**](docs/RoleControllerApi.md#role_id_get) | **GET** /api/role/{id} | Find role by id
*RoleControllerApi* | [**role_id_patch**](docs/RoleControllerApi.md#role_id_patch) | **PATCH** /api/role/{id} | Patch a role
*RoleControllerApi* | [**role_post**](docs/RoleControllerApi.md#role_post) | **POST** /api/role | Create a new role
*RoleControllerApi* | [**role_suggest_get**](docs/RoleControllerApi.md#role_suggest_get) | **GET** /api/role/suggest | Suggest roles
*RoleSchemaControllerApi* | [**roleschema_get**](docs/RoleSchemaControllerApi.md#roleschema_get) | **GET** /api/roleschema | Find all role schemas for given project
*RoleSchemaControllerApi* | [**roleschema_id_delete**](docs/RoleSchemaControllerApi.md#roleschema_id_delete) | **DELETE** /api/roleschema/{id} | Delete role schema by id
*RoleSchemaControllerApi* | [**roleschema_id_get**](docs/RoleSchemaControllerApi.md#roleschema_id_get) | **GET** /api/roleschema/{id} | Find role schema by id
*RoleSchemaControllerApi* | [**roleschema_id_patch**](docs/RoleSchemaControllerApi.md#roleschema_id_patch) | **PATCH** /api/roleschema/{id} | Patch role schema
*RoleSchemaControllerApi* | [**roleschema_post**](docs/RoleSchemaControllerApi.md#roleschema_post) | **POST** /api/roleschema | Create a new role schema
*SecurityAuthProviderControllerApi* | [**security_auth_providers_get**](docs/SecurityAuthProviderControllerApi.md#security_auth_providers_get) | **GET** /api/security/auth-providers | Find all security auth providers
*SecurityAuthProviderControllerApi* | [**security_auth_providers_id_disable_post**](docs/SecurityAuthProviderControllerApi.md#security_auth_providers_id_disable_post) | **POST** /api/security/auth-providers/{id}/disable | Disable security auth provider by given id
*SecurityAuthProviderControllerApi* | [**security_auth_providers_id_enable_post**](docs/SecurityAuthProviderControllerApi.md#security_auth_providers_id_enable_post) | **POST** /api/security/auth-providers/{id}/enable | Enable security auth provider by given id
*SecurityAuthProviderControllerApi* | [**security_auth_providers_id_get**](docs/SecurityAuthProviderControllerApi.md#security_auth_providers_id_get) | **GET** /api/security/auth-providers/{id} | Find security auth provider by given id
*SecurityAuthProviderControllerApi* | [**security_auth_providers_id_patch**](docs/SecurityAuthProviderControllerApi.md#security_auth_providers_id_patch) | **PATCH** /api/security/auth-providers/{id} | Update the security auth provider by given id
*SecurityAuthProviderControllerApi* | [**security_auth_providers_post**](docs/SecurityAuthProviderControllerApi.md#security_auth_providers_post) | **POST** /api/security/auth-providers | Create a new security auth provider
*SharedStepAttachmentControllerApi* | [**sharedstep_attachment_get**](docs/SharedStepAttachmentControllerApi.md#sharedstep_attachment_get) | **GET** /api/sharedstep/attachment | Find attachments for shared step
*SharedStepAttachmentControllerApi* | [**sharedstep_attachment_id_content_get**](docs/SharedStepAttachmentControllerApi.md#sharedstep_attachment_id_content_get) | **GET** /api/sharedstep/attachment/{id}/content | Get attachment content by id
*SharedStepAttachmentControllerApi* | [**sharedstep_attachment_id_content_put**](docs/SharedStepAttachmentControllerApi.md#sharedstep_attachment_id_content_put) | **PUT** /api/sharedstep/attachment/{id}/content | Update shared step attachment content
*SharedStepAttachmentControllerApi* | [**sharedstep_attachment_id_delete**](docs/SharedStepAttachmentControllerApi.md#sharedstep_attachment_id_delete) | **DELETE** /api/sharedstep/attachment/{id} | Delete shared step attachment
*SharedStepAttachmentControllerApi* | [**sharedstep_attachment_id_patch**](docs/SharedStepAttachmentControllerApi.md#sharedstep_attachment_id_patch) | **PATCH** /api/sharedstep/attachment/{id} | Patch shared step attachment
*SharedStepAttachmentControllerApi* | [**sharedstep_attachment_post**](docs/SharedStepAttachmentControllerApi.md#sharedstep_attachment_post) | **POST** /api/sharedstep/attachment | Upload new shared step attachments
*SharedStepControllerApi* | [**sharedstep_get**](docs/SharedStepControllerApi.md#sharedstep_get) | **GET** /api/sharedstep | Find all shared steps for specified project
*SharedStepControllerApi* | [**sharedstep_id_archive_post**](docs/SharedStepControllerApi.md#sharedstep_id_archive_post) | **POST** /api/sharedstep/{id}/archive | Archive ths shared step
*SharedStepControllerApi* | [**sharedstep_id_delete**](docs/SharedStepControllerApi.md#sharedstep_id_delete) | **DELETE** /api/sharedstep/{id} | Delete shared step by id
*SharedStepControllerApi* | [**sharedstep_id_get**](docs/SharedStepControllerApi.md#sharedstep_id_get) | **GET** /api/sharedstep/{id} | Find shared step by id
*SharedStepControllerApi* | [**sharedstep_id_patch**](docs/SharedStepControllerApi.md#sharedstep_id_patch) | **PATCH** /api/sharedstep/{id} | Patch a specified shared step
*SharedStepControllerApi* | [**sharedstep_id_unarchive_post**](docs/SharedStepControllerApi.md#sharedstep_id_unarchive_post) | **POST** /api/sharedstep/{id}/unarchive | Unarchive ths shared step
*SharedStepControllerApi* | [**sharedstep_post**](docs/SharedStepControllerApi.md#sharedstep_post) | **POST** /api/sharedstep | Create a new shared step
*SharedStepScenarioControllerApi* | [**sharedstep_id_scenario_delete**](docs/SharedStepScenarioControllerApi.md#sharedstep_id_scenario_delete) | **DELETE** /api/sharedstep/{id}/scenario | Delete scenario for test case
*SharedStepScenarioControllerApi* | [**sharedstep_id_scenario_post**](docs/SharedStepScenarioControllerApi.md#sharedstep_id_scenario_post) | **POST** /api/sharedstep/{id}/scenario | Set new scenario for ss
*SharedStepScenarioControllerApi* | [**sharedstep_id_step_get**](docs/SharedStepScenarioControllerApi.md#sharedstep_id_step_get) | **GET** /api/sharedstep/{id}/step | Get scenario for shared step
*SharedStepScenarioControllerApi* | [**sharedstep_id_usage_get**](docs/SharedStepScenarioControllerApi.md#sharedstep_id_usage_get) | **GET** /api/sharedstep/{id}/usage | Get testcases with usage of shared step
*SharedStepScenarioControllerApi* | [**sharedstep_step_id_copy_post**](docs/SharedStepScenarioControllerApi.md#sharedstep_step_id_copy_post) | **POST** /api/sharedstep/step/{id}/copy | Copy scenario step
*SharedStepScenarioControllerApi* | [**sharedstep_step_id_delete**](docs/SharedStepScenarioControllerApi.md#sharedstep_step_id_delete) | **DELETE** /api/sharedstep/step/{id} | Delete a specified scenario step
*SharedStepScenarioControllerApi* | [**sharedstep_step_id_move_post**](docs/SharedStepScenarioControllerApi.md#sharedstep_step_id_move_post) | **POST** /api/sharedstep/step/{id}/move | Move scenario step
*SharedStepScenarioControllerApi* | [**sharedstep_step_id_patch**](docs/SharedStepScenarioControllerApi.md#sharedstep_step_id_patch) | **PATCH** /api/sharedstep/step/{id} | Patch a specified scenario step
*SharedStepScenarioControllerApi* | [**sharedstep_step_post**](docs/SharedStepScenarioControllerApi.md#sharedstep_step_post) | **POST** /api/sharedstep/step | Create scenario step
*StatusControllerApi* | [**status_get**](docs/StatusControllerApi.md#status_get) | **GET** /api/status | Find all statuses
*StatusControllerApi* | [**status_id_delete**](docs/StatusControllerApi.md#status_id_delete) | **DELETE** /api/status/{id} | Delete status by id
*StatusControllerApi* | [**status_id_get**](docs/StatusControllerApi.md#status_id_get) | **GET** /api/status/{id} | Find status by id
*StatusControllerApi* | [**status_id_patch**](docs/StatusControllerApi.md#status_id_patch) | **PATCH** /api/status/{id} | Patch status
*StatusControllerApi* | [**status_post**](docs/StatusControllerApi.md#status_post) | **POST** /api/status | Create a new status
*StatusControllerApi* | [**status_suggest_get**](docs/StatusControllerApi.md#status_suggest_get) | **GET** /api/status/suggest | Suggest statuses
*TestCaseAttachmentControllerApi* | [**testcase_attachment_get**](docs/TestCaseAttachmentControllerApi.md#testcase_attachment_get) | **GET** /api/testcase/attachment | Find attachments for test case
*TestCaseAttachmentControllerApi* | [**testcase_attachment_id_content_get**](docs/TestCaseAttachmentControllerApi.md#testcase_attachment_id_content_get) | **GET** /api/testcase/attachment/{id}/content | Get attachment content by id
*TestCaseAttachmentControllerApi* | [**testcase_attachment_id_content_put**](docs/TestCaseAttachmentControllerApi.md#testcase_attachment_id_content_put) | **PUT** /api/testcase/attachment/{id}/content | Update test case attachment content
*TestCaseAttachmentControllerApi* | [**testcase_attachment_id_delete**](docs/TestCaseAttachmentControllerApi.md#testcase_attachment_id_delete) | **DELETE** /api/testcase/attachment/{id} | Delete test case attachment
*TestCaseAttachmentControllerApi* | [**testcase_attachment_id_patch**](docs/TestCaseAttachmentControllerApi.md#testcase_attachment_id_patch) | **PATCH** /api/testcase/attachment/{id} | Patch test case attachment
*TestCaseAttachmentControllerApi* | [**testcase_attachment_post**](docs/TestCaseAttachmentControllerApi.md#testcase_attachment_post) | **POST** /api/testcase/attachment | Upload new test case attachments
*TestCaseAuditControllerApi* | [**testcase_audit_get**](docs/TestCaseAuditControllerApi.md#testcase_audit_get) | **GET** /api/testcase/audit | Find audit log for test case
*TestCaseBulkControllerApi* | [**testcase_bulk_cfv_add_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_cfv_add_post) | **POST** /api/testcase/bulk/cfv/add | Add custom field values for all test cases
*TestCaseBulkControllerApi* | [**testcase_bulk_cfv_remove_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_cfv_remove_post) | **POST** /api/testcase/bulk/cfv/remove | Remove custom field values for all test cases
*TestCaseBulkControllerApi* | [**testcase_bulk_clone_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_clone_post) | **POST** /api/testcase/bulk/clone | Clone test cases by ids
*TestCaseBulkControllerApi* | [**testcase_bulk_draganddrop_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_draganddrop_post) | **POST** /api/testcase/bulk/draganddrop | dragAndDrop test cases for trees
*TestCaseBulkControllerApi* | [**testcase_bulk_externallink_add_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_externallink_add_post) | **POST** /api/testcase/bulk/externallink/add | Add external link for all test cases
*TestCaseBulkControllerApi* | [**testcase_bulk_issue_add_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_issue_add_post) | **POST** /api/testcase/bulk/issue/add | Add issues for all test cases
*TestCaseBulkControllerApi* | [**testcase_bulk_issue_remove_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_issue_remove_post) | **POST** /api/testcase/bulk/issue/remove | Remove issues for all test cases
*TestCaseBulkControllerApi* | [**testcase_bulk_layer_set_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_layer_set_post) | **POST** /api/testcase/bulk/layer/set | Set specified layer for all test cases
*TestCaseBulkControllerApi* | [**testcase_bulk_member_add_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_member_add_post) | **POST** /api/testcase/bulk/member/add | Add members for all test cases
*TestCaseBulkControllerApi* | [**testcase_bulk_member_remove_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_member_remove_post) | **POST** /api/testcase/bulk/member/remove | Remove member for all test cases
*TestCaseBulkControllerApi* | [**testcase_bulk_move_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_move_post) | **POST** /api/testcase/bulk/move | Move test cases to other project
*TestCaseBulkControllerApi* | [**testcase_bulk_mute_add_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_mute_add_post) | **POST** /api/testcase/bulk/mute/add | Add mute for all test cases
*TestCaseBulkControllerApi* | [**testcase_bulk_remove_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_remove_post) | **POST** /api/testcase/bulk/remove | Remove test cases by ids
*TestCaseBulkControllerApi* | [**testcase_bulk_run_existing_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_run_existing_post) | **POST** /api/testcase/bulk/run/existing | Run selected test cases in an existing launch
*TestCaseBulkControllerApi* | [**testcase_bulk_run_new_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_run_new_post) | **POST** /api/testcase/bulk/run/new | Run selected test cases in a new launch
*TestCaseBulkControllerApi* | [**testcase_bulk_run_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_run_post) | **POST** /api/testcase/bulk/run | Run selected test cases in a new launch
*TestCaseBulkControllerApi* | [**testcase_bulk_status_set_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_status_set_post) | **POST** /api/testcase/bulk/status/set | Set specified status for all test cases
*TestCaseBulkControllerApi* | [**testcase_bulk_tag_add_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_tag_add_post) | **POST** /api/testcase/bulk/tag/add | Add tags for all test cases
*TestCaseBulkControllerApi* | [**testcase_bulk_tag_remove_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_tag_remove_post) | **POST** /api/testcase/bulk/tag/remove | Remove tags for all test cases
*TestCaseBulkControllerApi* | [**testcase_bulk_testplan_create_post**](docs/TestCaseBulkControllerApi.md#testcase_bulk_testplan_create_post) | **POST** /api/testcase/bulk/testplan/create | Create test plan from selected test cases
*TestCaseBulkControllerV2Api* | [**v2_test_case_bulk_clone_post**](docs/TestCaseBulkControllerV2Api.md#v2_test_case_bulk_clone_post) | **POST** /api/v2/test-case/bulk/clone | Clone test cases
*TestCaseBulkControllerV2Api* | [**v2_test_case_bulk_count_post**](docs/TestCaseBulkControllerV2Api.md#v2_test_case_bulk_count_post) | **POST** /api/v2/test-case/bulk/count | Count test cases
*TestCaseBulkControllerV2Api* | [**v2_test_case_bulk_move_post**](docs/TestCaseBulkControllerV2Api.md#v2_test_case_bulk_move_post) | **POST** /api/v2/test-case/bulk/move | Move test cases to another project
*TestCaseBulkControllerV2Api* | [**v2_test_case_bulk_remove_post**](docs/TestCaseBulkControllerV2Api.md#v2_test_case_bulk_remove_post) | **POST** /api/v2/test-case/bulk/remove | Remove test cases
*TestCaseBulkControllerV2Api* | [**v2_test_case_bulk_restore_post**](docs/TestCaseBulkControllerV2Api.md#v2_test_case_bulk_restore_post) | **POST** /api/v2/test-case/bulk/restore | Restore test cases
*TestCaseCfBulkControllerApi* | [**v2_test_case_bulk_cf_delta_post**](docs/TestCaseCfBulkControllerApi.md#v2_test_case_bulk_cf_delta_post) | **POST** /api/v2/test-case/bulk/cf/delta | Find missing custom fields
*TestCaseCfvBulkControllerApi* | [**v2_test_case_bulk_cfv_add_post**](docs/TestCaseCfvBulkControllerApi.md#v2_test_case_bulk_cfv_add_post) | **POST** /api/v2/test-case/bulk/cfv/add | Add custom field values for selected test cases
*TestCaseCfvBulkControllerApi* | [**v2_test_case_bulk_cfv_post**](docs/TestCaseCfvBulkControllerApi.md#v2_test_case_bulk_cfv_post) | **POST** /api/v2/test-case/bulk/cfv | Find custom fields with values for test cases
*TestCaseCfvBulkControllerApi* | [**v2_test_case_bulk_cfv_remove_post**](docs/TestCaseCfvBulkControllerApi.md#v2_test_case_bulk_cfv_remove_post) | **POST** /api/v2/test-case/bulk/cfv/remove | Remove custom field values for selected test cases
*TestCaseCloneControllerApi* | [**testcase_id_clone_post**](docs/TestCaseCloneControllerApi.md#testcase_id_clone_post) | **POST** /api/testcase/{id}/clone | Clone test case
*TestCaseControllerApi* | [**testcase_deleted_get**](docs/TestCaseControllerApi.md#testcase_deleted_get) | **GET** /api/testcase/deleted | Find all deleted test cases for given project
*TestCaseControllerApi* | [**testcase_get**](docs/TestCaseControllerApi.md#testcase_get) | **GET** /api/testcase | Find all test cases for specified project
*TestCaseControllerApi* | [**testcase_history_get**](docs/TestCaseControllerApi.md#testcase_history_get) | **GET** /api/testcase/history | Find run history for test case
*TestCaseControllerApi* | [**testcase_id_delete**](docs/TestCaseControllerApi.md#testcase_id_delete) | **DELETE** /api/testcase/{id} | Delete test case by id
*TestCaseControllerApi* | [**testcase_id_detachautomation_post**](docs/TestCaseControllerApi.md#testcase_id_detachautomation_post) | **POST** /api/testcase/{id}/detachautomation | Detach automation from test case
*TestCaseControllerApi* | [**testcase_id_get**](docs/TestCaseControllerApi.md#testcase_id_get) | **GET** /api/testcase/{id} | Find test case by id
*TestCaseControllerApi* | [**testcase_id_history_get**](docs/TestCaseControllerApi.md#testcase_id_history_get) | **GET** /api/testcase/{id}/history | Find run history for test case
*TestCaseControllerApi* | [**testcase_id_patch**](docs/TestCaseControllerApi.md#testcase_id_patch) | **PATCH** /api/testcase/{id} | 
*TestCaseControllerApi* | [**testcase_id_restore_post**](docs/TestCaseControllerApi.md#testcase_id_restore_post) | **POST** /api/testcase/{id}/restore | Restore test case by id
*TestCaseControllerApi* | [**testcase_id_stats_get**](docs/TestCaseControllerApi.md#testcase_id_stats_get) | **GET** /api/testcase/{id}/stats | Get statistics for test case
*TestCaseControllerApi* | [**testcase_id_workflow_get**](docs/TestCaseControllerApi.md#testcase_id_workflow_get) | **GET** /api/testcase/{id}/workflow | Find workflow for test case
*TestCaseControllerApi* | [**testcase_muted_get**](docs/TestCaseControllerApi.md#testcase_muted_get) | **GET** /api/testcase/muted | Find all muted test cases for given project
*TestCaseControllerApi* | [**testcase_post**](docs/TestCaseControllerApi.md#testcase_post) | **POST** /api/testcase | Create a new test case
*TestCaseControllerApi* | [**testcase_suggest_get**](docs/TestCaseControllerApi.md#testcase_suggest_get) | **GET** /api/testcase/suggest | Find suggest for test case
*TestCaseCsvImportControllerApi* | [**testcase_import_csv_import_request_id_info_post**](docs/TestCaseCsvImportControllerApi.md#testcase_import_csv_import_request_id_info_post) | **POST** /api/testcase/import/csv/{importRequestId}/info | Get testcase csv import file and return import info
*TestCaseCsvImportControllerApi* | [**testcase_import_csv_import_request_id_preview_post**](docs/TestCaseCsvImportControllerApi.md#testcase_import_csv_import_request_id_preview_post) | **POST** /api/testcase/import/csv/{importRequestId}/preview | Preview testcase csv import
*TestCaseCsvImportControllerApi* | [**testcase_import_csv_import_request_id_submit_post**](docs/TestCaseCsvImportControllerApi.md#testcase_import_csv_import_request_id_submit_post) | **POST** /api/testcase/import/csv/{importRequestId}/submit | Submit testcase csv import
*TestCaseCustomFieldControllerApi* | [**testcase_cfv_post**](docs/TestCaseCustomFieldControllerApi.md#testcase_cfv_post) | **POST** /api/testcase/cfv | Find custom fields with values for test cases
*TestCaseCustomFieldControllerApi* | [**testcase_test_case_id_cfv_get**](docs/TestCaseCustomFieldControllerApi.md#testcase_test_case_id_cfv_get) | **GET** /api/testcase/{testCaseId}/cfv | Find custom fields with values for test case
*TestCaseCustomFieldControllerApi* | [**testcase_test_case_id_cfv_patch**](docs/TestCaseCustomFieldControllerApi.md#testcase_test_case_id_cfv_patch) | **PATCH** /api/testcase/{testCaseId}/cfv | Update custom field values of test case
*TestCaseDefectControllerApi* | [**testcase_id_defect_get**](docs/TestCaseDefectControllerApi.md#testcase_id_defect_get) | **GET** /api/testcase/{id}/defect | 
*TestCaseDefectControllerApi* | [**testcase_test_case_id_defect_defect_id_delete**](docs/TestCaseDefectControllerApi.md#testcase_test_case_id_defect_defect_id_delete) | **DELETE** /api/testcase/{testCaseId}/defect/{defectId} | 
*TestCaseDefectControllerApi* | [**testcase_test_case_id_defect_defect_id_post**](docs/TestCaseDefectControllerApi.md#testcase_test_case_id_defect_defect_id_post) | **POST** /api/testcase/{testCaseId}/defect/{defectId} | 
*TestCaseDurationUpdateControllerApi* | [**update_testcase_duration_post**](docs/TestCaseDurationUpdateControllerApi.md#update_testcase_duration_post) | **POST** /api/update-testcase-duration | Update test case duration based on median of last 14 passed test results
*TestCaseExampleControllerApi* | [**testcase_example_nwise_post**](docs/TestCaseExampleControllerApi.md#testcase_example_nwise_post) | **POST** /api/testcase/example/nwise | 
*TestCaseExampleControllerApi* | [**testcase_test_case_id_example_get**](docs/TestCaseExampleControllerApi.md#testcase_test_case_id_example_get) | **GET** /api/testcase/{testCaseId}/example | 
*TestCaseExampleControllerApi* | [**testcase_test_case_id_example_post**](docs/TestCaseExampleControllerApi.md#testcase_test_case_id_example_post) | **POST** /api/testcase/{testCaseId}/example | 
*TestCaseExampleControllerApi* | [**testcase_test_case_id_example_rename_parameter_post**](docs/TestCaseExampleControllerApi.md#testcase_test_case_id_example_rename_parameter_post) | **POST** /api/testcase/{testCaseId}/example/rename-parameter | 
*TestCaseExportBulkControllerApi* | [**v2_test_case_bulk_export_csv_post**](docs/TestCaseExportBulkControllerApi.md#v2_test_case_bulk_export_csv_post) | **POST** /api/v2/test-case/bulk/export/csv | Generate test cases csv report
*TestCaseExportBulkControllerApi* | [**v2_test_case_bulk_export_pdf_post**](docs/TestCaseExportBulkControllerApi.md#v2_test_case_bulk_export_pdf_post) | **POST** /api/v2/test-case/bulk/export/pdf | Generate test cases pdf report
*TestCaseExportControllerApi* | [**testcase_tms_sync_post**](docs/TestCaseExportControllerApi.md#testcase_tms_sync_post) | **POST** /api/testcase/tms/sync | 
*TestCaseExternalLinkBulkControllerApi* | [**v2_test_case_bulk_external_link_add_post**](docs/TestCaseExternalLinkBulkControllerApi.md#v2_test_case_bulk_external_link_add_post) | **POST** /api/v2/test-case/bulk/external-link/add | Add external link for selected test cases
*TestCaseFlatControllerApi* | [**v2_project_project_id_test_case_flat_get**](docs/TestCaseFlatControllerApi.md#v2_project_project_id_test_case_flat_get) | **GET** /api/v2/project/{projectId}/test-case/flat | Get test cases as a flat structure (AQL)
*TestCaseFlatControllerApi* | [**v2_project_project_id_test_case_flat_post**](docs/TestCaseFlatControllerApi.md#v2_project_project_id_test_case_flat_post) | **POST** /api/v2/project/{projectId}/test-case/flat | Add a new test case
*TestCaseFlatControllerApi* | [**v2_project_project_id_test_case_test_case_id_flat_name_put**](docs/TestCaseFlatControllerApi.md#v2_project_project_id_test_case_test_case_id_flat_name_put) | **PUT** /api/v2/project/{projectId}/test-case/{testCaseId}/flat/name | Rename the test case
*TestCaseIssueBulkControllerApi* | [**v2_test_case_bulk_issue_add_post**](docs/TestCaseIssueBulkControllerApi.md#v2_test_case_bulk_issue_add_post) | **POST** /api/v2/test-case/bulk/issue/add | Add issues for selected test cases
*TestCaseIssueBulkControllerApi* | [**v2_test_case_bulk_issue_remove_post**](docs/TestCaseIssueBulkControllerApi.md#v2_test_case_bulk_issue_remove_post) | **POST** /api/v2/test-case/bulk/issue/remove | Remove issues for selected test cases
*TestCaseIssueControllerApi* | [**testcase_test_case_id_issue_get**](docs/TestCaseIssueControllerApi.md#testcase_test_case_id_issue_get) | **GET** /api/testcase/{testCaseId}/issue | Find issues for test case
*TestCaseIssueControllerApi* | [**testcase_test_case_id_issue_post**](docs/TestCaseIssueControllerApi.md#testcase_test_case_id_issue_post) | **POST** /api/testcase/{testCaseId}/issue | Set issues to test case
*TestCaseLayerBulkControllerApi* | [**v2_test_case_bulk_layer_set_post**](docs/TestCaseLayerBulkControllerApi.md#v2_test_case_bulk_layer_set_post) | **POST** /api/v2/test-case/bulk/layer/set | Set specified layer for selected test cases
*TestCaseMemberBulkControllerApi* | [**v2_test_case_bulk_member_add_post**](docs/TestCaseMemberBulkControllerApi.md#v2_test_case_bulk_member_add_post) | **POST** /api/v2/test-case/bulk/member/add | Add members for selected test cases
*TestCaseMemberBulkControllerApi* | [**v2_test_case_bulk_member_remove_post**](docs/TestCaseMemberBulkControllerApi.md#v2_test_case_bulk_member_remove_post) | **POST** /api/v2/test-case/bulk/member/remove | Remove members for selected test cases
*TestCaseMembersControllerApi* | [**testcase_test_case_id_members_get**](docs/TestCaseMembersControllerApi.md#testcase_test_case_id_members_get) | **GET** /api/testcase/{testCaseId}/members | Find user roles for test case
*TestCaseMembersControllerApi* | [**testcase_test_case_id_members_post**](docs/TestCaseMembersControllerApi.md#testcase_test_case_id_members_post) | **POST** /api/testcase/{testCaseId}/members | Set user roles for test case
*TestCaseMuteBulkControllerApi* | [**v2_test_case_bulk_mute_add_post**](docs/TestCaseMuteBulkControllerApi.md#v2_test_case_bulk_mute_add_post) | **POST** /api/v2/test-case/bulk/mute/add | Add mute for selected test cases
*TestCaseOverviewControllerApi* | [**testcase_test_case_id_overview_get**](docs/TestCaseOverviewControllerApi.md#testcase_test_case_id_overview_get) | **GET** /api/testcase/{testCaseId}/overview | Get test case overview
*TestCaseRelationControllerApi* | [**testcase_test_case_id_relation_get**](docs/TestCaseRelationControllerApi.md#testcase_test_case_id_relation_get) | **GET** /api/testcase/{testCaseId}/relation | Find relations for test case
*TestCaseRelationControllerApi* | [**testcase_test_case_id_relation_post**](docs/TestCaseRelationControllerApi.md#testcase_test_case_id_relation_post) | **POST** /api/testcase/{testCaseId}/relation | Set relations for test case
*TestCaseRequirementControllerApi* | [**testcase_test_case_id_requirement_get**](docs/TestCaseRequirementControllerApi.md#testcase_test_case_id_requirement_get) | **GET** /api/testcase/{testCaseId}/requirement | Find requirements for test case
*TestCaseRequirementControllerApi* | [**testcase_test_case_id_requirement_post**](docs/TestCaseRequirementControllerApi.md#testcase_test_case_id_requirement_post) | **POST** /api/testcase/{testCaseId}/requirement | Set requirement to test case
*TestCaseRunBulkControllerApi* | [**v2_test_case_bulk_job_stats_post**](docs/TestCaseRunBulkControllerApi.md#v2_test_case_bulk_job_stats_post) | **POST** /api/v2/test-case/bulk/job/stats | Get run information
*TestCaseRunBulkControllerApi* | [**v2_test_case_bulk_run_existing_post**](docs/TestCaseRunBulkControllerApi.md#v2_test_case_bulk_run_existing_post) | **POST** /api/v2/test-case/bulk/run/existing | Run selected test cases in the existing launch
*TestCaseRunBulkControllerApi* | [**v2_test_case_bulk_run_new_post**](docs/TestCaseRunBulkControllerApi.md#v2_test_case_bulk_run_new_post) | **POST** /api/v2/test-case/bulk/run/new | Run selected test cases in a new launch
*TestCaseRunBulkControllerApi* | [**v2_test_case_bulk_run_post**](docs/TestCaseRunBulkControllerApi.md#v2_test_case_bulk_run_post) | **POST** /api/v2/test-case/bulk/run | Run selected test cases in a new launch
*TestCaseRunBulkControllerApi* | [**v2_test_case_bulk_run_stats_post**](docs/TestCaseRunBulkControllerApi.md#v2_test_case_bulk_run_stats_post) | **POST** /api/v2/test-case/bulk/run/stats | Get run information
*TestCaseScenarioControllerApi* | [**testcase_id_migrate_post**](docs/TestCaseScenarioControllerApi.md#testcase_id_migrate_post) | **POST** /api/testcase/{id}/migrate | Migrate scenario for test case
*TestCaseScenarioControllerApi* | [**testcase_id_scenario_delete**](docs/TestCaseScenarioControllerApi.md#testcase_id_scenario_delete) | **DELETE** /api/testcase/{id}/scenario | Delete scenario for test case
*TestCaseScenarioControllerApi* | [**testcase_id_scenario_get**](docs/TestCaseScenarioControllerApi.md#testcase_id_scenario_get) | **GET** /api/testcase/{id}/scenario | Find scenario for test case
*TestCaseScenarioControllerApi* | [**testcase_id_scenario_post**](docs/TestCaseScenarioControllerApi.md#testcase_id_scenario_post) | **POST** /api/testcase/{id}/scenario | Set new type scenario for test case
*TestCaseScenarioControllerApi* | [**testcase_id_scenariofromrun_get**](docs/TestCaseScenarioControllerApi.md#testcase_id_scenariofromrun_get) | **GET** /api/testcase/{id}/scenariofromrun | Find scenario for test case from last run
*TestCaseScenarioControllerApi* | [**testcase_id_step_get**](docs/TestCaseScenarioControllerApi.md#testcase_id_step_get) | **GET** /api/testcase/{id}/step | Get scenario for test case
*TestCaseScenarioControllerApi* | [**testcase_step_id_copy_post**](docs/TestCaseScenarioControllerApi.md#testcase_step_id_copy_post) | **POST** /api/testcase/step/{id}/copy | Copy scenario step
*TestCaseScenarioControllerApi* | [**testcase_step_id_delete**](docs/TestCaseScenarioControllerApi.md#testcase_step_id_delete) | **DELETE** /api/testcase/step/{id} | Delete a specified scenario step
*TestCaseScenarioControllerApi* | [**testcase_step_id_move_post**](docs/TestCaseScenarioControllerApi.md#testcase_step_id_move_post) | **POST** /api/testcase/step/{id}/move | Move scenario step
*TestCaseScenarioControllerApi* | [**testcase_step_id_patch**](docs/TestCaseScenarioControllerApi.md#testcase_step_id_patch) | **PATCH** /api/testcase/step/{id} | Patch a specified scenario step
*TestCaseScenarioControllerApi* | [**testcase_step_post**](docs/TestCaseScenarioControllerApi.md#testcase_step_post) | **POST** /api/testcase/step | Create scenario step
*TestCaseSearchControllerApi* | [**testcase_query_validate_get**](docs/TestCaseSearchControllerApi.md#testcase_query_validate_get) | **GET** /api/testcase/query/validate | Find all test cases by given AQL
*TestCaseSearchControllerApi* | [**testcase_search_get**](docs/TestCaseSearchControllerApi.md#testcase_search_get) | **GET** /api/testcase/__search | Find all test cases by given AQL
*TestCaseSnapshotControllerApi* | [**testcase_id_snapshot_get**](docs/TestCaseSnapshotControllerApi.md#testcase_id_snapshot_get) | **GET** /api/testcase/{id}/snapshot | List snapshots for a test case
*TestCaseSnapshotControllerApi* | [**testcase_id_snapshot_oldest_delete**](docs/TestCaseSnapshotControllerApi.md#testcase_id_snapshot_oldest_delete) | **DELETE** /api/testcase/{id}/snapshot/oldest | Delete N oldest snapshots for a test case
*TestCaseSnapshotControllerApi* | [**testcase_id_snapshot_post**](docs/TestCaseSnapshotControllerApi.md#testcase_id_snapshot_post) | **POST** /api/testcase/{id}/snapshot | Create snapshot for a test case
*TestCaseSnapshotControllerApi* | [**testcase_snapshot_id_delete**](docs/TestCaseSnapshotControllerApi.md#testcase_snapshot_id_delete) | **DELETE** /api/testcase/snapshot/{id} | Delete snapshot by identifier
*TestCaseSnapshotControllerApi* | [**testcase_snapshot_id_get**](docs/TestCaseSnapshotControllerApi.md#testcase_snapshot_id_get) | **GET** /api/testcase/snapshot/{id} | Get snapshot by identifier
*TestCaseSnapshotControllerApi* | [**testcase_snapshot_id_patch**](docs/TestCaseSnapshotControllerApi.md#testcase_snapshot_id_patch) | **PATCH** /api/testcase/snapshot/{id} | Update snapshot title and description
*TestCaseSnapshotControllerApi* | [**testcase_snapshot_id_restore_post**](docs/TestCaseSnapshotControllerApi.md#testcase_snapshot_id_restore_post) | **POST** /api/testcase/snapshot/{id}/restore | Restore a test case from snapshot
*TestCaseSnapshotControllerApi* | [**testcase_snapshot_max_count_get**](docs/TestCaseSnapshotControllerApi.md#testcase_snapshot_max_count_get) | **GET** /api/testcase/snapshot/max-count | Get maximum snapshot count for project
*TestCaseSnapshotControllerApi* | [**testcase_version_migrate_post**](docs/TestCaseSnapshotControllerApi.md#testcase_version_migrate_post) | **POST** /api/testcase/version/migrate | Trigger migration of legacy versions to new snapshots
*TestCaseStatusBulkControllerApi* | [**v2_test_case_bulk_status_set_post**](docs/TestCaseStatusBulkControllerApi.md#v2_test_case_bulk_status_set_post) | **POST** /api/v2/test-case/bulk/status/set | Set specified status for selected test cases
*TestCaseSyncControllerApi* | [**testcase_bulk_sync_post**](docs/TestCaseSyncControllerApi.md#testcase_bulk_sync_post) | **POST** /api/testcase/bulk/sync | Clone test case
*TestCaseTagBulkControllerApi* | [**v2_test_case_bulk_tag_add_post**](docs/TestCaseTagBulkControllerApi.md#v2_test_case_bulk_tag_add_post) | **POST** /api/v2/test-case/bulk/tag/add | Add tags for selected test cases
*TestCaseTagBulkControllerApi* | [**v2_test_case_bulk_tag_remove_post**](docs/TestCaseTagBulkControllerApi.md#v2_test_case_bulk_tag_remove_post) | **POST** /api/v2/test-case/bulk/tag/remove | Remove tags for selected test cases
*TestCaseTagControllerApi* | [**testcase_test_case_id_tag_get**](docs/TestCaseTagControllerApi.md#testcase_test_case_id_tag_get) | **GET** /api/testcase/{testCaseId}/tag | Find tags for test case
*TestCaseTagControllerApi* | [**testcase_test_case_id_tag_post**](docs/TestCaseTagControllerApi.md#testcase_test_case_id_tag_post) | **POST** /api/testcase/{testCaseId}/tag | Set test tags for test case
*TestCaseTestKeyControllerApi* | [**testcase_test_case_id_testkey_get**](docs/TestCaseTestKeyControllerApi.md#testcase_test_case_id_testkey_get) | **GET** /api/testcase/{testCaseId}/testkey | Find test keys for test case
*TestCaseTestKeyControllerApi* | [**testcase_test_case_id_testkey_post**](docs/TestCaseTestKeyControllerApi.md#testcase_test_case_id_testkey_post) | **POST** /api/testcase/{testCaseId}/testkey | Set test keys to test case
*TestCaseTestPlanBulkControllerApi* | [**v2_test_case_bulk_test_plan_create_post**](docs/TestCaseTestPlanBulkControllerApi.md#v2_test_case_bulk_test_plan_create_post) | **POST** /api/v2/test-case/bulk/test-plan/create | Create test plan from selected test cases
*TestCaseTreeBulkControllerV2Api* | [**v2_test_case_tree_bulk_drag_and_drop_post**](docs/TestCaseTreeBulkControllerV2Api.md#v2_test_case_tree_bulk_drag_and_drop_post) | **POST** /api/v2/test-case/tree/bulk/drag-and-drop | dragAndDrop test cases for trees
*TestCaseTreeControllerApi* | [**testcasetree_countleaves_get**](docs/TestCaseTreeControllerApi.md#testcasetree_countleaves_get) | **GET** /api/testcasetree/countleaves | Count all tree leaves for given path and filter
*TestCaseTreeControllerApi* | [**testcasetree_entity_get**](docs/TestCaseTreeControllerApi.md#testcasetree_entity_get) | **GET** /api/testcasetree/entity | 
*TestCaseTreeControllerApi* | [**testcasetree_group_get**](docs/TestCaseTreeControllerApi.md#testcasetree_group_get) | **GET** /api/testcasetree/group | Find tree groups for node (AQL)
*TestCaseTreeControllerApi* | [**testcasetree_group_post**](docs/TestCaseTreeControllerApi.md#testcasetree_group_post) | **POST** /api/testcasetree/group | Add a new group (AQL)
*TestCaseTreeControllerApi* | [**testcasetree_group_rename_post**](docs/TestCaseTreeControllerApi.md#testcasetree_group_rename_post) | **POST** /api/testcasetree/group/rename | Rename tree group (AQL)
*TestCaseTreeControllerApi* | [**testcasetree_job_post**](docs/TestCaseTreeControllerApi.md#testcasetree_job_post) | **POST** /api/testcasetree/job | Get information about jobs that will be used to run selected test cases
*TestCaseTreeControllerApi* | [**testcasetree_leaf_get**](docs/TestCaseTreeControllerApi.md#testcasetree_leaf_get) | **GET** /api/testcasetree/leaf | Find tree leaves for node (AQL)
*TestCaseTreeControllerApi* | [**testcasetree_leaf_post**](docs/TestCaseTreeControllerApi.md#testcasetree_leaf_post) | **POST** /api/testcasetree/leaf | Add a new group
*TestCaseTreeControllerApi* | [**testcasetree_leaf_rename_post**](docs/TestCaseTreeControllerApi.md#testcasetree_leaf_rename_post) | **POST** /api/testcasetree/leaf/rename | Rename tree leaf
*TestCaseTreeControllerApi* | [**testcasetree_paths_get**](docs/TestCaseTreeControllerApi.md#testcasetree_paths_get) | **GET** /api/testcasetree/paths | Find all paths to test case in tree
*TestCaseTreeControllerApi* | [**testcasetree_runstats_post**](docs/TestCaseTreeControllerApi.md#testcasetree_runstats_post) | **POST** /api/testcasetree/runstats | Get run information
*TestCaseTreeControllerApi* | [**testcasetree_suggest_get**](docs/TestCaseTreeControllerApi.md#testcasetree_suggest_get) | **GET** /api/testcasetree/suggest | Tree groups suggest
*TestCaseTreeControllerV2Api* | [**v2_project_project_id_test_case_tree_group_group_id_delete**](docs/TestCaseTreeControllerV2Api.md#v2_project_project_id_test_case_tree_group_group_id_delete) | **DELETE** /api/v2/project/{projectId}/test-case/tree/group/{groupId} | Delete the specified group
*TestCaseTreeControllerV2Api* | [**v2_project_project_id_test_case_tree_group_group_id_name_put**](docs/TestCaseTreeControllerV2Api.md#v2_project_project_id_test_case_tree_group_group_id_name_put) | **PUT** /api/v2/project/{projectId}/test-case/tree/group/{groupId}/name | Rename the specified group
*TestCaseTreeControllerV2Api* | [**v2_project_project_id_test_case_tree_group_post**](docs/TestCaseTreeControllerV2Api.md#v2_project_project_id_test_case_tree_group_post) | **POST** /api/v2/project/{projectId}/test-case/tree/group | Add a new group to the specified tree
*TestCaseTreeControllerV2Api* | [**v2_project_project_id_test_case_tree_group_put**](docs/TestCaseTreeControllerV2Api.md#v2_project_project_id_test_case_tree_group_put) | **PUT** /api/v2/project/{projectId}/test-case/tree/group | Add a new group to the specified tree and return group if it exists
*TestCaseTreeControllerV2Api* | [**v2_project_project_id_test_case_tree_leaf_leaf_id_name_put**](docs/TestCaseTreeControllerV2Api.md#v2_project_project_id_test_case_tree_leaf_leaf_id_name_put) | **PUT** /api/v2/project/{projectId}/test-case/tree/leaf/{leafId}/name | Rename the specified leaf
*TestCaseTreeControllerV2Api* | [**v2_project_project_id_test_case_tree_leaf_post**](docs/TestCaseTreeControllerV2Api.md#v2_project_project_id_test_case_tree_leaf_post) | **POST** /api/v2/project/{projectId}/test-case/tree/leaf | Add a new leaf to the specified tree
*TestCaseTreeControllerV2Api* | [**v2_project_project_id_test_case_tree_suggest_get**](docs/TestCaseTreeControllerV2Api.md#v2_project_project_id_test_case_tree_suggest_get) | **GET** /api/v2/project/{projectId}/test-case/tree/suggest | Tree groups suggest
*TestCaseTreeControllerV2Api* | [**v2_project_project_id_test_case_tree_tree_node_get**](docs/TestCaseTreeControllerV2Api.md#v2_project_project_id_test_case_tree_tree_node_get) | **GET** /api/v2/project/{projectId}/test-case/tree/tree-node | Get test cases as a tree structure (AQL)
*TestCaseTreeNodeMigrationControllerApi* | [**project_project_id_test_case_tree_migration_post**](docs/TestCaseTreeNodeMigrationControllerApi.md#project_project_id_test_case_tree_migration_post) | **POST** /api/project/{projectId}/test-case/tree/migration | Clear and load tree structure within the specified project
*TestCaseTreeNodeMigrationControllerApi* | [**project_project_id_test_case_tree_tree_id_migration_post**](docs/TestCaseTreeNodeMigrationControllerApi.md#project_project_id_test_case_tree_tree_id_migration_post) | **POST** /api/project/{projectId}/test-case/tree/{treeId}/migration | Clear and load the specified tree structure within the specified project
*TestCaseTreeNodeMigrationControllerApi* | [**project_test_case_tree_migration_post**](docs/TestCaseTreeNodeMigrationControllerApi.md#project_test_case_tree_migration_post) | **POST** /api/project/test-case/tree/migration | Clear and load tree structure for all projects
*TestCaseTreeSelectionControllerApi* | [**testcasetree_select_post**](docs/TestCaseTreeSelectionControllerApi.md#testcasetree_select_post) | **POST** /api/testcasetree/select | Count test cases by tree select
*TestCaseUpdateSchemaControllerApi* | [**testcaseupdateschema_get**](docs/TestCaseUpdateSchemaControllerApi.md#testcaseupdateschema_get) | **GET** /api/testcaseupdateschema | Find all test case update schemas for given project
*TestCaseUpdateSchemaControllerApi* | [**testcaseupdateschema_id_delete**](docs/TestCaseUpdateSchemaControllerApi.md#testcaseupdateschema_id_delete) | **DELETE** /api/testcaseupdateschema/{id} | Delete test case update schema by id
*TestCaseUpdateSchemaControllerApi* | [**testcaseupdateschema_id_get**](docs/TestCaseUpdateSchemaControllerApi.md#testcaseupdateschema_id_get) | **GET** /api/testcaseupdateschema/{id} | Find a test case update schemas by id
*TestCaseUpdateSchemaControllerApi* | [**testcaseupdateschema_id_patch**](docs/TestCaseUpdateSchemaControllerApi.md#testcaseupdateschema_id_patch) | **PATCH** /api/testcaseupdateschema/{id} | Patch test case update schema
*TestCaseUpdateSchemaControllerApi* | [**testcaseupdateschema_post**](docs/TestCaseUpdateSchemaControllerApi.md#testcaseupdateschema_post) | **POST** /api/testcaseupdateschema | Create a new test case update schema
*TestCaseVersionControllerApi* | [**testcase_id_version_get**](docs/TestCaseVersionControllerApi.md#testcase_id_version_get) | **GET** /api/testcase/{id}/version | Returns a list of version for test case
*TestCaseVersionControllerApi* | [**testcase_id_version_post**](docs/TestCaseVersionControllerApi.md#testcase_id_version_post) | **POST** /api/testcase/{id}/version | Create version for test case
*TestCaseVersionControllerApi* | [**testcase_version_id_data_get**](docs/TestCaseVersionControllerApi.md#testcase_version_id_data_get) | **GET** /api/testcase/version/{id}/data | Returns testcase overview data for given version
*TestCaseVersionControllerApi* | [**testcase_version_id_delete**](docs/TestCaseVersionControllerApi.md#testcase_version_id_delete) | **DELETE** /api/testcase/version/{id} | Delete version by id
*TestCaseVersionControllerApi* | [**testcase_version_id_get**](docs/TestCaseVersionControllerApi.md#testcase_version_id_get) | **GET** /api/testcase/version/{id} | Returns version row data
*TestCaseVersionControllerApi* | [**testcase_version_id_patch**](docs/TestCaseVersionControllerApi.md#testcase_version_id_patch) | **PATCH** /api/testcase/version/{id} | Patch version
*TestCaseVersionControllerApi* | [**testcase_version_id_restore_post**](docs/TestCaseVersionControllerApi.md#testcase_version_id_restore_post) | **POST** /api/testcase/version/{id}/restore | Create version for test case
*TestFixtureResultAttachmentControllerApi* | [**testfixtureresult_attachment_get**](docs/TestFixtureResultAttachmentControllerApi.md#testfixtureresult_attachment_get) | **GET** /api/testfixtureresult/attachment | 
*TestFixtureResultAttachmentControllerApi* | [**testfixtureresult_attachment_id_content_get**](docs/TestFixtureResultAttachmentControllerApi.md#testfixtureresult_attachment_id_content_get) | **GET** /api/testfixtureresult/attachment/{id}/content | 
*TestFixtureResultAttachmentControllerApi* | [**testfixtureresult_attachment_id_content_put**](docs/TestFixtureResultAttachmentControllerApi.md#testfixtureresult_attachment_id_content_put) | **PUT** /api/testfixtureresult/attachment/{id}/content | 
*TestFixtureResultAttachmentControllerApi* | [**testfixtureresult_attachment_id_delete**](docs/TestFixtureResultAttachmentControllerApi.md#testfixtureresult_attachment_id_delete) | **DELETE** /api/testfixtureresult/attachment/{id} | 
*TestFixtureResultAttachmentControllerApi* | [**testfixtureresult_attachment_id_patch**](docs/TestFixtureResultAttachmentControllerApi.md#testfixtureresult_attachment_id_patch) | **PATCH** /api/testfixtureresult/attachment/{id} | 
*TestFixtureResultAttachmentControllerApi* | [**testfixtureresult_attachment_post**](docs/TestFixtureResultAttachmentControllerApi.md#testfixtureresult_attachment_post) | **POST** /api/testfixtureresult/attachment | 
*TestKeyControllerApi* | [**testkey_id_get**](docs/TestKeyControllerApi.md#testkey_id_get) | **GET** /api/testkey/{id} | Find test key by id
*TestKeySchemaControllerApi* | [**testkeyschema_get**](docs/TestKeySchemaControllerApi.md#testkeyschema_get) | **GET** /api/testkeyschema | Find all test key schemas for given project
*TestKeySchemaControllerApi* | [**testkeyschema_id_delete**](docs/TestKeySchemaControllerApi.md#testkeyschema_id_delete) | **DELETE** /api/testkeyschema/{id} | Delete a test key schema by id
*TestKeySchemaControllerApi* | [**testkeyschema_id_get**](docs/TestKeySchemaControllerApi.md#testkeyschema_id_get) | **GET** /api/testkeyschema/{id} | Find a test key schema by id
*TestKeySchemaControllerApi* | [**testkeyschema_id_patch**](docs/TestKeySchemaControllerApi.md#testkeyschema_id_patch) | **PATCH** /api/testkeyschema/{id} | Patch a test key schema
*TestKeySchemaControllerApi* | [**testkeyschema_post**](docs/TestKeySchemaControllerApi.md#testkeyschema_post) | **POST** /api/testkeyschema | Create a new test key schema
*TestLayerControllerApi* | [**testlayer_get**](docs/TestLayerControllerApi.md#testlayer_get) | **GET** /api/testlayer | 
*TestLayerControllerApi* | [**testlayer_id_delete**](docs/TestLayerControllerApi.md#testlayer_id_delete) | **DELETE** /api/testlayer/{id} | 
*TestLayerControllerApi* | [**testlayer_id_get**](docs/TestLayerControllerApi.md#testlayer_id_get) | **GET** /api/testlayer/{id} | 
*TestLayerControllerApi* | [**testlayer_id_patch**](docs/TestLayerControllerApi.md#testlayer_id_patch) | **PATCH** /api/testlayer/{id} | 
*TestLayerControllerApi* | [**testlayer_post**](docs/TestLayerControllerApi.md#testlayer_post) | **POST** /api/testlayer | 
*TestLayerControllerApi* | [**testlayer_suggest_get**](docs/TestLayerControllerApi.md#testlayer_suggest_get) | **GET** /api/testlayer/suggest | 
*TestLayerSchemaControllerApi* | [**testlayerschema_get**](docs/TestLayerSchemaControllerApi.md#testlayerschema_get) | **GET** /api/testlayerschema | Find all test layer schemas for given project
*TestLayerSchemaControllerApi* | [**testlayerschema_id_delete**](docs/TestLayerSchemaControllerApi.md#testlayerschema_id_delete) | **DELETE** /api/testlayerschema/{id} | Delete test layer schema by id
*TestLayerSchemaControllerApi* | [**testlayerschema_id_get**](docs/TestLayerSchemaControllerApi.md#testlayerschema_id_get) | **GET** /api/testlayerschema/{id} | Find test layer schema by id
*TestLayerSchemaControllerApi* | [**testlayerschema_id_patch**](docs/TestLayerSchemaControllerApi.md#testlayerschema_id_patch) | **PATCH** /api/testlayerschema/{id} | Patch test layer schema
*TestLayerSchemaControllerApi* | [**testlayerschema_post**](docs/TestLayerSchemaControllerApi.md#testlayerschema_post) | **POST** /api/testlayerschema | Create a new test layer schema
*TestPlanControllerApi* | [**testplan_get**](docs/TestPlanControllerApi.md#testplan_get) | **GET** /api/testplan | Find all test plans for given project
*TestPlanControllerApi* | [**testplan_id_assign_post**](docs/TestPlanControllerApi.md#testplan_id_assign_post) | **POST** /api/testplan/{id}/assign | Assign test plan test cases to user
*TestPlanControllerApi* | [**testplan_id_delete**](docs/TestPlanControllerApi.md#testplan_id_delete) | **DELETE** /api/testplan/{id} | Delete test plan by given id
*TestPlanControllerApi* | [**testplan_id_diff_get**](docs/TestPlanControllerApi.md#testplan_id_diff_get) | **GET** /api/testplan/{id}/diff | Get test plan test cases changes
*TestPlanControllerApi* | [**testplan_id_get**](docs/TestPlanControllerApi.md#testplan_id_get) | **GET** /api/testplan/{id} | Find test plan by id
*TestPlanControllerApi* | [**testplan_id_job_get**](docs/TestPlanControllerApi.md#testplan_id_job_get) | **GET** /api/testplan/{id}/job | Get test plan jobs statistic
*TestPlanControllerApi* | [**testplan_id_jobparameter_post**](docs/TestPlanControllerApi.md#testplan_id_jobparameter_post) | **POST** /api/testplan/{id}/jobparameter | Configure test plan job parameters
*TestPlanControllerApi* | [**testplan_id_member_get**](docs/TestPlanControllerApi.md#testplan_id_member_get) | **GET** /api/testplan/{id}/member | Get test plan members statistic
*TestPlanControllerApi* | [**testplan_id_patch**](docs/TestPlanControllerApi.md#testplan_id_patch) | **PATCH** /api/testplan/{id} | Patch test plan
*TestPlanControllerApi* | [**testplan_id_resetjob_post**](docs/TestPlanControllerApi.md#testplan_id_resetjob_post) | **POST** /api/testplan/{id}/resetjob | Reset test plan
*TestPlanControllerApi* | [**testplan_id_run_post**](docs/TestPlanControllerApi.md#testplan_id_run_post) | **POST** /api/testplan/{id}/run | Run test plan by given id
*TestPlanControllerApi* | [**testplan_id_stat_get**](docs/TestPlanControllerApi.md#testplan_id_stat_get) | **GET** /api/testplan/{id}/stat | Get test plan test-cases statistic
*TestPlanControllerApi* | [**testplan_id_sync_post**](docs/TestPlanControllerApi.md#testplan_id_sync_post) | **POST** /api/testplan/{id}/sync | Sync test plan
*TestPlanControllerApi* | [**testplan_id_tree_group_get**](docs/TestPlanControllerApi.md#testplan_id_tree_group_get) | **GET** /api/testplan/{id}/tree/group | Find tree groups for node
*TestPlanControllerApi* | [**testplan_id_tree_leaf_get**](docs/TestPlanControllerApi.md#testplan_id_tree_leaf_get) | **GET** /api/testplan/{id}/tree/leaf | Find tree leafs for node
*TestPlanControllerApi* | [**testplan_post**](docs/TestPlanControllerApi.md#testplan_post) | **POST** /api/testplan | Create a new test plan
*TestPlanControllerApi* | [**testplan_suggest_get**](docs/TestPlanControllerApi.md#testplan_suggest_get) | **GET** /api/testplan/suggest | Suggest for test plans
*TestResultAttachmentControllerApi* | [**testresult_attachment_get**](docs/TestResultAttachmentControllerApi.md#testresult_attachment_get) | **GET** /api/testresult/attachment | 
*TestResultAttachmentControllerApi* | [**testresult_attachment_id_content_get**](docs/TestResultAttachmentControllerApi.md#testresult_attachment_id_content_get) | **GET** /api/testresult/attachment/{id}/content | 
*TestResultAttachmentControllerApi* | [**testresult_attachment_id_content_put**](docs/TestResultAttachmentControllerApi.md#testresult_attachment_id_content_put) | **PUT** /api/testresult/attachment/{id}/content | 
*TestResultAttachmentControllerApi* | [**testresult_attachment_id_delete**](docs/TestResultAttachmentControllerApi.md#testresult_attachment_id_delete) | **DELETE** /api/testresult/attachment/{id} | 
*TestResultAttachmentControllerApi* | [**testresult_attachment_id_patch**](docs/TestResultAttachmentControllerApi.md#testresult_attachment_id_patch) | **PATCH** /api/testresult/attachment/{id} | 
*TestResultAttachmentControllerApi* | [**testresult_attachment_post**](docs/TestResultAttachmentControllerApi.md#testresult_attachment_post) | **POST** /api/testresult/attachment | 
*TestResultBulkControllerApi* | [**testresult_bulk_assign_post**](docs/TestResultBulkControllerApi.md#testresult_bulk_assign_post) | **POST** /api/testresult/bulk/assign | Assign all selected test results
*TestResultBulkControllerApi* | [**testresult_bulk_defect_link_post**](docs/TestResultBulkControllerApi.md#testresult_bulk_defect_link_post) | **POST** /api/testresult/bulk/defect/link | Link defects for all selected test results
*TestResultBulkControllerApi* | [**testresult_bulk_hide_post**](docs/TestResultBulkControllerApi.md#testresult_bulk_hide_post) | **POST** /api/testresult/bulk/hide | Hide all selected test results
*TestResultBulkControllerApi* | [**testresult_bulk_mute_post**](docs/TestResultBulkControllerApi.md#testresult_bulk_mute_post) | **POST** /api/testresult/bulk/mute | Mute all selected test results
*TestResultBulkControllerApi* | [**testresult_bulk_rerun_post**](docs/TestResultBulkControllerApi.md#testresult_bulk_rerun_post) | **POST** /api/testresult/bulk/rerun | Rerun all selected test results
*TestResultBulkControllerApi* | [**testresult_bulk_resolve_post**](docs/TestResultBulkControllerApi.md#testresult_bulk_resolve_post) | **POST** /api/testresult/bulk/resolve | Resolve all selected test results
*TestResultBulkControllerApi* | [**testresult_bulk_tag_add_post**](docs/TestResultBulkControllerApi.md#testresult_bulk_tag_add_post) | **POST** /api/testresult/bulk/tag/add | Add tags for all selected test results
*TestResultBulkControllerApi* | [**testresult_bulk_tag_remove_post**](docs/TestResultBulkControllerApi.md#testresult_bulk_tag_remove_post) | **POST** /api/testresult/bulk/tag/remove | Remove tags for all selected test results
*TestResultBulkControllerApi* | [**testresult_bulk_unmute_post**](docs/TestResultBulkControllerApi.md#testresult_bulk_unmute_post) | **POST** /api/testresult/bulk/unmute | Unmute all selected test results
*TestResultBulkControllerV2Api* | [**v2_test_result_bulk_stats_post**](docs/TestResultBulkControllerV2Api.md#v2_test_result_bulk_stats_post) | **POST** /api/v2/test-result/bulk/stats | Get selected test results statistic
*TestResultControllerApi* | [**testresult_defects_get**](docs/TestResultControllerApi.md#testresult_defects_get) | **GET** /api/testresult/defects | Find defects by launch id
*TestResultControllerApi* | [**testresult_get**](docs/TestResultControllerApi.md#testresult_get) | **GET** /api/testresult | Finds all test results by given launch
*TestResultControllerApi* | [**testresult_id_delete**](docs/TestResultControllerApi.md#testresult_id_delete) | **DELETE** /api/testresult/{id} | Delete test result by given id
*TestResultControllerApi* | [**testresult_id_execution_get**](docs/TestResultControllerApi.md#testresult_id_execution_get) | **GET** /api/testresult/{id}/execution | Find all execution for given test result
*TestResultControllerApi* | [**testresult_id_get**](docs/TestResultControllerApi.md#testresult_id_get) | **GET** /api/testresult/{id} | 
*TestResultControllerApi* | [**testresult_id_history_get**](docs/TestResultControllerApi.md#testresult_id_history_get) | **GET** /api/testresult/{id}/history | Find all history for given test result
*TestResultControllerApi* | [**testresult_id_patch**](docs/TestResultControllerApi.md#testresult_id_patch) | **PATCH** /api/testresult/{id} | Patches a test result by given id
*TestResultControllerApi* | [**testresult_id_retries_get**](docs/TestResultControllerApi.md#testresult_id_retries_get) | **GET** /api/testresult/{id}/retries | Find all retries for given test result
*TestResultControllerApi* | [**testresult_post**](docs/TestResultControllerApi.md#testresult_post) | **POST** /api/testresult | Create a new test result
*TestResultControllerApi* | [**testresult_timeline_get**](docs/TestResultControllerApi.md#testresult_timeline_get) | **GET** /api/testresult/timeline | Find timeline data
*TestResultCustomFieldControllerApi* | [**testresult_test_result_id_cfv_get**](docs/TestResultCustomFieldControllerApi.md#testresult_test_result_id_cfv_get) | **GET** /api/testresult/{testResultId}/cfv | Find custom fields with values for test result
*TestResultCustomFieldControllerApi* | [**testresult_test_result_id_cfv_post**](docs/TestResultCustomFieldControllerApi.md#testresult_test_result_id_cfv_post) | **POST** /api/testresult/{testResultId}/cfv | Set custom field values to test result
*TestResultDefectControllerApi* | [**testresult_defect_match_get**](docs/TestResultDefectControllerApi.md#testresult_defect_match_get) | **GET** /api/testresult/defect/match | 
*TestResultDefectControllerApi* | [**testresult_id_defect_candidate_get**](docs/TestResultDefectControllerApi.md#testresult_id_defect_candidate_get) | **GET** /api/testresult/{id}/defect/candidate | 
*TestResultDefectControllerApi* | [**testresult_id_defect_similar_get**](docs/TestResultDefectControllerApi.md#testresult_id_defect_similar_get) | **GET** /api/testresult/{id}/defect/similar | 
*TestResultDefectControllerApi* | [**testresult_test_result_id_defect_defect_id_delete**](docs/TestResultDefectControllerApi.md#testresult_test_result_id_defect_defect_id_delete) | **DELETE** /api/testresult/{testResultId}/defect/{defectId} | 
*TestResultDefectControllerApi* | [**testresult_test_result_id_defect_defect_id_post**](docs/TestResultDefectControllerApi.md#testresult_test_result_id_defect_defect_id_post) | **POST** /api/testresult/{testResultId}/defect/{defectId} | 
*TestResultDefectControllerApi* | [**testresult_test_result_id_defect_get**](docs/TestResultDefectControllerApi.md#testresult_test_result_id_defect_get) | **GET** /api/testresult/{testResultId}/defect | 
*TestResultDefectControllerApi* | [**testresult_test_result_id_defect_post**](docs/TestResultDefectControllerApi.md#testresult_test_result_id_defect_post) | **POST** /api/testresult/{testResultId}/defect | 
*TestResultEnvVarControllerApi* | [**testresult_test_result_id_evv_get**](docs/TestResultEnvVarControllerApi.md#testresult_test_result_id_evv_get) | **GET** /api/testresult/{testResultId}/evv | Find environment variables for test result
*TestResultFixtureControllerApi* | [**testresult_test_result_id_fixture_attachment_get**](docs/TestResultFixtureControllerApi.md#testresult_test_result_id_fixture_attachment_get) | **GET** /api/testresult/{testResultId}/fixture/attachment | Find fixtures attachments for test result
*TestResultFixtureControllerApi* | [**testresult_test_result_id_fixture_get**](docs/TestResultFixtureControllerApi.md#testresult_test_result_id_fixture_get) | **GET** /api/testresult/{testResultId}/fixture | Find fixtures for test result
*TestResultFlatControllerApi* | [**v2_launch_launch_id_test_result_flat_get**](docs/TestResultFlatControllerApi.md#v2_launch_launch_id_test_result_flat_get) | **GET** /api/v2/launch/{launchId}/test-result/flat | Get test results as a flat structure
*TestResultIssueControllerApi* | [**testresult_test_result_id_issue_get**](docs/TestResultIssueControllerApi.md#testresult_test_result_id_issue_get) | **GET** /api/testresult/{testResultId}/issue | Find issues for test result
*TestResultIssueControllerApi* | [**testresult_test_result_id_issue_post**](docs/TestResultIssueControllerApi.md#testresult_test_result_id_issue_post) | **POST** /api/testresult/{testResultId}/issue | Set issues to test result
*TestResultMembersControllerApi* | [**testresult_test_result_id_members_get**](docs/TestResultMembersControllerApi.md#testresult_test_result_id_members_get) | **GET** /api/testresult/{testResultId}/members | Find user roles for test result
*TestResultMembersControllerApi* | [**testresult_test_result_id_members_post**](docs/TestResultMembersControllerApi.md#testresult_test_result_id_members_post) | **POST** /api/testresult/{testResultId}/members | Set user roles for test result
*TestResultMuteControllerApi* | [**testresult_id_mute_post**](docs/TestResultMuteControllerApi.md#testresult_id_mute_post) | **POST** /api/testresult/{id}/mute | Mute test result
*TestResultMuteControllerApi* | [**testresult_id_unmute_post**](docs/TestResultMuteControllerApi.md#testresult_id_unmute_post) | **POST** /api/testresult/{id}/unmute | Unmute test result
*TestResultRequirementControllerApi* | [**testresult_test_result_id_requirement_get**](docs/TestResultRequirementControllerApi.md#testresult_test_result_id_requirement_get) | **GET** /api/testresult/{testResultId}/requirement | Find requirements for test result
*TestResultRerunControllerApi* | [**testresult_test_result_id_rerun_post**](docs/TestResultRerunControllerApi.md#testresult_test_result_id_rerun_post) | **POST** /api/testresult/{testResultId}/rerun | Schedule manual rerun for test case
*TestResultRerunControllerApi* | [**testresult_test_result_id_retry_post**](docs/TestResultRerunControllerApi.md#testresult_test_result_id_retry_post) | **POST** /api/testresult/{testResultId}/retry | Schedule manual rerun for test case
*TestResultRunControllerApi* | [**testresult_id_assign_post**](docs/TestResultRunControllerApi.md#testresult_id_assign_post) | **POST** /api/testresult/{id}/assign | Assign test result
*TestResultRunControllerApi* | [**testresult_id_in_progress_post**](docs/TestResultRunControllerApi.md#testresult_id_in_progress_post) | **POST** /api/testresult/{id}/in-progress | Set test result in progress
*TestResultRunControllerApi* | [**testresult_id_resolve_post**](docs/TestResultRunControllerApi.md#testresult_id_resolve_post) | **POST** /api/testresult/{id}/resolve | Resolve test result
*TestResultSearchControllerApi* | [**testresult_query_validate_get**](docs/TestResultSearchControllerApi.md#testresult_query_validate_get) | **GET** /api/testresult/query/validate | Find all test results by given AQL
*TestResultSearchControllerApi* | [**testresult_search_get**](docs/TestResultSearchControllerApi.md#testresult_search_get) | **GET** /api/testresult/__search | Find all test results by given AQL
*TestResultStatusBulkControllerApi* | [**v2_test_result_bulk_resolve_post**](docs/TestResultStatusBulkControllerApi.md#v2_test_result_bulk_resolve_post) | **POST** /api/v2/test-result/bulk/resolve | Resolve selected test results
*TestResultTestKeyControllerApi* | [**testresult_test_result_id_testkey_get**](docs/TestResultTestKeyControllerApi.md#testresult_test_result_id_testkey_get) | **GET** /api/testresult/{testResultId}/testkey | Find test keys for test result
*TestResultTestKeyControllerApi* | [**testresult_test_result_id_testkey_post**](docs/TestResultTestKeyControllerApi.md#testresult_test_result_id_testkey_post) | **POST** /api/testresult/{testResultId}/testkey | Set test keys to test result
*TestResultTreeControllerApi* | [**testresulttree_countleaves_get**](docs/TestResultTreeControllerApi.md#testresulttree_countleaves_get) | **GET** /api/testresulttree/countleaves | Count tree leafs for node
*TestResultTreeControllerApi* | [**testresulttree_group_get**](docs/TestResultTreeControllerApi.md#testresulttree_group_get) | **GET** /api/testresulttree/group | Find tree groups for node
*TestResultTreeControllerApi* | [**testresulttree_leaf_get**](docs/TestResultTreeControllerApi.md#testresulttree_leaf_get) | **GET** /api/testresulttree/leaf | Find tree leafs for node
*TestResultTreeControllerV2Api* | [**v2_launch_launch_id_test_result_tree_entity_get**](docs/TestResultTreeControllerV2Api.md#v2_launch_launch_id_test_result_tree_entity_get) | **GET** /api/v2/launch/{launchId}/test-result/tree/entity | Get test results as a tree structure
*TestResultTreeControllerV2Api* | [**v2_launch_launch_id_test_result_tree_folder_get**](docs/TestResultTreeControllerV2Api.md#v2_launch_launch_id_test_result_tree_folder_get) | **GET** /api/v2/launch/{launchId}/test-result/tree/folder | Get test results as a tree structure
*TestResultTreeSelectionControllerApi* | [**testresulttree_select_post**](docs/TestResultTreeSelectionControllerApi.md#testresulttree_select_post) | **POST** /api/testresulttree/select | Count test cases by tree select
*TestTagControllerApi* | [**tag_get**](docs/TestTagControllerApi.md#tag_get) | **GET** /api/tag | Find all test tags
*TestTagControllerApi* | [**tag_id_delete**](docs/TestTagControllerApi.md#tag_id_delete) | **DELETE** /api/tag/{id} | Delete test tag by id
*TestTagControllerApi* | [**tag_id_get**](docs/TestTagControllerApi.md#tag_id_get) | **GET** /api/tag/{id} | Find test tag by id
*TestTagControllerApi* | [**tag_id_patch**](docs/TestTagControllerApi.md#tag_id_patch) | **PATCH** /api/tag/{id} | Patch test tag
*TestTagControllerApi* | [**tag_post**](docs/TestTagControllerApi.md#tag_post) | **POST** /api/tag | Create a new test tag
*TestTagControllerApi* | [**tag_suggest_get**](docs/TestTagControllerApi.md#tag_suggest_get) | **GET** /api/tag/suggest | Suggest test tags
*TreeControllerApi* | [**tree_get**](docs/TreeControllerApi.md#tree_get) | **GET** /api/tree | 
*TreeControllerApi* | [**tree_id_delete**](docs/TreeControllerApi.md#tree_id_delete) | **DELETE** /api/tree/{id} | 
*TreeControllerApi* | [**tree_id_get**](docs/TreeControllerApi.md#tree_id_get) | **GET** /api/tree/{id} | 
*TreeControllerApi* | [**tree_id_patch**](docs/TreeControllerApi.md#tree_id_patch) | **PATCH** /api/tree/{id} | 
*TreeControllerApi* | [**tree_post**](docs/TreeControllerApi.md#tree_post) | **POST** /api/tree | 
*TreeControllerApi* | [**tree_suggest_get**](docs/TreeControllerApi.md#tree_suggest_get) | **GET** /api/tree/suggest | 
*TreeControllerV2Api* | [**v2_tree_get**](docs/TreeControllerV2Api.md#v2_tree_get) | **GET** /api/v2/tree | 
*TreeControllerV2Api* | [**v2_tree_id_get**](docs/TreeControllerV2Api.md#v2_tree_id_get) | **GET** /api/v2/tree/{id} | 
*TreeFolderControllerApi* | [**tree_folder_project_id_drag_and_drop_post**](docs/TreeFolderControllerApi.md#tree_folder_project_id_drag_and_drop_post) | **POST** /api/tree-folder/{projectId}/drag-and-drop | Move folder or testcase to new parent or update position
*TreeFolderControllerApi* | [**tree_folder_project_id_folder_id_content_get**](docs/TreeFolderControllerApi.md#tree_folder_project_id_folder_id_content_get) | **GET** /api/tree-folder/{projectId}/{folderId}/content | Get folder content including subfolders and test cases
*TreeFolderControllerApi* | [**tree_folder_project_id_folder_id_delete**](docs/TreeFolderControllerApi.md#tree_folder_project_id_folder_id_delete) | **DELETE** /api/tree-folder/{projectId}/{folderId} | Delete folder and all its descendants
*TreeFolderControllerApi* | [**tree_folder_project_id_folder_id_description_get**](docs/TreeFolderControllerApi.md#tree_folder_project_id_folder_id_description_get) | **GET** /api/tree-folder/{projectId}/{folderId}/description | Get folder description
*TreeFolderControllerApi* | [**tree_folder_project_id_folder_id_patch**](docs/TreeFolderControllerApi.md#tree_folder_project_id_folder_id_patch) | **PATCH** /api/tree-folder/{projectId}/{folderId} | Update folder name and description
*TreeFolderControllerApi* | [**tree_folder_project_id_folder_id_test_cases_test_case_id_delete**](docs/TreeFolderControllerApi.md#tree_folder_project_id_folder_id_test_cases_test_case_id_delete) | **DELETE** /api/tree-folder/{projectId}/{folderId}/test-cases/{testCaseId} | Remove test case from folder
*TreeFolderControllerApi* | [**tree_folder_project_id_folder_post**](docs/TreeFolderControllerApi.md#tree_folder_project_id_folder_post) | **POST** /api/tree-folder/{projectId}/folder | Create a new folder
*TreeFolderControllerApi* | [**tree_folder_project_id_get**](docs/TreeFolderControllerApi.md#tree_folder_project_id_get) | **GET** /api/tree-folder/{projectId} | Get paginated list of root folders and unassigned test cases
*TreeFolderControllerApi* | [**tree_folder_project_id_suggest_get**](docs/TreeFolderControllerApi.md#tree_folder_project_id_suggest_get) | **GET** /api/tree-folder/{projectId}/suggest | Suggest distinct folder names
*TreeFolderControllerApi* | [**tree_folder_project_id_test_case_post**](docs/TreeFolderControllerApi.md#tree_folder_project_id_test_case_post) | **POST** /api/tree-folder/{projectId}/test-case | Create a new testcase
*TreePathControllerApi* | [**treepath_get**](docs/TreePathControllerApi.md#treepath_get) | **GET** /api/treepath | 
*TreePathControllerApi* | [**treepath_id_delete**](docs/TreePathControllerApi.md#treepath_id_delete) | **DELETE** /api/treepath/{id} | 
*TreePathControllerApi* | [**treepath_path_get**](docs/TreePathControllerApi.md#treepath_path_get) | **GET** /api/treepath/path | 
*TreePathControllerApi* | [**treepath_post**](docs/TreePathControllerApi.md#treepath_post) | **POST** /api/treepath | 
*UploadControllerApi* | [**upload_archive_post**](docs/UploadControllerApi.md#upload_archive_post) | **POST** /api/upload/archive | Upload archives with test results
*UploadControllerApi* | [**upload_file_post**](docs/UploadControllerApi.md#upload_file_post) | **POST** /api/upload/file | Upload files with test results
*UploadControllerApi* | [**upload_jobrun_get**](docs/UploadControllerApi.md#upload_jobrun_get) | **GET** /api/upload/jobrun | Get information about job run by id
*UploadControllerApi* | [**upload_post**](docs/UploadControllerApi.md#upload_post) | **POST** /api/upload | Upload test results
*UploadControllerApi* | [**upload_run_post**](docs/UploadControllerApi.md#upload_run_post) | **POST** /api/upload/run | Notifies about external job run start
*UploadControllerApi* | [**upload_session_post**](docs/UploadControllerApi.md#upload_session_post) | **POST** /api/upload/session | Creates test session for manual upload
*UploadControllerApi* | [**upload_start_post**](docs/UploadControllerApi.md#upload_start_post) | **POST** /api/upload/start | Notifies about external job run start
*UploadControllerApi* | [**upload_stop_post**](docs/UploadControllerApi.md#upload_stop_post) | **POST** /api/upload/stop | Notifies about external job run stop
*UserControllerApi* | [**user_suggest_get**](docs/UserControllerApi.md#user_suggest_get) | **GET** /api/user/suggest | Get suggest for users
*WebhookControllerApi* | [**notification_webhook_get**](docs/WebhookControllerApi.md#notification_webhook_get) | **GET** /api/notification/webhook | Find webhooks in project
*WebhookControllerApi* | [**notification_webhook_id_delete**](docs/WebhookControllerApi.md#notification_webhook_id_delete) | **DELETE** /api/notification/webhook/{id} | 
*WebhookControllerApi* | [**notification_webhook_id_disable_post**](docs/WebhookControllerApi.md#notification_webhook_id_disable_post) | **POST** /api/notification/webhook/{id}/disable | Disable webhook by given id
*WebhookControllerApi* | [**notification_webhook_id_enable_post**](docs/WebhookControllerApi.md#notification_webhook_id_enable_post) | **POST** /api/notification/webhook/{id}/enable | Enable webhook by given id
*WebhookControllerApi* | [**notification_webhook_id_get**](docs/WebhookControllerApi.md#notification_webhook_id_get) | **GET** /api/notification/webhook/{id} | Find webhook by given id
*WebhookControllerApi* | [**notification_webhook_id_patch**](docs/WebhookControllerApi.md#notification_webhook_id_patch) | **PATCH** /api/notification/webhook/{id} | 
*WebhookControllerApi* | [**notification_webhook_post**](docs/WebhookControllerApi.md#notification_webhook_post) | **POST** /api/notification/webhook | 
*WebhookControllerApi* | [**notification_webhook_validate_post**](docs/WebhookControllerApi.md#notification_webhook_validate_post) | **POST** /api/notification/webhook/validate | 
*WidgetControllerApi* | [**widget_get**](docs/WidgetControllerApi.md#widget_get) | **GET** /api/widget | 
*WidgetControllerApi* | [**widget_id_data_get**](docs/WidgetControllerApi.md#widget_id_data_get) | **GET** /api/widget/{id}/data | 
*WidgetControllerApi* | [**widget_id_delete**](docs/WidgetControllerApi.md#widget_id_delete) | **DELETE** /api/widget/{id} | 
*WidgetControllerApi* | [**widget_id_get**](docs/WidgetControllerApi.md#widget_id_get) | **GET** /api/widget/{id} | 
*WidgetControllerApi* | [**widget_id_patch**](docs/WidgetControllerApi.md#widget_id_patch) | **PATCH** /api/widget/{id} | 
*WidgetControllerApi* | [**widget_post**](docs/WidgetControllerApi.md#widget_post) | **POST** /api/widget | 
*WorkflowControllerApi* | [**workflow_get**](docs/WorkflowControllerApi.md#workflow_get) | **GET** /api/workflow | Find all workflows
*WorkflowControllerApi* | [**workflow_id_delete**](docs/WorkflowControllerApi.md#workflow_id_delete) | **DELETE** /api/workflow/{id} | Delete workflow by given id
*WorkflowControllerApi* | [**workflow_id_get**](docs/WorkflowControllerApi.md#workflow_id_get) | **GET** /api/workflow/{id} | Find workflow by given id
*WorkflowControllerApi* | [**workflow_id_patch**](docs/WorkflowControllerApi.md#workflow_id_patch) | **PATCH** /api/workflow/{id} | Patch workflow
*WorkflowControllerApi* | [**workflow_post**](docs/WorkflowControllerApi.md#workflow_post) | **POST** /api/workflow | Create a new workflow
*WorkflowControllerApi* | [**workflow_suggest_get**](docs/WorkflowControllerApi.md#workflow_suggest_get) | **GET** /api/workflow/suggest | Suggest workflows
*WorkflowSchemaControllerApi* | [**workflowschema_get**](docs/WorkflowSchemaControllerApi.md#workflowschema_get) | **GET** /api/workflowschema | Find all workflow schemas for given project
*WorkflowSchemaControllerApi* | [**workflowschema_id_delete**](docs/WorkflowSchemaControllerApi.md#workflowschema_id_delete) | **DELETE** /api/workflowschema/{id} | Delete workflow schema by given id
*WorkflowSchemaControllerApi* | [**workflowschema_id_get**](docs/WorkflowSchemaControllerApi.md#workflowschema_id_get) | **GET** /api/workflowschema/{id} | Find workflow schema by given id
*WorkflowSchemaControllerApi* | [**workflowschema_id_patch**](docs/WorkflowSchemaControllerApi.md#workflowschema_id_patch) | **PATCH** /api/workflowschema/{id} | Update workflow schema
*WorkflowSchemaControllerApi* | [**workflowschema_post**](docs/WorkflowSchemaControllerApi.md#workflowschema_post) | **POST** /api/workflowschema | Create a new workflow schema


## Documentation For Models

 - [AccessGroupBulkDto](docs/AccessGroupBulkDto.md)
 - [AccessGroupCreateDto](docs/AccessGroupCreateDto.md)
 - [AccessGroupDto](docs/AccessGroupDto.md)
 - [AccessGroupPaDto](docs/AccessGroupPaDto.md)
 - [AccessGroupPatchDto](docs/AccessGroupPatchDto.md)
 - [AccessGroupProjectAccessDto](docs/AccessGroupProjectAccessDto.md)
 - [AccessGroupProjectsAddDto](docs/AccessGroupProjectsAddDto.md)
 - [AccessGroupUserDto](docs/AccessGroupUserDto.md)
 - [AccessGroupUsersAddDto](docs/AccessGroupUsersAddDto.md)
 - [AccountChangePasswordRequestDto](docs/AccountChangePasswordRequestDto.md)
 - [AccountDto](docs/AccountDto.md)
 - [AccountGeneratedPasswordDto](docs/AccountGeneratedPasswordDto.md)
 - [AccountPatchDto](docs/AccountPatchDto.md)
 - [AccountRegistrationRequestDto](docs/AccountRegistrationRequestDto.md)
 - [AccountSessionPresenceDto](docs/AccountSessionPresenceDto.md)
 - [AllowedRoleDto](docs/AllowedRoleDto.md)
 - [AnalyticAutomationTrendDto](docs/AnalyticAutomationTrendDto.md)
 - [AnalyticDto](docs/AnalyticDto.md)
 - [AnalyticInterval](docs/AnalyticInterval.md)
 - [AnalyticLaunchDurationHistogramDto](docs/AnalyticLaunchDurationHistogramDto.md)
 - [AnalyticMuteTrendDto](docs/AnalyticMuteTrendDto.md)
 - [AnalyticTcAutomationCountDto](docs/AnalyticTcAutomationCountDto.md)
 - [AnalyticTcStatusCountDto](docs/AnalyticTcStatusCountDto.md)
 - [AnalyticTrByStatusTrendDto](docs/AnalyticTrByStatusTrendDto.md)
 - [ApiTokenCreateDto](docs/ApiTokenCreateDto.md)
 - [ApiTokenDto](docs/ApiTokenDto.md)
 - [ApiTokenFullDto](docs/ApiTokenFullDto.md)
 - [AqlValidateResponseDto](docs/AqlValidateResponseDto.md)
 - [AssignRequestDto](docs/AssignRequestDto.md)
 - [AsyncJobDto](docs/AsyncJobDto.md)
 - [AsyncJobStatusDto](docs/AsyncJobStatusDto.md)
 - [AsyncJobStepDto](docs/AsyncJobStepDto.md)
 - [AsyncJobStepStatusDto](docs/AsyncJobStepStatusDto.md)
 - [AsyncJobWithStepsDto](docs/AsyncJobWithStepsDto.md)
 - [AttachmentRow](docs/AttachmentRow.md)
 - [AttachmentStepDto](docs/AttachmentStepDto.md)
 - [Attrs](docs/Attrs.md)
 - [AuditActionTypeDto](docs/AuditActionTypeDto.md)
 - [AuthProviderType](docs/AuthProviderType.md)
 - [AuthorityType](docs/AuthorityType.md)
 - [AuthorityTypeDto](docs/AuthorityTypeDto.md)
 - [BlobStorageStats](docs/BlobStorageStats.md)
 - [BlobStorageUpdateStats](docs/BlobStorageUpdateStats.md)
 - [BodyStepDto](docs/BodyStepDto.md)
 - [BoldMark](docs/BoldMark.md)
 - [BusinessMetricDto](docs/BusinessMetricDto.md)
 - [CategoryCountRowDto](docs/CategoryCountRowDto.md)
 - [CategoryCreateDto](docs/CategoryCreateDto.md)
 - [CategoryDto](docs/CategoryDto.md)
 - [CategoryMatcherCreateDto](docs/CategoryMatcherCreateDto.md)
 - [CategoryMatcherDto](docs/CategoryMatcherDto.md)
 - [CategoryMatcherPatchDto](docs/CategoryMatcherPatchDto.md)
 - [CategoryPatchDto](docs/CategoryPatchDto.md)
 - [CfvMergeToExistingGlobalValueDto](docs/CfvMergeToExistingGlobalValueDto.md)
 - [CfvMergeToNewGlobalValueDto](docs/CfvMergeToNewGlobalValueDto.md)
 - [Ci](docs/Ci.md)
 - [CleanerSchemaCreateDto](docs/CleanerSchemaCreateDto.md)
 - [CleanerSchemaDto](docs/CleanerSchemaDto.md)
 - [CleanerSchemaPatchDto](docs/CleanerSchemaPatchDto.md)
 - [CleanerSchemaTargetDto](docs/CleanerSchemaTargetDto.md)
 - [CodeBlockDocumentNode](docs/CodeBlockDocumentNode.md)
 - [CodeMark](docs/CodeMark.md)
 - [CommentCreateDto](docs/CommentCreateDto.md)
 - [CommentDto](docs/CommentDto.md)
 - [CommentPatchDto](docs/CommentPatchDto.md)
 - [ConfirmMfaSettingsDto](docs/ConfirmMfaSettingsDto.md)
 - [CreateLaunchEvent](docs/CreateLaunchEvent.md)
 - [CsrfToken](docs/CsrfToken.md)
 - [CsvImportOptions](docs/CsvImportOptions.md)
 - [CustomFieldBulkAddToProjectsDto](docs/CustomFieldBulkAddToProjectsDto.md)
 - [CustomFieldBulkArchiveDto](docs/CustomFieldBulkArchiveDto.md)
 - [CustomFieldCreateDto](docs/CustomFieldCreateDto.md)
 - [CustomFieldDto](docs/CustomFieldDto.md)
 - [CustomFieldExportFieldMapping](docs/CustomFieldExportFieldMapping.md)
 - [CustomFieldImportFieldMapping](docs/CustomFieldImportFieldMapping.md)
 - [CustomFieldMergeDto](docs/CustomFieldMergeDto.md)
 - [CustomFieldPatchDto](docs/CustomFieldPatchDto.md)
 - [CustomFieldProjectCountDto](docs/CustomFieldProjectCountDto.md)
 - [CustomFieldProjectDto](docs/CustomFieldProjectDto.md)
 - [CustomFieldProjectPatchDto](docs/CustomFieldProjectPatchDto.md)
 - [CustomFieldProjectWithValuesDto](docs/CustomFieldProjectWithValuesDto.md)
 - [CustomFieldRawDto](docs/CustomFieldRawDto.md)
 - [CustomFieldSchemaCountDto](docs/CustomFieldSchemaCountDto.md)
 - [CustomFieldSchemaCreateDto](docs/CustomFieldSchemaCreateDto.md)
 - [CustomFieldSchemaDto](docs/CustomFieldSchemaDto.md)
 - [CustomFieldSchemaPatchDto](docs/CustomFieldSchemaPatchDto.md)
 - [CustomFieldValueBulkDeleteDto](docs/CustomFieldValueBulkDeleteDto.md)
 - [CustomFieldValueBulkMergeDto](docs/CustomFieldValueBulkMergeDto.md)
 - [CustomFieldValueDto](docs/CustomFieldValueDto.md)
 - [CustomFieldValuePatchDto](docs/CustomFieldValuePatchDto.md)
 - [CustomFieldValueProjectCreateDto](docs/CustomFieldValueProjectCreateDto.md)
 - [CustomFieldValueProjectMergeByIdDto](docs/CustomFieldValueProjectMergeByIdDto.md)
 - [CustomFieldValueProjectMergeByNameDto](docs/CustomFieldValueProjectMergeByNameDto.md)
 - [CustomFieldValueProjectPatchDto](docs/CustomFieldValueProjectPatchDto.md)
 - [CustomFieldValueProjectRenameDto](docs/CustomFieldValueProjectRenameDto.md)
 - [CustomFieldValueWithCfDto](docs/CustomFieldValueWithCfDto.md)
 - [CustomFieldValueWithTcCountDto](docs/CustomFieldValueWithTcCountDto.md)
 - [CustomFieldWithValuesDto](docs/CustomFieldWithValuesDto.md)
 - [DashboardCopyDto](docs/DashboardCopyDto.md)
 - [DashboardCreateDto](docs/DashboardCreateDto.md)
 - [DashboardDragAndDropDto](docs/DashboardDragAndDropDto.md)
 - [DashboardDto](docs/DashboardDto.md)
 - [DashboardOverviewDto](docs/DashboardOverviewDto.md)
 - [DashboardPatchDto](docs/DashboardPatchDto.md)
 - [DashboardUpdateDto](docs/DashboardUpdateDto.md)
 - [DefaultCustomFieldValueDto](docs/DefaultCustomFieldValueDto.md)
 - [DefaultTextMarkupDocument](docs/DefaultTextMarkupDocument.md)
 - [DefaultTextMarkupDocumentAllOfContent](docs/DefaultTextMarkupDocumentAllOfContent.md)
 - [DefaultWebhookSettings](docs/DefaultWebhookSettings.md)
 - [DefaultWebhookSettingsAllOfSubjects](docs/DefaultWebhookSettingsAllOfSubjects.md)
 - [DefectBulkDto](docs/DefectBulkDto.md)
 - [DefectCountRowDto](docs/DefectCountRowDto.md)
 - [DefectCreateDto](docs/DefectCreateDto.md)
 - [DefectDto](docs/DefectDto.md)
 - [DefectIssueLinkDto](docs/DefectIssueLinkDto.md)
 - [DefectMatcherCreateDto](docs/DefectMatcherCreateDto.md)
 - [DefectMatcherDto](docs/DefectMatcherDto.md)
 - [DefectMatcherPatchDto](docs/DefectMatcherPatchDto.md)
 - [DefectOverviewDto](docs/DefectOverviewDto.md)
 - [DefectPatchDto](docs/DefectPatchDto.md)
 - [DefectRowDto](docs/DefectRowDto.md)
 - [DefectWebhook](docs/DefectWebhook.md)
 - [DiffValueChangeBoolean](docs/DiffValueChangeBoolean.md)
 - [DiffValueChangeLong](docs/DiffValueChangeLong.md)
 - [DiffValueChangeSetLong](docs/DiffValueChangeSetLong.md)
 - [DiffValueChangeString](docs/DiffValueChangeString.md)
 - [DocumentNode](docs/DocumentNode.md)
 - [EnvVarCreateDto](docs/EnvVarCreateDto.md)
 - [EnvVarDto](docs/EnvVarDto.md)
 - [EnvVarMergeDto](docs/EnvVarMergeDto.md)
 - [EnvVarPatchDto](docs/EnvVarPatchDto.md)
 - [EnvVarSchemaCreateDto](docs/EnvVarSchemaCreateDto.md)
 - [EnvVarSchemaDto](docs/EnvVarSchemaDto.md)
 - [EnvVarSchemaPatchDto](docs/EnvVarSchemaPatchDto.md)
 - [EnvVarValueCreateDto](docs/EnvVarValueCreateDto.md)
 - [EnvVarValueDto](docs/EnvVarValueDto.md)
 - [EnvVarValuePatchDto](docs/EnvVarValuePatchDto.md)
 - [EnvironmentSetDto](docs/EnvironmentSetDto.md)
 - [EventType](docs/EventType.md)
 - [EventTypeSettings](docs/EventTypeSettings.md)
 - [ExampleExportFieldMapping](docs/ExampleExportFieldMapping.md)
 - [ExpectedBodyStepDto](docs/ExpectedBodyStepDto.md)
 - [ExportFieldMappingTestCaseExportField](docs/ExportFieldMappingTestCaseExportField.md)
 - [ExportFieldMappingTestResultExportField](docs/ExportFieldMappingTestResultExportField.md)
 - [ExportRequestDto](docs/ExportRequestDto.md)
 - [ExportStatus](docs/ExportStatus.md)
 - [ExportType](docs/ExportType.md)
 - [ExtFormField](docs/ExtFormField.md)
 - [ExtFormFieldCascadeMultiselect](docs/ExtFormFieldCascadeMultiselect.md)
 - [ExtFormFieldCheckbox](docs/ExtFormFieldCheckbox.md)
 - [ExtFormFieldComposite](docs/ExtFormFieldComposite.md)
 - [ExtFormFieldExternalSelect](docs/ExtFormFieldExternalSelect.md)
 - [ExtFormFieldFormChoice](docs/ExtFormFieldFormChoice.md)
 - [ExtFormFieldFormChoiceOption](docs/ExtFormFieldFormChoiceOption.md)
 - [ExtFormFieldList](docs/ExtFormFieldList.md)
 - [ExtFormFieldNumber](docs/ExtFormFieldNumber.md)
 - [ExtFormFieldOption](docs/ExtFormFieldOption.md)
 - [ExtFormFieldPassword](docs/ExtFormFieldPassword.md)
 - [ExtFormFieldSelect](docs/ExtFormFieldSelect.md)
 - [ExtFormFieldSlider](docs/ExtFormFieldSlider.md)
 - [ExtFormFieldText](docs/ExtFormFieldText.md)
 - [ExtFormFieldTextarea](docs/ExtFormFieldTextarea.md)
 - [ExtFormFieldUnknown](docs/ExtFormFieldUnknown.md)
 - [ExtIssueLink](docs/ExtIssueLink.md)
 - [ExtIssueType](docs/ExtIssueType.md)
 - [ExtProject](docs/ExtProject.md)
 - [ExtRequirementLink](docs/ExtRequirementLink.md)
 - [ExtSelectValue](docs/ExtSelectValue.md)
 - [ExternalLinkDto](docs/ExternalLinkDto.md)
 - [ExternalRunResponseDto](docs/ExternalRunResponseDto.md)
 - [ExternalRunStartRequestDto](docs/ExternalRunStartRequestDto.md)
 - [ExternalRunStopRequestDto](docs/ExternalRunStopRequestDto.md)
 - [FeatureFlagAttributesDto](docs/FeatureFlagAttributesDto.md)
 - [FeatureFlagDto](docs/FeatureFlagDto.md)
 - [FeatureFlagEnabledDto](docs/FeatureFlagEnabledDto.md)
 - [FileUploadResponseDto](docs/FileUploadResponseDto.md)
 - [FilterBaseSetDto](docs/FilterBaseSetDto.md)
 - [FilterCreateDto](docs/FilterCreateDto.md)
 - [FilterDto](docs/FilterDto.md)
 - [FilterPatchDto](docs/FilterPatchDto.md)
 - [FilterTypeDto](docs/FilterTypeDto.md)
 - [FolderContentResponseDto](docs/FolderContentResponseDto.md)
 - [ForgotPasswordDto](docs/ForgotPasswordDto.md)
 - [GlobalPermissionsDto](docs/GlobalPermissionsDto.md)
 - [GlobalSettingsDto](docs/GlobalSettingsDto.md)
 - [GlobalSettingsProjectCreatePatchDto](docs/GlobalSettingsProjectCreatePatchDto.md)
 - [GridPosDto](docs/GridPosDto.md)
 - [GroupAuthorities](docs/GroupAuthorities.md)
 - [GroupBy](docs/GroupBy.md)
 - [GroupNodeContext](docs/GroupNodeContext.md)
 - [IdAndNameOnlyDto](docs/IdAndNameOnlyDto.md)
 - [IdOnlyDto](docs/IdOnlyDto.md)
 - [ImportRequestDto](docs/ImportRequestDto.md)
 - [ImportRequestInfoDto](docs/ImportRequestInfoDto.md)
 - [ImportRequestStateDto](docs/ImportRequestStateDto.md)
 - [ImportRequestTypeDto](docs/ImportRequestTypeDto.md)
 - [IntegrationCreateDto](docs/IntegrationCreateDto.md)
 - [IntegrationDto](docs/IntegrationDto.md)
 - [IntegrationExportCreateDto](docs/IntegrationExportCreateDto.md)
 - [IntegrationExportDto](docs/IntegrationExportDto.md)
 - [IntegrationExportFieldGet200ResponseInner](docs/IntegrationExportFieldGet200ResponseInner.md)
 - [IntegrationExportPatchDto](docs/IntegrationExportPatchDto.md)
 - [IntegrationFieldsFormDto](docs/IntegrationFieldsFormDto.md)
 - [IntegrationInfoDto](docs/IntegrationInfoDto.md)
 - [IntegrationLinksFixedDto](docs/IntegrationLinksFixedDto.md)
 - [IntegrationOperationTypeDto](docs/IntegrationOperationTypeDto.md)
 - [IntegrationPatchDto](docs/IntegrationPatchDto.md)
 - [IntegrationRoutineTypeDto](docs/IntegrationRoutineTypeDto.md)
 - [IntegrationTypeDto](docs/IntegrationTypeDto.md)
 - [IntegrationValidateDto](docs/IntegrationValidateDto.md)
 - [IntegrationWebhookCreateDto](docs/IntegrationWebhookCreateDto.md)
 - [IntegrationWebhookDto](docs/IntegrationWebhookDto.md)
 - [IntegrationWebhookLogDto](docs/IntegrationWebhookLogDto.md)
 - [IntegrationWebhookPatchDto](docs/IntegrationWebhookPatchDto.md)
 - [IntegrationWebhookTokenDto](docs/IntegrationWebhookTokenDto.md)
 - [InviteBulkDto](docs/InviteBulkDto.md)
 - [InviteDto](docs/InviteDto.md)
 - [InvitePatchDto](docs/InvitePatchDto.md)
 - [InvitePersonal](docs/InvitePersonal.md)
 - [InviteSendDto](docs/InviteSendDto.md)
 - [InviteValidateDto](docs/InviteValidateDto.md)
 - [InviteValidateRequest](docs/InviteValidateRequest.md)
 - [IssueCreateDto](docs/IssueCreateDto.md)
 - [IssueDto](docs/IssueDto.md)
 - [IssueImportFieldMapping](docs/IssueImportFieldMapping.md)
 - [IssueIntegrationExportFieldMapping](docs/IssueIntegrationExportFieldMapping.md)
 - [IssuePatchDto](docs/IssuePatchDto.md)
 - [IssueSchemaCreateDto](docs/IssueSchemaCreateDto.md)
 - [IssueSchemaDto](docs/IssueSchemaDto.md)
 - [IssueSchemaPatchDto](docs/IssueSchemaPatchDto.md)
 - [IssueToCreateDto](docs/IssueToCreateDto.md)
 - [ItalicMark](docs/ItalicMark.md)
 - [Job](docs/Job.md)
 - [JobCreateDto](docs/JobCreateDto.md)
 - [JobDto](docs/JobDto.md)
 - [JobGet200Response](docs/JobGet200Response.md)
 - [JobInfoDto](docs/JobInfoDto.md)
 - [JobMapping](docs/JobMapping.md)
 - [JobParameterDto](docs/JobParameterDto.md)
 - [JobPatchDto](docs/JobPatchDto.md)
 - [JobRerunRequestDto](docs/JobRerunRequestDto.md)
 - [JobRun](docs/JobRun.md)
 - [JobRunDto](docs/JobRunDto.md)
 - [JobRunRequestDto](docs/JobRunRequestDto.md)
 - [JobRunStageDto](docs/JobRunStageDto.md)
 - [JobRunStatusDto](docs/JobRunStatusDto.md)
 - [JobRunUploadInfoDto](docs/JobRunUploadInfoDto.md)
 - [JobTestCasesStatDto](docs/JobTestCasesStatDto.md)
 - [Launch](docs/Launch.md)
 - [LaunchCleanupRequest](docs/LaunchCleanupRequest.md)
 - [LaunchCloseConfigDto](docs/LaunchCloseConfigDto.md)
 - [LaunchCopyRqDto](docs/LaunchCopyRqDto.md)
 - [LaunchCreateAndUploadDto](docs/LaunchCreateAndUploadDto.md)
 - [LaunchCreateDto](docs/LaunchCreateDto.md)
 - [LaunchDiffCell](docs/LaunchDiffCell.md)
 - [LaunchDiffMode](docs/LaunchDiffMode.md)
 - [LaunchDiffRow](docs/LaunchDiffRow.md)
 - [LaunchDiffStatusChangeDto](docs/LaunchDiffStatusChangeDto.md)
 - [LaunchDiffTestResult](docs/LaunchDiffTestResult.md)
 - [LaunchDiffTestResultDto](docs/LaunchDiffTestResultDto.md)
 - [LaunchDto](docs/LaunchDto.md)
 - [LaunchExistingUploadDto](docs/LaunchExistingUploadDto.md)
 - [LaunchGet200Response](docs/LaunchGet200Response.md)
 - [LaunchLiveDocConfigDto](docs/LaunchLiveDocConfigDto.md)
 - [LaunchMemberStatsDto](docs/LaunchMemberStatsDto.md)
 - [LaunchMergeDto](docs/LaunchMergeDto.md)
 - [LaunchPatchDto](docs/LaunchPatchDto.md)
 - [LaunchPdfOptions](docs/LaunchPdfOptions.md)
 - [LaunchPdfPart](docs/LaunchPdfPart.md)
 - [LaunchPdfStructure](docs/LaunchPdfStructure.md)
 - [LaunchPreviewDto](docs/LaunchPreviewDto.md)
 - [LaunchProgressDto](docs/LaunchProgressDto.md)
 - [LaunchRowDto](docs/LaunchRowDto.md)
 - [LaunchTagCreateDto](docs/LaunchTagCreateDto.md)
 - [LaunchTagDto](docs/LaunchTagDto.md)
 - [LaunchTagPatchDto](docs/LaunchTagPatchDto.md)
 - [LaunchTestCasesAddDto](docs/LaunchTestCasesAddDto.md)
 - [LaunchTestPlanAddDto](docs/LaunchTestPlanAddDto.md)
 - [LaunchUploadResponseDto](docs/LaunchUploadResponseDto.md)
 - [LaunchVariableDto](docs/LaunchVariableDto.md)
 - [LaunchWebhook](docs/LaunchWebhook.md)
 - [LicenseBodyDto](docs/LicenseBodyDto.md)
 - [LicenseFeature](docs/LicenseFeature.md)
 - [LicenseInfoDto](docs/LicenseInfoDto.md)
 - [LineBreakParagraphNode](docs/LineBreakParagraphNode.md)
 - [LinkExportFieldMapping](docs/LinkExportFieldMapping.md)
 - [LinkImportFieldMapping](docs/LinkImportFieldMapping.md)
 - [LinkMark](docs/LinkMark.md)
 - [ListSelectionDto](docs/ListSelectionDto.md)
 - [LoginProps](docs/LoginProps.md)
 - [LoginTypeDto](docs/LoginTypeDto.md)
 - [MailValidateRequest](docs/MailValidateRequest.md)
 - [MailVerificationDto](docs/MailVerificationDto.md)
 - [MailVerificationPatchDto](docs/MailVerificationPatchDto.md)
 - [ManualSessionRequestDto](docs/ManualSessionRequestDto.md)
 - [Matcher](docs/Matcher.md)
 - [MemberBulkDto](docs/MemberBulkDto.md)
 - [MemberCreateDto](docs/MemberCreateDto.md)
 - [MemberDto](docs/MemberDto.md)
 - [MemberPatchDto](docs/MemberPatchDto.md)
 - [MemberRoleBulkDto](docs/MemberRoleBulkDto.md)
 - [MetadataSource](docs/MetadataSource.md)
 - [Metric](docs/Metric.md)
 - [MfaBackupCodeDto](docs/MfaBackupCodeDto.md)
 - [MfaBackupCodesCounterDto](docs/MfaBackupCodesCounterDto.md)
 - [MfaDto](docs/MfaDto.md)
 - [MfaGlobalSettingsDto](docs/MfaGlobalSettingsDto.md)
 - [MfaGlobalSettingsPatchDto](docs/MfaGlobalSettingsPatchDto.md)
 - [MfaVerificationResponseDto](docs/MfaVerificationResponseDto.md)
 - [MultiValueExportFieldMapping](docs/MultiValueExportFieldMapping.md)
 - [MultiValueImportFieldMapping](docs/MultiValueImportFieldMapping.md)
 - [MultiValueMapStringString](docs/MultiValueMapStringString.md)
 - [MuteCreateDto](docs/MuteCreateDto.md)
 - [MuteDto](docs/MuteDto.md)
 - [NameOnlyDto](docs/NameOnlyDto.md)
 - [NodeType](docs/NodeType.md)
 - [NormalizedScenarioDto](docs/NormalizedScenarioDto.md)
 - [NormalizedScenarioStepDto](docs/NormalizedScenarioStepDto.md)
 - [NumberOnlyDto](docs/NumberOnlyDto.md)
 - [OrderedValueDtoString](docs/OrderedValueDtoString.md)
 - [PageAccessGroupDto](docs/PageAccessGroupDto.md)
 - [PageAccessGroupPaDto](docs/PageAccessGroupPaDto.md)
 - [PageAccessGroupUserDto](docs/PageAccessGroupUserDto.md)
 - [PageAccountDto](docs/PageAccountDto.md)
 - [PageAccountSessionPresenceDto](docs/PageAccountSessionPresenceDto.md)
 - [PageAsyncJobDto](docs/PageAsyncJobDto.md)
 - [PageCategoryCountRowDto](docs/PageCategoryCountRowDto.md)
 - [PageCategoryDto](docs/PageCategoryDto.md)
 - [PageCategoryMatcherDto](docs/PageCategoryMatcherDto.md)
 - [PageCleanerSchemaDto](docs/PageCleanerSchemaDto.md)
 - [PageCommentDto](docs/PageCommentDto.md)
 - [PageCustomFieldProjectDto](docs/PageCustomFieldProjectDto.md)
 - [PageCustomFieldSchemaDto](docs/PageCustomFieldSchemaDto.md)
 - [PageCustomFieldValueWithTcCountDto](docs/PageCustomFieldValueWithTcCountDto.md)
 - [PageDashboardDto](docs/PageDashboardDto.md)
 - [PageDefectCountRowDto](docs/PageDefectCountRowDto.md)
 - [PageDefectDto](docs/PageDefectDto.md)
 - [PageDefectMatcherDto](docs/PageDefectMatcherDto.md)
 - [PageDefectRowDto](docs/PageDefectRowDto.md)
 - [PageEnvVarSchemaDto](docs/PageEnvVarSchemaDto.md)
 - [PageExportRequestDto](docs/PageExportRequestDto.md)
 - [PageFilterDto](docs/PageFilterDto.md)
 - [PageIdAndNameOnlyDto](docs/PageIdAndNameOnlyDto.md)
 - [PageImportRequestDto](docs/PageImportRequestDto.md)
 - [PageIntegrationDto](docs/PageIntegrationDto.md)
 - [PageIntegrationExportDto](docs/PageIntegrationExportDto.md)
 - [PageIntegrationInfoDto](docs/PageIntegrationInfoDto.md)
 - [PageIntegrationWebhookDto](docs/PageIntegrationWebhookDto.md)
 - [PageIntegrationWebhookLogDto](docs/PageIntegrationWebhookLogDto.md)
 - [PageInviteDto](docs/PageInviteDto.md)
 - [PageIssueDto](docs/PageIssueDto.md)
 - [PageIssueSchemaDto](docs/PageIssueSchemaDto.md)
 - [PageJobDto](docs/PageJobDto.md)
 - [PageLaunchDiffRow](docs/PageLaunchDiffRow.md)
 - [PageLaunchDto](docs/PageLaunchDto.md)
 - [PageLaunchMemberStatsDto](docs/PageLaunchMemberStatsDto.md)
 - [PageLaunchPreviewDto](docs/PageLaunchPreviewDto.md)
 - [PageLaunchRowDto](docs/PageLaunchRowDto.md)
 - [PageLaunchTagDto](docs/PageLaunchTagDto.md)
 - [PageLaunchVariableDto](docs/PageLaunchVariableDto.md)
 - [PageMemberDto](docs/PageMemberDto.md)
 - [PageMuteDto](docs/PageMuteDto.md)
 - [PageNameOnlyDto](docs/PageNameOnlyDto.md)
 - [PagePermissionSetDto](docs/PagePermissionSetDto.md)
 - [PageProjectCollaboratorAccessDto](docs/PageProjectCollaboratorAccessDto.md)
 - [PageProjectCollaboratorDto](docs/PageProjectCollaboratorDto.md)
 - [PageProjectCustomFieldDto](docs/PageProjectCustomFieldDto.md)
 - [PageProjectDto](docs/PageProjectDto.md)
 - [PageProjectGroupAccessDto](docs/PageProjectGroupAccessDto.md)
 - [PageProjectIntegrationDto](docs/PageProjectIntegrationDto.md)
 - [PageProjectSuggestDto](docs/PageProjectSuggestDto.md)
 - [PageReleaseDto](docs/PageReleaseDto.md)
 - [PageReleasePreviewDto](docs/PageReleasePreviewDto.md)
 - [PageRequirementStatsDto](docs/PageRequirementStatsDto.md)
 - [PageRequirementSuggestDto](docs/PageRequirementSuggestDto.md)
 - [PageRoleSchemaDto](docs/PageRoleSchemaDto.md)
 - [PageSecurityAuthProviderDto](docs/PageSecurityAuthProviderDto.md)
 - [PageSharedStepAttachmentRowDto](docs/PageSharedStepAttachmentRowDto.md)
 - [PageSharedStepDto](docs/PageSharedStepDto.md)
 - [PageStatisticWidgetItem](docs/PageStatisticWidgetItem.md)
 - [PageStatusDto](docs/PageStatusDto.md)
 - [PageTemplateDto](docs/PageTemplateDto.md)
 - [PageTestCaseAttachmentRowDto](docs/PageTestCaseAttachmentRowDto.md)
 - [PageTestCaseAuditLogEntryDto](docs/PageTestCaseAuditLogEntryDto.md)
 - [PageTestCaseDto](docs/PageTestCaseDto.md)
 - [PageTestCaseExampleDto](docs/PageTestCaseExampleDto.md)
 - [PageTestCaseFlatDto](docs/PageTestCaseFlatDto.md)
 - [PageTestCaseRowDto](docs/PageTestCaseRowDto.md)
 - [PageTestCaseSnapshotDto](docs/PageTestCaseSnapshotDto.md)
 - [PageTestCaseTreeGroupDto](docs/PageTestCaseTreeGroupDto.md)
 - [PageTestCaseTreeLeafDto](docs/PageTestCaseTreeLeafDto.md)
 - [PageTestCaseTreeLeafDtoSort](docs/PageTestCaseTreeLeafDtoSort.md)
 - [PageTestCaseTreeNodeDto](docs/PageTestCaseTreeNodeDto.md)
 - [PageTestCaseTreeNodeDtoContentInner](docs/PageTestCaseTreeNodeDtoContentInner.md)
 - [PageTestFixtureResultAttachmentRowDto](docs/PageTestFixtureResultAttachmentRowDto.md)
 - [PageTestKeySchemaDto](docs/PageTestKeySchemaDto.md)
 - [PageTestLayerDto](docs/PageTestLayerDto.md)
 - [PageTestLayerSchemaDto](docs/PageTestLayerSchemaDto.md)
 - [PageTestPlanDto](docs/PageTestPlanDto.md)
 - [PageTestPlanRowDto](docs/PageTestPlanRowDto.md)
 - [PageTestResultAttachmentRowDto](docs/PageTestResultAttachmentRowDto.md)
 - [PageTestResultDefectMatchDto](docs/PageTestResultDefectMatchDto.md)
 - [PageTestResultDto](docs/PageTestResultDto.md)
 - [PageTestResultFlatDto](docs/PageTestResultFlatDto.md)
 - [PageTestResultHistoryDto](docs/PageTestResultHistoryDto.md)
 - [PageTestResultRetriesRowDto](docs/PageTestResultRetriesRowDto.md)
 - [PageTestResultRowDto](docs/PageTestResultRowDto.md)
 - [PageTestResultTreeGroupDto](docs/PageTestResultTreeGroupDto.md)
 - [PageTestResultTreeLeafDto](docs/PageTestResultTreeLeafDto.md)
 - [PageTestResultTreeNodeDto](docs/PageTestResultTreeNodeDto.md)
 - [PageTestResultTreeNodeDtoContentInner](docs/PageTestResultTreeNodeDtoContentInner.md)
 - [PageTreeDto](docs/PageTreeDto.md)
 - [PageTreeDtoV2](docs/PageTreeDtoV2.md)
 - [PageTreeNodeDto](docs/PageTreeNodeDto.md)
 - [PageTreeNodeDtoContentInner](docs/PageTreeNodeDtoContentInner.md)
 - [PageTreePathDto](docs/PageTreePathDto.md)
 - [PageUserSuggestDto](docs/PageUserSuggestDto.md)
 - [PageWebhookDto](docs/PageWebhookDto.md)
 - [PageWidgetDto](docs/PageWidgetDto.md)
 - [PageWorkflowDto](docs/PageWorkflowDto.md)
 - [PageWorkflowSchemaDto](docs/PageWorkflowSchemaDto.md)
 - [Pageable](docs/Pageable.md)
 - [ParagraphDocumentNode](docs/ParagraphDocumentNode.md)
 - [ParagraphDocumentNodeAllOfContent](docs/ParagraphDocumentNodeAllOfContent.md)
 - [ParagraphNode](docs/ParagraphNode.md)
 - [Parameter](docs/Parameter.md)
 - [ParameterParagraphNode](docs/ParameterParagraphNode.md)
 - [ParameterValueDto](docs/ParameterValueDto.md)
 - [PermissionDto](docs/PermissionDto.md)
 - [PermissionSetCreateDto](docs/PermissionSetCreateDto.md)
 - [PermissionSetDto](docs/PermissionSetDto.md)
 - [PermissionSetPatchDto](docs/PermissionSetPatchDto.md)
 - [PortalLocationRpDto](docs/PortalLocationRpDto.md)
 - [PortalLocationRqDto](docs/PortalLocationRqDto.md)
 - [ProjectAccessCollaboratorAddDto](docs/ProjectAccessCollaboratorAddDto.md)
 - [ProjectAccessGroupAddDto](docs/ProjectAccessGroupAddDto.md)
 - [ProjectCategoryAddDto](docs/ProjectCategoryAddDto.md)
 - [ProjectCategoryMatcherAddDto](docs/ProjectCategoryMatcherAddDto.md)
 - [ProjectCategoryMatcherRemoveDto](docs/ProjectCategoryMatcherRemoveDto.md)
 - [ProjectCategoryRemoveDto](docs/ProjectCategoryRemoveDto.md)
 - [ProjectCollaboratorAccessDto](docs/ProjectCollaboratorAccessDto.md)
 - [ProjectCollaboratorDto](docs/ProjectCollaboratorDto.md)
 - [ProjectCreateDto](docs/ProjectCreateDto.md)
 - [ProjectCustomFieldDto](docs/ProjectCustomFieldDto.md)
 - [ProjectDto](docs/ProjectDto.md)
 - [ProjectGroupAccessAddDto](docs/ProjectGroupAccessAddDto.md)
 - [ProjectGroupAccessDto](docs/ProjectGroupAccessDto.md)
 - [ProjectIntegrationCreateDto](docs/ProjectIntegrationCreateDto.md)
 - [ProjectIntegrationDto](docs/ProjectIntegrationDto.md)
 - [ProjectIntegrationFieldsFormDto](docs/ProjectIntegrationFieldsFormDto.md)
 - [ProjectIntegrationPatchDto](docs/ProjectIntegrationPatchDto.md)
 - [ProjectIntegrationValidateDto](docs/ProjectIntegrationValidateDto.md)
 - [ProjectMetricDto](docs/ProjectMetricDto.md)
 - [ProjectPatchDto](docs/ProjectPatchDto.md)
 - [ProjectPropertyCreateDto](docs/ProjectPropertyCreateDto.md)
 - [ProjectPropertyDto](docs/ProjectPropertyDto.md)
 - [ProjectPropertyPatchDto](docs/ProjectPropertyPatchDto.md)
 - [ProjectStatsDto](docs/ProjectStatsDto.md)
 - [ProjectSuggestDto](docs/ProjectSuggestDto.md)
 - [ProjectSyncRequest](docs/ProjectSyncRequest.md)
 - [ProjectTestCaseCountDto](docs/ProjectTestCaseCountDto.md)
 - [RegistrationDto](docs/RegistrationDto.md)
 - [ReleaseCreateDto](docs/ReleaseCreateDto.md)
 - [ReleaseDto](docs/ReleaseDto.md)
 - [ReleasePatchDto](docs/ReleasePatchDto.md)
 - [ReleasePreviewDto](docs/ReleasePreviewDto.md)
 - [ReleaseStatisticDto](docs/ReleaseStatisticDto.md)
 - [RequirementCreateDto](docs/RequirementCreateDto.md)
 - [RequirementDto](docs/RequirementDto.md)
 - [RequirementStatsDto](docs/RequirementStatsDto.md)
 - [RequirementSuggestDto](docs/RequirementSuggestDto.md)
 - [ResetPasswordByEmailDto](docs/ResetPasswordByEmailDto.md)
 - [ResolveRequestV2Dto](docs/ResolveRequestV2Dto.md)
 - [Retry](docs/Retry.md)
 - [RoleCreateDto](docs/RoleCreateDto.md)
 - [RoleDto](docs/RoleDto.md)
 - [RoleExportFieldMapping](docs/RoleExportFieldMapping.md)
 - [RoleImportFieldMapping](docs/RoleImportFieldMapping.md)
 - [RolePatchDto](docs/RolePatchDto.md)
 - [RoleSchemaCreateDto](docs/RoleSchemaCreateDto.md)
 - [RoleSchemaDto](docs/RoleSchemaDto.md)
 - [RoleSchemaPatchDto](docs/RoleSchemaPatchDto.md)
 - [Saml2Settings](docs/Saml2Settings.md)
 - [ScenarioExportFieldMapping](docs/ScenarioExportFieldMapping.md)
 - [ScenarioStepCopyDto](docs/ScenarioStepCopyDto.md)
 - [ScenarioStepCreateDto](docs/ScenarioStepCreateDto.md)
 - [ScenarioStepCreatedResponseDto](docs/ScenarioStepCreatedResponseDto.md)
 - [ScenarioStepDto](docs/ScenarioStepDto.md)
 - [ScenarioStepMoveDto](docs/ScenarioStepMoveDto.md)
 - [ScenarioStepPatchDto](docs/ScenarioStepPatchDto.md)
 - [SecurityAuthProviderCreateDto](docs/SecurityAuthProviderCreateDto.md)
 - [SecurityAuthProviderDto](docs/SecurityAuthProviderDto.md)
 - [SecurityAuthProviderPatchDto](docs/SecurityAuthProviderPatchDto.md)
 - [SecurityAuthProviderSettings](docs/SecurityAuthProviderSettings.md)
 - [SessionVariable](docs/SessionVariable.md)
 - [SetRoleDto](docs/SetRoleDto.md)
 - [SharedStepAttachmentPatchDto](docs/SharedStepAttachmentPatchDto.md)
 - [SharedStepAttachmentRowDto](docs/SharedStepAttachmentRowDto.md)
 - [SharedStepCreateDto](docs/SharedStepCreateDto.md)
 - [SharedStepDto](docs/SharedStepDto.md)
 - [SharedStepPatchDto](docs/SharedStepPatchDto.md)
 - [SharedStepScenarioDto](docs/SharedStepScenarioDto.md)
 - [SharedStepScenarioDtoStepsInner](docs/SharedStepScenarioDtoStepsInner.md)
 - [SharedStepStepDto](docs/SharedStepStepDto.md)
 - [StatisticDto](docs/StatisticDto.md)
 - [StatisticWidgetItem](docs/StatisticWidgetItem.md)
 - [Status](docs/Status.md)
 - [StatusCreateDto](docs/StatusCreateDto.md)
 - [StatusDto](docs/StatusDto.md)
 - [StatusPatchDto](docs/StatusPatchDto.md)
 - [StrikeMark](docs/StrikeMark.md)
 - [TabCount](docs/TabCount.md)
 - [TabStatistics](docs/TabStatistics.md)
 - [TagImportFieldMapping](docs/TagImportFieldMapping.md)
 - [TemplateDto](docs/TemplateDto.md)
 - [TemplateOverviewDto](docs/TemplateOverviewDto.md)
 - [TestCaseAssociationDiff](docs/TestCaseAssociationDiff.md)
 - [TestCaseAttachmentPatchDto](docs/TestCaseAttachmentPatchDto.md)
 - [TestCaseAttachmentRowDto](docs/TestCaseAttachmentRowDto.md)
 - [TestCaseAuditLogData](docs/TestCaseAuditLogData.md)
 - [TestCaseAuditLogDataDiff](docs/TestCaseAuditLogDataDiff.md)
 - [TestCaseAuditLogEntryDto](docs/TestCaseAuditLogEntryDto.md)
 - [TestCaseBulkCfMoveStrategy](docs/TestCaseBulkCfMoveStrategy.md)
 - [TestCaseBulkChangeProjectDtoV2](docs/TestCaseBulkChangeProjectDtoV2.md)
 - [TestCaseBulkCloneDto](docs/TestCaseBulkCloneDto.md)
 - [TestCaseBulkCloneDtoV2](docs/TestCaseBulkCloneDtoV2.md)
 - [TestCaseBulkDragAndDropDto](docs/TestCaseBulkDragAndDropDto.md)
 - [TestCaseBulkDragAndDropDtoV2](docs/TestCaseBulkDragAndDropDtoV2.md)
 - [TestCaseBulkDto](docs/TestCaseBulkDto.md)
 - [TestCaseBulkDtoV2](docs/TestCaseBulkDtoV2.md)
 - [TestCaseBulkEntityIdsDto](docs/TestCaseBulkEntityIdsDto.md)
 - [TestCaseBulkEntityIdsDtoV2](docs/TestCaseBulkEntityIdsDtoV2.md)
 - [TestCaseBulkExportCsvOptions](docs/TestCaseBulkExportCsvOptions.md)
 - [TestCaseBulkExportPdfOptions](docs/TestCaseBulkExportPdfOptions.md)
 - [TestCaseBulkExternalLinkDto](docs/TestCaseBulkExternalLinkDto.md)
 - [TestCaseBulkIssueDto](docs/TestCaseBulkIssueDto.md)
 - [TestCaseBulkLayerDto](docs/TestCaseBulkLayerDto.md)
 - [TestCaseBulkMemberDto](docs/TestCaseBulkMemberDto.md)
 - [TestCaseBulkMuteDto](docs/TestCaseBulkMuteDto.md)
 - [TestCaseBulkNewCfvDto](docs/TestCaseBulkNewCfvDto.md)
 - [TestCaseBulkProjectChangeDto](docs/TestCaseBulkProjectChangeDto.md)
 - [TestCaseBulkRunExistingLaunchDto](docs/TestCaseBulkRunExistingLaunchDto.md)
 - [TestCaseBulkRunNewLaunchDto](docs/TestCaseBulkRunNewLaunchDto.md)
 - [TestCaseBulkStatusDto](docs/TestCaseBulkStatusDto.md)
 - [TestCaseBulkTagDto](docs/TestCaseBulkTagDto.md)
 - [TestCaseBulkTestPlanCreateDto](docs/TestCaseBulkTestPlanCreateDto.md)
 - [TestCaseCfBulkDeltaDtoV2](docs/TestCaseCfBulkDeltaDtoV2.md)
 - [TestCaseCfvBulkAddDto](docs/TestCaseCfvBulkAddDto.md)
 - [TestCaseCloneRqDto](docs/TestCaseCloneRqDto.md)
 - [TestCaseCountDto](docs/TestCaseCountDto.md)
 - [TestCaseCreateV2Dto](docs/TestCaseCreateV2Dto.md)
 - [TestCaseCsvExportOptions](docs/TestCaseCsvExportOptions.md)
 - [TestCaseCsvExportOptionsMappingInner](docs/TestCaseCsvExportOptionsMappingInner.md)
 - [TestCaseCsvImportOptions](docs/TestCaseCsvImportOptions.md)
 - [TestCaseCsvImportOptionsMappingInner](docs/TestCaseCsvImportOptionsMappingInner.md)
 - [TestCaseCsvPreviewOptions](docs/TestCaseCsvPreviewOptions.md)
 - [TestCaseDetachAutomationRqDto](docs/TestCaseDetachAutomationRqDto.md)
 - [TestCaseDiff](docs/TestCaseDiff.md)
 - [TestCaseDto](docs/TestCaseDto.md)
 - [TestCaseExampleDto](docs/TestCaseExampleDto.md)
 - [TestCaseExportField](docs/TestCaseExportField.md)
 - [TestCaseExternalLinkBulkAddDto](docs/TestCaseExternalLinkBulkAddDto.md)
 - [TestCaseFlatDto](docs/TestCaseFlatDto.md)
 - [TestCaseFolderDragAndDropDto](docs/TestCaseFolderDragAndDropDto.md)
 - [TestCaseFullTreeNodeDto](docs/TestCaseFullTreeNodeDto.md)
 - [TestCaseImportDto](docs/TestCaseImportDto.md)
 - [TestCaseImportField](docs/TestCaseImportField.md)
 - [TestCaseImportMapping](docs/TestCaseImportMapping.md)
 - [TestCaseInFolderDto](docs/TestCaseInFolderDto.md)
 - [TestCaseInfo](docs/TestCaseInfo.md)
 - [TestCaseIssueBulkAddDto](docs/TestCaseIssueBulkAddDto.md)
 - [TestCaseLastResultDto](docs/TestCaseLastResultDto.md)
 - [TestCaseLayerBulkSetDto](docs/TestCaseLayerBulkSetDto.md)
 - [TestCaseLightTreeNodeDto](docs/TestCaseLightTreeNodeDto.md)
 - [TestCaseMemberBulkAddDto](docs/TestCaseMemberBulkAddDto.md)
 - [TestCaseMuteBulkAddDto](docs/TestCaseMuteBulkAddDto.md)
 - [TestCaseOverviewDto](docs/TestCaseOverviewDto.md)
 - [TestCaseParameterDto](docs/TestCaseParameterDto.md)
 - [TestCaseParameterValues](docs/TestCaseParameterValues.md)
 - [TestCasePatchV2Dto](docs/TestCasePatchV2Dto.md)
 - [TestCasePdfOptions](docs/TestCasePdfOptions.md)
 - [TestCasePdfPart](docs/TestCasePdfPart.md)
 - [TestCaseRelationDto](docs/TestCaseRelationDto.md)
 - [TestCaseRelationTypeDto](docs/TestCaseRelationTypeDto.md)
 - [TestCaseRowDto](docs/TestCaseRowDto.md)
 - [TestCaseRunBulkExistingLaunchDto](docs/TestCaseRunBulkExistingLaunchDto.md)
 - [TestCaseRunBulkNewLaunchDto](docs/TestCaseRunBulkNewLaunchDto.md)
 - [TestCaseRunByStats](docs/TestCaseRunByStats.md)
 - [TestCaseRunStatsRequestDto](docs/TestCaseRunStatsRequestDto.md)
 - [TestCaseScenarioDto](docs/TestCaseScenarioDto.md)
 - [TestCaseScenarioStepDto](docs/TestCaseScenarioStepDto.md)
 - [TestCaseScenarioV2Dto](docs/TestCaseScenarioV2Dto.md)
 - [TestCaseSelectionDtoV2](docs/TestCaseSelectionDtoV2.md)
 - [TestCaseSnapshotContentDto](docs/TestCaseSnapshotContentDto.md)
 - [TestCaseSnapshotDto](docs/TestCaseSnapshotDto.md)
 - [TestCaseSnapshotSaveRqDto](docs/TestCaseSnapshotSaveRqDto.md)
 - [TestCaseSnapshotUpdateRqDto](docs/TestCaseSnapshotUpdateRqDto.md)
 - [TestCaseStatsDto](docs/TestCaseStatsDto.md)
 - [TestCaseStatusBulkSetDto](docs/TestCaseStatusBulkSetDto.md)
 - [TestCaseStyle](docs/TestCaseStyle.md)
 - [TestCaseSyncFromTo](docs/TestCaseSyncFromTo.md)
 - [TestCaseSyncRqDto](docs/TestCaseSyncRqDto.md)
 - [TestCaseTagBulkAddDto](docs/TestCaseTagBulkAddDto.md)
 - [TestCaseTestPlanBulkCreateDto](docs/TestCaseTestPlanBulkCreateDto.md)
 - [TestCaseTreeAllPathsDto](docs/TestCaseTreeAllPathsDto.md)
 - [TestCaseTreeFilterCountDto](docs/TestCaseTreeFilterCountDto.md)
 - [TestCaseTreeGroupAddDto](docs/TestCaseTreeGroupAddDto.md)
 - [TestCaseTreeGroupDto](docs/TestCaseTreeGroupDto.md)
 - [TestCaseTreeGroupRenameDto](docs/TestCaseTreeGroupRenameDto.md)
 - [TestCaseTreeLeafAddDto](docs/TestCaseTreeLeafAddDto.md)
 - [TestCaseTreeLeafDto](docs/TestCaseTreeLeafDto.md)
 - [TestCaseTreeLeafDtoV2](docs/TestCaseTreeLeafDtoV2.md)
 - [TestCaseTreeLeafRenameDto](docs/TestCaseTreeLeafRenameDto.md)
 - [TestCaseTreeNodeDto](docs/TestCaseTreeNodeDto.md)
 - [TestCaseTreeRunStatRequestDto](docs/TestCaseTreeRunStatRequestDto.md)
 - [TestCaseTreeSelectionDto](docs/TestCaseTreeSelectionDto.md)
 - [TestCaseTreeSelectionDtoV2](docs/TestCaseTreeSelectionDtoV2.md)
 - [TestCaseType](docs/TestCaseType.md)
 - [TestCaseUpdateFieldDto](docs/TestCaseUpdateFieldDto.md)
 - [TestCaseUpdatePolicyDto](docs/TestCaseUpdatePolicyDto.md)
 - [TestCaseUpdateSchemaCreateDto](docs/TestCaseUpdateSchemaCreateDto.md)
 - [TestCaseUpdateSchemaDto](docs/TestCaseUpdateSchemaDto.md)
 - [TestCaseUpdateSchemaPatchDto](docs/TestCaseUpdateSchemaPatchDto.md)
 - [TestCaseVersionDto](docs/TestCaseVersionDto.md)
 - [TestCaseVersionMigrationResponse](docs/TestCaseVersionMigrationResponse.md)
 - [TestCaseVersionPatchDto](docs/TestCaseVersionPatchDto.md)
 - [TestCaseVersionRqDto](docs/TestCaseVersionRqDto.md)
 - [TestDurationCount](docs/TestDurationCount.md)
 - [TestFixtureResultAttachmentPatchDto](docs/TestFixtureResultAttachmentPatchDto.md)
 - [TestFixtureResultAttachmentRowDto](docs/TestFixtureResultAttachmentRowDto.md)
 - [TestFixtureResultTypeDto](docs/TestFixtureResultTypeDto.md)
 - [TestFixtureResultV2Dto](docs/TestFixtureResultV2Dto.md)
 - [TestKeyDto](docs/TestKeyDto.md)
 - [TestKeyImportFieldMapping](docs/TestKeyImportFieldMapping.md)
 - [TestKeySchemaCreateDto](docs/TestKeySchemaCreateDto.md)
 - [TestKeySchemaDto](docs/TestKeySchemaDto.md)
 - [TestKeySchemaPatchDto](docs/TestKeySchemaPatchDto.md)
 - [TestLayerCreateDto](docs/TestLayerCreateDto.md)
 - [TestLayerDto](docs/TestLayerDto.md)
 - [TestLayerPatchDto](docs/TestLayerPatchDto.md)
 - [TestLayerSchemaCreateDto](docs/TestLayerSchemaCreateDto.md)
 - [TestLayerSchemaDto](docs/TestLayerSchemaDto.md)
 - [TestLayerSchemaPatchDto](docs/TestLayerSchemaPatchDto.md)
 - [TestPlanAssignDto](docs/TestPlanAssignDto.md)
 - [TestPlanCreateDto](docs/TestPlanCreateDto.md)
 - [TestPlanDiffDto](docs/TestPlanDiffDto.md)
 - [TestPlanDto](docs/TestPlanDto.md)
 - [TestPlanJobParametersDto](docs/TestPlanJobParametersDto.md)
 - [TestPlanJobStatDto](docs/TestPlanJobStatDto.md)
 - [TestPlanMemberStatDto](docs/TestPlanMemberStatDto.md)
 - [TestPlanPatchDto](docs/TestPlanPatchDto.md)
 - [TestPlanRowDto](docs/TestPlanRowDto.md)
 - [TestPlanRunRequestDto](docs/TestPlanRunRequestDto.md)
 - [TestPlanStatDto](docs/TestPlanStatDto.md)
 - [TestPlanTreeSelectionDto](docs/TestPlanTreeSelectionDto.md)
 - [TestPlanWebhook](docs/TestPlanWebhook.md)
 - [TestResultAttachmentPatchDto](docs/TestResultAttachmentPatchDto.md)
 - [TestResultAttachmentRowDto](docs/TestResultAttachmentRowDto.md)
 - [TestResultAttachmentStepDto](docs/TestResultAttachmentStepDto.md)
 - [TestResultAttachmentStepDtoAllOfAttachment](docs/TestResultAttachmentStepDtoAllOfAttachment.md)
 - [TestResultBodyStepDto](docs/TestResultBodyStepDto.md)
 - [TestResultBulkAssignDto](docs/TestResultBulkAssignDto.md)
 - [TestResultBulkDto](docs/TestResultBulkDto.md)
 - [TestResultBulkEntityIdsDto](docs/TestResultBulkEntityIdsDto.md)
 - [TestResultBulkMuteDto](docs/TestResultBulkMuteDto.md)
 - [TestResultBulkRerunDto](docs/TestResultBulkRerunDto.md)
 - [TestResultBulkResolveDto](docs/TestResultBulkResolveDto.md)
 - [TestResultBulkTagDto](docs/TestResultBulkTagDto.md)
 - [TestResultCreateV2Dto](docs/TestResultCreateV2Dto.md)
 - [TestResultCsvExportOptions](docs/TestResultCsvExportOptions.md)
 - [TestResultCsvExportOptionsMappingInner](docs/TestResultCsvExportOptionsMappingInner.md)
 - [TestResultDefectMatchDto](docs/TestResultDefectMatchDto.md)
 - [TestResultDefectMatcherDto](docs/TestResultDefectMatcherDto.md)
 - [TestResultDto](docs/TestResultDto.md)
 - [TestResultExpectedBodyStepDto](docs/TestResultExpectedBodyStepDto.md)
 - [TestResultExportField](docs/TestResultExportField.md)
 - [TestResultFlatDto](docs/TestResultFlatDto.md)
 - [TestResultGroupNode](docs/TestResultGroupNode.md)
 - [TestResultHistoryDto](docs/TestResultHistoryDto.md)
 - [TestResultLeafNode](docs/TestResultLeafNode.md)
 - [TestResultLinkDefectDto](docs/TestResultLinkDefectDto.md)
 - [TestResultMuteReason](docs/TestResultMuteReason.md)
 - [TestResultNewDefectDto](docs/TestResultNewDefectDto.md)
 - [TestResultParameterDto](docs/TestResultParameterDto.md)
 - [TestResultPatchDto](docs/TestResultPatchDto.md)
 - [TestResultRerunDto](docs/TestResultRerunDto.md)
 - [TestResultRetriesRowDto](docs/TestResultRetriesRowDto.md)
 - [TestResultRowDto](docs/TestResultRowDto.md)
 - [TestResultScenarioDto](docs/TestResultScenarioDto.md)
 - [TestResultScenarioStepDto](docs/TestResultScenarioStepDto.md)
 - [TestResultScenarioStepParameter](docs/TestResultScenarioStepParameter.md)
 - [TestResultScenarioV2Dto](docs/TestResultScenarioV2Dto.md)
 - [TestResultScenarioV2DtoStepsInner](docs/TestResultScenarioV2DtoStepsInner.md)
 - [TestResultStatsDto](docs/TestResultStatsDto.md)
 - [TestResultTree](docs/TestResultTree.md)
 - [TestResultTreeFilterCountDto](docs/TestResultTreeFilterCountDto.md)
 - [TestResultTreeGroupDto](docs/TestResultTreeGroupDto.md)
 - [TestResultTreeGroupDtoV2](docs/TestResultTreeGroupDtoV2.md)
 - [TestResultTreeLeafDto](docs/TestResultTreeLeafDto.md)
 - [TestResultTreeLeafDtoV2](docs/TestResultTreeLeafDtoV2.md)
 - [TestResultTreeNodeDto](docs/TestResultTreeNodeDto.md)
 - [TestResultTreeSelectionDto](docs/TestResultTreeSelectionDto.md)
 - [TestSessionResponseDto](docs/TestSessionResponseDto.md)
 - [TestStatus](docs/TestStatus.md)
 - [TestStatusCount](docs/TestStatusCount.md)
 - [TestTagCreateDto](docs/TestTagCreateDto.md)
 - [TestTagDto](docs/TestTagDto.md)
 - [TestTagPatchDto](docs/TestTagPatchDto.md)
 - [TextColorMark](docs/TextColorMark.md)
 - [TextFillMark](docs/TextFillMark.md)
 - [TextMark](docs/TextMark.md)
 - [TextMarkupDocument](docs/TextMarkupDocument.md)
 - [TextParagraphNode](docs/TextParagraphNode.md)
 - [TextParagraphNodeMarksInner](docs/TextParagraphNodeMarksInner.md)
 - [TrScenarioStepDto](docs/TrScenarioStepDto.md)
 - [TreeCreateDto](docs/TreeCreateDto.md)
 - [TreeCustomFieldProjectDto](docs/TreeCustomFieldProjectDto.md)
 - [TreeDto](docs/TreeDto.md)
 - [TreeDtoV2](docs/TreeDtoV2.md)
 - [TreeFolderCreateDto](docs/TreeFolderCreateDto.md)
 - [TreeFolderDto](docs/TreeFolderDto.md)
 - [TreeFolderTestCaseCreateDto](docs/TreeFolderTestCaseCreateDto.md)
 - [TreeFolderUpdateDto](docs/TreeFolderUpdateDto.md)
 - [TreeNodeDto](docs/TreeNodeDto.md)
 - [TreePatchDto](docs/TreePatchDto.md)
 - [TreePathCreateDto](docs/TreePathCreateDto.md)
 - [TreePathDto](docs/TreePathDto.md)
 - [TreePathItemDto](docs/TreePathItemDto.md)
 - [TreeSelectionDto](docs/TreeSelectionDto.md)
 - [UnderlineMark](docs/UnderlineMark.md)
 - [UserAccount](docs/UserAccount.md)
 - [UserSuggestDto](docs/UserSuggestDto.md)
 - [WebhookCreateDto](docs/WebhookCreateDto.md)
 - [WebhookDto](docs/WebhookDto.md)
 - [WebhookPatchDto](docs/WebhookPatchDto.md)
 - [WebhookSettings](docs/WebhookSettings.md)
 - [WebhookSubject](docs/WebhookSubject.md)
 - [WebhookValidateDto](docs/WebhookValidateDto.md)
 - [WidgetCreateDto](docs/WidgetCreateDto.md)
 - [WidgetDataDto](docs/WidgetDataDto.md)
 - [WidgetDto](docs/WidgetDto.md)
 - [WidgetOptions](docs/WidgetOptions.md)
 - [WidgetOptionsAnalyticGraph](docs/WidgetOptionsAnalyticGraph.md)
 - [WidgetOptionsHavingSettableAql](docs/WidgetOptionsHavingSettableAql.md)
 - [WidgetOptionsLastLaunchPieChart](docs/WidgetOptionsLastLaunchPieChart.md)
 - [WidgetOptionsLaunchList](docs/WidgetOptionsLaunchList.md)
 - [WidgetOptionsLaunchTrend](docs/WidgetOptionsLaunchTrend.md)
 - [WidgetOptionsMarkdown](docs/WidgetOptionsMarkdown.md)
 - [WidgetOptionsStatisticTrend](docs/WidgetOptionsStatisticTrend.md)
 - [WidgetOptionsTcPieChart](docs/WidgetOptionsTcPieChart.md)
 - [WidgetOptionsTcTreeMap](docs/WidgetOptionsTcTreeMap.md)
 - [WidgetOptionsTopTc](docs/WidgetOptionsTopTc.md)
 - [WidgetOptionsTrend](docs/WidgetOptionsTrend.md)
 - [WidgetOptionsTrendV2](docs/WidgetOptionsTrendV2.md)
 - [WidgetPatchDto](docs/WidgetPatchDto.md)
 - [WidgetPatchDtoOptions](docs/WidgetPatchDtoOptions.md)
 - [WidgetTypeDto](docs/WidgetTypeDto.md)
 - [WorkflowCreateDto](docs/WorkflowCreateDto.md)
 - [WorkflowDto](docs/WorkflowDto.md)
 - [WorkflowPatchDto](docs/WorkflowPatchDto.md)
 - [WorkflowRowDto](docs/WorkflowRowDto.md)
 - [WorkflowSchemaCreateDto](docs/WorkflowSchemaCreateDto.md)
 - [WorkflowSchemaDto](docs/WorkflowSchemaDto.md)
 - [WorkflowSchemaPatchDto](docs/WorkflowSchemaPatchDto.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




