# coding: utf-8

"""
    allure-testops-service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 525u01
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from allure_client.models.project_group_access_dto import ProjectGroupAccessDto
from typing import Optional, Set
from typing_extensions import Self

class ProjectCollaboratorAccessDto(BaseModel):
    """
    ProjectCollaboratorAccessDto
    """ # noqa: E501
    first_name: Optional[StrictStr] = Field(default=None, alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, alias="lastName")
    permission_set_name: Optional[StrictStr] = Field(default=None, alias="permissionSetName")
    permission_set_id: StrictInt = Field(alias="permissionSetId")
    project_groups: Optional[List[ProjectGroupAccessDto]] = Field(default=None, alias="projectGroups")
    email: Optional[StrictStr] = None
    username: StrictStr
    __properties: ClassVar[List[str]] = ["firstName", "lastName", "permissionSetName", "permissionSetId", "projectGroups", "email", "username"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectCollaboratorAccessDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in project_groups (list)
        _items = []
        if self.project_groups:
            for _item_project_groups in self.project_groups:
                if _item_project_groups:
                    _items.append(_item_project_groups.to_dict())
            _dict['projectGroups'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectCollaboratorAccessDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "permissionSetName": obj.get("permissionSetName"),
            "permissionSetId": obj.get("permissionSetId"),
            "projectGroups": [ProjectGroupAccessDto.from_dict(_item) for _item in obj["projectGroups"]] if obj.get("projectGroups") is not None else None,
            "email": obj.get("email"),
            "username": obj.get("username")
        })
        return _obj


