# coding: utf-8

"""
    allure-testops-service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 525u01
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from allure_client.models.category_dto import CategoryDto
from allure_client.models.external_link_dto import ExternalLinkDto
from allure_client.models.id_and_name_only_dto import IdAndNameOnlyDto
from allure_client.models.job_run_dto import JobRunDto
from allure_client.models.test_layer_dto import TestLayerDto
from allure_client.models.test_result_parameter_dto import TestResultParameterDto
from allure_client.models.test_status import TestStatus
from allure_client.models.test_tag_dto import TestTagDto
from typing import Optional, Set
from typing_extensions import Self

class TestResultDto(BaseModel):
    """
    TestResultDto
    """ # noqa: E501
    hidden: Optional[StrictBool] = None
    tested_by: Optional[StrictStr] = Field(default=None, alias="testedBy")
    flaky: Optional[StrictBool] = None
    description: Optional[StrictStr] = None
    scenario_key: Optional[StrictStr] = Field(default=None, alias="scenarioKey")
    manual: Optional[StrictBool] = None
    retried_by: Optional[IdAndNameOnlyDto] = Field(default=None, alias="retriedBy")
    layer: Optional[TestLayerDto] = None
    duration: Optional[StrictInt] = None
    thread_id: Optional[StrictStr] = Field(default=None, alias="threadId")
    trace: Optional[StrictStr] = None
    known: Optional[StrictBool] = None
    expected_result_html: Optional[StrictStr] = Field(default=None, alias="expectedResultHtml")
    links: Optional[List[ExternalLinkDto]] = None
    id: Optional[StrictInt] = None
    muted: Optional[StrictBool] = None
    history_key: Optional[StrictStr] = Field(default=None, alias="historyKey")
    job_run: Optional[JobRunDto] = Field(default=None, alias="jobRun")
    last_modified_date: Optional[StrictInt] = Field(default=None, alias="lastModifiedDate")
    last_modified_by: Optional[StrictStr] = Field(default=None, alias="lastModifiedBy")
    start: Optional[StrictInt] = None
    full_name: Optional[StrictStr] = Field(default=None, alias="fullName")
    host_id: Optional[StrictStr] = Field(default=None, alias="hostId")
    precondition: Optional[StrictStr] = None
    message: Optional[StrictStr] = None
    tags: Optional[List[TestTagDto]] = None
    launch_id: Optional[StrictInt] = Field(default=None, alias="launchId")
    external: Optional[StrictBool] = None
    created_date: Optional[StrictInt] = Field(default=None, alias="createdDate")
    precondition_html: Optional[StrictStr] = Field(default=None, alias="preconditionHtml")
    stop: Optional[StrictInt] = None
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    expected_result: Optional[StrictStr] = Field(default=None, alias="expectedResult")
    name: Optional[StrictStr] = None
    description_html: Optional[StrictStr] = Field(default=None, alias="descriptionHtml")
    assignee: Optional[StrictStr] = None
    category: Optional[CategoryDto] = None
    parameters: Optional[List[TestResultParameterDto]] = None
    project_id: Optional[StrictInt] = Field(default=None, alias="projectId")
    status: Optional[TestStatus] = None
    test_case_id: Optional[StrictInt] = Field(default=None, alias="testCaseId")
    __properties: ClassVar[List[str]] = ["hidden", "testedBy", "flaky", "description", "scenarioKey", "manual", "retriedBy", "layer", "duration", "threadId", "trace", "known", "expectedResultHtml", "links", "id", "muted", "historyKey", "jobRun", "lastModifiedDate", "lastModifiedBy", "start", "fullName", "hostId", "precondition", "message", "tags", "launchId", "external", "createdDate", "preconditionHtml", "stop", "createdBy", "expectedResult", "name", "descriptionHtml", "assignee", "category", "parameters", "projectId", "status", "testCaseId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestResultDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of retried_by
        if self.retried_by:
            _dict['retriedBy'] = self.retried_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of layer
        if self.layer:
            _dict['layer'] = self.layer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item_links in self.links:
                if _item_links:
                    _items.append(_item_links.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of job_run
        if self.job_run:
            _dict['jobRun'] = self.job_run.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of category
        if self.category:
            _dict['category'] = self.category.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in parameters (list)
        _items = []
        if self.parameters:
            for _item_parameters in self.parameters:
                if _item_parameters:
                    _items.append(_item_parameters.to_dict())
            _dict['parameters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestResultDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "hidden": obj.get("hidden"),
            "testedBy": obj.get("testedBy"),
            "flaky": obj.get("flaky"),
            "description": obj.get("description"),
            "scenarioKey": obj.get("scenarioKey"),
            "manual": obj.get("manual"),
            "retriedBy": IdAndNameOnlyDto.from_dict(obj["retriedBy"]) if obj.get("retriedBy") is not None else None,
            "layer": TestLayerDto.from_dict(obj["layer"]) if obj.get("layer") is not None else None,
            "duration": obj.get("duration"),
            "threadId": obj.get("threadId"),
            "trace": obj.get("trace"),
            "known": obj.get("known"),
            "expectedResultHtml": obj.get("expectedResultHtml"),
            "links": [ExternalLinkDto.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
            "id": obj.get("id"),
            "muted": obj.get("muted"),
            "historyKey": obj.get("historyKey"),
            "jobRun": JobRunDto.from_dict(obj["jobRun"]) if obj.get("jobRun") is not None else None,
            "lastModifiedDate": obj.get("lastModifiedDate"),
            "lastModifiedBy": obj.get("lastModifiedBy"),
            "start": obj.get("start"),
            "fullName": obj.get("fullName"),
            "hostId": obj.get("hostId"),
            "precondition": obj.get("precondition"),
            "message": obj.get("message"),
            "tags": [TestTagDto.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "launchId": obj.get("launchId"),
            "external": obj.get("external"),
            "createdDate": obj.get("createdDate"),
            "preconditionHtml": obj.get("preconditionHtml"),
            "stop": obj.get("stop"),
            "createdBy": obj.get("createdBy"),
            "expectedResult": obj.get("expectedResult"),
            "name": obj.get("name"),
            "descriptionHtml": obj.get("descriptionHtml"),
            "assignee": obj.get("assignee"),
            "category": CategoryDto.from_dict(obj["category"]) if obj.get("category") is not None else None,
            "parameters": [TestResultParameterDto.from_dict(_item) for _item in obj["parameters"]] if obj.get("parameters") is not None else None,
            "projectId": obj.get("projectId"),
            "status": obj.get("status"),
            "testCaseId": obj.get("testCaseId")
        })
        return _obj


