# coding: utf-8

"""
    allure-testops-service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 525u01
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from allure_client.models.external_link_dto import ExternalLinkDto
from allure_client.models.issue_dto import IssueDto
from allure_client.models.launch_tag_dto import LaunchTagDto
from typing import Optional, Set
from typing_extensions import Self

class LaunchPatchDto(BaseModel):
    """
    LaunchPatchDto
    """ # noqa: E501
    external: Optional[StrictBool] = None
    autoclose: Optional[StrictBool] = None
    release_id: Optional[StrictInt] = Field(default=None, alias="releaseId")
    name: Optional[StrictStr] = None
    links: Optional[List[ExternalLinkDto]] = None
    issues: Optional[List[IssueDto]] = None
    tags: Optional[List[LaunchTagDto]] = None
    __properties: ClassVar[List[str]] = ["external", "autoclose", "releaseId", "name", "links", "issues", "tags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LaunchPatchDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item_links in self.links:
                if _item_links:
                    _items.append(_item_links.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in issues (list)
        _items = []
        if self.issues:
            for _item_issues in self.issues:
                if _item_issues:
                    _items.append(_item_issues.to_dict())
            _dict['issues'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LaunchPatchDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "external": obj.get("external"),
            "autoclose": obj.get("autoclose"),
            "releaseId": obj.get("releaseId"),
            "name": obj.get("name"),
            "links": [ExternalLinkDto.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
            "issues": [IssueDto.from_dict(_item) for _item in obj["issues"]] if obj.get("issues") is not None else None,
            "tags": [LaunchTagDto.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None
        })
        return _obj


