# coding: utf-8

"""
    allure-testops-service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 525u01
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from allure_client.models.authority_type import AuthorityType
from allure_client.models.group_authorities import GroupAuthorities
from allure_client.models.security_auth_provider_settings import SecurityAuthProviderSettings
from typing import Optional, Set
from typing_extensions import Self

class Saml2Settings(SecurityAuthProviderSettings):
    """
    Saml2Settings
    """ # noqa: E501
    acs_url: Optional[StrictStr] = Field(default=None, alias="acsUrl")
    default_role: Optional[AuthorityType] = Field(default=None, alias="defaultRole")
    email_attribute: Optional[StrictStr] = Field(default=None, alias="emailAttribute")
    entity_id: Optional[StrictStr] = Field(default=None, alias="entityId")
    first_name_attribute: Optional[StrictStr] = Field(default=None, alias="firstNameAttribute")
    group_authorities: Optional[GroupAuthorities] = Field(default=None, alias="groupAuthorities")
    group_role_attribute: Optional[StrictStr] = Field(default=None, alias="groupRoleAttribute")
    last_name_attribute: Optional[StrictStr] = Field(default=None, alias="lastNameAttribute")
    metadata_url: Optional[StrictStr] = Field(default=None, alias="metadataUrl")
    metadata_xml: Optional[StrictStr] = Field(default=None, alias="metadataXml")
    sync_roles: Optional[StrictBool] = Field(default=None, alias="syncRoles")
    __properties: ClassVar[List[str]] = ["type", "acsUrl", "defaultRole", "emailAttribute", "entityId", "firstNameAttribute", "groupAuthorities", "groupRoleAttribute", "lastNameAttribute", "metadataUrl", "metadataXml", "syncRoles"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Saml2Settings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of group_authorities
        if self.group_authorities:
            _dict['groupAuthorities'] = self.group_authorities.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Saml2Settings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "acsUrl": obj.get("acsUrl"),
            "defaultRole": obj.get("defaultRole"),
            "emailAttribute": obj.get("emailAttribute"),
            "entityId": obj.get("entityId"),
            "firstNameAttribute": obj.get("firstNameAttribute"),
            "groupAuthorities": GroupAuthorities.from_dict(obj["groupAuthorities"]) if obj.get("groupAuthorities") is not None else None,
            "groupRoleAttribute": obj.get("groupRoleAttribute"),
            "lastNameAttribute": obj.get("lastNameAttribute"),
            "metadataUrl": obj.get("metadataUrl"),
            "metadataXml": obj.get("metadataXml"),
            "syncRoles": obj.get("syncRoles")
        })
        return _obj


