# coding: utf-8

"""
    allure-testops-service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 525u01
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from allure_client.models.environment_set_dto import EnvironmentSetDto
from allure_client.models.job_mapping import JobMapping
from allure_client.models.job_parameter_dto import JobParameterDto
from allure_client.models.test_case_selection_dto_v2 import TestCaseSelectionDtoV2
from typing import Optional, Set
from typing_extensions import Self

class TestCaseRunBulkExistingLaunchDto(BaseModel):
    """
    TestCaseRunBulkExistingLaunchDto
    """ # noqa: E501
    assignees: Optional[List[StrictStr]] = None
    env_var_value_sets: Optional[List[EnvironmentSetDto]] = Field(default=None, alias="envVarValueSets")
    jobs_mapping: Optional[List[JobMapping]] = Field(default=None, alias="jobsMapping")
    jobs_params: Optional[List[JobParameterDto]] = Field(default=None, alias="jobsParams")
    launch_id: StrictInt = Field(alias="launchId")
    selection: TestCaseSelectionDtoV2
    tree_folder: Optional[StrictBool] = Field(default=None, alias="treeFolder")
    __properties: ClassVar[List[str]] = ["assignees", "envVarValueSets", "jobsMapping", "jobsParams", "launchId", "selection", "treeFolder"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestCaseRunBulkExistingLaunchDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in env_var_value_sets (list)
        _items = []
        if self.env_var_value_sets:
            for _item_env_var_value_sets in self.env_var_value_sets:
                if _item_env_var_value_sets:
                    _items.append(_item_env_var_value_sets.to_dict())
            _dict['envVarValueSets'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in jobs_mapping (list)
        _items = []
        if self.jobs_mapping:
            for _item_jobs_mapping in self.jobs_mapping:
                if _item_jobs_mapping:
                    _items.append(_item_jobs_mapping.to_dict())
            _dict['jobsMapping'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in jobs_params (list)
        _items = []
        if self.jobs_params:
            for _item_jobs_params in self.jobs_params:
                if _item_jobs_params:
                    _items.append(_item_jobs_params.to_dict())
            _dict['jobsParams'] = _items
        # override the default output from pydantic by calling `to_dict()` of selection
        if self.selection:
            _dict['selection'] = self.selection.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestCaseRunBulkExistingLaunchDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assignees": obj.get("assignees"),
            "envVarValueSets": [EnvironmentSetDto.from_dict(_item) for _item in obj["envVarValueSets"]] if obj.get("envVarValueSets") is not None else None,
            "jobsMapping": [JobMapping.from_dict(_item) for _item in obj["jobsMapping"]] if obj.get("jobsMapping") is not None else None,
            "jobsParams": [JobParameterDto.from_dict(_item) for _item in obj["jobsParams"]] if obj.get("jobsParams") is not None else None,
            "launchId": obj.get("launchId"),
            "selection": TestCaseSelectionDtoV2.from_dict(obj["selection"]) if obj.get("selection") is not None else None,
            "treeFolder": obj.get("treeFolder")
        })
        return _obj


