# coding: utf-8

"""
    allure-testops-service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 525u01
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from allure_client.models.category_dto import CategoryDto
from allure_client.models.external_link_dto import ExternalLinkDto
from allure_client.models.id_and_name_only_dto import IdAndNameOnlyDto
from allure_client.models.job_run_dto import JobRunDto
from allure_client.models.test_layer_dto import TestLayerDto
from allure_client.models.test_result_parameter_dto import TestResultParameterDto
from allure_client.models.test_status import TestStatus
from allure_client.models.test_tag_dto import TestTagDto
from typing import Optional, Set
from typing_extensions import Self

class TestResultDto(BaseModel):
    """
    TestResultDto
    """ # noqa: E501
    assignee: Optional[StrictStr] = None
    category: Optional[CategoryDto] = None
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    created_date: Optional[StrictInt] = Field(default=None, alias="createdDate")
    description: Optional[StrictStr] = None
    description_html: Optional[StrictStr] = Field(default=None, alias="descriptionHtml")
    duration: Optional[StrictInt] = None
    expected_result: Optional[StrictStr] = Field(default=None, alias="expectedResult")
    expected_result_html: Optional[StrictStr] = Field(default=None, alias="expectedResultHtml")
    external: Optional[StrictBool] = None
    flaky: Optional[StrictBool] = None
    full_name: Optional[StrictStr] = Field(default=None, alias="fullName")
    hidden: Optional[StrictBool] = None
    history_key: Optional[StrictStr] = Field(default=None, alias="historyKey")
    host_id: Optional[StrictStr] = Field(default=None, alias="hostId")
    id: Optional[StrictInt] = None
    job_run: Optional[JobRunDto] = Field(default=None, alias="jobRun")
    known: Optional[StrictBool] = None
    last_modified_by: Optional[StrictStr] = Field(default=None, alias="lastModifiedBy")
    last_modified_date: Optional[StrictInt] = Field(default=None, alias="lastModifiedDate")
    launch_id: Optional[StrictInt] = Field(default=None, alias="launchId")
    layer: Optional[TestLayerDto] = None
    links: Optional[List[ExternalLinkDto]] = None
    manual: Optional[StrictBool] = None
    message: Optional[StrictStr] = None
    muted: Optional[StrictBool] = None
    name: Optional[StrictStr] = None
    parameters: Optional[List[TestResultParameterDto]] = None
    precondition: Optional[StrictStr] = None
    precondition_html: Optional[StrictStr] = Field(default=None, alias="preconditionHtml")
    project_id: Optional[StrictInt] = Field(default=None, alias="projectId")
    retried_by: Optional[IdAndNameOnlyDto] = Field(default=None, alias="retriedBy")
    scenario_key: Optional[StrictStr] = Field(default=None, alias="scenarioKey")
    start: Optional[StrictInt] = None
    status: Optional[TestStatus] = None
    stop: Optional[StrictInt] = None
    tags: Optional[List[TestTagDto]] = None
    test_case_id: Optional[StrictInt] = Field(default=None, alias="testCaseId")
    tested_by: Optional[StrictStr] = Field(default=None, alias="testedBy")
    thread_id: Optional[StrictStr] = Field(default=None, alias="threadId")
    trace: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["assignee", "category", "createdBy", "createdDate", "description", "descriptionHtml", "duration", "expectedResult", "expectedResultHtml", "external", "flaky", "fullName", "hidden", "historyKey", "hostId", "id", "jobRun", "known", "lastModifiedBy", "lastModifiedDate", "launchId", "layer", "links", "manual", "message", "muted", "name", "parameters", "precondition", "preconditionHtml", "projectId", "retriedBy", "scenarioKey", "start", "status", "stop", "tags", "testCaseId", "testedBy", "threadId", "trace"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestResultDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of category
        if self.category:
            _dict['category'] = self.category.to_dict()
        # override the default output from pydantic by calling `to_dict()` of job_run
        if self.job_run:
            _dict['jobRun'] = self.job_run.to_dict()
        # override the default output from pydantic by calling `to_dict()` of layer
        if self.layer:
            _dict['layer'] = self.layer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item_links in self.links:
                if _item_links:
                    _items.append(_item_links.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in parameters (list)
        _items = []
        if self.parameters:
            for _item_parameters in self.parameters:
                if _item_parameters:
                    _items.append(_item_parameters.to_dict())
            _dict['parameters'] = _items
        # override the default output from pydantic by calling `to_dict()` of retried_by
        if self.retried_by:
            _dict['retriedBy'] = self.retried_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestResultDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assignee": obj.get("assignee"),
            "category": CategoryDto.from_dict(obj["category"]) if obj.get("category") is not None else None,
            "createdBy": obj.get("createdBy"),
            "createdDate": obj.get("createdDate"),
            "description": obj.get("description"),
            "descriptionHtml": obj.get("descriptionHtml"),
            "duration": obj.get("duration"),
            "expectedResult": obj.get("expectedResult"),
            "expectedResultHtml": obj.get("expectedResultHtml"),
            "external": obj.get("external"),
            "flaky": obj.get("flaky"),
            "fullName": obj.get("fullName"),
            "hidden": obj.get("hidden"),
            "historyKey": obj.get("historyKey"),
            "hostId": obj.get("hostId"),
            "id": obj.get("id"),
            "jobRun": JobRunDto.from_dict(obj["jobRun"]) if obj.get("jobRun") is not None else None,
            "known": obj.get("known"),
            "lastModifiedBy": obj.get("lastModifiedBy"),
            "lastModifiedDate": obj.get("lastModifiedDate"),
            "launchId": obj.get("launchId"),
            "layer": TestLayerDto.from_dict(obj["layer"]) if obj.get("layer") is not None else None,
            "links": [ExternalLinkDto.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
            "manual": obj.get("manual"),
            "message": obj.get("message"),
            "muted": obj.get("muted"),
            "name": obj.get("name"),
            "parameters": [TestResultParameterDto.from_dict(_item) for _item in obj["parameters"]] if obj.get("parameters") is not None else None,
            "precondition": obj.get("precondition"),
            "preconditionHtml": obj.get("preconditionHtml"),
            "projectId": obj.get("projectId"),
            "retriedBy": IdAndNameOnlyDto.from_dict(obj["retriedBy"]) if obj.get("retriedBy") is not None else None,
            "scenarioKey": obj.get("scenarioKey"),
            "start": obj.get("start"),
            "status": obj.get("status"),
            "stop": obj.get("stop"),
            "tags": [TestTagDto.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "testCaseId": obj.get("testCaseId"),
            "testedBy": obj.get("testedBy"),
            "threadId": obj.get("threadId"),
            "trace": obj.get("trace")
        })
        return _obj


