# coding: utf-8

"""
    allure-testops-service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 525u01
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from allure_client.models.env_var_value_dto import EnvVarValueDto
from allure_client.models.id_and_name_only_dto import IdAndNameOnlyDto
from allure_client.models.test_result_parameter_dto import TestResultParameterDto
from allure_client.models.test_status import TestStatus
from typing import Optional, Set
from typing_extensions import Self

class TestResultHistoryDto(BaseModel):
    """
    TestResultHistoryDto
    """ # noqa: E501
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    created_date: Optional[StrictInt] = Field(default=None, alias="createdDate")
    duration: Optional[StrictInt] = None
    environment: Optional[List[EnvVarValueDto]] = None
    id: Optional[StrictInt] = None
    last_modified_by: Optional[StrictStr] = Field(default=None, alias="lastModifiedBy")
    last_modified_date: Optional[StrictInt] = Field(default=None, alias="lastModifiedDate")
    launch: Optional[IdAndNameOnlyDto] = None
    message: Optional[StrictStr] = None
    parameters: Optional[List[TestResultParameterDto]] = None
    start: Optional[StrictInt] = None
    status: Optional[TestStatus] = None
    stop: Optional[StrictInt] = None
    tested_by: Optional[StrictStr] = Field(default=None, alias="testedBy")
    trace: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["createdBy", "createdDate", "duration", "environment", "id", "lastModifiedBy", "lastModifiedDate", "launch", "message", "parameters", "start", "status", "stop", "testedBy", "trace"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestResultHistoryDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in environment (list)
        _items = []
        if self.environment:
            for _item_environment in self.environment:
                if _item_environment:
                    _items.append(_item_environment.to_dict())
            _dict['environment'] = _items
        # override the default output from pydantic by calling `to_dict()` of launch
        if self.launch:
            _dict['launch'] = self.launch.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in parameters (list)
        _items = []
        if self.parameters:
            for _item_parameters in self.parameters:
                if _item_parameters:
                    _items.append(_item_parameters.to_dict())
            _dict['parameters'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestResultHistoryDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdBy": obj.get("createdBy"),
            "createdDate": obj.get("createdDate"),
            "duration": obj.get("duration"),
            "environment": [EnvVarValueDto.from_dict(_item) for _item in obj["environment"]] if obj.get("environment") is not None else None,
            "id": obj.get("id"),
            "lastModifiedBy": obj.get("lastModifiedBy"),
            "lastModifiedDate": obj.get("lastModifiedDate"),
            "launch": IdAndNameOnlyDto.from_dict(obj["launch"]) if obj.get("launch") is not None else None,
            "message": obj.get("message"),
            "parameters": [TestResultParameterDto.from_dict(_item) for _item in obj["parameters"]] if obj.get("parameters") is not None else None,
            "start": obj.get("start"),
            "status": obj.get("status"),
            "stop": obj.get("stop"),
            "testedBy": obj.get("testedBy"),
            "trace": obj.get("trace")
        })
        return _obj


