# coding: utf-8

"""
    allure-testops-service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 525u01
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from allure_client.models.default_webhook_settings import DefaultWebhookSettings
from typing import Optional, Set
from typing_extensions import Self

class WebhookDto(BaseModel):
    """
    WebhookDto
    """ # noqa: E501
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    created_date: Optional[StrictInt] = Field(default=None, alias="createdDate")
    enabled: Optional[StrictBool] = None
    endpoint: Optional[StrictStr] = None
    id: Optional[StrictInt] = None
    last_modified_by: Optional[StrictStr] = Field(default=None, alias="lastModifiedBy")
    last_modified_date: Optional[StrictInt] = Field(default=None, alias="lastModifiedDate")
    name: Optional[StrictStr] = None
    project_id: Optional[StrictInt] = Field(default=None, alias="projectId")
    settings: Optional[DefaultWebhookSettings] = None
    with_error: Optional[StrictBool] = Field(default=None, alias="withError")
    __properties: ClassVar[List[str]] = ["createdBy", "createdDate", "enabled", "endpoint", "id", "lastModifiedBy", "lastModifiedDate", "name", "projectId", "settings", "withError"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of settings
        if self.settings:
            _dict['settings'] = self.settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdBy": obj.get("createdBy"),
            "createdDate": obj.get("createdDate"),
            "enabled": obj.get("enabled"),
            "endpoint": obj.get("endpoint"),
            "id": obj.get("id"),
            "lastModifiedBy": obj.get("lastModifiedBy"),
            "lastModifiedDate": obj.get("lastModifiedDate"),
            "name": obj.get("name"),
            "projectId": obj.get("projectId"),
            "settings": DefaultWebhookSettings.from_dict(obj["settings"]) if obj.get("settings") is not None else None,
            "withError": obj.get("withError")
        })
        return _obj


